/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.omf;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.ByteProviderInputStream;
import ghidra.app.util.bin.format.omf.OmfFileHeader;
import ghidra.app.util.bin.format.omf.OmfLibraryRecord;
import ghidra.file.formats.omf.OmfArchiveFileSystemFactory;
import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.FSUtilities;
import ghidra.formats.gfilesystem.FileSystemIndexHelper;
import ghidra.formats.gfilesystem.FileSystemRefManager;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.formats.gfilesystem.annotations.FileSystemInfo;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@FileSystemInfo(type="omf", description="OMF Archive", factory=OmfArchiveFileSystemFactory.class)
public class OmfArchiveFileSystem
implements GFileSystem {
    private final FSRLRoot fsFSRL;
    private FileSystemIndexHelper<OmfLibraryRecord.MemberHeader> fsih;
    private FileSystemRefManager refManager = new FileSystemRefManager((GFileSystem)this);
    private ByteProvider provider;

    public OmfArchiveFileSystem(FSRLRoot fsFSRL, ByteProvider provider) {
        this.fsFSRL = fsFSRL;
        this.provider = provider;
        this.fsih = new FileSystemIndexHelper((GFileSystem)this, fsFSRL);
    }

    public void mount(TaskMonitor monitor) throws IOException {
        monitor.setMessage("Opening OMF archive...");
        BinaryReader reader = OmfFileHeader.createReader((ByteProvider)this.provider);
        OmfLibraryRecord libraryRec = OmfLibraryRecord.parse((BinaryReader)reader, (TaskMonitor)monitor);
        ArrayList memberHeaders = libraryRec.getMemberHeaders();
        for (OmfLibraryRecord.MemberHeader member : memberHeaders) {
            String name = member.name;
            monitor.setMessage(name);
            this.fsih.storeFile(name, this.fsih.getFileCount(), false, member.size, (Object)member);
        }
    }

    public void close() throws IOException {
        this.refManager.onClose();
        if (this.provider != null) {
            this.provider.close();
            this.provider = null;
        }
        this.fsih.clear();
    }

    public String getName() {
        return this.fsFSRL.getContainer().getName();
    }

    public FSRLRoot getFSRL() {
        return this.fsFSRL;
    }

    public boolean isClosed() {
        return this.provider == null;
    }

    public int getFileCount() {
        return this.fsih.getFileCount();
    }

    public FileSystemRefManager getRefManager() {
        return this.refManager;
    }

    public GFile lookup(String path) throws IOException {
        return this.fsih.lookup(path);
    }

    public InputStream getInputStream(GFile file, TaskMonitor monitor) throws IOException, CancelledException {
        OmfLibraryRecord.MemberHeader member = (OmfLibraryRecord.MemberHeader)this.fsih.getMetadata(file);
        return member != null ? new ByteProviderInputStream(this.provider, member.payloadOffset, member.size) : null;
    }

    public List<GFile> getListing(GFile directory) throws IOException {
        return this.fsih.getListing(directory);
    }

    public String getInfo(GFile file, TaskMonitor monitor) {
        OmfLibraryRecord.MemberHeader entry = (OmfLibraryRecord.MemberHeader)this.fsih.getMetadata(file);
        return entry == null ? null : FSUtilities.infoMapToString(this.getInfoMap(entry));
    }

    public Map<String, String> getInfoMap(OmfLibraryRecord.MemberHeader member) {
        LinkedHashMap<String, String> info = new LinkedHashMap<String, String>();
        info.put("Name", member.name);
        info.put("Size", Long.toString(member.size) + ", 0x" + Long.toHexString(member.size));
        return info;
    }
}

