/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.sevenzip;

import ghidra.file.formats.sevenzip.SevenZipFileSystemFactory;
import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.FSUtilities;
import ghidra.formats.gfilesystem.FileCacheEntry;
import ghidra.formats.gfilesystem.FileSystemIndexHelper;
import ghidra.formats.gfilesystem.FileSystemRefManager;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.formats.gfilesystem.annotations.FileSystemInfo;
import ghidra.util.Msg;
import ghidra.util.NumericUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sf.sevenzipjbinding.ExtractAskMode;
import net.sf.sevenzipjbinding.ExtractOperationResult;
import net.sf.sevenzipjbinding.IArchiveExtractCallback;
import net.sf.sevenzipjbinding.IInArchive;
import net.sf.sevenzipjbinding.IInStream;
import net.sf.sevenzipjbinding.ISequentialOutStream;
import net.sf.sevenzipjbinding.SevenZip;
import net.sf.sevenzipjbinding.SevenZipException;
import net.sf.sevenzipjbinding.impl.RandomAccessFileInStream;
import net.sf.sevenzipjbinding.simple.ISimpleInArchive;
import net.sf.sevenzipjbinding.simple.ISimpleInArchiveItem;
import org.apache.commons.io.FilenameUtils;
import utilities.util.FileUtilities;

@FileSystemInfo(type="7zip", description="7Zip", factory=SevenZipFileSystemFactory.class)
public class SevenZipFileSystem
implements GFileSystem {
    private FileSystemService fileSystemService;
    private FileSystemIndexHelper<ISimpleInArchiveItem> fsIndexHelper;
    private FSRLRoot fsrl;
    private FileSystemRefManager refManager = new FileSystemRefManager((GFileSystem)this);
    private IInArchive archive;
    private ISimpleInArchive archiveInterface;
    private RandomAccessFile randomAccessFile;

    public SevenZipFileSystem(FSRLRoot fsrl) {
        this.fsrl = fsrl;
        this.fsIndexHelper = new FileSystemIndexHelper((GFileSystem)this, fsrl);
        this.fileSystemService = FileSystemService.getInstance();
    }

    public void mount(File containerFile, TaskMonitor monitor) throws CancelledException, IOException {
        this.randomAccessFile = new RandomAccessFile(containerFile, "r");
        try {
            ISimpleInArchiveItem[] items;
            this.archive = SevenZip.openInArchive(null, (IInStream)new RandomAccessFileInStream(this.randomAccessFile));
            this.archiveInterface = this.archive.getSimpleInterface();
            for (ISimpleInArchiveItem item : items = this.archiveInterface.getArchiveItems()) {
                if (monitor.isCancelled()) {
                    throw new CancelledException();
                }
                String itemPath = item.getPath();
                if (items.length == 1 && itemPath.isBlank()) {
                    itemPath = FilenameUtils.getBaseName((String)this.fsrl.getContainer().getName());
                }
                this.fsIndexHelper.storeFile(itemPath, item.getItemIndex(), item.isFolder(), SevenZipFileSystem.getSize(item), (Object)item);
            }
            this.preCacheAll(monitor);
        }
        catch (SevenZipException e) {
            throw new IOException("Failed to open archive: " + this.fsrl, e);
        }
    }

    private void preCacheAll(TaskMonitor monitor) throws SevenZipException {
        SZExtractCallback szCallback = new SZExtractCallback(monitor);
        this.archive.extract(null, false, (IArchiveExtractCallback)szCallback);
    }

    public void close() throws IOException {
        this.refManager.onClose();
        if (this.randomAccessFile != null) {
            try {
                this.archive.close();
            }
            catch (SevenZipException e) {
                Msg.warn((Object)this, (Object)"Problem closing 7-Zip archive", (Throwable)e);
            }
            this.archive = null;
            this.archiveInterface = null;
            this.randomAccessFile.close();
            this.randomAccessFile = null;
        }
        this.fsIndexHelper.clear();
    }

    public String getName() {
        return this.fsrl.getContainer().getName();
    }

    public FSRLRoot getFSRL() {
        return this.fsrl;
    }

    public boolean isClosed() {
        return this.randomAccessFile == null;
    }

    public FileSystemRefManager getRefManager() {
        return this.refManager;
    }

    public GFile lookup(String path) throws IOException {
        return this.fsIndexHelper.lookup(path);
    }

    public List<GFile> getListing(GFile directory) throws IOException {
        return this.fsIndexHelper.getListing(directory);
    }

    public String getInfo(GFile file, TaskMonitor monitor) {
        ISimpleInArchiveItem entry = (ISimpleInArchiveItem)this.fsIndexHelper.getMetadata(file);
        return entry != null ? FSUtilities.infoMapToString(this.getInfoMap(entry)) : null;
    }

    private Map<String, String> getInfoMap(ISimpleInArchiveItem entry) {
        LinkedHashMap<String, String> info = new LinkedHashMap<String, String>();
        try {
            info.put("Name", entry.getPath());
            info.put("Folder?", Boolean.toString(SevenZipFileSystem.isFolder(entry)));
            info.put("Encrypted?", Boolean.toString(entry.isEncrypted()));
            info.put("Comment", entry.getComment());
            Long compressedSize = SevenZipFileSystem.getCompressedSize(entry);
            info.put("Compressed Size", compressedSize != null ? NumericUtilities.toHexString((long)compressedSize) : "NA");
            info.put("Uncompressed Size", NumericUtilities.toHexString((long)SevenZipFileSystem.getSize(entry)));
            Integer crc = SevenZipFileSystem.getCRC(entry);
            info.put("CRC", crc != null ? NumericUtilities.toHexString((long)((long)crc.intValue() & 0xFFFFFFFFL)) : "NA");
            info.put("Compression Method", entry.getMethod());
            Date creationTime = SevenZipFileSystem.getCreateDate(entry);
            info.put("Time", creationTime != null ? creationTime.toGMTString() : "NA");
        }
        catch (SevenZipException e) {
            Msg.warn((Object)this, (Object)"7-Zip exception trying to get info on item", (Throwable)e);
        }
        return info;
    }

    public InputStream getInputStream(GFile file, TaskMonitor monitor) throws IOException, CancelledException {
        ISimpleInArchiveItem entry = (ISimpleInArchiveItem)this.fsIndexHelper.getMetadata(file);
        if (entry == null) {
            return null;
        }
        try {
            if (entry.isFolder()) {
                throw new IOException("Not a file: " + file.getName());
            }
        }
        catch (SevenZipException e) {
            throw new IOException("Error getting status of file: " + file.getName(), e);
        }
        File cachedFile = this.extractSZFile(file, entry, monitor);
        return new FileInputStream(cachedFile);
    }

    private File extractSZFile(GFile file, ISimpleInArchiveItem entry, TaskMonitor monitor) throws CancelledException, IOException {
        FileCacheEntry fce = FileSystemService.getInstance().getDerivedFilePush(this.fsrl.getContainer(), Integer.toString(entry.getItemIndex()), os -> {
            Msg.info((Object)this, (Object)("Extracting singleton file from sevenzip (slow): " + file.getFSRL()));
            try {
                ExtractOperationResult operationResult = entry.extractSlow(new ISequentialOutStream(){

                    public int write(byte[] data) throws SevenZipException {
                        try {
                            os.write(data);
                            return data.length;
                        }
                        catch (IOException ioe) {
                            throw new SevenZipException((Throwable)ioe);
                        }
                    }
                });
                SevenZipFileSystem.extractOperationResultToException(operationResult);
            }
            catch (SevenZipException e) {
                Throwable cause = e.getCause();
                if (cause != null && cause instanceof IOException) {
                    throw (IOException)cause;
                }
                if (cause != null && cause instanceof CancelledException) {
                    throw (CancelledException)cause;
                }
                throw new IOException("7-Zip exception", e);
            }
        }, monitor);
        return fce.file;
    }

    private static void extractOperationResultToException(ExtractOperationResult operationResult) throws IOException {
        if (operationResult == null) {
            throw new IOException("7-Zip returned null operation result");
        }
        switch (operationResult) {
            case CRCERROR: {
                throw new IOException("7-Zip returned CRC error");
            }
            case DATAERROR: {
                throw new IOException("7-Zip returned data error");
            }
            case UNSUPPORTEDMETHOD: {
                throw new IOException("Unexpected: 7-Zip returned unsupported method");
            }
            case UNKNOWN_OPERATION_RESULT: {
                throw new IOException("Unexpected: 7-Zip returned unknown operation result");
            }
        }
    }

    private static long getSize(ISimpleInArchiveItem entry) throws SevenZipException {
        Long tempSize = entry.getSize();
        return tempSize == null ? -1L : (long)tempSize.intValue();
    }

    private static Long getCompressedSize(ISimpleInArchiveItem entry) {
        try {
            return entry.getPackedSize();
        }
        catch (SevenZipException sevenZipException) {
            return null;
        }
    }

    private static Integer getCRC(ISimpleInArchiveItem entry) {
        try {
            return entry.getCRC();
        }
        catch (SevenZipException sevenZipException) {
            return null;
        }
    }

    private static Date getCreateDate(ISimpleInArchiveItem entry) {
        try {
            return entry.getCreationTime();
        }
        catch (SevenZipException sevenZipException) {
            return null;
        }
    }

    private static boolean isFolder(ISimpleInArchiveItem entry) {
        try {
            return entry.isFolder();
        }
        catch (SevenZipException sevenZipException) {
            return false;
        }
    }

    private class SZExtractCallback
    implements IArchiveExtractCallback,
    ISequentialOutStream {
        private TaskMonitor monitor;
        private int currentIndex;
        private File currentTempFile;
        private OutputStream currentTempFileOutputStream;

        public SZExtractCallback(TaskMonitor monitor) {
            this.monitor = monitor;
        }

        public ISequentialOutStream getStream(int index, ExtractAskMode extractAskMode) throws SevenZipException {
            try {
                if (!SevenZipFileSystem.this.fileSystemService.hasDerivedFile(SevenZipFileSystem.this.fsrl.getContainer(), Integer.toString(index), this.monitor)) {
                    this.currentIndex = index;
                    return this;
                }
            }
            catch (CancelledException | IOException throwable) {
                // empty catch block
            }
            return null;
        }

        public void prepareOperation(ExtractAskMode extractAskMode) throws SevenZipException {
            if (extractAskMode == ExtractAskMode.EXTRACT) {
                try {
                    this.currentTempFile = File.createTempFile("ghidra_sevenzip_", ".tmp");
                    this.currentTempFileOutputStream = new FileOutputStream(this.currentTempFile);
                }
                catch (IOException e) {
                    throw new SevenZipException((Throwable)e);
                }
            }
        }

        public int write(byte[] data) throws SevenZipException {
            try {
                this.currentTempFileOutputStream.write(data);
                return data.length;
            }
            catch (IOException e) {
                throw new SevenZipException((Throwable)e);
            }
        }

        public void setOperationResult(ExtractOperationResult extractOperationResult) throws SevenZipException {
            if (this.currentTempFileOutputStream != null) {
                try {
                    this.currentTempFileOutputStream.close();
                    SevenZipFileSystem.extractOperationResultToException(extractOperationResult);
                    SevenZipFileSystem.this.fileSystemService.getDerivedFilePush(SevenZipFileSystem.this.fsrl.getContainer(), Integer.toString(this.currentIndex), os -> {
                        try (FileInputStream is = new FileInputStream(this.currentTempFile);){
                            FileUtilities.copyStreamToStream((InputStream)is, (OutputStream)os, (TaskMonitor)this.monitor);
                        }
                    }, this.monitor);
                    this.currentTempFile.delete();
                }
                catch (CancelledException | IOException e) {
                    throw new SevenZipException(e);
                }
                finally {
                    this.currentTempFile = null;
                    this.currentTempFileOutputStream = null;
                }
            }
        }

        public void setTotal(long total) throws SevenZipException {
        }

        public void setCompleted(long complete) throws SevenZipException {
        }
    }
}

