/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.visualization;

import ghidra.service.graph.Attributed;
import java.awt.Color;
import java.awt.Paint;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class Colors {
    private static final Pattern HEX_PATTERN = Pattern.compile("(0x|#)[0-9A-Fa-f]{6}");
    static Map<String, Color> WEB_COLOR_MAP = Map.ofEntries(Map.entry("Black", Color.decode("0x000000")), Map.entry("Navy", Color.decode("0x000080")), Map.entry("DarkBlue", Color.decode("0x00008B")), Map.entry("MediumBlue", Color.decode("0x0000CD")), Map.entry("Blue", Color.decode("0x0000FF")), Map.entry("DarkGreen", Color.decode("0x006400")), Map.entry("Green", Color.decode("0x008000")), Map.entry("Teal", Color.decode("0x008080")), Map.entry("DarkCyan", Color.decode("0x008B8B")), Map.entry("DeepSkyBlue", Color.decode("0x00BFFF")), Map.entry("DarkTurquoise", Color.decode("0x00CED1")), Map.entry("MediumSpringGreen", Color.decode("0x00FA9A")), Map.entry("Lime", Color.decode("0x00FF00")), Map.entry("SpringGreen", Color.decode("0x00FF7F")), Map.entry("Aqua", Color.decode("0x00FFFF")), Map.entry("Cyan", Color.decode("0x00FFFF")), Map.entry("MidnightBlue", Color.decode("0x191970")), Map.entry("DodgerBlue", Color.decode("0x1E90FF")), Map.entry("LightSeaGreen", Color.decode("0x20B2AA")), Map.entry("ForestGreen", Color.decode("0x228B22")), Map.entry("SeaGreen", Color.decode("0x2E8B57")), Map.entry("DarkSlateGray", Color.decode("0x2F4F4F")), Map.entry("DarkSlateGrey", Color.decode("0x2F4F4F")), Map.entry("LimeGreen", Color.decode("0x32CD32")), Map.entry("MediumSeaGreen", Color.decode("0x3CB371")), Map.entry("Turquoise", Color.decode("0x40E0D0")), Map.entry("RoyalBlue", Color.decode("0x4169E1")), Map.entry("SteelBlue", Color.decode("0x4682B4")), Map.entry("DarkSlateBlue", Color.decode("0x483D8B")), Map.entry("MediumTurquoise", Color.decode("0x48D1CC")), Map.entry("Indigo", Color.decode("0x4B0082")), Map.entry("DarkOliveGreen", Color.decode("0x556B2F")), Map.entry("CadetBlue", Color.decode("0x5F9EA0")), Map.entry("CornflowerBlue", Color.decode("0x6495ED")), Map.entry("RebeccaPurple", Color.decode("0x663399")), Map.entry("MediumAquaMarine", Color.decode("0x66CDAA")), Map.entry("DimGray", Color.decode("0x696969")), Map.entry("DimGrey", Color.decode("0x696969")), Map.entry("SlateBlue", Color.decode("0x6A5ACD")), Map.entry("OliveDrab", Color.decode("0x6B8E23")), Map.entry("SlateGray", Color.decode("0x708090")), Map.entry("SlateGrey", Color.decode("0x708090")), Map.entry("LightSlateGray", Color.decode("0x778899")), Map.entry("LightSlateGrey", Color.decode("0x778899")), Map.entry("MediumSlateBlue", Color.decode("0x7B68EE")), Map.entry("LawnGreen", Color.decode("0x7CFC00")), Map.entry("Chartreuse", Color.decode("0x7FFF00")), Map.entry("Aquamarine", Color.decode("0x7FFFD4")), Map.entry("Maroon", Color.decode("0x800000")), Map.entry("Purple", Color.decode("0x800080")), Map.entry("Olive", Color.decode("0x808000")), Map.entry("Gray", Color.decode("0x808080")), Map.entry("Grey", Color.decode("0x808080")), Map.entry("SkyBlue", Color.decode("0x87CEEB")), Map.entry("LightSkyBlue", Color.decode("0x87CEFA")), Map.entry("BlueViolet", Color.decode("0x8A2BE2")), Map.entry("DarkRed", Color.decode("0x8B0000")), Map.entry("DarkMagenta", Color.decode("0x8B008B")), Map.entry("SaddleBrown", Color.decode("0x8B4513")), Map.entry("DarkSeaGreen", Color.decode("0x8FBC8F")), Map.entry("LightGreen", Color.decode("0x90EE90")), Map.entry("MediumPurple", Color.decode("0x9370DB")), Map.entry("DarkViolet", Color.decode("0x9400D3")), Map.entry("PaleGreen", Color.decode("0x98FB98")), Map.entry("DarkOrchid", Color.decode("0x9932CC")), Map.entry("YellowGreen", Color.decode("0x9ACD32")), Map.entry("Sienna", Color.decode("0xA0522D")), Map.entry("Brown", Color.decode("0xA52A2A")), Map.entry("DarkGray", Color.decode("0xA9A9A9")), Map.entry("DarkGrey", Color.decode("0xA9A9A9")), Map.entry("LightBlue", Color.decode("0xADD8E6")), Map.entry("GreenYellow", Color.decode("0xADFF2F")), Map.entry("PaleTurquoise", Color.decode("0xAFEEEE")), Map.entry("LightSteelBlue", Color.decode("0xB0C4DE")), Map.entry("PowderBlue", Color.decode("0xB0E0E6")), Map.entry("FireBrick", Color.decode("0xB22222")), Map.entry("DarkGoldenRod", Color.decode("0xB8860B")), Map.entry("MediumOrchid", Color.decode("0xBA55D3")), Map.entry("RosyBrown", Color.decode("0xBC8F8F")), Map.entry("DarkKhaki", Color.decode("0xBDB76B")), Map.entry("Silver", Color.decode("0xC0C0C0")), Map.entry("MediumVioletRed", Color.decode("0xC71585")), Map.entry("IndianRed", Color.decode("0xCD5C5C")), Map.entry("Peru", Color.decode("0xCD853F")), Map.entry("Chocolate", Color.decode("0xD2691E")), Map.entry("Tan", Color.decode("0xD2B48C")), Map.entry("LightGray", Color.decode("0xD3D3D3")), Map.entry("LightGrey", Color.decode("0xD3D3D3")), Map.entry("Thistle", Color.decode("0xD8BFD8")), Map.entry("Orchid", Color.decode("0xDA70D6")), Map.entry("GoldenRod", Color.decode("0xDAA520")), Map.entry("PaleVioletRed", Color.decode("0xDB7093")), Map.entry("Crimson", Color.decode("0xDC143C")), Map.entry("Gainsboro", Color.decode("0xDCDCDC")), Map.entry("Plum", Color.decode("0xDDA0DD")), Map.entry("BurlyWood", Color.decode("0xDEB887")), Map.entry("LightCyan", Color.decode("0xE0FFFF")), Map.entry("Lavender", Color.decode("0xE6E6FA")), Map.entry("DarkSalmon", Color.decode("0xE9967A")), Map.entry("Violet", Color.decode("0xEE82EE")), Map.entry("PaleGoldenRod", Color.decode("0xEEE8AA")), Map.entry("LightCoral", Color.decode("0xF08080")), Map.entry("Khaki", Color.decode("0xF0E68C")), Map.entry("AliceBlue", Color.decode("0xF0F8FF")), Map.entry("HoneyDew", Color.decode("0xF0FFF0")), Map.entry("Azure", Color.decode("0xF0FFFF")), Map.entry("SandyBrown", Color.decode("0xF4A460")), Map.entry("Wheat", Color.decode("0xF5DEB3")), Map.entry("Beige", Color.decode("0xF5F5DC")), Map.entry("WhiteSmoke", Color.decode("0xF5F5F5")), Map.entry("MintCream", Color.decode("0xF5FFFA")), Map.entry("GhostWhite", Color.decode("0xF8F8FF")), Map.entry("Salmon", Color.decode("0xFA8072")), Map.entry("AntiqueWhite", Color.decode("0xFAEBD7")), Map.entry("Linen", Color.decode("0xFAF0E6")), Map.entry("LightGoldenRodYellow", Color.decode("0xFAFAD2")), Map.entry("OldLace", Color.decode("0xFDF5E6")), Map.entry("Red", Color.decode("0xFF0000")), Map.entry("Fuchsia", Color.decode("0xFF00FF")), Map.entry("Magenta", Color.decode("0xFF00FF")), Map.entry("DeepPink", Color.decode("0xFF1493")), Map.entry("OrangeRed", Color.decode("0xFF4500")), Map.entry("Tomato", Color.decode("0xFF6347")), Map.entry("HotPink", Color.decode("0xFF69B4")), Map.entry("Coral", Color.decode("0xFF7F50")), Map.entry("DarkOrange", Color.decode("0xFF8C00")), Map.entry("LightSalmon", Color.decode("0xFFA07A")), Map.entry("Orange", Color.decode("0xFFA500")), Map.entry("LightPink", Color.decode("0xFFB6C1")), Map.entry("Pink", Color.decode("0xFFC0CB")), Map.entry("Gold", Color.decode("0xFFD700")), Map.entry("PeachPuff", Color.decode("0xFFDAB9")), Map.entry("NavajoWhite", Color.decode("0xFFDEAD")), Map.entry("Moccasin", Color.decode("0xFFE4B5")), Map.entry("Bisque", Color.decode("0xFFE4C4")), Map.entry("MistyRose", Color.decode("0xFFE4E1")), Map.entry("BlanchedAlmond", Color.decode("0xFFEBCD")), Map.entry("PapayaWhip", Color.decode("0xFFEFD5")), Map.entry("LavenderBlush", Color.decode("0xFFF0F5")), Map.entry("SeaShell", Color.decode("0xFFF5EE")), Map.entry("Cornsilk", Color.decode("0xFFF8DC")), Map.entry("LemonChiffon", Color.decode("0xFFFACD")), Map.entry("FloralWhite", Color.decode("0xFFFAF0")), Map.entry("Snow", Color.decode("0xFFFAFA")), Map.entry("Yellow", Color.decode("0xFFFF00")), Map.entry("LightYellow", Color.decode("0xFFFFE0")), Map.entry("Ivory", Color.decode("0xFFFFF0")), Map.entry("White", Color.decode("0xFFFFFF")));
    private static Color blue = new Color(100, 100, 255);
    private static Color darkerYellow = new Color(225, 225, 0);
    public static Map<String, Paint> VERTEX_TYPE_TO_COLOR_MAP = Map.ofEntries(Map.entry("Body", blue), Map.entry("Entry", WEB_COLOR_MAP.get("DarkOrange")), Map.entry("Exit", Color.magenta), Map.entry("Switch", Color.cyan), Map.entry("Bad", Color.red), Map.entry("Entry-Nexus", Color.white), Map.entry("External", Color.green), Map.entry("Folder", WEB_COLOR_MAP.get("DarkOrange")), Map.entry("Fragment", WEB_COLOR_MAP.get("Purple")), Map.entry("Data", Color.pink));
    public static Map<String, Paint> EDGE_TYPE_TO_COLOR_MAP = Map.ofEntries(Map.entry("Entry", Color.gray), Map.entry("Fall-Through", Color.blue), Map.entry("Conditional-Call", WEB_COLOR_MAP.get("DarkOrange")), Map.entry("Unconditional-Call", WEB_COLOR_MAP.get("DarkOrange")), Map.entry("Computed", Color.cyan), Map.entry("Indirection", Color.pink), Map.entry("Unconditional-Jump", Color.green), Map.entry("Conditional-Jump", darkerYellow), Map.entry("Terminator", WEB_COLOR_MAP.get("Purple")), Map.entry("Conditional-Return", WEB_COLOR_MAP.get("Purple")));

    private Colors() {
    }

    public static Paint getColor(Attributed attributed) {
        Map map = attributed.getAttributeMap();
        if (map.containsKey("VertexType")) {
            String typeValue = (String)map.get("VertexType");
            return VERTEX_TYPE_TO_COLOR_MAP.getOrDefault(typeValue, Color.blue);
        }
        if (map.containsKey("EdgeType")) {
            String typeValue = (String)map.get("EdgeType");
            return EDGE_TYPE_TO_COLOR_MAP.getOrDefault(typeValue, Color.green);
        }
        if (map.containsKey("Color")) {
            String colorName = (String)map.get("Color");
            if (WEB_COLOR_MAP.containsKey(colorName)) {
                return WEB_COLOR_MAP.get(colorName);
            }
            Color c = Colors.getHexColor(colorName);
            if (c != null) {
                return c;
            }
        }
        return Color.green;
    }

    public static Color getHexColor(String hexString) {
        Matcher matcher = HEX_PATTERN.matcher(hexString);
        if (matcher.matches()) {
            return Color.decode(hexString);
        }
        return null;
    }
}

