/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.visualization;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.DialogComponentProvider;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.ToggleDockingAction;
import docking.action.builder.ActionBuilder;
import docking.action.builder.MultiStateActionBuilder;
import docking.action.builder.ToggleActionBuilder;
import docking.menu.ActionState;
import docking.widgets.EventTrigger;
import generic.util.WindowUtilities;
import ghidra.framework.plugintool.PluginTool;
import ghidra.graph.AttributeFilters;
import ghidra.graph.job.GraphJob;
import ghidra.graph.job.GraphJobRunner;
import ghidra.graph.viewer.popup.PopupRegulator;
import ghidra.graph.viewer.popup.PopupSource;
import ghidra.graph.viewer.popup.ToolTipInfo;
import ghidra.graph.visualization.CenterAnimationJob;
import ghidra.graph.visualization.Colors;
import ghidra.graph.visualization.DefaultDisplayGraphIcons;
import ghidra.graph.visualization.DefaultGraphDisplayComponentProvider;
import ghidra.graph.visualization.DefaultGraphDisplayProvider;
import ghidra.graph.visualization.EdgeComparator;
import ghidra.graph.visualization.FilterDialog;
import ghidra.graph.visualization.GhidraIconCache;
import ghidra.graph.visualization.LayoutTransitionManager;
import ghidra.graph.visualization.ProgramGraphFunctions;
import ghidra.graph.visualization.SetLayoutTask;
import ghidra.graph.visualization.mouse.JgtPluggableGraphMouse;
import ghidra.graph.visualization.mouse.JgtUtils;
import ghidra.service.graph.Attributed;
import ghidra.service.graph.AttributedEdge;
import ghidra.service.graph.AttributedGraph;
import ghidra.service.graph.AttributedVertex;
import ghidra.service.graph.DummyGraphDisplayListener;
import ghidra.service.graph.EdgeGraphActionContext;
import ghidra.service.graph.GraphActionContext;
import ghidra.service.graph.GraphDisplay;
import ghidra.service.graph.GraphDisplayListener;
import ghidra.service.graph.VertexGraphActionContext;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.Swing;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.JToolTip;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.apache.commons.lang3.StringUtils;
import org.jgrapht.Graph;
import org.jgrapht.graph.AsSubgraph;
import org.jungrapht.visualization.DefaultSatelliteVisualizationViewer;
import org.jungrapht.visualization.DefaultVisualizationViewer;
import org.jungrapht.visualization.MultiLayerTransformer;
import org.jungrapht.visualization.RenderContext;
import org.jungrapht.visualization.SatelliteVisualizationViewer;
import org.jungrapht.visualization.VisualizationModel;
import org.jungrapht.visualization.VisualizationServer;
import org.jungrapht.visualization.VisualizationViewer;
import org.jungrapht.visualization.annotations.MultiSelectedVertexPaintable;
import org.jungrapht.visualization.annotations.SingleSelectedVertexPaintable;
import org.jungrapht.visualization.control.DefaultLensGraphMouse;
import org.jungrapht.visualization.control.DefaultSatelliteGraphMouse;
import org.jungrapht.visualization.control.LensGraphMouse;
import org.jungrapht.visualization.control.LensMagnificationGraphMousePlugin;
import org.jungrapht.visualization.control.MultiSelectionStrategy;
import org.jungrapht.visualization.decorators.EdgeShape;
import org.jungrapht.visualization.decorators.EllipseShapeFunction;
import org.jungrapht.visualization.decorators.IconShapeFunction;
import org.jungrapht.visualization.layout.algorithms.LayoutAlgorithm;
import org.jungrapht.visualization.layout.algorithms.util.InitialDimensionFunction;
import org.jungrapht.visualization.layout.model.LayoutModel;
import org.jungrapht.visualization.layout.model.Point;
import org.jungrapht.visualization.renderers.BiModalRenderer;
import org.jungrapht.visualization.renderers.JLabelVertexLabelRenderer;
import org.jungrapht.visualization.renderers.LightweightVertexRenderer;
import org.jungrapht.visualization.renderers.ModalRenderer;
import org.jungrapht.visualization.renderers.Renderer;
import org.jungrapht.visualization.renderers.VertexLabelRenderer;
import org.jungrapht.visualization.selection.MutableSelectedState;
import org.jungrapht.visualization.selection.VertexEndpointsSelectedEdgeSelectedState;
import org.jungrapht.visualization.transform.Lens;
import org.jungrapht.visualization.transform.LensSupport;
import org.jungrapht.visualization.transform.LensTransformer;
import org.jungrapht.visualization.transform.MutableTransformer;
import org.jungrapht.visualization.transform.shape.MagnifyImageLensSupport;
import org.jungrapht.visualization.transform.shape.MagnifyShapeTransformer;
import org.jungrapht.visualization.util.RectangleUtils;
import resources.Icons;

public class DefaultGraphDisplay
implements GraphDisplay {
    private static final String ACTION_OWNER = "GraphServices";
    private static final String FAVORED_EDGE = "Fall-Through";
    private static final int MAX_NODES = Integer.getInteger("maxNodes", 10000);
    private static final Dimension PREFERRED_VIEW_SIZE = new Dimension(1000, 1000);
    private static final Dimension PREFERRED_LAYOUT_SIZE = new Dimension(3000, 3000);
    private Logger log = Logger.getLogger(DefaultGraphDisplay.class.getName());
    private GraphDisplayListener listener = new DummyGraphDisplayListener();
    private String title;
    private AttributedGraph graph;
    private final int displayId;
    private final VisualizationViewer<AttributedVertex, AttributedEdge> viewer;
    private final PluginTool pluginTool;
    private final DefaultGraphDisplayComponentProvider componentProvider;
    private boolean ensureVertexIsVisible = false;
    private final LayoutTransitionManager layoutTransitionManager;
    private final DefaultGraphDisplayProvider graphDisplayProvider;
    private AttributedVertex focusedVertex;
    private final GraphJobRunner jobRunner = new GraphJobRunner();
    private final SatelliteVisualizationViewer<AttributedVertex, AttributedEdge> satelliteViewer;
    private FilterDialog filterDialog;
    private AttributeFilters edgeFilters;
    private AttributeFilters vertexFilters;
    private GhidraIconCache iconCache;
    private boolean freeFormSelection;
    private JgtPluggableGraphMouse graphMouse;
    private ToggleDockingAction hideSelectedAction;
    private ToggleDockingAction hideUnselectedAction;
    private SwitchableSelectionItemListener switchableSelectionListener;
    private ToggleDockingAction togglePopupsAction;
    private PopupRegulator<AttributedVertex, AttributedEdge> popupRegulator;

    DefaultGraphDisplay(DefaultGraphDisplayProvider displayProvider, int id) {
        this.graphDisplayProvider = displayProvider;
        this.displayId = id;
        this.pluginTool = this.graphDisplayProvider.getPluginTool();
        this.viewer = this.createViewer();
        this.buildHighlighers();
        this.componentProvider = new DefaultGraphDisplayComponentProvider(this, this.pluginTool);
        this.componentProvider.addToTool();
        this.satelliteViewer = this.createSatelliteViewer(this.viewer);
        if (this.graphDisplayProvider.getDefaultSatelliteState()) {
            this.viewer.getComponent().add(this.satelliteViewer.getComponent());
        }
        this.layoutTransitionManager = new LayoutTransitionManager((VisualizationServer<AttributedVertex, AttributedEdge>)this.viewer, this::isRoot);
        this.viewer.getComponent().addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                super.componentResized(e);
                Component vv = e.getComponent();
                Dimension vvd = vv.getSize();
                Dimension sd = DefaultGraphDisplay.this.satelliteViewer.getSize();
                java.awt.Point p = new java.awt.Point(vvd.width - sd.width, vvd.height - sd.height);
                DefaultGraphDisplay.this.satelliteViewer.getComponent().setBounds(p.x, p.y, sd.width, sd.height);
                DefaultGraphDisplay.this.satelliteViewer.scaleToLayout();
            }
        });
        this.viewer.setInitialDimensionFunction((Function)InitialDimensionFunction.builder((Function)this.viewer.getRenderContext().getVertexBoundsFunction()).build());
        this.createToolbarActions();
        this.createPopupActions();
        this.connectSelectionStateListeners();
    }

    JComponent getComponent() {
        JComponent component = this.viewer.getComponent();
        component.setFocusable(true);
        return component;
    }

    int getId() {
        return this.displayId;
    }

    private LensSupport<LensGraphMouse> createMagnifier() {
        Lens lens = Lens.builder().lensShape(Lens.Shape.RECTANGLE).magnification(3.0f).build();
        lens.setMagnification(2.0f);
        LensMagnificationGraphMousePlugin magnificationPlugin = new LensMagnificationGraphMousePlugin(1.0f, 60.0f, 0.2f);
        MutableTransformer transformer = this.viewer.getRenderContext().getMultiLayerTransformer().getTransformer(MultiLayerTransformer.Layer.VIEW);
        MagnifyShapeTransformer shapeTransformer = ((MagnifyShapeTransformer.Builder)MagnifyShapeTransformer.builder((Lens)lens).delegate(transformer)).build();
        DefaultLensGraphMouse lensGraphMouse = new DefaultLensGraphMouse(magnificationPlugin);
        return ((MagnifyImageLensSupport.Builder)((MagnifyImageLensSupport.Builder)MagnifyImageLensSupport.builder(this.viewer).lensTransformer((LensTransformer)shapeTransformer)).lensGraphMouse((LensGraphMouse)lensGraphMouse)).build();
    }

    private void buildHighlighers() {
        MultiSelectedVertexPaintable multiSelectedVertexPaintable = MultiSelectedVertexPaintable.builder(this.viewer).selectionStrokeMin(4.0f).selectionPaint((Paint)Color.red).useBounds(false).build();
        SingleSelectedVertexPaintable singleSelectedVertexPaintable = SingleSelectedVertexPaintable.builder(this.viewer).selectionStrokeMin(4.0f).selectionPaint((Paint)Color.red).selectedVertexFunction(vs -> this.focusedVertex).build();
        this.viewer.addPostRenderPaintable((VisualizationServer.Paintable)multiSelectedVertexPaintable);
        this.viewer.addPostRenderPaintable((VisualizationServer.Paintable)singleSelectedVertexPaintable);
    }

    private void createToolbarActions() {
        ((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)new ToggleActionBuilder("Scroll To Selection", ACTION_OWNER).toolBarIcon((Icon)Icons.NAVIGATE_ON_INCOMING_EVENT_ICON)).description("Ensure that the 'focused' vertex is visible")).selected(true).onAction(context -> {
            this.ensureVertexIsVisible = ((AbstractButton)context.getSourceObject()).isSelected();
        })).buildAndInstallLocal((ComponentProvider)this.componentProvider);
        this.ensureVertexIsVisible = true;
        ((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)new ToggleActionBuilder("Free-Form Selection", ACTION_OWNER).toolBarIcon(DefaultDisplayGraphIcons.LASSO_ICON)).description("Trace Free-Form Shape to select multiple vertices (CTRL-click-drag)")).selected(false).onAction(context -> {
            this.freeFormSelection = ((AbstractButton)context.getSourceObject()).isSelected();
        })).buildAndInstallLocal((ComponentProvider)this.componentProvider);
        ((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)new ToggleActionBuilder("SatelliteView", ACTION_OWNER).description("Show Satellite View")).toolBarIcon(DefaultDisplayGraphIcons.SATELLITE_VIEW_ICON)).onAction(this::toggleSatellite)).selected(this.graphDisplayProvider.getDefaultSatelliteState()).buildAndInstallLocal((ComponentProvider)this.componentProvider);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Reset View", ACTION_OWNER).description("Fit Graph to Window")).toolBarIcon(DefaultDisplayGraphIcons.FIT_TO_WINDOW)).onAction(context -> this.centerAndScale())).buildAndInstallLocal((ComponentProvider)this.componentProvider);
        LensSupport<LensGraphMouse> magnifyViewSupport = this.createMagnifier();
        ToggleDockingAction lensToggle = ((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)new ToggleActionBuilder("View Magnifier", ACTION_OWNER).description("Show View Magnifier")).toolBarIcon(DefaultDisplayGraphIcons.VIEW_MAGNIFIER_ICON)).onAction(context -> magnifyViewSupport.activate(((AbstractButton)context.getSourceObject()).isSelected()))).build();
        magnifyViewSupport.addItemListener(itemEvent -> lensToggle.setSelected(itemEvent.getStateChange() == 1));
        this.componentProvider.addLocalAction((DockingActionIf)lensToggle);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Show Filters", ACTION_OWNER).description("Show Graph Filters")).toolBarIcon(DefaultDisplayGraphIcons.FILTER_ICON)).onAction(context -> this.showFilterDialog())).buildAndInstallLocal((ComponentProvider)this.componentProvider);
        List<ActionState<String>> layoutActionStates = this.getLayoutActionStates();
        ((MultiStateActionBuilder)((MultiStateActionBuilder)new MultiStateActionBuilder("Arrangement", ACTION_OWNER).description("Arrangement: " + layoutActionStates.get(0).getName())).toolBarIcon(DefaultDisplayGraphIcons.LAYOUT_ALGORITHM_ICON)).fireFirstAction(false).onActionStateChanged((s, t) -> this.layoutChanged(s.getName())).addStates(layoutActionStates).buildAndInstallLocal((ComponentProvider)this.componentProvider);
    }

    private void createPopupActions() {
        ((ActionBuilder)((ActionBuilder)new ActionBuilder("Select Vertex", ACTION_OWNER).popupMenuPath(new String[]{"Select Vertex"})).popupMenuGroup("selection", "1")).withContext(VertexGraphActionContext.class).enabledWhen(c -> !this.isSelected(c.getClickedVertex())).onAction(c -> this.viewer.getSelectedVertexState().select((Object)c.getClickedVertex())).buildAndInstallLocal((ComponentProvider)this.componentProvider);
        ((ActionBuilder)((ActionBuilder)new ActionBuilder("Deselect Vertex", ACTION_OWNER).popupMenuPath(new String[]{"Deselect Vertex"})).popupMenuGroup("selection", "2")).withContext(VertexGraphActionContext.class).enabledWhen(c -> this.isSelected(c.getClickedVertex())).onAction(c -> this.viewer.getSelectedVertexState().deselect((Object)c.getClickedVertex())).buildAndInstallLocal((ComponentProvider)this.componentProvider);
        ((ActionBuilder)((ActionBuilder)new ActionBuilder("Select Edge", ACTION_OWNER).popupMenuPath(new String[]{"Select Edge"})).popupMenuGroup("selection", "1")).withContext(EdgeGraphActionContext.class).enabledWhen(c -> !this.isSelected(c.getClickedEdge())).onAction(c -> this.selectEdge(c.getClickedEdge())).buildAndInstallLocal((ComponentProvider)this.componentProvider);
        ((ActionBuilder)((ActionBuilder)new ActionBuilder("Deselect Edge", ACTION_OWNER).popupMenuPath(new String[]{"Deselect Edge"})).popupMenuGroup("selection", "2")).withContext(EdgeGraphActionContext.class).enabledWhen(c -> this.isSelected(c.getClickedEdge())).onAction(c -> this.deselectEdge(c.getClickedEdge())).buildAndInstallLocal((ComponentProvider)this.componentProvider);
        ((ActionBuilder)((ActionBuilder)new ActionBuilder("Edge Source", ACTION_OWNER).popupMenuPath(new String[]{"Go To Edge Source"})).popupMenuGroup("Go To")).withContext(EdgeGraphActionContext.class).onAction(c -> this.setFocusedVertex((AttributedVertex)this.graph.getEdgeSource((Object)c.getClickedEdge()))).buildAndInstallLocal((ComponentProvider)this.componentProvider);
        ((ActionBuilder)((ActionBuilder)new ActionBuilder("Edge Target", ACTION_OWNER).popupMenuPath(new String[]{"Go To Edge Target"})).popupMenuGroup("Go To")).withContext(EdgeGraphActionContext.class).onAction(c -> this.setFocusedVertex((AttributedVertex)this.graph.getEdgeTarget((Object)c.getClickedEdge()))).buildAndInstallLocal((ComponentProvider)this.componentProvider);
        this.hideSelectedAction = (ToggleDockingAction)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)new ToggleActionBuilder("Hide Selected", ACTION_OWNER).popupMenuPath(new String[]{"Hide Selected"})).popupMenuGroup("z", "1")).description("Toggles whether or not to show selected vertices and edges")).onAction(c -> this.manageVertexDisplay())).buildAndInstallLocal((ComponentProvider)this.componentProvider);
        this.hideUnselectedAction = (ToggleDockingAction)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)new ToggleActionBuilder("Hide Unselected", ACTION_OWNER).popupMenuPath(new String[]{"Hide Unselected"})).popupMenuGroup("z", "2")).description("Toggles whether or not to show selected vertices and edges")).onAction(c -> this.manageVertexDisplay())).buildAndInstallLocal((ComponentProvider)this.componentProvider);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Invert Selection", ACTION_OWNER).popupMenuPath(new String[]{"Invert Selection"})).popupMenuGroup("z", "3")).description("Inverts the current selection")).onAction(c -> this.invertSelection())).buildAndInstallLocal((ComponentProvider)this.componentProvider);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Grow Selection To Targets", ACTION_OWNER).popupMenuPath(new String[]{"Grow Selection To Targets"})).popupMenuGroup("z", "4")).description("Extends the current selection by including the target vertex of all edges whose source is selected")).keyBinding("ctrl O")).enabledWhen(c -> !this.isAllSelected(this.getTargetVerticesFromSelected()))).onAction(c -> this.growSelection(this.getTargetVerticesFromSelected()))).buildAndInstallLocal((ComponentProvider)this.componentProvider);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Grow Selection From Sources", ACTION_OWNER).popupMenuPath(new String[]{"Grow Selection From Sources"})).popupMenuGroup("z", "4")).description("Extends the current selection by including the target vertex of all edges whose source is selected")).keyBinding("ctrl I")).enabledWhen(c -> !this.isAllSelected(this.getSourceVerticesFromSelected()))).onAction(c -> this.growSelection(this.getSourceVerticesFromSelected()))).buildAndInstallLocal((ComponentProvider)this.componentProvider);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Clear Selection", ACTION_OWNER).popupMenuPath(new String[]{"Clear Selection"})).popupMenuGroup("z", "5")).keyBinding("escape")).enabledWhen(c -> this.hasSelection())).onAction(c -> this.clearSelection(true))).buildAndInstallLocal((ComponentProvider)this.componentProvider);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Create Subgraph", ACTION_OWNER).popupMenuPath(new String[]{"Display Selected as New Graph"})).popupMenuGroup("zz", "5")).description("Creates a subgraph from the selected nodes")).enabledWhen(c -> !this.viewer.getSelectedVertexState().getSelected().isEmpty())).onAction(c -> this.createAndDisplaySubGraph())).buildAndInstallLocal((ComponentProvider)this.componentProvider);
        this.togglePopupsAction = (ToggleDockingAction)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)new ToggleActionBuilder("Display Popup Windows", ACTION_OWNER).popupMenuPath(new String[]{"Display Popup Windows"})).popupMenuGroup("zz", "1")).description("Toggles whether or not to show popup windows, such as tool tips")).selected(true).onAction(c -> this.popupRegulator.setPopupsVisible(this.togglePopupsAction.isSelected()))).buildAndInstallLocal((ComponentProvider)this.componentProvider);
        this.popupRegulator.setPopupsVisible(this.togglePopupsAction.isSelected());
    }

    private void clearSelection(boolean fireEvents) {
        this.viewer.getSelectedVertexState().clear(fireEvents);
        this.viewer.getSelectedEdgeState().clear(fireEvents);
    }

    private boolean hasSelection() {
        return !this.viewer.getSelectedVertexState().getSelected().isEmpty() || !this.viewer.getSelectedEdgeState().getSelected().isEmpty();
    }

    private boolean isSelected(AttributedVertex v) {
        return this.viewer.getSelectedVertexState().isSelected((Object)v);
    }

    private boolean isSelected(AttributedEdge e) {
        return this.viewer.getSelectedEdgeState().isSelected((Object)e);
    }

    private void createAndDisplaySubGraph() {
        GraphDisplay display = this.graphDisplayProvider.getGraphDisplay(false, TaskMonitor.DUMMY);
        try {
            display.setGraph(this.createSubGraph(), "SubGraph", false, TaskMonitor.DUMMY);
            display.setGraphDisplayListener(this.listener.cloneWith(display));
        }
        catch (CancelledException cancelledException) {
            // empty catch block
        }
    }

    private AttributedGraph createSubGraph() {
        Set selected = this.viewer.getSelectedVertexState().getSelected();
        AsSubgraph subGraph = new AsSubgraph((Graph)this.graph, selected);
        AttributedGraph newGraph = new AttributedGraph();
        subGraph.vertexSet().forEach(arg_0 -> ((AttributedGraph)newGraph).addVertex(arg_0));
        subGraph.edgeSet().forEach(arg_0 -> DefaultGraphDisplay.lambda$createSubGraph$30((Graph)subGraph, newGraph, arg_0));
        return newGraph;
    }

    private void growSelection(Set<AttributedVertex> vertices) {
        this.viewer.getSelectedVertexState().select(vertices);
    }

    private boolean isAllSelected(Set<AttributedVertex> vertices) {
        return this.viewer.getSelectedVertexState().getSelected().containsAll(vertices);
    }

    private Set<AttributedVertex> getTargetVerticesFromSelected() {
        HashSet<AttributedVertex> targets = new HashSet<AttributedVertex>();
        Set<AttributedVertex> selectedVertices = this.getSelectedVertices();
        selectedVertices.forEach(v -> {
            Set edges = this.graph.outgoingEdgesOf(v);
            edges.forEach(e -> targets.add((AttributedVertex)this.graph.getEdgeTarget(e)));
        });
        return targets;
    }

    private Set<AttributedVertex> getSourceVerticesFromSelected() {
        HashSet<AttributedVertex> sources = new HashSet<AttributedVertex>();
        Set<AttributedVertex> selectedVertices = this.getSelectedVertices();
        selectedVertices.forEach(v -> {
            Set edges = this.graph.incomingEdgesOf(v);
            edges.forEach(e -> sources.add((AttributedVertex)this.graph.getEdgeSource(e)));
        });
        return sources;
    }

    private void invertSelection() {
        this.switchableSelectionListener.setEnabled(false);
        try {
            MutableSelectedState selectedVertexState = this.viewer.getSelectedVertexState();
            this.graph.vertexSet().forEach(v -> {
                if (selectedVertexState.isSelected(v)) {
                    selectedVertexState.deselect(v);
                } else {
                    selectedVertexState.select(v);
                }
            });
            Set selected = selectedVertexState.getSelected();
            this.notifySelectionChanged(selected);
        }
        finally {
            this.switchableSelectionListener.setEnabled(true);
        }
    }

    private List<ActionState<String>> getLayoutActionStates() {
        String[] names = this.layoutTransitionManager.getLayoutNames();
        ArrayList<ActionState<String>> actionStates = new ArrayList<ActionState<String>>();
        for (String layoutName : names) {
            ActionState state = new ActionState(layoutName, DefaultDisplayGraphIcons.LAYOUT_ALGORITHM_ICON, (Object)layoutName);
            state.setHelpLocation(new HelpLocation(ACTION_OWNER, layoutName));
            actionStates.add((ActionState<String>)state);
        }
        return actionStates;
    }

    private void layoutChanged(String layoutName) {
        if (this.layoutTransitionManager != null) {
            new TaskLauncher((Task)new SetLayoutTask(this.viewer, this.layoutTransitionManager, layoutName), null, 1000);
        }
    }

    private void showFilterDialog() {
        if (this.filterDialog == null) {
            if (this.vertexFilters == null) {
                Msg.showWarn((Object)this, null, (String)"No Graph", (Object)"Can't set filters with no graph present!");
                return;
            }
            this.filterDialog = new FilterDialog(this.vertexFilters.getButtons(), this.edgeFilters.getButtons());
        }
        this.componentProvider.getTool().showDialog((DialogComponentProvider)this.filterDialog);
    }

    private void toggleSatellite(ActionContext context) {
        boolean selected = ((AbstractButton)context.getSourceObject()).isSelected();
        this.graphDisplayProvider.setDefaultSatelliteState(selected);
        if (selected) {
            this.viewer.getComponent().add(this.satelliteViewer.getComponent());
            this.satelliteViewer.scaleToLayout();
        } else {
            this.viewer.getComponent().remove(this.satelliteViewer.getComponent());
        }
        this.viewer.repaint();
    }

    private SatelliteVisualizationViewer<AttributedVertex, AttributedEdge> createSatelliteViewer(VisualizationViewer<AttributedVertex, AttributedEdge> parentViewer) {
        Dimension viewerSize = parentViewer.getSize();
        Dimension satelliteSize = new Dimension(viewerSize.width / 4, viewerSize.height / 4);
        DefaultSatelliteVisualizationViewer satellite = ((SatelliteVisualizationViewer.Builder)SatelliteVisualizationViewer.builder(parentViewer).viewSize(satelliteSize)).build();
        satellite.setGraphMouse((VisualizationViewer.GraphMouse)new DefaultSatelliteGraphMouse());
        satellite.getRenderContext().setEdgeDrawPaintFunction(Colors::getColor);
        satellite.getRenderContext().setEdgeStrokeFunction(ProgramGraphFunctions::getEdgeStroke);
        satellite.getRenderContext().setVertexFillPaintFunction(Colors::getColor);
        satellite.scaleToLayout();
        satellite.getRenderContext().setVertexLabelFunction(n -> null);
        satellite.getRenderContext().setVertexIncludePredicate(v -> this.viewer.getRenderContext().getVertexIncludePredicate().test(v));
        satellite.getComponent().setBorder(BorderFactory.createEtchedBorder());
        parentViewer.getComponent().addComponentListener(new ComponentAdapter((SatelliteVisualizationViewer)satellite){
            final /* synthetic */ SatelliteVisualizationViewer val$satellite;
            {
                this.val$satellite = satelliteVisualizationViewer;
            }

            @Override
            public void componentResized(ComponentEvent evt) {
                Dimension size = evt.getComponent().getSize();
                Dimension quarterSize = new Dimension(size.width / 4, size.height / 4);
                this.val$satellite.getComponent().setSize(quarterSize);
            }
        });
        return satellite;
    }

    public void close() {
        this.graphDisplayProvider.remove(this);
        if (this.listener != null) {
            this.listener.graphClosed();
        }
        this.listener = null;
        this.componentProvider.closeComponent();
    }

    public void setGraphDisplayListener(GraphDisplayListener listener) {
        if (this.listener != null) {
            this.listener.graphClosed();
        }
        this.listener = listener;
    }

    private void deselectEdge(AttributedEdge edge) {
        this.viewer.getSelectedEdgeState().deselect((Object)edge);
        AttributedVertex source = (AttributedVertex)this.graph.getEdgeSource((Object)edge);
        AttributedVertex target = (AttributedVertex)this.graph.getEdgeTarget((Object)edge);
        this.viewer.getSelectedVertexState().deselect(Set.of(source, target));
    }

    private void selectEdge(AttributedEdge edge) {
        this.viewer.getSelectedEdgeState().select((Object)edge);
        AttributedVertex source = (AttributedVertex)this.graph.getEdgeSource((Object)edge);
        AttributedVertex target = (AttributedVertex)this.graph.getEdgeTarget((Object)edge);
        this.viewer.getSelectedVertexState().select(Set.of(source, target));
    }

    private void connectSelectionStateListeners() {
        this.switchableSelectionListener = new SwitchableSelectionItemListener();
        this.viewer.getSelectedVertexState().addItemListener((ItemListener)this.switchableSelectionListener);
    }

    public void setFocusedVertex(AttributedVertex vertex) {
        this.setFocusedVertex(vertex, EventTrigger.API_CALL);
    }

    public void setFocusedVertex(AttributedVertex vertex, EventTrigger eventTrigger) {
        boolean changed = this.focusedVertex != vertex;
        this.focusedVertex = vertex;
        if (this.focusedVertex != null) {
            if (changed && eventTrigger != EventTrigger.INTERNAL_ONLY) {
                this.notifyLocationFocusChanged(this.focusedVertex);
            }
            this.scrollToSelected(this.focusedVertex);
        }
        this.viewer.repaint();
    }

    private boolean isVisible(double x, double y) {
        if (this.viewer.getComponent().isVisible() && !this.viewer.getBounds().isEmpty()) {
            return this.viewer.getRenderContext().getMultiLayerTransformer().inverseTransform((Shape)this.viewer.getBounds()).getBounds().contains(x, y);
        }
        return true;
    }

    private Collection<AttributedVertex> getVertices(Object item) {
        if (item instanceof Collection) {
            return (Collection)item;
        }
        if (item instanceof AttributedVertex) {
            return List.of((AttributedVertex)item);
        }
        return Collections.emptyList();
    }

    private void notifySelectionChanged(Set<AttributedVertex> selected) {
        Swing.runLater(() -> this.listener.selectionChanged(selected));
    }

    private void notifyLocationFocusChanged(AttributedVertex vertex) {
        Swing.runLater(() -> this.listener.locationFocusChanged(vertex));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectVertices(Set<AttributedVertex> selected, EventTrigger eventTrigger) {
        this.switchableSelectionListener.setEnabled(eventTrigger != EventTrigger.INTERNAL_ONLY);
        try {
            MutableSelectedState nodeSelectedState = this.viewer.getSelectedVertexState();
            if (selected.isEmpty()) {
                nodeSelectedState.clear();
            } else if (!Arrays.asList(nodeSelectedState.getSelectedObjects()).containsAll(selected)) {
                nodeSelectedState.clear();
                nodeSelectedState.select(selected, false);
                this.scrollToSelected(selected);
            }
            this.viewer.repaint();
        }
        finally {
            this.switchableSelectionListener.setEnabled(true);
        }
    }

    private void doSetGraphData(AttributedGraph attributedGraph) {
        this.clearSelection(false);
        this.focusedVertex = null;
        this.graph = attributedGraph;
        this.layoutTransitionManager.setEdgeComparator(new EdgeComparator(this.graph, "EdgeType", FAVORED_EDGE));
        this.configureViewerPreferredSize();
        Swing.runNow(() -> {
            this.viewer.getVisualizationModel().setGraph((Graph)this.graph, false);
            this.configureFilters();
            LayoutAlgorithm<AttributedVertex> initialLayoutAlgorithm = this.layoutTransitionManager.getInitialLayoutAlgorithm();
            initialLayoutAlgorithm.setAfter(() -> this.centerAndScale());
            this.viewer.getVisualizationModel().setLayoutAlgorithm(initialLayoutAlgorithm);
        });
        this.componentProvider.setVisible(true);
    }

    private boolean isRoot(AttributedVertex vertex) {
        Set incomingEdgesOf = this.graph.incomingEdgesOf((Object)vertex);
        return incomingEdgesOf.isEmpty();
    }

    private void configureFilters() {
        if (this.filterDialog != null) {
            this.filterDialog.close();
            this.filterDialog = null;
        }
        Set vertices = this.graph.vertexSet();
        Set edges = this.graph.edgeSet();
        this.vertexFilters = AttributeFilters.builder().exclude(Set.of("Address", "Code", "Name")).elements(vertices).maxFactor(0.05).buttonSupplier(JRadioButton::new).paintFunction(v -> Colors.VERTEX_TYPE_TO_COLOR_MAP.getOrDefault(v, Color.blue)).build();
        this.vertexFilters.addItemListener(item -> {
            Set selected = (Set)item.getItem();
            this.viewer.getRenderContext().setVertexIncludePredicate(v -> v.getAttributeMap().values().stream().noneMatch(selected::contains));
            this.viewer.repaint();
        });
        this.edgeFilters = AttributeFilters.builder().exclude(Set.of("*ToKey", "*FromKey", "Address", "Name")).elements(edges).maxFactor(0.01).buttonSupplier(JRadioButton::new).paintFunction(e -> Colors.EDGE_TYPE_TO_COLOR_MAP.getOrDefault(e, Color.green)).build();
        this.edgeFilters.addItemListener(item -> {
            Set selected = (Set)item.getItem();
            this.viewer.getRenderContext().setEdgeIncludePredicate(e -> e.getAttributeMap().values().stream().noneMatch(selected::contains));
            this.viewer.repaint();
        });
    }

    private void configureViewerPreferredSize() {
        int vertexCount = this.graph.vertexSet().size();
        Dimension viewSize = this.viewer.getPreferredSize();
        if (vertexCount < 100) {
            this.viewer.getVisualizationModel().getLayoutModel().setPreferredSize(viewSize.width, viewSize.height);
        } else {
            int newSize = viewSize.width + 5 * (vertexCount - 100);
            this.viewer.getVisualizationModel().getLayoutModel().setPreferredSize(newSize, newSize);
        }
    }

    public void defineVertexAttribute(String attributeName) {
        this.log.fine("defineVertexAttribute " + attributeName + " is not implemented");
    }

    public void defineEdgeAttribute(String attributeName) {
        this.log.fine("defineEdgeAttribute " + attributeName + " is not implemented");
    }

    public void setVertexLabel(String attributeName, int alignment, int size, boolean monospace, int maxLines) {
        this.log.fine("setVertexLabel " + attributeName);
    }

    public void setGraph(AttributedGraph graph, String title, boolean append, TaskMonitor monitor) {
        this.iconCache.clear();
        if (append && Objects.equals(title, this.title) && this.graph != null) {
            graph = this.mergeGraphs(graph, this.graph);
        }
        this.title = title;
        this.componentProvider.setTitle(title);
        int count = graph.getVertexCount();
        if (count > MAX_NODES) {
            Msg.showWarn((Object)this, null, (String)"Graph Not Rendered - Too many nodes!", (Object)("Exceeded limit of " + MAX_NODES + " nodes.\n\n  Graph contained " + count + " nodes!"));
            graph = new AttributedGraph();
            graph.addVertex("1", "Graph Aborted");
        }
        this.doSetGraphData(graph);
    }

    private AttributedGraph mergeGraphs(AttributedGraph newGraph, AttributedGraph oldGraph) {
        for (AttributedVertex vertex : oldGraph.vertexSet()) {
            newGraph.addVertex(vertex);
        }
        for (AttributedEdge edge : oldGraph.edgeSet()) {
            AttributedVertex from = (AttributedVertex)oldGraph.getEdgeSource((Object)edge);
            AttributedVertex to = (AttributedVertex)oldGraph.getEdgeTarget((Object)edge);
            AttributedEdge newEdge = newGraph.addEdge(from, to);
            Map attributeMap = edge.getAttributeMap();
            for (String key : attributeMap.keySet()) {
                newEdge.setAttribute(key, edge.getAttribute(key));
            }
        }
        return newGraph;
    }

    public void centerAndScale() {
        this.viewer.scaleToLayout();
        this.satelliteViewer.scaleToLayout();
    }

    public void clear() {
        this.graph.removeAllEdges(new HashSet(this.graph.edgeSet()));
        this.graph.removeAllVertices(new HashSet(this.graph.vertexSet()));
    }

    void scrollToSelected(Collection<AttributedVertex> vertices) {
        if (this.ensureVertexIsVisible) {
            this.jobRunner.finishAllJobs();
            Point2D newCenter = this.getPointToCenter(vertices);
            if (!this.isVisible(newCenter.getX(), newCenter.getY())) {
                Point2D existingCenter = this.viewer.getRenderContext().getMultiLayerTransformer().inverseTransform(this.viewer.getCenter());
                this.jobRunner.schedule((GraphJob)new CenterAnimationJob(this.viewer, existingCenter, newCenter));
            }
        }
    }

    private void scrollToSelected(AttributedVertex vertex) {
        List<AttributedVertex> vertices = vertex == null ? Collections.emptyList() : List.of(vertex);
        this.scrollToSelected(vertices);
    }

    private Point2D getPointToCenter(Collection<AttributedVertex> vertices) {
        LayoutModel layoutModel = this.viewer.getVisualizationModel().getLayoutModel();
        Collection points = vertices.stream().map(layoutModel).collect(Collectors.toList());
        if (points.size() > 0) {
            Point p = Point.centroidOf((Collection)points);
            return new Point2D.Double(p.x, p.y);
        }
        Point2D center = this.viewer.getCenter();
        Point p = Point.of((double)center.getX(), (double)center.getY());
        return new Point2D.Double(p.x, p.y);
    }

    public void updateVertexName(AttributedVertex vertex, String newName) {
        vertex.setName(newName);
        vertex.clearCache();
        this.iconCache.evict(vertex);
        this.viewer.repaint();
    }

    public String getGraphTitle() {
        return this.title;
    }

    public VisualizationViewer<AttributedVertex, AttributedEdge> createViewer() {
        MouseListener[] mouseListeners;
        DefaultVisualizationViewer vv = ((VisualizationViewer.Builder)((VisualizationViewer.Builder)VisualizationViewer.builder().multiSelectionStrategySupplier(() -> this.freeFormSelection ? MultiSelectionStrategy.arbitrary() : MultiSelectionStrategy.rectangular()).viewSize(PREFERRED_VIEW_SIZE)).layoutSize(PREFERRED_LAYOUT_SIZE)).build();
        vv.getComponent().addAncestorListener(new AncestorListener((VisualizationViewer)vv){
            final /* synthetic */ VisualizationViewer val$vv;
            {
                this.val$vv = visualizationViewer;
            }

            @Override
            public void ancestorAdded(AncestorEvent ancestorEvent) {
                this.val$vv.getComponent().removeAncestorListener(this);
                Swing.runLater(() -> DefaultGraphDisplay.this.centerAndScale());
            }

            @Override
            public void ancestorRemoved(AncestorEvent ancestorEvent) {
            }

            @Override
            public void ancestorMoved(AncestorEvent ancestorEvent) {
            }
        });
        vv.setVertexToolTipFunction(v -> null);
        vv.setEdgeToolTipFunction(e -> null);
        vv.setToolTipText(null);
        GraphDisplayPopupSource popupSource = new GraphDisplayPopupSource((VisualizationViewer<AttributedVertex, AttributedEdge>)vv);
        this.popupRegulator = new PopupRegulator((PopupSource)popupSource);
        this.iconCache = new GhidraIconCache();
        RenderContext renderContext = vv.getRenderContext();
        IconShapeFunction nodeImageShapeFunction = new IconShapeFunction((Function)new EllipseShapeFunction());
        vv.getRenderContext().setVertexIconFunction(this.iconCache::get);
        nodeImageShapeFunction.setIconFunction(this.iconCache::get);
        renderContext.setVertexShapeFunction((Function)nodeImageShapeFunction);
        renderContext.setVertexIconFunction(this.iconCache::get);
        vv.setInitialDimensionFunction((Function)InitialDimensionFunction.builder((Function)nodeImageShapeFunction.andThen(s -> RectangleUtils.convert((Rectangle2D)s.getBounds2D()))).build());
        vv.setSelectedEdgeState((MutableSelectedState)new VertexEndpointsSelectedEdgeSelectedState(() -> ((VisualizationModel)vv.getVisualizationModel()).getGraph(), vv.getSelectedVertexState()));
        renderContext.setEdgeStrokeFunction(e -> renderContext.getSelectedEdgeState().isSelected(e) ? new BasicStroke(20.0f) : ProgramGraphFunctions.getEdgeStroke(e));
        renderContext.setEdgeDrawPaintFunction(e -> renderContext.getSelectedEdgeState().isSelected(e) ? Color.red : Colors.getColor((Attributed)e));
        renderContext.setArrowDrawPaintFunction(e -> renderContext.getSelectedEdgeState().isSelected(e) ? Color.red : Colors.getColor((Attributed)e));
        renderContext.setArrowFillPaintFunction(e -> renderContext.getSelectedEdgeState().isSelected(e) ? Color.red : Colors.getColor((Attributed)e));
        ModalRenderer modalRenderer = vv.getRenderer();
        Renderer.Vertex vertexRenderer = modalRenderer.getVertexRenderer(BiModalRenderer.LIGHTWEIGHT);
        if (vertexRenderer instanceof LightweightVertexRenderer) {
            LightweightVertexRenderer lightweightVertexRenderer = (LightweightVertexRenderer)vertexRenderer;
            lightweightVertexRenderer.setVertexShapeFunction(ProgramGraphFunctions::getVertexShape);
        }
        renderContext.setVertexLabelRenderer((VertexLabelRenderer)new JLabelVertexLabelRenderer(Color.black));
        renderContext.setVertexDrawPaintFunction(Colors::getColor);
        renderContext.setVertexFillPaintFunction(Colors::getColor);
        renderContext.setVertexStrokeFunction(n -> new BasicStroke(3.0f));
        renderContext.setEdgeShapeFunction((BiFunction)EdgeShape.line());
        vv.getComponent().requestFocus();
        vv.setBackground(Color.WHITE);
        for (MouseListener mouseListener : mouseListeners = vv.getComponent().getMouseListeners()) {
            vv.getComponent().removeMouseListener(mouseListener);
        }
        this.graphMouse = new JgtPluggableGraphMouse(this);
        vv.setGraphMouse((VisualizationViewer.GraphMouse)this.graphMouse);
        return vv;
    }

    public void addAction(DockingAction action) {
        Swing.runLater(() -> this.componentProvider.addLocalAction((DockingActionIf)action));
    }

    public AttributedVertex getFocusedVertex() {
        return this.focusedVertex;
    }

    public Set<AttributedVertex> getSelectedVertices() {
        return this.viewer.getSelectedVertexState().getSelected();
    }

    public ActionContext getActionContext(MouseEvent e) {
        AttributedVertex pickedVertex = JgtUtils.getVertex(e, this.viewer);
        if (pickedVertex != null) {
            return new VertexGraphActionContext((ComponentProvider)this.componentProvider, this.graph, this.getSelectedVertices(), this.focusedVertex, pickedVertex);
        }
        AttributedEdge pickedEdge = JgtUtils.getEdge(e, this.viewer);
        if (pickedEdge != null) {
            return new EdgeGraphActionContext((ComponentProvider)this.componentProvider, this.graph, this.getSelectedVertices(), this.focusedVertex, pickedEdge);
        }
        return new GraphActionContext((ComponentProvider)this.componentProvider, this.graph, this.getSelectedVertices(), this.focusedVertex);
    }

    private void manageVertexDisplay() {
        boolean hideSelected = this.hideSelectedAction.isSelected();
        boolean hideUnselected = this.hideUnselectedAction.isSelected();
        MutableSelectedState selectedVertexState = this.viewer.getSelectedVertexState();
        if (hideSelected && hideUnselected) {
            this.viewer.getRenderContext().setVertexIncludePredicate(v -> false);
        } else if (hideSelected) {
            this.viewer.getRenderContext().setVertexIncludePredicate(Predicate.not(arg_0 -> ((MutableSelectedState)selectedVertexState).isSelected(arg_0)));
        } else if (hideUnselected) {
            this.viewer.getRenderContext().setVertexIncludePredicate(arg_0 -> ((MutableSelectedState)selectedVertexState).isSelected(arg_0));
        } else {
            this.viewer.getRenderContext().setVertexIncludePredicate(v -> true);
        }
        this.viewer.repaint();
    }

    public AttributedGraph getGraph() {
        return this.graph;
    }

    void restoreToDefaultSetOfActions() {
        Swing.runLater(() -> {
            this.componentProvider.removeAllLocalActions();
            this.createToolbarActions();
            this.createPopupActions();
        });
    }

    private static /* synthetic */ void lambda$createSubGraph$30(Graph subGraph, AttributedGraph newGraph, AttributedEdge e) {
        AttributedVertex source = (AttributedVertex)subGraph.getEdgeSource((Object)e);
        AttributedVertex target = (AttributedVertex)subGraph.getEdgeTarget((Object)e);
        newGraph.addEdge(source, target, e);
    }

    private class EdgeToolTipInfo
    extends ToolTipInfo<AttributedEdge> {
        EdgeToolTipInfo(AttributedEdge edge, MouseEvent event) {
            super(event, (Object)edge);
        }

        protected JComponent createToolTipComponent() {
            if (this.graphObject == null) {
                return null;
            }
            String toolTip = ((AttributedEdge)this.graphObject).getHtmlString();
            if (StringUtils.isBlank((CharSequence)toolTip)) {
                return null;
            }
            JToolTip jToolTip = new JToolTip();
            jToolTip.setTipText(toolTip);
            return jToolTip;
        }

        protected void emphasize() {
        }

        protected void deEmphasize() {
        }
    }

    private class VertexToolTipInfo
    extends ToolTipInfo<AttributedVertex> {
        VertexToolTipInfo(AttributedVertex vertex, MouseEvent event) {
            super(event, (Object)vertex);
        }

        public JComponent createToolTipComponent() {
            if (this.graphObject == null) {
                return null;
            }
            String toolTip = ((AttributedVertex)this.graphObject).getHtmlString();
            if (StringUtils.isBlank((CharSequence)toolTip)) {
                return null;
            }
            JToolTip jToolTip = new JToolTip();
            jToolTip.setTipText(toolTip);
            return jToolTip;
        }

        protected void emphasize() {
        }

        protected void deEmphasize() {
        }
    }

    private class GraphDisplayPopupSource
    implements PopupSource<AttributedVertex, AttributedEdge> {
        private VisualizationViewer<AttributedVertex, AttributedEdge> vv;

        public GraphDisplayPopupSource(VisualizationViewer<AttributedVertex, AttributedEdge> vv) {
            this.vv = vv;
        }

        public ToolTipInfo<?> getToolTipInfo(MouseEvent event) {
            AttributedVertex vertex = this.getVertex(event);
            if (vertex != null) {
                return new VertexToolTipInfo(vertex, event);
            }
            AttributedEdge edge = this.getEdge(event);
            if (edge != null) {
                return new EdgeToolTipInfo(edge, event);
            }
            return new VertexToolTipInfo(vertex, event);
        }

        public AttributedVertex getVertex(MouseEvent event) {
            LayoutModel layoutModel = this.vv.getVisualizationModel().getLayoutModel();
            Point2D p = this.vv.getTransformSupport().inverseTransform(this.vv, (Point2D)event.getPoint());
            AttributedVertex vertex = (AttributedVertex)this.vv.getPickSupport().getVertex(layoutModel, p.getX(), p.getY());
            return vertex;
        }

        public AttributedEdge getEdge(MouseEvent event) {
            LayoutModel layoutModel = this.vv.getVisualizationModel().getLayoutModel();
            Point2D p = this.vv.getTransformSupport().inverseTransform(this.vv, (Point2D)event.getPoint());
            AttributedEdge edge = (AttributedEdge)this.vv.getPickSupport().getEdge(layoutModel, p.getX(), p.getY());
            return edge;
        }

        public void addMouseMotionListener(MouseMotionListener l) {
            this.vv.getComponent().addMouseMotionListener(l);
        }

        public void repaint() {
            this.vv.repaint();
        }

        public Window getPopupParent() {
            return WindowUtilities.windowForComponent((Component)this.vv.getComponent());
        }
    }

    class SwitchableSelectionItemListener
    implements ItemListener {
        boolean enabled = true;

        SwitchableSelectionItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (this.enabled) {
                Swing.runLater(() -> this.run(e));
            }
        }

        private void run(ItemEvent e) {
            if (e.getStateChange() == 1) {
                Collection<AttributedVertex> selectedVertices = DefaultGraphDisplay.this.getVertices(e.getItem());
                DefaultGraphDisplay.this.notifySelectionChanged(new HashSet<AttributedVertex>(selectedVertices));
                if (selectedVertices.size() == 1) {
                    DefaultGraphDisplay.this.setFocusedVertex(selectedVertices.stream().findFirst().get());
                } else if (DefaultGraphDisplay.this.focusedVertex == null) {
                    DefaultGraphDisplay.this.setFocusedVertex(selectedVertices.stream().findFirst().orElse(null));
                }
            } else if (e.getStateChange() == 2) {
                DefaultGraphDisplay.this.notifySelectionChanged(Collections.emptySet());
            }
            DefaultGraphDisplay.this.viewer.repaint();
        }

        void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }
}

