/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.visualization;

import ghidra.graph.visualization.Colors;
import ghidra.graph.visualization.IconShape;
import ghidra.graph.visualization.ProgramGraphFunctions;
import ghidra.service.graph.Attributed;
import ghidra.service.graph.AttributedVertex;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;

public class GhidraIconCache {
    private static final int DEFAULT_STROKE_THICKNESS = 12;
    private static final int DEFAULT_FONT_SIZE = 12;
    private static final String DEFAULT_FONT_NAME = "Dialog";
    private static final int DEFAULT_MARGIN_BORDER_SIZE = 8;
    private static final float LABEL_TO_ICON_PROPORTION = 1.1f;
    private final JLabel rendererLabel = new JLabel();
    private final Map<RenderingHints.Key, Object> renderingHints = new HashMap<RenderingHints.Key, Object>();
    private int strokeThickness = 12;
    private final Map<AttributedVertex, Icon> map = new ConcurrentHashMap<AttributedVertex, Icon>();
    private final IconShape.Function iconShapeFunction = new IconShape.Function();

    Icon get(AttributedVertex vertex) {
        Icon icon = this.map.get(vertex);
        if (icon == null) {
            icon = this.createIcon(vertex);
            this.map.put(vertex, icon);
        }
        return icon;
    }

    GhidraIconCache() {
        this.renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    }

    private Icon createIcon(AttributedVertex vertex) {
        this.rendererLabel.setText(ProgramGraphFunctions.getLabel((Attributed)vertex));
        this.rendererLabel.setFont(new Font(DEFAULT_FONT_NAME, 1, 12));
        this.rendererLabel.setForeground(Color.black);
        this.rendererLabel.setBackground(Color.white);
        this.rendererLabel.setOpaque(true);
        Border lineBorder = BorderFactory.createLineBorder((Color)Colors.getColor((Attributed)vertex), 2);
        Border marginBorder = BorderFactory.createEmptyBorder(8, 8, 8, 8);
        this.rendererLabel.setBorder(new CompoundBorder(lineBorder, marginBorder));
        Dimension labelSize = this.rendererLabel.getPreferredSize();
        this.rendererLabel.setSize(labelSize);
        Shape shape = ProgramGraphFunctions.getVertexShape((Attributed)vertex);
        IconShape.Type shapeType = this.iconShapeFunction.apply(shape);
        return this.createImageIcon(vertex, shapeType, this.rendererLabel, labelSize, shape);
    }

    private Icon createImageIcon(AttributedVertex vertex, IconShape.Type vertexShapeCategory, JLabel label, Dimension labelSize, Shape vertexShape) {
        int offset = 0;
        switch (vertexShapeCategory) {
            case TRIANGLE: {
                double scalex = labelSize.getWidth() / vertexShape.getBounds().getWidth() * (double)1.1f;
                double scaley = labelSize.getHeight() / vertexShape.getBounds().getHeight() * (double)1.1f;
                vertexShape = AffineTransform.getScaleInstance(scalex, scaley).createTransformedShape(vertexShape);
                offset = -((int)((vertexShape.getBounds().getHeight() - labelSize.getHeight()) / 2.0));
                break;
            }
            case INVERTED_TRIANGLE: {
                double scalex = labelSize.getWidth() / vertexShape.getBounds().getWidth() * (double)1.1f;
                double scaley = labelSize.getHeight() / vertexShape.getBounds().getHeight() * (double)1.1f;
                vertexShape = AffineTransform.getScaleInstance(scalex, scaley).createTransformedShape(vertexShape);
                offset = (int)((vertexShape.getBounds().getHeight() - labelSize.getHeight()) / 2.0);
                break;
            }
            case RECTANGLE: {
                double scalex = labelSize.getWidth() / vertexShape.getBounds().getWidth();
                double scaley = labelSize.getHeight() / vertexShape.getBounds().getHeight();
                vertexShape = AffineTransform.getScaleInstance(scalex, scaley).createTransformedShape(vertexShape);
                break;
            }
            default: {
                double scalex = labelSize.getWidth() / vertexShape.getBounds().getWidth() * 1.1;
                double scaley = labelSize.getHeight() / vertexShape.getBounds().getHeight() * 1.1;
                vertexShape = AffineTransform.getScaleInstance(scalex, scaley).createTransformedShape(vertexShape);
            }
        }
        Rectangle vertexBounds = vertexShape.getBounds();
        BufferedImage bufferedImage = new BufferedImage(vertexBounds.width + 2 * this.strokeThickness, vertexBounds.height + 2 * this.strokeThickness, 2);
        Graphics2D graphics = bufferedImage.createGraphics();
        graphics.setRenderingHints(this.renderingHints);
        AffineTransform graphicsTransform = graphics.getTransform();
        AffineTransform offsetTransform = AffineTransform.getTranslateInstance((double)this.strokeThickness + (double)vertexBounds.width / 2.0, (double)this.strokeThickness + (double)vertexBounds.height / 2.0);
        offsetTransform.preConcatenate(graphicsTransform);
        graphics.setTransform(offsetTransform);
        graphics.setPaint(Color.white);
        graphics.fill(vertexShape);
        graphics.setPaint(Colors.getColor((Attributed)vertex));
        graphics.setStroke(new BasicStroke(this.strokeThickness));
        graphics.draw(vertexShape);
        int xoffset = this.strokeThickness + (vertexBounds.width - labelSize.width) / 2;
        int yoffset = this.strokeThickness + (vertexBounds.height - labelSize.height) / 2;
        offsetTransform = AffineTransform.getTranslateInstance(xoffset, yoffset + offset);
        offsetTransform.preConcatenate(graphicsTransform);
        graphics.setPaint(Color.black);
        graphics.setTransform(offsetTransform);
        label.paint(graphics);
        offsetTransform = AffineTransform.getTranslateInstance((double)this.strokeThickness + (double)vertexBounds.width / 2.0, (double)this.strokeThickness + (double)vertexBounds.height / 2.0);
        offsetTransform.preConcatenate(graphicsTransform);
        graphics.setTransform(offsetTransform);
        Paint paint = Colors.getColor((Attributed)vertex);
        if (paint instanceof Color) {
            Color color = (Color)paint;
            Color transparent = new Color(color.getRed(), color.getGreen(), color.getBlue(), 50);
            graphics.setPaint(transparent);
            graphics.setStroke(new BasicStroke(this.strokeThickness));
            graphics.draw(vertexShape);
        }
        graphics.setTransform(graphicsTransform);
        graphics.dispose();
        return new ImageIcon(bufferedImage);
    }

    public void clear() {
        this.map.clear();
    }

    public void evict(AttributedVertex vertex) {
        this.map.remove(vertex);
    }
}

