/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.visualization;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import org.jgrapht.Graph;
import org.jungrapht.visualization.layout.model.LayoutModel;
import org.jungrapht.visualization.layout.model.Point;

public class PostProcessRunnable<V, E>
implements Runnable {
    LayoutModel<V> layoutModel;

    public PostProcessRunnable(LayoutModel<V> layoutModel) {
        this.layoutModel = layoutModel;
    }

    @Override
    public void run() {
        this.moveVerticesThatOverlapVerticalEdges(this.layoutModel);
    }

    protected int moveVerticesThatOverlapVerticalEdges(LayoutModel<V> layoutModel) {
        int offset = 100;
        int moved = 0;
        Graph graph = layoutModel.getGraph();
        LinkedHashMap verticalEdgeMap = new LinkedHashMap();
        graph.edgeSet().stream().filter(e -> ((Point)layoutModel.apply((Object)graph.getEdgeSource((Object)e))).x == ((Point)layoutModel.apply((Object)graph.getEdgeTarget((Object)e))).x).forEach(e -> verticalEdgeMap.computeIfAbsent(((Point)layoutModel.apply((Object)graph.getEdgeSource((Object)e))).x, k -> new HashSet()).add(e));
        for (Object v : graph.vertexSet()) {
            double x = ((Point)layoutModel.apply(v)).x;
            for (Object edge : verticalEdgeMap.getOrDefault(x, Collections.emptySet())) {
                double vy;
                Object source = graph.getEdgeSource(edge);
                Object target = graph.getEdgeTarget(edge);
                if (v.equals(source) || v.equals(target)) continue;
                double lowy = ((Point)layoutModel.apply((Object)source)).y;
                double hiy = ((Point)layoutModel.apply((Object)target)).y;
                if (lowy > hiy) {
                    double temp = lowy;
                    lowy = hiy;
                    hiy = temp;
                }
                if (!(lowy <= (vy = ((Point)layoutModel.apply(v)).y)) || !(vy <= hiy)) continue;
                layoutModel.set(v, ((Point)layoutModel.apply(v)).add((double)offset, 0.0));
                ++moved;
            }
        }
        return moved;
    }
}

