/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.visualization;

import ghidra.graph.visualization.LayoutTransitionManager;
import ghidra.service.graph.AttributedEdge;
import ghidra.service.graph.AttributedVertex;
import ghidra.util.Swing;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.CancelledListener;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import java.util.concurrent.CountDownLatch;
import org.jungrapht.visualization.VisualizationModel;
import org.jungrapht.visualization.VisualizationViewer;
import org.jungrapht.visualization.layout.event.LayoutStateChange;
import org.jungrapht.visualization.layout.model.LayoutModel;

public class SetLayoutTask
extends Task {
    private LayoutTransitionManager layoutTransitionManager;
    private String layoutName;
    private VisualizationViewer<AttributedVertex, AttributedEdge> viewer;
    private CountDownLatch taskDone = new CountDownLatch(1);

    public SetLayoutTask(VisualizationViewer<AttributedVertex, AttributedEdge> viewer, LayoutTransitionManager layoutTransitionManager, String layoutName) {
        super("Changing Graph Layout to " + layoutName, true, false, true, false);
        this.viewer = viewer;
        this.layoutTransitionManager = layoutTransitionManager;
        this.layoutName = layoutName;
    }

    public void run(TaskMonitor monitor) throws CancelledException {
        CancelledListener cancelListener = this::taskCancelled;
        monitor.addCancelledListener(cancelListener);
        VisualizationModel model = this.viewer.getVisualizationModel();
        LayoutModel layoutModel = model.getLayoutModel();
        LayoutStateChange.Support support = layoutModel.getLayoutStateChangeSupport();
        LayoutStateChange.Listener listener = this::layoutStateChanged;
        support.addLayoutStateChangeListener(listener);
        Swing.runNow(() -> this.layoutTransitionManager.setLayout(this.layoutName));
        try {
            this.taskDone.await();
        }
        catch (InterruptedException e) {
            model.getLayoutAlgorithm().cancel();
        }
        support.removeLayoutStateChangeListener(listener);
        monitor.removeCancelledListener(cancelListener);
    }

    private void layoutStateChanged(LayoutStateChange.Event e) {
        if (!e.active) {
            this.taskDone.countDown();
        }
    }

    private void taskCancelled() {
        this.taskDone.countDown();
        this.viewer.getVisualizationModel().getLayoutAlgorithm().cancel();
    }
}

