/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.visualization.mouse;

import ghidra.graph.visualization.CenterAnimationJob;
import ghidra.graph.visualization.mouse.AbstractJgtGraphMousePlugin;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import org.jgrapht.Graph;
import org.jungrapht.visualization.VisualizationViewer;
import org.jungrapht.visualization.layout.model.Point;
import org.jungrapht.visualization.selection.MutableSelectedState;

public class JgtEdgeNavigationPlugin<V, E>
extends AbstractJgtGraphMousePlugin<V, E> {
    public JgtEdgeNavigationPlugin() {
        this.cursor = Cursor.getPredefinedCursor(12);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!this.checkModifiers(e)) {
            return;
        }
        if (e.getClickCount() != 2) {
            return;
        }
        this.checkForEdge(e);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (!this.isHandlingMouseEvents) {
            return;
        }
        Object edge = this.selectedEdge;
        e.consume();
        this.resetState();
        VisualizationViewer viewer = this.getViewer(e);
        MutableSelectedState selectedState = viewer.getSelectedVertexState();
        Graph graph = viewer.getVisualizationModel().getGraph();
        Object end = graph.getEdgeTarget(edge);
        if (!selectedState.isSelected(end)) {
            this.pickAndShowVertex(end, selectedState, viewer);
            return;
        }
        Object source = graph.getEdgeSource(edge);
        this.pickAndShowVertex(source, selectedState, viewer);
    }

    private void pickAndShowVertex(V vertex, MutableSelectedState<V> selectedVertexState, VisualizationViewer<V, E> viewer) {
        Point2D existingCenter = viewer.getRenderContext().getMultiLayerTransformer().inverseTransform(viewer.getCenter());
        Point vp = viewer.getVisualizationModel().getLayoutModel().get(vertex);
        Point2D.Double newCenter = new Point2D.Double(vp.x, vp.y);
        CenterAnimationJob job = new CenterAnimationJob(viewer, existingCenter, newCenter);
        job.finished();
        selectedVertexState.clear();
        selectedVertexState.select(vertex);
    }

    @Override
    protected boolean shouldShowCursor(MouseEvent e) {
        return this.isOverEdge(e);
    }
}

