/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.program;

import docking.widgets.EventTrigger;
import ghidra.app.plugin.core.colorizer.ColorizingService;
import ghidra.framework.plugintool.PluginTool;
import ghidra.graph.program.BlockModelGraphDisplayListener;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.block.CodeBlock;
import ghidra.program.model.block.CodeBlockIterator;
import ghidra.program.model.block.CodeBlockModel;
import ghidra.program.model.block.CodeBlockReference;
import ghidra.program.model.block.CodeBlockReferenceIterator;
import ghidra.program.model.block.SubroutineBlockModel;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.CodeUnitIterator;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.FlowType;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.service.graph.AttributedEdge;
import ghidra.service.graph.AttributedGraph;
import ghidra.service.graph.AttributedVertex;
import ghidra.service.graph.GraphDisplay;
import ghidra.service.graph.GraphDisplayListener;
import ghidra.service.graph.GraphDisplayProvider;
import ghidra.util.HTMLUtilities;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.GraphException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

public class BlockGraphTask
extends Task {
    private static final String CODE_ATTRIBUTE = "Code";
    private static final String SYMBOLS_ATTRIBUTE = "Symbols";
    protected static final String PROGRESS_DIALOG_TITLE = "Graphing Program";
    protected static final String INIT_PROGRESS_MSG = "Graphing Program...";
    private boolean graphEntryPointNexus = false;
    private boolean showCode = false;
    private int codeLimitPerBlock = 10;
    private ColorizingService colorizingService;
    protected static final int FALLTHROUGH = 0;
    protected static final int CONDITIONAL_RETURN = 1;
    protected static final int UNCONDITIONAL_JUMP = 2;
    protected static final int CONDITIONAL_JUMP = 3;
    protected static final int UNCONDITIONAL_CALL = 4;
    protected static final int CONDITIONAL_CALL = 5;
    protected static final int TERMINATOR = 6;
    protected static final int COMPUTED = 7;
    protected static final int INDIRECTION = 8;
    protected static final int ENTRY = 9;
    protected static final String[] edgeNames = new String[]{"1", "2", "3", "4", "5", "6", "7", "13", "14", "15"};
    protected static final String[] edgeTypes = new String[]{"Fall-Through", "Conditional-Return", "Unconditional-Jump", "Conditional-Jump", "Unconditional-Call", "Conditional-Call", "Terminator", "Computed", "Indirection", "Entry"};
    private static final String ENTRY_NODE = "Entry";
    private static final String BODY_NODE = "Body";
    private static final String EXIT_NODE = "Exit";
    private static final String SWITCH_NODE = "Switch";
    private static final String BAD_NODE = "Bad";
    private static final String DATA_NODE = "Data";
    private static final String ENTRY_NEXUS = "Entry-Nexus";
    private static final String EXTERNAL_NODE = "External";
    private static final String ENTRY_NEXUS_NAME = "Entry Points";
    private CodeBlockModel blockModel;
    private AddressSetView selection;
    private ProgramLocation location;
    private GraphDisplayProvider graphProvider;
    private boolean reuseGraph;
    private boolean appendGraph;
    private PluginTool tool;
    private Program program;
    private AddressSetView graphScope;
    private String graphTitle;

    public BlockGraphTask(String actionName, boolean graphEntryPointNexus, boolean showCode, boolean reuseGraph, boolean appendGraph, PluginTool tool, ProgramSelection selection, ProgramLocation location, CodeBlockModel blockModel, GraphDisplayProvider graphProvider) {
        super("Graph Program", true, false, true);
        this.graphEntryPointNexus = graphEntryPointNexus;
        this.showCode = showCode;
        this.reuseGraph = reuseGraph;
        this.appendGraph = appendGraph;
        this.tool = tool;
        this.blockModel = blockModel;
        this.graphProvider = graphProvider;
        this.colorizingService = (ColorizingService)tool.getService(ColorizingService.class);
        this.selection = selection;
        this.location = location;
        this.program = blockModel.getProgram();
        this.graphTitle = actionName + ": ";
    }

    public void run(TaskMonitor monitor) throws CancelledException {
        block5: {
            this.graphScope = this.getGraphScopeAndGenerateGraphTitle();
            AttributedGraph graph = this.createGraph();
            monitor.setMessage("Generating Graph...");
            try {
                Set<AttributedVertex> selectedVertices;
                GraphDisplay display = this.graphProvider.getGraphDisplay(this.reuseGraph, monitor);
                BlockModelGraphDisplayListener listener = new BlockModelGraphDisplayListener(this.tool, this.blockModel, display);
                display.setGraphDisplayListener((GraphDisplayListener)listener);
                if (this.showCode) {
                    display.defineVertexAttribute(CODE_ATTRIBUTE);
                    display.defineVertexAttribute(SYMBOLS_ATTRIBUTE);
                    display.setVertexLabel(CODE_ATTRIBUTE, 0, 12, true, this.codeLimitPerBlock + 1);
                }
                display.setGraph(graph, this.graphTitle, this.appendGraph, monitor);
                if (this.location != null) {
                    AttributedVertex vertex = listener.getVertex(this.location.getAddress());
                    display.setFocusedVertex(vertex, EventTrigger.INTERNAL_ONLY);
                }
                if (this.selection != null && !this.selection.isEmpty() && (selectedVertices = listener.getVertices(this.selection)) != null) {
                    display.selectVertices(selectedVertices, EventTrigger.INTERNAL_ONLY);
                }
            }
            catch (GraphException e) {
                if (monitor.isCancelled()) break block5;
                Msg.showError((Object)((Object)this), null, (String)"Graphing Error", (Object)e.getMessage());
            }
        }
    }

    public void setCodeLimitPerBlock(int maxLines) {
        this.codeLimitPerBlock = maxLines;
    }

    protected AttributedGraph createGraph() throws CancelledException {
        int blockCount = 0;
        AttributedGraph graph = new AttributedGraph();
        CodeBlockIterator it = this.getBlockIterator();
        ArrayList<AttributedVertex> entryPoints = new ArrayList<AttributedVertex>();
        while (it.hasNext()) {
            CodeBlock curBB = it.next();
            Address start = this.graphBlock(graph, curBB, entryPoints);
            if (start == null || ++blockCount % 50 != 0) continue;
            this.taskMonitor.setMessage("Process Block: " + start.toString());
        }
        if (this.graphEntryPointNexus && entryPoints.size() > 1) {
            this.addEntryEdges(graph, entryPoints);
        }
        return graph;
    }

    private CodeBlockIterator getBlockIterator() throws CancelledException {
        return this.blockModel.getCodeBlocksContaining(this.graphScope, this.taskMonitor);
    }

    private AddressSetView getGraphScopeAndGenerateGraphTitle() {
        if (this.selection != null && !this.selection.isEmpty()) {
            this.graphTitle = this.graphTitle + this.selection.getMinAddress().toString();
            return this.selection;
        }
        Function function = this.getContainingFunction(this.location);
        if (function != null) {
            this.graphTitle = this.graphTitle + function.getName();
            if (this.isCallGraph()) {
                return this.getScopeForCallGraph(function);
            }
            return function.getBody();
        }
        this.graphTitle = this.graphTitle + "(Entire Program)";
        return this.blockModel.getProgram().getMemory();
    }

    private boolean isCallGraph() {
        return this.blockModel instanceof SubroutineBlockModel;
    }

    private AddressSetView getScopeForCallGraph(Function function) {
        AddressSet set = new AddressSet();
        set.add(function.getBody());
        try {
            CodeBlockReference next;
            CodeBlock block = this.blockModel.getCodeBlockAt(function.getEntryPoint(), this.taskMonitor);
            CodeBlockReferenceIterator it = this.blockModel.getDestinations(block, this.taskMonitor);
            while (it.hasNext()) {
                next = it.next();
                set.add((AddressSetView)next.getDestinationBlock());
            }
            it = this.blockModel.getSources(block, this.taskMonitor);
            while (it.hasNext()) {
                next = it.next();
                set.add((AddressSetView)next.getSourceBlock());
            }
        }
        catch (CancelledException cancelledException) {
            // empty catch block
        }
        return set;
    }

    private Function getContainingFunction(ProgramLocation cursorLocation) {
        if (cursorLocation == null) {
            return null;
        }
        Address address = cursorLocation.getAddress();
        if (address == null) {
            return null;
        }
        return this.blockModel.getProgram().getFunctionManager().getFunctionContaining(address);
    }

    private Address graphBlock(AttributedGraph graph, CodeBlock curBB, List<AttributedVertex> entries) throws CancelledException {
        Address[] startAddrs = curBB.getStartAddresses();
        if (startAddrs == null || startAddrs.length == 0) {
            Msg.error((Object)((Object)this), (Object)("Block not graphed, missing start address: " + curBB.getMinAddress()));
            return null;
        }
        AttributedVertex vertex = this.graphBasicBlock(graph, curBB);
        if (this.graphEntryPointNexus && this.hasExternalEntryPoint(startAddrs)) {
            entries.add(vertex);
        }
        return startAddrs[0];
    }

    private boolean hasExternalEntryPoint(Address[] startAddrs) {
        SymbolTable symbolTable = this.program.getSymbolTable();
        for (Address address : startAddrs) {
            if (!symbolTable.isExternalEntryPoint(address)) continue;
            return true;
        }
        return false;
    }

    private void addEntryEdges(AttributedGraph graph, List<AttributedVertex> entries) {
        AttributedVertex entryNexusVertex = this.getEntryNexusVertex(graph);
        for (AttributedVertex vertex : entries) {
            AttributedEdge edge = graph.addEdge(entryNexusVertex, vertex);
            edge.setAttribute("Name", edgeNames[9]);
            edge.setAttribute("EdgeType", edgeTypes[9]);
        }
    }

    protected AttributedVertex graphBasicBlock(AttributedGraph graph, CodeBlock curBB) throws CancelledException {
        AttributedVertex fromVertex = this.getBasicBlockVertex(graph, curBB);
        CodeBlockReferenceIterator refIter = curBB.getDestinations(this.taskMonitor);
        while (refIter.hasNext()) {
            AttributedVertex toVertex;
            CodeBlockReference cbRef = refIter.next();
            CodeBlock db = cbRef.getDestinationBlock();
            if (db == null || this.graphScope != null && !this.graphScope.isEmpty() && !this.graphScope.intersects((AddressSetView)db) || (toVertex = this.getBasicBlockVertex(graph, db)) == null) continue;
            String edgeAddr = cbRef.getReferent().toString();
            AttributedEdge newEdge = graph.addEdge(fromVertex, toVertex);
            this.setEdgeAttributes(newEdge, cbRef);
            this.setEdgeColor(newEdge, fromVertex, toVertex);
        }
        return fromVertex;
    }

    private void setEdgeColor(AttributedEdge edge, AttributedVertex fromVertex, AttributedVertex toVertex) {
        String fromColor = fromVertex.getAttribute("Color");
        String toColor = toVertex.getAttribute("Color");
        if (fromColor != null || toColor != null) {
            if (fromColor != null) {
                edge.setAttribute("Color", fromColor);
            } else if (toColor != null) {
                edge.setAttribute("Color", toColor);
            }
        }
    }

    private String getVertexId(CodeBlock bb) {
        Address addr = bb.getFirstStartAddress();
        if (addr.isExternalAddress()) {
            Symbol s = bb.getModel().getProgram().getSymbolTable().getPrimarySymbol(addr);
            return s.getName(true);
        }
        return addr.toString();
    }

    protected AttributedVertex getBasicBlockVertex(AttributedGraph graph, CodeBlock bb) throws CancelledException {
        String vertexId = this.getVertexId(bb);
        AttributedVertex vertex = graph.getVertex(vertexId);
        if (vertex != null) {
            return vertex;
        }
        String vertexName = bb.getName();
        vertex = graph.addVertex(vertexId, vertexName);
        this.setVertexAttributes(vertex, bb, vertexName.equals(vertexId) ? false : this.isEntryNode(bb));
        if (this.showCode) {
            this.addSymbolAttribute(vertex, bb);
            this.addCodeAttribute(vertex, bb);
        }
        return vertex;
    }

    private void addCodeAttribute(AttributedVertex vertex, CodeBlock bb) {
        if (!bb.getMinAddress().isMemoryAddress()) {
            vertex.setAttribute(CODE_ATTRIBUTE, vertex.getAttribute(SYMBOLS_ATTRIBUTE));
        }
        Listing listing = this.program.getListing();
        CodeUnitIterator cuIter = listing.getCodeUnits((AddressSetView)bb, true);
        int cnt = 0;
        int maxMnemonicFieldLen = 0;
        StringBuffer buf = new StringBuffer();
        while (cuIter.hasNext()) {
            String line;
            int ix;
            CodeUnit cu = cuIter.next();
            if (cnt != 0) {
                buf.append('\n');
            }
            if ((ix = (line = cu.toString()).indexOf(32)) > maxMnemonicFieldLen) {
                maxMnemonicFieldLen = ix;
            }
            buf.append(line);
            if (++cnt != this.codeLimitPerBlock) continue;
            buf.append("\n...");
            break;
        }
        vertex.setAttribute(CODE_ATTRIBUTE, this.adjustCode(buf, maxMnemonicFieldLen + 1));
    }

    private void addSymbolAttribute(AttributedVertex vertex, CodeBlock bb) {
        Symbol[] symbols = this.program.getSymbolTable().getSymbols(bb.getMinAddress());
        if (symbols.length != 0) {
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < symbols.length; ++i) {
                if (i != 0) {
                    buf.append('\n');
                }
                buf.append(symbols[i].getName());
            }
            vertex.setAttribute(SYMBOLS_ATTRIBUTE, buf.toString());
        }
    }

    private String adjustCode(StringBuffer buf, int mnemonicFieldLen) {
        if (mnemonicFieldLen <= 1) {
            return buf.toString();
        }
        int ix = 0;
        char[] pad = new char[mnemonicFieldLen];
        Arrays.fill(pad, ' ');
        while (ix < buf.length()) {
            int padSize;
            int padIx;
            int eolIx = buf.indexOf("\n", ix);
            if (eolIx < 0) {
                eolIx = buf.length();
            }
            if ((padIx = buf.indexOf(" ", ix)) > 0 && padIx < eolIx && (padSize = mnemonicFieldLen - padIx + ix) > 0) {
                buf.insert(padIx, pad, 0, padSize);
                eolIx += padSize;
            }
            ix = eolIx + 1;
        }
        return buf.toString();
    }

    protected boolean isEntryNode(CodeBlock block) throws CancelledException {
        CodeBlockReferenceIterator iter = block.getSources(this.taskMonitor);
        boolean isSource = true;
        while (iter.hasNext()) {
            isSource = false;
            if (!iter.next().getFlowType().isCall()) continue;
            return true;
        }
        return isSource;
    }

    protected void setEdgeAttributes(AttributedEdge edge, CodeBlockReference ref) {
        FlowType flowType = ref.getFlowType();
        int edgeType = flowType == RefType.FALL_THROUGH ? 0 : (flowType == RefType.UNCONDITIONAL_JUMP ? 2 : (flowType == RefType.CONDITIONAL_JUMP ? 3 : (flowType == RefType.UNCONDITIONAL_CALL ? 4 : (flowType == RefType.CONDITIONAL_CALL ? 5 : (flowType.isComputed() ? 7 : (flowType.isIndirect() ? 8 : (flowType == RefType.TERMINATOR ? 6 : 1)))))));
        edge.setAttribute("Name", edgeNames[edgeType]);
        edge.setAttribute("EdgeType", edgeTypes[edgeType]);
    }

    protected void setVertexAttributes(AttributedVertex vertex, CodeBlock bb, boolean isEntry) {
        String vertexType = BODY_NODE;
        Address firstStartAddress = bb.getFirstStartAddress();
        if (firstStartAddress.isExternalAddress()) {
            vertexType = EXTERNAL_NODE;
        } else if (isEntry) {
            vertexType = ENTRY_NODE;
        } else {
            FlowType flowType = bb.getFlowType();
            if (flowType.isTerminal()) {
                vertexType = EXIT_NODE;
            } else if (flowType.isComputed()) {
                vertexType = SWITCH_NODE;
            } else if (flowType == RefType.INDIRECTION) {
                vertexType = DATA_NODE;
            } else if (flowType == RefType.INVALID) {
                vertexType = BAD_NODE;
            }
        }
        vertex.setAttribute("VertexType", vertexType);
        this.setVertexColor(vertex, vertexType, firstStartAddress);
    }

    private void setVertexColor(AttributedVertex vertex, String vertexType, Address address) {
        if (this.colorizingService == null) {
            return;
        }
        Color color = this.colorizingService.getBackgroundColor(address);
        if (color == null) {
            return;
        }
        String rgb = "RGB" + HTMLUtilities.toRGBString((Color)color);
        vertex.setAttribute("Color", rgb);
        if (this.showCode) {
            vertex.setAttribute("VertexType", "ColorFilled");
        } else {
            vertex.setAttribute("VertexType", vertexType + ".Filled");
        }
    }

    private AttributedVertex getEntryNexusVertex(AttributedGraph graph) {
        AttributedVertex vertex = graph.getVertex(ENTRY_NEXUS_NAME);
        if (vertex == null) {
            vertex = graph.addVertex(ENTRY_NEXUS_NAME, ENTRY_NEXUS_NAME);
            vertex.setAttribute("VertexType", ENTRY_NEXUS);
        }
        return vertex;
    }
}

