/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.program;

import docking.ActionContext;
import docking.Tool;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.ToggleDockingAction;
import docking.action.builder.ActionBuilder;
import docking.action.builder.ToggleActionBuilder;
import ghidra.app.events.ProgramLocationPluginEvent;
import ghidra.app.events.ProgramSelectionPluginEvent;
import ghidra.app.plugin.ProgramPlugin;
import ghidra.app.plugin.core.graph.GraphDisplayBrokerListener;
import ghidra.app.services.BlockModelService;
import ghidra.app.services.BlockModelServiceListener;
import ghidra.app.services.GoToService;
import ghidra.app.services.GraphDisplayBroker;
import ghidra.framework.options.Options;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.graph.program.BlockGraphTask;
import ghidra.program.model.block.CodeBlockModel;
import ghidra.service.graph.GraphDisplayProvider;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.exception.NotFoundException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Graph", shortDescription="Program graph generator", description="This plugin provides actions for creating and managing program graphs (block graphs and call graphs).Once a graph is created, it uses the currenly selected graph output to display or export the graph.  The plugin also provides event handling to facilitate interaction between the graph and the  tool.", servicesRequired={GoToService.class, BlockModelService.class, GraphDisplayBroker.class}, eventsProduced={ProgramLocationPluginEvent.class, ProgramSelectionPluginEvent.class})
public class ProgramGraphPlugin
extends ProgramPlugin
implements OptionsChangeListener,
BlockModelServiceListener,
GraphDisplayBrokerListener {
    private static final String MAX_CODE_LINES_DISPLAYED = "Max Code Lines Displayed";
    private static final String REUSE_GRAPH = "Reuse Graph";
    private static final String GRAPH_ENTRY_POINT_NEXUS = "Graph Entry Point Nexus";
    private static final String FORCE_LOCATION_DISPLAY_OPTION = "Force Location Visible on Graph";
    public static final String MENU_GRAPH = "&Graph";
    private BlockModelService blockModelService;
    private List<DockingAction> subUsingGraphActions = new ArrayList<DockingAction>();
    private ToggleDockingAction reuseGraphAction;
    private ToggleDockingAction appendGraphAction;
    private boolean reuseGraph = false;
    private boolean appendToGraph = false;
    private boolean graphEntryPointNexus = false;
    private int codeLimitPerBlock = 10;
    private ToggleDockingAction forceLocationVisibleAction;
    private GraphDisplayBroker broker;
    private GraphDisplayProvider defaultGraphService;

    public ProgramGraphPlugin(PluginTool tool) {
        super(tool, true, true);
        this.intializeOptions();
    }

    private void intializeOptions() {
        HelpLocation help = new HelpLocation(this.getName(), "Graph_Option");
        ToolOptions options = this.tool.getOptions("Graph");
        options.registerOption(MAX_CODE_LINES_DISPLAYED, (Object)this.codeLimitPerBlock, help, "Specifies the maximum number of instructions to display in each graph node in a Code Flow Graph.");
        options.registerOption(REUSE_GRAPH, (Object)false, help, "Determines whether the graph will reuse the active graph window when displaying graphs.");
        options.registerOption(GRAPH_ENTRY_POINT_NEXUS, (Object)false, help, "Add a dummy node at the root of the graph and adds dummy edges to each node that has no incoming edges.");
        options.registerOption(FORCE_LOCATION_DISPLAY_OPTION, (Object)false, help, "Specifies whether or not graph displays should force the visible graph to pan and/or scale to ensure that focused locations are visible.");
        this.setOptions((Options)options);
        options.addOptionsChangeListener((OptionsChangeListener)this);
        options.setOptionsHelpLocation(new HelpLocation(this.getName(), "Graph_Option"));
    }

    protected void init() {
        this.broker = (GraphDisplayBroker)this.tool.getService(GraphDisplayBroker.class);
        this.broker.addGraphDisplayBrokerListener((GraphDisplayBrokerListener)this);
        this.defaultGraphService = this.broker.getDefaultGraphDisplayProvider();
        this.blockModelService = (BlockModelService)this.tool.getService(BlockModelService.class);
        this.blockModelService.addListener((BlockModelServiceListener)this);
        this.createActions();
    }

    public void dispose() {
        super.dispose();
        if (this.blockModelService != null) {
            this.blockModelService.removeListener((BlockModelServiceListener)this);
            this.blockModelService = null;
        }
    }

    public void optionsChanged(ToolOptions options, String optionName, Object oldValue, Object newValue) {
        this.setOptions((Options)options);
    }

    private void setOptions(Options options) {
        this.codeLimitPerBlock = options.getInt(MAX_CODE_LINES_DISPLAYED, this.codeLimitPerBlock);
        this.graphEntryPointNexus = options.getBoolean(GRAPH_ENTRY_POINT_NEXUS, false);
        this.reuseGraph = options.getBoolean(REUSE_GRAPH, false);
        if (this.reuseGraphAction != null) {
            this.reuseGraphAction.setSelected(this.reuseGraph);
        }
    }

    private void createActions() {
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Graph Block Flow", this.getName()).menuPath(new String[]{MENU_GRAPH, "&Block Flow"})).menuGroup("Graph", "A")).onAction(c -> this.graphBlockFlow())).enabledWhen(this::canGraph)).buildAndInstall((Tool)this.tool);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Graph Code Flow", this.getName()).menuPath(new String[]{MENU_GRAPH, "C&ode Flow"})).menuGroup("Graph", "B")).onAction(c -> this.graphCodeFlow())).enabledWhen(this::canGraph)).buildAndInstall((Tool)this.tool);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Graph Calls Using Default Model", this.getName()).menuPath(new String[]{MENU_GRAPH, "&Calls"})).menuGroup("Graph", "C")).onAction(c -> this.graphSubroutines())).enabledWhen(this::canGraph)).buildAndInstall((Tool)this.tool);
        this.reuseGraphAction = (ToggleDockingAction)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)new ToggleActionBuilder(REUSE_GRAPH, this.getName()).menuPath(new String[]{MENU_GRAPH, REUSE_GRAPH})).menuGroup("Graph Options")).selected(this.reuseGraph).onAction(c -> {
            this.reuseGraph = this.reuseGraphAction.isSelected();
        })).enabledWhen(this::canGraph)).buildAndInstall((Tool)this.tool);
        this.appendGraphAction = (ToggleDockingAction)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)new ToggleActionBuilder("Append Graph", this.getName()).menuPath(new String[]{MENU_GRAPH, "Append Graph"})).menuGroup("Graph Options")).selected(false).onAction(c -> this.updateAppendAndReuseGraph())).enabledWhen(this::canGraph)).buildAndInstall((Tool)this.tool);
        this.forceLocationVisibleAction = (ToggleDockingAction)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)new ToggleActionBuilder("Show Location in Graph", this.getName()).menuPath(new String[]{MENU_GRAPH, "Show Location"})).description("Tell the graph to pan/scale as need to keep location changes visible")).menuGroup("Graph Options")).onAction(c -> this.toggleForceLocationVisible())).enabledWhen(this::canGraph)).buildAndInstall((Tool)this.tool);
        this.updateSubroutineActions();
    }

    private boolean canGraph(ActionContext context) {
        return this.currentProgram != null && this.defaultGraphService != null;
    }

    private void toggleForceLocationVisible() {
        ToolOptions options = this.tool.getOptions("Graph");
        options.setBoolean(FORCE_LOCATION_DISPLAY_OPTION, this.forceLocationVisibleAction.isSelected());
    }

    private void updateAppendAndReuseGraph() {
        this.appendToGraph = this.appendGraphAction.isSelected();
        if (this.appendToGraph && !this.reuseGraph) {
            this.reuseGraph = true;
            this.reuseGraphAction.setSelected(true);
        }
    }

    private void updateSubroutineActions() {
        for (DockingAction action : this.subUsingGraphActions) {
            this.tool.removeAction((DockingActionIf)action);
        }
        String[] subModels = this.blockModelService.getAvailableModelNames(2);
        if (subModels.length <= 1) {
            return;
        }
        HelpLocation helpLoc = new HelpLocation(this.getName(), "Graph_Calls_Using_Model");
        for (String blockModelName : subModels) {
            DockingAction action = this.buildGraphActionWithModel(blockModelName, helpLoc);
            this.subUsingGraphActions.add(action);
        }
        this.tool.setMenuGroup(new String[]{"Graph", "Calls Using Model"}, "Graph");
    }

    private DockingAction buildGraphActionWithModel(String blockModelName, HelpLocation helpLoc) {
        return (DockingAction)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Graph Calls using " + blockModelName, this.getName()).menuPath(new String[]{"Graph", "Calls Using Model", blockModelName})).menuGroup("Graph")).helpLocation(helpLoc)).onAction(c -> this.graphSubroutinesUsing(blockModelName))).enabledWhen(this::canGraph)).buildAndInstall((Tool)this.tool);
    }

    private void graphBlockFlow() {
        this.graph("Block Flow Graph", this.blockModelService.getActiveBlockModelName(), false);
    }

    private void graphCodeFlow() {
        this.graph("Code Flow Graph", this.blockModelService.getActiveBlockModelName(), true);
    }

    private void graphSubroutines() {
        this.graph("Call Graph", this.blockModelService.getActiveSubroutineModelName(), false);
    }

    private void graphSubroutinesUsing(String modelName) {
        this.graph("Call Graph (" + modelName + ")", modelName, false);
    }

    private void graph(String actionName, String modelName, boolean showCode) {
        try {
            CodeBlockModel model = this.blockModelService.getNewModelByName(modelName, this.currentProgram, true);
            BlockGraphTask task = new BlockGraphTask(actionName, this.graphEntryPointNexus, showCode, this.reuseGraph, this.appendToGraph, this.tool, this.currentSelection, this.currentLocation, model, this.defaultGraphService);
            task.setCodeLimitPerBlock(this.codeLimitPerBlock);
            new TaskLauncher((Task)task, (Component)this.tool.getToolFrame());
        }
        catch (NotFoundException e) {
            Msg.showError((Object)((Object)this), null, (String)"Error That Can't Happen", (Object)"Can't find a block model from a name that we got from the existing block models!");
        }
    }

    String getProgramName() {
        return this.currentProgram != null ? this.currentProgram.getName() : null;
    }

    public void modelAdded(String modeName, int modelType) {
        if (modelType == 2) {
            this.updateSubroutineActions();
        }
    }

    public void modelRemoved(String modeName, int modelType) {
        if (modelType == 2) {
            this.updateSubroutineActions();
        }
    }

    public void providersChanged() {
        this.defaultGraphService = this.broker.getDefaultGraphDisplayProvider();
    }
}

