/*
 * Decompiled with CFR 0.152.
 */
package db;

import db.BinaryField;
import db.BooleanField;
import db.Buffer;
import db.ByteField;
import db.Field;
import db.IntField;
import db.LongField;
import db.ShortField;
import db.StringField;
import ghidra.util.exception.AssertException;
import java.io.IOException;

abstract class IndexField
extends Field {
    private static final int MAX_INDEX_FIELD_LENGTH = 64;
    private long primaryKey;
    private Field nonTruncatedIndexField;
    private Field indexField;
    private boolean isTruncated = false;

    IndexField(Field newIndexField) {
        this.indexField = newIndexField;
        this.nonTruncatedIndexField = newIndexField;
    }

    IndexField(Field value, long primaryKey) {
        this.nonTruncatedIndexField = value;
        this.indexField = value.newField(value);
        if (this.indexField.isVariableLength() && this.indexField.length() >= 64) {
            this.indexField.truncate(64);
            this.isTruncated = true;
        }
        this.primaryKey = primaryKey;
    }

    Field getIndexField() {
        return this.indexField;
    }

    Field getNonTruncatedIndexField() {
        return this.nonTruncatedIndexField;
    }

    boolean usesTruncatedFieldValue() {
        return this.isTruncated;
    }

    long getPrimaryKey() {
        return this.primaryKey;
    }

    @Override
    int length() {
        return this.indexField.length() + 8;
    }

    @Override
    int write(Buffer buf, int offset) throws IOException {
        offset = this.indexField.write(buf, offset);
        return buf.putLong(offset, this.primaryKey);
    }

    @Override
    int read(Buffer buf, int offset) throws IOException {
        offset = this.indexField.read(buf, offset);
        this.primaryKey = buf.getLong(offset);
        return offset + 8;
    }

    @Override
    int readLength(Buffer buf, int offset) throws IOException {
        return this.indexField.readLength(buf, offset) + 8;
    }

    @Override
    public boolean isVariableLength() {
        return true;
    }

    @Override
    protected abstract byte getFieldType();

    abstract String getFieldTypeString();

    public String toString() {
        return this.getFieldTypeString() + ": " + this.indexField;
    }

    @Override
    public String getValueAsString() {
        return this.indexField.getValueAsString() + " + " + Long.toHexString(this.primaryKey);
    }

    boolean hasSameIndex(IndexField field) {
        if (field == null) {
            return false;
        }
        if (this.indexField == null) {
            return field.indexField == null;
        }
        return this.indexField.equals(field.indexField);
    }

    @Override
    public byte[] getBinaryData() {
        byte[] indexBytes = this.indexField.getBinaryData();
        int len = indexBytes.length;
        byte[] bytes = new byte[len + 8];
        System.arraycopy(indexBytes, 0, bytes, 0, len);
        bytes[len] = (byte)(this.primaryKey >> 56);
        bytes[++len] = (byte)(this.primaryKey >> 48);
        bytes[++len] = (byte)(this.primaryKey >> 40);
        bytes[++len] = (byte)(this.primaryKey >> 32);
        bytes[++len] = (byte)(this.primaryKey >> 24);
        bytes[++len] = (byte)(this.primaryKey >> 16);
        bytes[++len] = (byte)(this.primaryKey >> 8);
        bytes[++len] = (byte)this.primaryKey;
        return bytes;
    }

    @Override
    public int compareTo(Field o) {
        IndexField f = (IndexField)o;
        int result = this.indexField.compareTo(f.indexField);
        if (result != 0) {
            return result;
        }
        if (this.primaryKey == f.primaryKey) {
            return 0;
        }
        if (this.primaryKey < f.primaryKey) {
            return -1;
        }
        return 1;
    }

    @Override
    public boolean equals(Object obj) {
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        IndexField f = (IndexField)obj;
        return this.primaryKey == f.primaryKey && this.indexField.equals(f.indexField);
    }

    @Override
    public int hashCode() {
        return (int)this.primaryKey;
    }

    static IndexField getIndexField(byte fieldType) {
        switch (fieldType & 0x3F) {
            case 3: {
                return new LongIndexField();
            }
            case 2: {
                return new IntIndexField();
            }
            case 4: {
                return new StringIndexField();
            }
            case 1: {
                return new ShortIndexField();
            }
            case 0: {
                return new ByteIndexField();
            }
            case 6: {
                return new BooleanIndexField();
            }
            case 5: {
                return new BinaryIndexField();
            }
        }
        throw new AssertException();
    }

    static IndexField getIndexField(Field indexedField, long primaryKey) {
        switch (indexedField.getFieldType()) {
            case 3: {
                return new LongIndexField((LongField)indexedField, primaryKey);
            }
            case 2: {
                return new IntIndexField((IntField)indexedField, primaryKey);
            }
            case 4: {
                return new StringIndexField((StringField)indexedField, primaryKey);
            }
            case 1: {
                return new ShortIndexField((ShortField)indexedField, primaryKey);
            }
            case 0: {
                return new ByteIndexField((ByteField)indexedField, primaryKey);
            }
            case 6: {
                return new BooleanIndexField((BooleanField)indexedField, primaryKey);
            }
            case 5: {
                return new BinaryIndexField((BinaryField)indexedField, primaryKey);
            }
        }
        throw new AssertException();
    }

    private static class BinaryIndexField
    extends IndexField {
        BinaryIndexField() {
            super(new BinaryField());
        }

        BinaryIndexField(BinaryField indexedField, long primaryKey) {
            super(indexedField, primaryKey);
        }

        @Override
        protected byte getFieldType() {
            return -123;
        }

        @Override
        String getFieldTypeString() {
            return "BinaryIndexField";
        }

        @Override
        public Field newField(Field fieldValue) {
            if (!(fieldValue instanceof BinaryIndexField)) {
                throw new AssertException();
            }
            BinaryIndexField f = (BinaryIndexField)fieldValue;
            return new BinaryIndexField((BinaryField)f.getIndexField(), f.getPrimaryKey());
        }

        @Override
        public Field newField() {
            return new BinaryIndexField();
        }
    }

    private static class BooleanIndexField
    extends IndexField {
        BooleanIndexField() {
            super(new BooleanField());
        }

        BooleanIndexField(BooleanField indexedField, long primaryKey) {
            super(indexedField, primaryKey);
        }

        @Override
        protected byte getFieldType() {
            return -122;
        }

        @Override
        String getFieldTypeString() {
            return "BooleanIndexField";
        }

        @Override
        public Field newField(Field fieldValue) {
            if (!(fieldValue instanceof BooleanIndexField)) {
                throw new AssertException();
            }
            BooleanIndexField f = (BooleanIndexField)fieldValue;
            return new BooleanIndexField((BooleanField)f.getIndexField(), f.getPrimaryKey());
        }

        @Override
        public Field newField() {
            return new BooleanIndexField();
        }
    }

    private static class ByteIndexField
    extends IndexField {
        ByteIndexField() {
            super(new ByteField());
        }

        ByteIndexField(ByteField indexedField, long primaryKey) {
            super(indexedField, primaryKey);
        }

        @Override
        protected byte getFieldType() {
            return -128;
        }

        @Override
        String getFieldTypeString() {
            return "ByteIndexField";
        }

        @Override
        public Field newField(Field fieldValue) {
            if (!(fieldValue instanceof ByteIndexField)) {
                throw new AssertException();
            }
            ByteIndexField f = (ByteIndexField)fieldValue;
            return new ByteIndexField((ByteField)f.getIndexField(), f.getPrimaryKey());
        }

        @Override
        public Field newField() {
            return new ByteIndexField();
        }
    }

    private static class ShortIndexField
    extends IndexField {
        ShortIndexField() {
            super(new ShortField());
        }

        ShortIndexField(ShortField indexedField, long primaryKey) {
            super(indexedField, primaryKey);
        }

        @Override
        protected byte getFieldType() {
            return -127;
        }

        @Override
        String getFieldTypeString() {
            return "ShortIndexField";
        }

        @Override
        public Field newField(Field fieldValue) {
            if (!(fieldValue instanceof ShortIndexField)) {
                throw new AssertException();
            }
            ShortIndexField f = (ShortIndexField)fieldValue;
            return new ShortIndexField((ShortField)f.getIndexField(), f.getPrimaryKey());
        }

        @Override
        public Field newField() {
            return new ShortIndexField();
        }
    }

    private static class StringIndexField
    extends IndexField {
        StringIndexField() {
            super(new StringField());
        }

        StringIndexField(StringField indexedField, long primaryKey) {
            super(indexedField, primaryKey);
        }

        @Override
        protected byte getFieldType() {
            return -124;
        }

        @Override
        String getFieldTypeString() {
            return "StringIndexField";
        }

        @Override
        public Field newField(Field fieldValue) {
            if (!(fieldValue instanceof StringIndexField)) {
                throw new AssertException();
            }
            StringIndexField f = (StringIndexField)fieldValue;
            return new StringIndexField((StringField)f.getIndexField(), f.getPrimaryKey());
        }

        @Override
        public Field newField() {
            return new StringIndexField();
        }
    }

    private static class IntIndexField
    extends IndexField {
        IntIndexField() {
            super(new IntField());
        }

        IntIndexField(IntField indexedField, long primaryKey) {
            super(indexedField, primaryKey);
        }

        @Override
        protected byte getFieldType() {
            return -126;
        }

        @Override
        String getFieldTypeString() {
            return "IntIndexField";
        }

        @Override
        public Field newField(Field fieldValue) {
            if (!(fieldValue instanceof IntIndexField)) {
                throw new AssertException();
            }
            IntIndexField f = (IntIndexField)fieldValue;
            return new IntIndexField((IntField)f.getIndexField(), f.getPrimaryKey());
        }

        @Override
        public Field newField() {
            return new IntIndexField();
        }
    }

    private static class LongIndexField
    extends IndexField {
        LongIndexField() {
            super(new LongField());
        }

        LongIndexField(LongField indexedField, long primaryKey) {
            super(indexedField, primaryKey);
        }

        @Override
        protected byte getFieldType() {
            return -125;
        }

        @Override
        String getFieldTypeString() {
            return "LongIndexField";
        }

        @Override
        public Field newField(Field fieldValue) {
            if (!(fieldValue instanceof LongIndexField)) {
                throw new AssertException();
            }
            LongIndexField f = (LongIndexField)fieldValue;
            return new LongIndexField((LongField)f.getIndexField(), f.getPrimaryKey());
        }

        @Override
        public Field newField() {
            return new LongIndexField();
        }
    }
}

