/*
 * Decompiled with CFR 0.152.
 */
package db.buffers;

import java.util.Stack;

class IndexProvider {
    private int nextIndex = 0;
    private Stack<Integer> freeIndexStack = new Stack();

    IndexProvider() {
    }

    IndexProvider(int indexCount, int[] freeIndexes) {
        this.nextIndex = indexCount;
        for (int i = 0; i < freeIndexes.length; ++i) {
            this.freeIndexStack.push(new Integer(freeIndexes[i]));
        }
    }

    int getIndexCount() {
        return this.nextIndex;
    }

    int getFreeIndexCount() {
        return this.freeIndexStack.size();
    }

    int allocateIndex() {
        if (this.freeIndexStack.isEmpty()) {
            return this.nextIndex++;
        }
        return this.freeIndexStack.pop();
    }

    boolean allocateIndex(int index) {
        if (index >= this.nextIndex) {
            for (int i = this.nextIndex; i < index; ++i) {
                this.freeIndexStack.push(new Integer(i));
            }
            this.nextIndex = index + 1;
            return true;
        }
        return this.freeIndexStack.remove(new Integer(index));
    }

    boolean isFree(int index) {
        return this.freeIndexStack.contains(new Integer(index));
    }

    void freeIndex(int index) {
        this.freeIndexStack.push(new Integer(index));
    }

    boolean truncate(int newIndexCnt) {
        if (newIndexCnt >= this.nextIndex) {
            return false;
        }
        this.nextIndex = newIndexCnt;
        int cnt = this.freeIndexStack.size();
        for (int i = cnt - 1; i >= 0; --i) {
            int freeIndex = (Integer)this.freeIndexStack.get(i);
            if (freeIndex < newIndexCnt) continue;
            this.freeIndexStack.remove(i);
        }
        return true;
    }

    int[] getFreeIndexes() {
        int[] freeIndexes = new int[this.freeIndexStack.size()];
        for (int i = 0; i < freeIndexes.length; ++i) {
            freeIndexes[i] = (Integer)this.freeIndexStack.get(i);
        }
        return freeIndexes;
    }
}

