/*
 * Decompiled with CFR 0.152.
 */
package db.buffers;

import db.DBChangeSet;
import db.DBHandle;
import db.buffers.BufferFile;
import db.buffers.BufferMgr;
import db.buffers.BufferNode;
import db.buffers.DataBuffer;
import db.buffers.LocalBufferFile;
import db.buffers.RecoveryFile;
import ghidra.util.Msg;
import ghidra.util.datastruct.IntSet;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.NoSuchElementException;

class RecoveryMgr {
    private static final String SNAPSHOT1_FILE = "snapshotA.grf";
    private static final String SNAPSHOT2_FILE = "snapshotB.grf";
    private static final String SNAPSHOT1_CHANGESET_FILE = "changeA.grf";
    private static final String SNAPSHOT2_CHANGESET_FILE = "changeB.grf";
    private static final String CHANGE_SET_REQUIRED_PARM = "";
    private File[] snapshotFiles;
    private File[] changeFiles;
    private int snapshotIndex = -1;
    private RecoveryFile activeFile;
    private IntSet oldIndexSet;
    private boolean newSnapshot;
    private long lastSnapshotTime;
    private boolean recovered = false;
    private boolean recoveryHasChangeSet = false;
    private BufferMgr bufferMgr;
    private int[] buffersSaved = new int[]{0, 0};
    private int[] buffersIgnored = new int[]{0, 0};
    private int[] buffersRemoved = new int[]{0, 0};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RecoveryMgr(BufferMgr bufferMgr, TaskMonitor monitor) throws IOException, CancelledException {
        this.bufferMgr = bufferMgr;
        BufferFile bf = bufferMgr.getSourceFile();
        if (!(bf instanceof LocalBufferFile)) {
            throw new RuntimeException("Invalid use of recovery manager");
        }
        LocalBufferFile lbf = (LocalBufferFile)bf;
        this.snapshotFiles = RecoveryMgr.getSnapshotFiles(lbf);
        this.changeFiles = RecoveryMgr.getChangeFiles(lbf);
        RecoveryFile recoveryFile = RecoveryMgr.getRecoveryFile(lbf, this.snapshotFiles);
        if (recoveryFile != null) {
            try {
                this.lastSnapshotTime = recoveryFile.getFile().lastModified();
                this.snapshotIndex = recoveryFile.getFile().equals(this.snapshotFiles[0]) ? 0 : 1;
                try {
                    this.recoveryHasChangeSet = recoveryFile.getParameter(CHANGE_SET_REQUIRED_PARM) != 0;
                }
                catch (NoSuchElementException noSuchElementException) {
                    // empty catch block
                }
                if (!this.recoveryHasChangeSet || this.changeFiles[this.snapshotIndex].exists()) {
                    Msg.info((Object)this, (Object)("Applying buffer file recovery data: " + lbf.getFile()));
                    bufferMgr.recover(recoveryFile, this.snapshotIndex, monitor);
                    this.recovered = true;
                }
            }
            finally {
                try {
                    recoveryFile.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (this.snapshotIndex != 0) {
            this.snapshotFiles[0].delete();
            this.changeFiles[0].delete();
        }
        if (this.snapshotIndex != 1) {
            this.snapshotFiles[1].delete();
            this.changeFiles[1].delete();
        }
    }

    RecoveryMgr(BufferMgr bufferMgr) {
        this.bufferMgr = bufferMgr;
        BufferFile bf = bufferMgr.getSourceFile();
        if (!(bf instanceof LocalBufferFile)) {
            throw new RuntimeException("Invalid use of recovery manager");
        }
        LocalBufferFile lbf = (LocalBufferFile)bf;
        this.snapshotFiles = RecoveryMgr.getSnapshotFiles(lbf);
        this.changeFiles = RecoveryMgr.getChangeFiles(lbf);
        this.snapshotFiles[0].delete();
        this.snapshotFiles[1].delete();
        this.changeFiles[0].delete();
        this.changeFiles[1].delete();
    }

    void dispose() {
        if (this.activeFile != null) {
            this.endSnapshot(false);
            this.activeFile = null;
        }
        this.snapshotFiles[0].delete();
        this.changeFiles[0].delete();
        this.snapshotFiles[1].delete();
        this.changeFiles[1].delete();
        this.snapshotFiles[0] = null;
        this.snapshotFiles[1] = null;
        this.changeFiles[0] = null;
        this.changeFiles[1] = null;
    }

    boolean recovered() {
        return this.recovered;
    }

    LocalBufferFile getRecoveryChangeSetFile() throws IOException {
        if (this.recovered && this.recoveryHasChangeSet) {
            return new LocalBufferFile(this.changeFiles[this.snapshotIndex], true);
        }
        return null;
    }

    void clear() {
        if (this.activeFile != null) {
            throw new AssertException("Snapshot already in progress");
        }
        this.snapshotFiles[0].delete();
        this.snapshotFiles[1].delete();
        this.changeFiles[0].delete();
        this.changeFiles[1].delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean canRecover(LocalBufferFile bf) {
        block16: {
            RecoveryFile rf = null;
            try {
                File[] snapshotFiles = RecoveryMgr.getSnapshotFiles(bf);
                rf = RecoveryMgr.getRecoveryFile(bf, snapshotFiles);
                if (rf == null) break block16;
                boolean canRecover = true;
                try {
                    if (rf.getParameter(CHANGE_SET_REQUIRED_PARM) != 0) {
                        File[] changeFiles = RecoveryMgr.getChangeFiles(bf);
                        int snapshotIndex = rf.getFile().equals(snapshotFiles[0]) ? 0 : 1;
                        canRecover = changeFiles[snapshotIndex].exists();
                    }
                }
                catch (NoSuchElementException noSuchElementException) {
                    // empty catch block
                }
                boolean bl = canRecover;
                return bl;
            }
            catch (IOException iOException) {
            }
            finally {
                if (rf != null) {
                    try {
                        rf.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static RecoveryFile getRecoveryFile(LocalBufferFile srcBf, File[] snapshotFiles) {
        RecoveryFile[] recoveryFiles = new RecoveryFile[2];
        long[] modTimes = new long[2];
        for (int i = 0; i < recoveryFiles.length; ++i) {
            if (!snapshotFiles[i].exists()) continue;
            try {
                RecoveryFile rf = new RecoveryFile(srcBf, snapshotFiles[i]);
                if (rf.isValid()) {
                    recoveryFiles[i] = rf;
                    modTimes[i] = rf.getTimestamp();
                    continue;
                }
                rf.close();
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (recoveryFiles[0] == null) return recoveryFiles[1];
        if (recoveryFiles[1] == null) return recoveryFiles[0];
        RecoveryFile closeRf = null;
        try {
            RecoveryFile recoveryFile;
            if (modTimes[1] == modTimes[0]) {
                Msg.warn(RecoveryMgr.class, (Object)("Recover files have same timestamp: " + modTimes[0]));
                closeRf = recoveryFiles[1];
                try {
                    recoveryFiles[0].close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                recoveryFile = null;
                return recoveryFile;
            }
            if (modTimes[1] > modTimes[0]) {
                closeRf = recoveryFiles[0];
                recoveryFile = recoveryFiles[1];
                return recoveryFile;
            }
            closeRf = recoveryFiles[1];
            recoveryFile = recoveryFiles[0];
            return recoveryFile;
        }
        finally {
            if (closeRf != null) {
                try {
                    closeRf.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static File[] getSnapshotFiles(LocalBufferFile bf) {
        File dir = bf.getFile().getParentFile();
        return new File[]{new File(dir, SNAPSHOT1_FILE), new File(dir, SNAPSHOT2_FILE)};
    }

    private static File[] getChangeFiles(LocalBufferFile bf) {
        File dir = bf.getFile().getParentFile();
        return new File[]{new File(dir, SNAPSHOT1_CHANGESET_FILE), new File(dir, SNAPSHOT2_CHANGESET_FILE)};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startSnapshot(int indexCnt, int[] freeIndexes, DBChangeSet changeSet, TaskMonitor monitor) throws CancelledException, IOException {
        long t;
        if (this.activeFile != null) {
            throw new AssertException("Snapshot already in progress");
        }
        this.recovered = false;
        ++this.snapshotIndex;
        if (this.snapshotIndex == 2) {
            this.snapshotIndex = 0;
        }
        if ((t = new Date().getTime()) - this.lastSnapshotTime < 1L) {
            try {
                Thread.sleep(2L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            t = new Date().getTime();
        }
        boolean success = false;
        try {
            this.newSnapshot = !this.snapshotFiles[this.snapshotIndex].exists();
            try {
                this.activeFile = new RecoveryFile((LocalBufferFile)this.bufferMgr.getSourceFile(), this.snapshotFiles[this.snapshotIndex], this.newSnapshot);
            }
            catch (IOException e) {
                if (this.newSnapshot) {
                    throw e;
                }
                this.snapshotFiles[this.snapshotIndex].delete();
                this.newSnapshot = true;
                this.activeFile = new RecoveryFile((LocalBufferFile)this.bufferMgr.getSourceFile(), this.snapshotFiles[this.snapshotIndex], this.newSnapshot);
            }
            this.activeFile.setIndexCount(indexCnt);
            this.activeFile.setFreeIndexList(freeIndexes);
            this.oldIndexSet = new IntSet(this.activeFile.getBufferIndexes());
            if (changeSet != null) {
                this.activeFile.setParameter(CHANGE_SET_REQUIRED_PARM, 1);
                this.changeFiles[this.snapshotIndex].delete();
                try (DBHandle csh = new DBHandle();){
                    changeSet.write(csh, true);
                    csh.saveAs(this.changeFiles[this.snapshotIndex], true, monitor);
                }
            } else {
                this.activeFile.setParameter(CHANGE_SET_REQUIRED_PARM, 0);
            }
            success = true;
        }
        finally {
            if (!success && this.activeFile != null) {
                this.activeFile.close();
                this.activeFile = null;
                this.snapshotFiles[this.snapshotIndex].delete();
                this.changeFiles[this.snapshotIndex].delete();
            }
        }
        this.buffersSaved[this.snapshotIndex] = 0;
        this.buffersIgnored[this.snapshotIndex] = 0;
        this.buffersRemoved[this.snapshotIndex] = 0;
    }

    boolean isSnapshotInProgress() {
        return this.activeFile != null;
    }

    void endSnapshot(boolean commit) {
        if (this.activeFile == null) {
            throw new AssertException("Snapshot not in progress");
        }
        try {
            if (commit) {
                int[] indexes = this.oldIndexSet.getValues();
                for (int i = 0; i < indexes.length; ++i) {
                    this.activeFile.removeBuffer(indexes[i]);
                }
                this.buffersRemoved[this.snapshotIndex] = indexes.length;
                File file = this.activeFile.getFile();
                this.activeFile.close();
                this.lastSnapshotTime = file.lastModified();
                Msg.info((Object)this, (Object)(new Date() + " Recovery snapshot created: " + this.snapshotFiles[this.snapshotIndex]));
            } else {
                this.activeFile.close();
            }
        }
        catch (IOException e) {
            commit = false;
        }
        this.activeFile = null;
        if (!commit) {
            this.snapshotFiles[this.snapshotIndex].delete();
            --this.snapshotIndex;
            if (this.snapshotIndex < 0) {
                this.snapshotIndex = 1;
            }
        }
    }

    void putBuffer(DataBuffer buffer, BufferNode node) throws IOException {
        if (this.activeFile == null) {
            throw new AssertException("Snapshot not in progress");
        }
        if (this.newSnapshot || !node.snapshotTaken[this.snapshotIndex]) {
            this.activeFile.putBuffer(buffer);
            node.snapshotTaken[this.snapshotIndex] = true;
            int n = this.snapshotIndex;
            this.buffersSaved[n] = this.buffersSaved[n] + 1;
        } else {
            int n = this.snapshotIndex;
            this.buffersIgnored[n] = this.buffersIgnored[n] + 1;
        }
        this.oldIndexSet.remove(node.id);
    }

    void printStats() {
        Msg.info((Object)this, (Object)"RecoveryMgr stats:");
        for (int i = 0; i < 2; ++i) {
            String lastSnapshot = this.snapshotIndex == i ? "*" : " ";
            Msg.info((Object)this, (Object)("  " + lastSnapshot + this.snapshotFiles[i]));
            Msg.info((Object)this, (Object)("     buffers saved: " + this.buffersSaved[i]));
            Msg.info((Object)this, (Object)("     buffers unchanged: " + this.buffersIgnored[i]));
            Msg.info((Object)this, (Object)("     buffers removed: " + this.buffersRemoved[i]));
        }
    }
}

