/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.prop;

import ghidra.util.prop.PropertyPage;
import ghidra.util.prop.PropertySet;
import ghidra.util.prop.PropertyVisitor;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class StringPropertySet
extends PropertySet {
    private static final long serialVersionUID = 1L;

    public StringPropertySet(String name) {
        super(name, null);
    }

    @Override
    public int getDataSize() {
        return 8;
    }

    public void putString(long index, String value) {
        PropertyPage page = this.getOrCreatePage(this.getPageID(index));
        int n = page.getSize();
        page.addString(this.getPageOffset(index), value);
        this.numProperties += page.getSize() - n;
    }

    public String getString(long index) {
        PropertyPage page = this.getPage(this.getPageID(index));
        if (page != null) {
            return page.getString(this.getPageOffset(index));
        }
        return null;
    }

    @Override
    protected void moveIndex(long from, long to) {
        String value = this.getString(from);
        this.remove(from);
        this.putString(to, value);
    }

    @Override
    protected void saveProperty(ObjectOutputStream oos, long index) throws IOException {
        oos.writeObject(this.getString(index));
    }

    @Override
    protected void restoreProperty(ObjectInputStream ois, long index) throws IOException, ClassNotFoundException {
        this.putString(index, (String)ois.readObject());
    }

    @Override
    public void applyValue(PropertyVisitor visitor, long addr) {
        String str = this.getString(addr);
        if (str != null) {
            visitor.visit(str);
        }
    }
}

