/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pcodeInject;

import ghidra.app.plugin.processors.sleigh.PcodeEmit;
import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.javaclass.format.ClassFileAnalysisState;
import ghidra.javaclass.format.ClassFileJava;
import ghidra.javaclass.format.constantpool.AbstractConstantPoolInfoJava;
import ghidra.program.model.lang.InjectContext;
import ghidra.program.model.lang.InjectPayload;
import ghidra.program.model.listing.Program;
import java.io.IOException;

public abstract class InjectPayloadJava
implements InjectPayload {
    protected SleighLanguage language;
    protected long uniqueBase;
    private String sourceName;

    public InjectPayloadJava(String sourceName, SleighLanguage language, long uniqBase) {
        this.language = language;
        this.sourceName = sourceName;
        this.uniqueBase = uniqBase;
    }

    protected static AbstractConstantPoolInfoJava[] getConstantPool(Program program) {
        ClassFileAnalysisState analysisState;
        try {
            analysisState = ClassFileAnalysisState.getState(program);
        }
        catch (IOException e) {
            return null;
        }
        ClassFileJava classFile = analysisState.getClassFile();
        return classFile.getConstantPool();
    }

    public int getType() {
        return 2;
    }

    public String getSource() {
        return this.sourceName;
    }

    public int getParamShift() {
        return 0;
    }

    public void inject(InjectContext context, PcodeEmit emit) {
    }

    public boolean isFallThru() {
        return true;
    }

    public InjectPayload.InjectParameter[] getInput() {
        return null;
    }

    public InjectPayload.InjectParameter[] getOutput() {
        return null;
    }
}

