/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pcodeInject;

import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.app.util.pcodeInject.ConstantPoolJava;
import ghidra.app.util.pcodeInject.InjectGetField;
import ghidra.app.util.pcodeInject.InjectGetStatic;
import ghidra.app.util.pcodeInject.InjectInvokeDynamic;
import ghidra.app.util.pcodeInject.InjectInvokeInterface;
import ghidra.app.util.pcodeInject.InjectInvokeSpecial;
import ghidra.app.util.pcodeInject.InjectInvokeStatic;
import ghidra.app.util.pcodeInject.InjectInvokeVirtual;
import ghidra.app.util.pcodeInject.InjectLdc;
import ghidra.app.util.pcodeInject.InjectMultiANewArray;
import ghidra.app.util.pcodeInject.InjectPayloadJava;
import ghidra.app.util.pcodeInject.InjectPayloadJavaParameters;
import ghidra.app.util.pcodeInject.InjectPutField;
import ghidra.app.util.pcodeInject.InjectPutStatic;
import ghidra.program.model.lang.ConstantPool;
import ghidra.program.model.lang.InjectPayload;
import ghidra.program.model.lang.PcodeInjectLibrary;
import ghidra.program.model.listing.Program;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class PcodeInjectLibraryJava
extends PcodeInjectLibrary {
    public static final int CONSTANT_POOL_START_ADDRESS = 10;
    public static final String GETFIELD = "getFieldCallOther";
    public static final String GETSTATIC = "getStaticCallOther";
    public static final String INVOKE_DYNAMIC = "invokedynamicCallOther";
    public static final String INVOKE_INTERFACE = "invokeinterfaceCallOther";
    public static final String INVOKE_SPECIAL = "invokespecialCallOther";
    public static final String INVOKE_STATIC = "invokestaticCallOther";
    public static final String INVOKE_VIRTUAL = "invokevirtualCallOther";
    public static final String LDC = "ldcCallOther";
    public static final String LDC2_W = "ldc2_wCallOther";
    public static final String LDC_W = "ldc_wCallOther";
    public static final String MULTIANEWARRAY = "multianewarrayCallOther";
    public static final String PUTFIELD = "putFieldCallOther";
    public static final String PUTSTATIC = "putStaticCallOther";
    public static final String SOURCENAME = "javainternal";
    public static final int REFERENCE_SIZE = 4;
    private Map<String, InjectPayloadJava> implementedOps;
    private InjectPayloadJavaParameters paramPayload;

    public PcodeInjectLibraryJava(SleighLanguage l) {
        super(l);
        long offset = l.getUniqueBase();
        this.implementedOps = new HashMap<String, InjectPayloadJava>();
        this.implementedOps.put(GETFIELD, new InjectGetField(SOURCENAME, l, offset));
        this.implementedOps.put(GETSTATIC, new InjectGetStatic(SOURCENAME, l, offset += 256L));
        this.implementedOps.put(INVOKE_DYNAMIC, new InjectInvokeDynamic(SOURCENAME, l, offset += 256L));
        this.implementedOps.put(INVOKE_INTERFACE, new InjectInvokeInterface(SOURCENAME, l, offset += 256L));
        this.implementedOps.put(INVOKE_SPECIAL, new InjectInvokeSpecial(SOURCENAME, l, offset += 256L));
        this.implementedOps.put(INVOKE_STATIC, new InjectInvokeStatic(SOURCENAME, l, offset += 256L));
        this.implementedOps.put(INVOKE_VIRTUAL, new InjectInvokeVirtual(SOURCENAME, l, offset += 256L));
        InjectLdc ldcInject = new InjectLdc(SOURCENAME, l, offset += 256L);
        offset += 256L;
        this.implementedOps.put(LDC, ldcInject);
        this.implementedOps.put(LDC2_W, ldcInject);
        this.implementedOps.put(LDC_W, ldcInject);
        this.implementedOps.put(MULTIANEWARRAY, new InjectMultiANewArray(SOURCENAME, l, offset));
        this.implementedOps.put(PUTFIELD, new InjectPutField(SOURCENAME, l, offset += 256L));
        this.implementedOps.put(PUTSTATIC, new InjectPutStatic(SOURCENAME, l, offset += 256L));
        this.paramPayload = new InjectPayloadJavaParameters(l, offset += 256L);
    }

    public InjectPayload getPayload(int type, String name, Program program, String context) {
        if (type == 3) {
            return this.paramPayload;
        }
        InjectPayloadJava payload = this.implementedOps.get(name);
        if (payload == null) {
            return super.getPayload(type, name, program, context);
        }
        return payload;
    }

    public ConstantPool getConstantPool(Program program) throws IOException {
        return new ConstantPoolJava(program);
    }
}

