/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.store.local;

import ghidra.framework.store.FolderItem;
import ghidra.framework.store.ItemCheckoutStatus;
import ghidra.framework.store.Version;
import ghidra.framework.store.local.LocalFileSystem;
import ghidra.framework.store.local.LocalFolderItem;
import ghidra.util.PropertyFile;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;

public class UnknownFolderItem
extends LocalFolderItem {
    public static final String UNKNOWN_CONTENT_TYPE = "Unknown";

    UnknownFolderItem(LocalFileSystem fileSystem, PropertyFile propertyFile) {
        super(fileSystem, propertyFile);
    }

    @Override
    public long length() throws IOException {
        return 0L;
    }

    @Override
    public void updateCheckout(FolderItem versionedFolderItem, boolean updateItem, TaskMonitor monitor) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateCheckout(FolderItem item, int checkoutVersion) throws IOException {
        throw new UnsupportedOperationException();
    }

    public synchronized ItemCheckoutStatus checkout(String user) throws IOException {
        throw new IOException(this.propertyFile.getName() + " may not be checked-out, item may be corrupt");
    }

    public synchronized void terminateCheckout(long checkoutId) {
    }

    @Override
    public void clearCheckout() throws IOException {
    }

    public void setCheckout(long checkoutId, int checkoutVersion, int localVersion) {
    }

    @Override
    public synchronized ItemCheckoutStatus getCheckout(long checkoutId) throws IOException {
        return null;
    }

    @Override
    public synchronized ItemCheckoutStatus[] getCheckouts() throws IOException {
        return new ItemCheckoutStatus[0];
    }

    @Override
    public synchronized Version[] getVersions() throws IOException {
        throw new IOException("History data is unavailable for " + this.propertyFile.getName());
    }

    @Override
    public String getContentType() {
        return UNKNOWN_CONTENT_TYPE;
    }

    @Override
    void deleteMinimumVersion(String user) throws IOException {
        throw new UnsupportedOperationException("Versioning not supported for UnknownFolderItems");
    }

    @Override
    void deleteCurrentVersion(String user) throws IOException {
        throw new UnsupportedOperationException("Versioning not supported for UnknownFolderItems");
    }

    @Override
    public void output(File outputFile, int version, TaskMonitor monitor) throws IOException {
        throw new UnsupportedOperationException("Output not supported for UnknownFolderItems");
    }

    @Override
    int getMinimumVersion() throws IOException {
        return -1;
    }

    @Override
    public int getCurrentVersion() {
        return -1;
    }

    @Override
    public boolean canRecover() {
        return false;
    }
}

