/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jms.ra.util;

import java.util.Hashtable;
import java.util.ListIterator;
import java.util.Vector;
import javax.resource.spi.InvalidPropertyException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomTokenizer {
    private static final char ESCAPE_CHAR = '\\';
    private static final String QUOTE_STRING = "\"";
    private int size = 0;
    private ListIterator tokenIterator = null;

    public CustomTokenizer(String string, String string2) throws InvalidPropertyException {
        if (!this.checkForMatchingQuotes(string)) {
            throw new InvalidPropertyException("UnclosedString");
        }
        if (string == null || string2 == null) {
            throw new InvalidPropertyException("CouldNotCreateCliTokenizer");
        }
        this.tokenIterator = this.populateList(string, string2);
    }

    public int countTokens() {
        return this.size;
    }

    public boolean hasMoreTokens() {
        return this.tokenIterator.hasNext();
    }

    public String nextTokenWithoutEscapeAndQuoteChars() throws InvalidPropertyException {
        String string = this.removeEscapeChars((String)this.tokenIterator.next());
        String string2 = this.removeQuoteChars(string);
        return this.removeEscapeCharsFromQuotes(string2);
    }

    public String nextToken() throws InvalidPropertyException {
        return (String)this.tokenIterator.next();
    }

    private boolean checkForMatchingQuotes(String string) throws InvalidPropertyException {
        int n = this.getStringDelimiterIndex(string, QUOTE_STRING, 0);
        while (n != -1) {
            int n2 = this.getStringDelimiterIndex(string, QUOTE_STRING, n + 1);
            if (n2 == -1) {
                return false;
            }
            n = this.getStringDelimiterIndex(string, QUOTE_STRING, n2 + 1);
        }
        return true;
    }

    private ListIterator populateList(String string, String string2) throws InvalidPropertyException {
        Vector<String> vector = new Vector<String>();
        int n = this.getStringDelimiterIndex(string, string2, 0);
        if (n == -1) {
            vector.add(string);
        } else {
            int n2 = 0;
            while (n > -1) {
                if (n2 != n) {
                    vector.add(string.substring(n2, n));
                }
                n2 = n + 1;
                n = this.getStringDelimiterIndex(string, string2, n2);
            }
            if (n2 != string.length()) {
                vector.add(string.substring(n2));
            }
        }
        this.size = vector.size();
        try {
            return vector.listIterator();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new InvalidPropertyException((Throwable)indexOutOfBoundsException);
        }
    }

    private String removeEscapeChars(String string) throws InvalidPropertyException {
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while (n < string.length()) {
            int n2 = this.getStringDelimiterIndex(string, String.valueOf('\\'), n);
            if (n2 == -1) {
                stringBuffer.append(string.substring(n));
                break;
            }
            if (n2 + 1 < string.length() && String.valueOf(string.charAt(n2 + 1)).equals(QUOTE_STRING)) {
                stringBuffer.append(string.substring(n, n2 + 1));
            } else {
                stringBuffer.append(string.substring(n, n2));
            }
            n = n2 + 1;
        }
        return stringBuffer.toString();
    }

    private String removeEscapeCharsFromQuotes(String string) throws InvalidPropertyException {
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while (n < string.length()) {
            int n2 = string.indexOf(String.valueOf('\\'), n);
            if (n2 == -1) {
                stringBuffer.append(string.substring(n));
                break;
            }
            if (String.valueOf(string.charAt(n2 + 1)).equals(QUOTE_STRING)) {
                stringBuffer.append(string.substring(n, n2));
            } else {
                stringBuffer.append(string.substring(n, n2 + 1));
            }
            n = n2 + 1;
        }
        return stringBuffer.toString();
    }

    private String removeQuoteChars(String string) throws InvalidPropertyException {
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while (n < string.length()) {
            int n2 = this.getStringDelimiterIndex(string, QUOTE_STRING, n);
            if (n2 == -1) {
                stringBuffer.append(string.substring(n));
                break;
            }
            stringBuffer.append(string.substring(n, n2));
            n = n2 + 1;
        }
        return stringBuffer.toString();
    }

    private int getStringDelimiterIndex(String string, String string2, int n) throws InvalidPropertyException {
        if (n > string.length() - 1) {
            return -1;
        }
        int n2 = string.indexOf(string2, n);
        int n3 = string.indexOf(QUOTE_STRING, n);
        if (n3 != -1 && n2 != -1 && n3 < n2) {
            int n4 = string.indexOf(QUOTE_STRING, n3 + 1);
            if (n4 == -1) {
                throw new InvalidPropertyException("UnclosedString");
            }
            if (n4 != string.length() - 1) {
                return this.getStringDelimiterIndex(string, string2, n4 + 1);
            }
            return -1;
        }
        if (n2 > 0 && string.charAt(n2 - 1) == '\\') {
            return this.getStringDelimiterIndex(string, string2, n2 + 1);
        }
        return n2;
    }

    public static void main(String[] stringArray) throws Exception {
        String string = "imqConsumerFlowThreshold=78,imqAddressList=tcp://localhost:7676\\,tcp://localhost:7677";
        System.out.println("Parsing " + string);
        String string2 = "=";
        String string3 = ",";
        CustomTokenizer customTokenizer = new CustomTokenizer(string, string3);
        while (customTokenizer.hasMoreTokens()) {
            String string4 = customTokenizer.nextTokenWithoutEscapeAndQuoteChars();
            int n = string4.indexOf(string2);
            String string5 = string4.substring(0, n);
            String string6 = string4.substring(n + string2.length());
            System.out.println("name=" + string5);
            System.out.println("value=" + string6);
        }
    }

    public static Hashtable<String, String> parseToProperties(String string) throws InvalidPropertyException {
        String string2 = "=";
        String string3 = ",";
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        if (string == null || string.trim().equals("")) {
            return hashtable;
        }
        CustomTokenizer customTokenizer = new CustomTokenizer(string, string3);
        while (customTokenizer.hasMoreTokens()) {
            String string4 = customTokenizer.nextTokenWithoutEscapeAndQuoteChars();
            int n = string4.indexOf(string2);
            String string5 = string4.substring(0, n);
            String string6 = string4.substring(n + string2.length());
            hashtable.put(string5, string6);
        }
        return hashtable;
    }
}

