/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.runtime;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.Fiber;
import com.sun.xml.ws.client.ClientTransportException;
import com.sun.xml.ws.rx.RxRuntimeException;
import com.sun.xml.ws.rx.rm.localization.LocalizationMessages;
import com.sun.xml.ws.rx.rm.runtime.ApplicationMessage;
import com.sun.xml.ws.rx.rm.runtime.JaxwsApplicationMessage;
import com.sun.xml.ws.rx.rm.runtime.RedeliveryTaskExecutor;
import com.sun.xml.ws.rx.rm.runtime.RuntimeContext;
import com.sun.xml.ws.rx.rm.runtime.delivery.Postman;
import com.sun.xml.ws.rx.rm.runtime.sequence.DuplicateMessageRegistrationException;
import com.sun.xml.ws.rx.util.AbstractResponseHandler;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.xml.ws.WebServiceException;

class ClientSourceDeliveryCallback
implements Postman.Callback {
    private static final Logger LOGGER = Logger.getLogger(ClientSourceDeliveryCallback.class);
    private final RuntimeContext rc;

    public ClientSourceDeliveryCallback(RuntimeContext rc) {
        this.rc = rc;
    }

    public void deliver(ApplicationMessage message) {
        if (!(message instanceof JaxwsApplicationMessage)) {
            throw (RxRuntimeException)((Object)LOGGER.logSevereException((Throwable)((Object)new RxRuntimeException(LocalizationMessages.WSRM_1141_UNEXPECTED_MESSAGE_CLASS(message.getClass().getName(), JaxwsApplicationMessage.class.getName())))));
        }
        this.deliver((JaxwsApplicationMessage)JaxwsApplicationMessage.class.cast(message));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deliver(JaxwsApplicationMessage message) {
        LOGGER.entering(new Object[]{message});
        try {
            this.rc.sourceMessageHandler.attachAcknowledgementInfo(message);
            Packet outboundPacketCopy = message.getPacket().copy(true);
            Boolean isResquestResponseMep = outboundPacketCopy.expectReply = message.getPacket().expectReply;
            outboundPacketCopy.expectReply = Boolean.TRUE;
            this.rc.protocolHandler.appendSequenceHeader(outboundPacketCopy.getMessage(), message);
            this.rc.protocolHandler.appendAcknowledgementHeaders(outboundPacketCopy, message.getAcknowledgementData());
            AbstractResponseHandler responseCallback = isResquestResponseMep == null ? new AmbiguousMepCallbackHandler(message, this.rc) : (isResquestResponseMep != false ? new ReqRespMepCallbackHandler(message, this.rc) : new OneWayMepCallbackHandler(message, this.rc));
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finer("Selected Response callback class: " + responseCallback.getClass().getName());
            }
            this.rc.communicator.sendAsync(outboundPacketCopy, (Fiber.CompletionCallback)((Object)responseCallback));
        }
        finally {
            LOGGER.exiting();
        }
    }

    private static boolean isResendPossible(Throwable throwable) {
        if (throwable instanceof IOException) {
            return true;
        }
        if (throwable instanceof WebServiceException) {
            if (throwable instanceof ClientTransportException) {
                return true;
            }
            if (throwable.getCause() instanceof IOException) {
                return true;
            }
        }
        return false;
    }

    private static class AmbiguousMepCallbackHandler
    extends AbstractResponseHandler
    implements Fiber.CompletionCallback {
        private final ApplicationMessage request;
        private final RuntimeContext rc;

        public AmbiguousMepCallbackHandler(ApplicationMessage request, RuntimeContext rc) {
            super(rc.suspendedFiberStorage, request.getCorrelationId());
            this.request = request;
            this.rc = rc;
        }

        public void onCompletion(Packet response) {
            if (response.getMessage() != null) {
                JaxwsApplicationMessage message = new JaxwsApplicationMessage(response, this.getCorrelationId());
                this.rc.protocolHandler.loadSequenceHeaderData(message, message.getJaxwsMessage());
                this.rc.protocolHandler.loadAcknowledgementData(message, message.getJaxwsMessage());
                this.rc.destinationMessageHandler.processAcknowledgements(message.getAcknowledgementData());
                if (message.getSequenceId() != null) {
                    try {
                        this.rc.destinationMessageHandler.registerMessage(message);
                        this.rc.destinationMessageHandler.putToDeliveryQueue(message);
                        return;
                    }
                    catch (DuplicateMessageRegistrationException ex) {
                        this.onCompletion(ex);
                        return;
                    }
                }
            }
            this.resumeParentFiber(response);
        }

        public void onCompletion(Throwable error) {
            if (ClientSourceDeliveryCallback.isResendPossible(error)) {
                RedeliveryTaskExecutor.INSTANCE.register(this.request, this.rc.configuration.getRmFeature().getRetransmissionBackoffAlgorithm().getDelayInMillis(this.request.getNextResendCount(), this.rc.configuration.getRmFeature().getMessageRetransmissionInterval()), TimeUnit.MILLISECONDS, this.rc.sourceMessageHandler);
            } else {
                this.resumeParentFiber(error);
            }
        }
    }

    private static class OneWayMepCallbackHandler
    extends AbstractResponseHandler
    implements Fiber.CompletionCallback {
        private final RuntimeContext rc;
        private final ApplicationMessage request;

        public OneWayMepCallbackHandler(ApplicationMessage request, RuntimeContext rc) {
            super(rc.suspendedFiberStorage, request.getCorrelationId());
            this.request = request;
            this.rc = rc;
        }

        public void onCompletion(Packet response) {
            if (response.getMessage() != null) {
                JaxwsApplicationMessage message = new JaxwsApplicationMessage(response, this.getCorrelationId());
                this.rc.protocolHandler.loadSequenceHeaderData(message, message.getJaxwsMessage());
                this.rc.protocolHandler.loadAcknowledgementData(message, message.getJaxwsMessage());
                this.rc.destinationMessageHandler.processAcknowledgements(message.getAcknowledgementData());
            }
            this.resumeParentFiber(response);
        }

        public void onCompletion(Throwable error) {
            if (ClientSourceDeliveryCallback.isResendPossible(error)) {
                RedeliveryTaskExecutor.INSTANCE.register(this.request, this.rc.configuration.getRmFeature().getRetransmissionBackoffAlgorithm().getDelayInMillis(this.request.getNextResendCount(), this.rc.configuration.getRmFeature().getMessageRetransmissionInterval()), TimeUnit.MILLISECONDS, this.rc.sourceMessageHandler);
            } else {
                this.resumeParentFiber(error);
            }
        }
    }

    private static class ReqRespMepCallbackHandler
    extends AbstractResponseHandler
    implements Fiber.CompletionCallback {
        private final ApplicationMessage request;
        private final RuntimeContext rc;

        public ReqRespMepCallbackHandler(ApplicationMessage request, RuntimeContext rc) {
            super(rc.suspendedFiberStorage, request.getCorrelationId());
            this.request = request;
            this.rc = rc;
        }

        public void onCompletion(Packet response) {
            if (response.getMessage() != null) {
                JaxwsApplicationMessage message = new JaxwsApplicationMessage(response, this.getCorrelationId());
                this.rc.protocolHandler.loadSequenceHeaderData(message, message.getJaxwsMessage());
                this.rc.protocolHandler.loadAcknowledgementData(message, message.getJaxwsMessage());
                try {
                    this.rc.destinationMessageHandler.registerMessage(message);
                    this.rc.destinationMessageHandler.processAcknowledgements(message.getAcknowledgementData());
                    this.rc.destinationMessageHandler.putToDeliveryQueue(message);
                }
                catch (DuplicateMessageRegistrationException ex) {
                    this.onCompletion(ex);
                }
            } else {
                RedeliveryTaskExecutor.INSTANCE.register(this.request, this.rc.configuration.getRmFeature().getRetransmissionBackoffAlgorithm().getDelayInMillis(this.request.getNextResendCount(), this.rc.configuration.getRmFeature().getMessageRetransmissionInterval()), TimeUnit.MILLISECONDS, this.rc.sourceMessageHandler);
            }
        }

        public void onCompletion(Throwable error) {
            if (ClientSourceDeliveryCallback.isResendPossible(error)) {
                RedeliveryTaskExecutor.INSTANCE.register(this.request, this.rc.configuration.getRmFeature().getRetransmissionBackoffAlgorithm().getDelayInMillis(this.request.getNextResendCount(), this.rc.configuration.getRmFeature().getMessageRetransmissionInterval()), TimeUnit.MILLISECONDS, this.rc.sourceMessageHandler);
            } else {
                this.resumeParentFiber(error);
            }
        }
    }
}

