/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.runtime;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.api.addressing.WSEndpointReference;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.Fiber;
import com.sun.xml.ws.api.pipe.NextAction;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.api.pipe.TubeCloner;
import com.sun.xml.ws.api.pipe.helper.AbstractFilterTubeImpl;
import com.sun.xml.ws.assembler.ClientTubelineAssemblyContext;
import com.sun.xml.ws.commons.MaintenanceTaskExecutor;
import com.sun.xml.ws.commons.VolatileReference;
import com.sun.xml.ws.rx.RxRuntimeException;
import com.sun.xml.ws.rx.mc.runtime.McClientTube;
import com.sun.xml.ws.rx.mc.runtime.spi.ProtocolMessageHandler;
import com.sun.xml.ws.rx.rm.RmVersion;
import com.sun.xml.ws.rx.rm.localization.LocalizationMessages;
import com.sun.xml.ws.rx.rm.protocol.AcknowledgementData;
import com.sun.xml.ws.rx.rm.protocol.CloseSequenceData;
import com.sun.xml.ws.rx.rm.protocol.CloseSequenceResponseData;
import com.sun.xml.ws.rx.rm.protocol.CreateSequenceData;
import com.sun.xml.ws.rx.rm.protocol.CreateSequenceResponseData;
import com.sun.xml.ws.rx.rm.protocol.TerminateSequenceData;
import com.sun.xml.ws.rx.rm.protocol.TerminateSequenceResponseData;
import com.sun.xml.ws.rx.rm.runtime.ClientAckRequesterTask;
import com.sun.xml.ws.rx.rm.runtime.ClientDestinationDeliveryCallback;
import com.sun.xml.ws.rx.rm.runtime.ClientSourceDeliveryCallback;
import com.sun.xml.ws.rx.rm.runtime.DestinationMessageHandler;
import com.sun.xml.ws.rx.rm.runtime.JaxwsApplicationMessage;
import com.sun.xml.ws.rx.rm.runtime.RmConfiguration;
import com.sun.xml.ws.rx.rm.runtime.RuntimeContext;
import com.sun.xml.ws.rx.rm.runtime.WsrmProtocolHandler;
import com.sun.xml.ws.rx.rm.runtime.delivery.DeliveryQueueBuilder;
import com.sun.xml.ws.rx.rm.runtime.delivery.PostmanPool;
import com.sun.xml.ws.rx.rm.runtime.sequence.DuplicateMessageRegistrationException;
import com.sun.xml.ws.rx.rm.runtime.sequence.DuplicateSequenceException;
import com.sun.xml.ws.rx.rm.runtime.sequence.Sequence;
import com.sun.xml.ws.rx.rm.runtime.sequence.SequenceManager;
import com.sun.xml.ws.rx.rm.runtime.sequence.SequenceManagerFactory;
import com.sun.xml.ws.rx.rm.runtime.sequence.UnknownSequenceException;
import com.sun.xml.ws.rx.util.Communicator;
import com.sun.xml.ws.security.secconv.SecureConversationInitiator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;

final class ClientTube
extends AbstractFilterTubeImpl {
    private static final Logger LOGGER = Logger.getLogger(ClientTube.class);
    private static final Lock INIT_LOCK = new ReentrantLock();
    private final RuntimeContext rc;
    private final WSEndpointReference rmSourceReference;
    private volatile VolatileReference<String> outboundSequenceId;

    ClientTube(ClientTube original, TubeCloner cloner) {
        super(original, cloner);
        this.rc = original.rc;
        this.rmSourceReference = original.rmSourceReference;
        this.outboundSequenceId = original.outboundSequenceId;
    }

    ClientTube(RmConfiguration configuration, Tube tubelineHead, ClientTubelineAssemblyContext context) throws RxRuntimeException {
        super(tubelineHead);
        this.outboundSequenceId = new VolatileReference<Object>(null);
        SecureConversationInitiator scInitiator = context.getImplementation(SecureConversationInitiator.class);
        if (scInitiator == null) {
            scInitiator = context.getScInitiator();
        }
        this.rc = RuntimeContext.getBuilder(configuration, new Communicator("rm-client-tube-communicator", context.getAddress(), this.next, scInitiator, configuration.getAddressingVersion(), configuration.getSoapVersion(), configuration.getRmFeature().getVersion().getJaxbContext(configuration.getAddressingVersion()))).build();
        DeliveryQueueBuilder outboundQueueBuilder = DeliveryQueueBuilder.getBuilder(this.rc.configuration, PostmanPool.INSTANCE.getPostman(), new ClientSourceDeliveryCallback(this.rc));
        DeliveryQueueBuilder inboundQueueBuilder = null;
        if (this.rc.configuration.requestResponseOperationsDetected()) {
            inboundQueueBuilder = DeliveryQueueBuilder.getBuilder(this.rc.configuration, PostmanPool.INSTANCE.getPostman(), new ClientDestinationDeliveryCallback(this.rc));
        }
        SequenceManager sequenceManager = SequenceManagerFactory.INSTANCE.createSequenceManager(false, context.getAddress().getURI().toString(), inboundQueueBuilder, outboundQueueBuilder, this.rc.configuration);
        this.rc.setSequenceManager(sequenceManager);
        McClientTube mcClientTube = context.getImplementation(McClientTube.class);
        if (configuration.isMakeConnectionSupportEnabled()) {
            assert (mcClientTube != null);
            this.rmSourceReference = mcClientTube.getWsmcAnonymousEndpointReference();
            mcClientTube.registerProtocolMessageHandler(ClientTube.createRmProtocolMessageHandler(this.rc.configuration, this.rc.protocolHandler, this.rc.destinationMessageHandler));
        } else {
            this.rmSourceReference = configuration.getAddressingVersion().anonymousEpr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientTube copy(TubeCloner cloner) {
        LOGGER.entering();
        try {
            ClientTube clientTube = new ClientTube(this, cloner);
            return clientTube;
        }
        finally {
            LOGGER.exiting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NextAction processRequest(Packet request) {
        LOGGER.entering();
        try {
            try {
                INIT_LOCK.lock();
                if (this.outboundSequenceId.value == null) {
                    this.openRmSession(request);
                }
            }
            finally {
                INIT_LOCK.unlock();
            }
            assert (this.outboundSequenceId != null);
            JaxwsApplicationMessage message = new JaxwsApplicationMessage(request, request.getMessage().getID(this.rc.addressingVersion, this.rc.soapVersion));
            this.rc.sourceMessageHandler.registerMessage(message, (String)this.outboundSequenceId.value);
            Object object = message.getCorrelationId();
            synchronized (object) {
                try {
                    this.rc.suspendedFiberStorage.register(message.getCorrelationId(), Fiber.current());
                    this.rc.sourceMessageHandler.putToDeliveryQueue(message);
                    NextAction nextAction = super.doSuspend();
                    return nextAction;
                }
                catch (Throwable throwable) {
                    try {
                        throw throwable;
                    }
                    catch (DuplicateMessageRegistrationException ex) {
                        LOGGER.logSevereException((Throwable)ex);
                        object = this.doThrow(ex);
                        return object;
                    }
                    catch (RxRuntimeException ex) {
                        LOGGER.logSevereException((Throwable)((Object)ex));
                        object = this.doThrow((Throwable)((Object)ex));
                        return object;
                    }
                }
            }
        }
        finally {
            LOGGER.exiting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NextAction processResponse(Packet repsonse) {
        LOGGER.entering();
        try {
            NextAction nextAction = super.processResponse(repsonse);
            return nextAction;
        }
        finally {
            LOGGER.exiting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NextAction processException(Throwable throwable) {
        LOGGER.entering();
        try {
            NextAction nextAction = super.processException(throwable);
            return nextAction;
        }
        finally {
            LOGGER.exiting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preDestroy() {
        LOGGER.entering();
        try {
            if (this.outboundSequenceId.value != null) {
                this.closeRmSession();
            }
        }
        catch (RuntimeException ex) {
            LOGGER.warning(LocalizationMessages.WSRM_1103_RM_SEQUENCE_NOT_TERMINATED_NORMALLY(), (Throwable)ex);
        }
        finally {
            super.preDestroy();
            LOGGER.exiting();
        }
    }

    static final ProtocolMessageHandler createRmProtocolMessageHandler(RmConfiguration configuration, final WsrmProtocolHandler protocolHandler, final DestinationMessageHandler dstMsgHandler) {
        final RmVersion rmVersion = configuration.getRmFeature().getVersion();
        return new ProtocolMessageHandler(){
            Collection<String> SUPPORTED_WSA_ACTIONS;
            {
                this.SUPPORTED_WSA_ACTIONS = Collections.unmodifiableCollection(Arrays.asList(rmVersion.ackRequestedAction, rmVersion.sequenceAcknowledgementAction));
            }

            @Override
            public Collection<String> getSuportedWsaActions() {
                return this.SUPPORTED_WSA_ACTIONS;
            }

            @Override
            public void processProtocolMessage(Packet protocolMessagePacket) {
                if (protocolHandler.containsProtocolMessage(protocolMessagePacket)) {
                    LOGGER.finer("Processing RM protocol response message.");
                    AcknowledgementData ackData = protocolHandler.getAcknowledgementData(protocolMessagePacket.getMessage());
                    dstMsgHandler.processAcknowledgements(ackData);
                } else {
                    LOGGER.severe(LocalizationMessages.WSRM_1120_RESPONSE_NOT_IDENTIFIED_AS_PROTOCOL_MESSAGE());
                }
            }
        };
    }

    private void openRmSession(Packet request) {
        this.createSequences(request);
        ClientAckRequesterTask cart = new ClientAckRequesterTask(this.rc, (String)this.outboundSequenceId.value);
        MaintenanceTaskExecutor.INSTANCE.register(cart, cart.getExecutionDelay(), cart.getExecutionDelayTimeUnit());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeRmSession() {
        try {
            String inboundSequenceId = this.rc.getBoundSequenceId((String)this.outboundSequenceId.value);
            if (inboundSequenceId != null) {
                this.waitForMissingAcknowledgements(inboundSequenceId, this.rc.configuration.getRmFeature().getCloseSequenceOperationTimeout());
            }
            this.closeSequence();
            this.waitForMissingAcknowledgements((String)this.outboundSequenceId.value, this.rc.configuration.getRmFeature().getCloseSequenceOperationTimeout());
            this.terminateSequence();
        }
        finally {
            this.rc.close();
        }
    }

    private void createSequences(Packet appRequest) throws RxRuntimeException, DuplicateSequenceException {
        CreateSequenceData.Builder csBuilder = CreateSequenceData.getBuilder(this.rmSourceReference.toSpec());
        csBuilder.strType(this.rc.communicator.tryStartSecureConversation(appRequest));
        if (this.rc.configuration.requestResponseOperationsDetected()) {
            csBuilder.offeredInboundSequenceId(this.rc.sequenceManager().generateSequenceUID());
        }
        CreateSequenceData requestData = csBuilder.build();
        Packet request = this.rc.protocolHandler.toPacket(requestData, null);
        CreateSequenceResponseData responseData = this.rc.protocolHandler.toCreateSequenceResponseData(this.verifyResponse(this.rc.communicator.send(request), "CreateSequence", Level.SEVERE));
        if (requestData.getOfferedSequenceId() != null) {
            if (responseData.getAcceptedSequenceAcksTo() == null) {
                throw new RxRuntimeException(LocalizationMessages.WSRM_1116_ACKS_TO_NOT_EQUAL_TO_ENDPOINT_DESTINATION(null, this.rc.communicator.getDestinationAddress()));
            }
            if (!this.rc.communicator.getDestinationAddress().getURI().toString().equals(new WSEndpointReference(responseData.getAcceptedSequenceAcksTo()).getAddress())) {
                throw new RxRuntimeException(LocalizationMessages.WSRM_1116_ACKS_TO_NOT_EQUAL_TO_ENDPOINT_DESTINATION(responseData.getAcceptedSequenceAcksTo().toString(), this.rc.communicator.getDestinationAddress()));
            }
        }
        this.outboundSequenceId.value = this.rc.sequenceManager().createOutboundSequence(responseData.getSequenceId(), requestData.getStrType() != null ? requestData.getStrType().getId() : null, responseData.getDuration() == -1L ? -1L : responseData.getDuration() + this.rc.sequenceManager().currentTimeInMillis()).getId();
        if (requestData.getOfferedSequenceId() != null) {
            Sequence inboundSequence = this.rc.sequenceManager().createInboundSequence(requestData.getOfferedSequenceId(), requestData.getStrType() != null ? requestData.getStrType().getId() : null, responseData.getDuration() == -1L ? -1L : responseData.getDuration() + this.rc.sequenceManager().currentTimeInMillis());
            this.rc.sequenceManager().bindSequences((String)this.outboundSequenceId.value, inboundSequence.getId());
            this.rc.sequenceManager().bindSequences(inboundSequence.getId(), (String)this.outboundSequenceId.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeSequence() {
        CloseSequenceData.Builder dataBuilder = CloseSequenceData.getBuilder((String)this.outboundSequenceId.value, this.rc.sequenceManager().getSequence((String)this.outboundSequenceId.value).getLastMessageNumber());
        dataBuilder.acknowledgementData(this.rc.sourceMessageHandler.getAcknowledgementData((String)this.outboundSequenceId.value));
        Packet request = this.rc.protocolHandler.toPacket(dataBuilder.build(), null);
        CloseSequenceResponseData responseData = this.rc.protocolHandler.toCloseSequenceResponseData(this.verifyResponse(this.rc.communicator.send(request), "CloseSequence", Level.WARNING));
        this.rc.destinationMessageHandler.processAcknowledgements(responseData.getAcknowledgementData());
        if (!((String)this.outboundSequenceId.value).equals(responseData.getSequenceId())) {
            LOGGER.warning(LocalizationMessages.WSRM_1119_UNEXPECTED_SEQUENCE_ID_IN_CLOSE_SR(responseData.getSequenceId(), this.outboundSequenceId));
        }
        String boundSequenceId = this.rc.getBoundSequenceId((String)this.outboundSequenceId.value);
        try {
            this.rc.sequenceManager().closeSequence((String)this.outboundSequenceId.value);
        }
        finally {
            if (boundSequenceId != null) {
                this.rc.sequenceManager().closeSequence(boundSequenceId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void terminateSequence() {
        TerminateSequenceData.Builder dataBuilder = TerminateSequenceData.getBuilder((String)this.outboundSequenceId.value, this.rc.sequenceManager().getSequence((String)this.outboundSequenceId.value).getLastMessageNumber());
        dataBuilder.acknowledgementData(this.rc.sourceMessageHandler.getAcknowledgementData((String)this.outboundSequenceId.value));
        Packet request = this.rc.protocolHandler.toPacket(dataBuilder.build(), null);
        Packet response = this.verifyResponse(this.rc.communicator.send(request), "TerminateSequence", Level.FINE);
        if (response.getMessage() != null) {
            String responseAction = this.rc.communicator.getWsaAction(response);
            if (this.rc.rmVersion.terminateSequenceAction.equals(responseAction)) {
                TerminateSequenceData responseData = this.rc.protocolHandler.toTerminateSequenceData(response);
                this.rc.destinationMessageHandler.processAcknowledgements(responseData.getAcknowledgementData());
                String boundSequenceId = this.rc.getBoundSequenceId((String)this.outboundSequenceId.value);
                if (!this.areEqual(boundSequenceId, responseData.getSequenceId())) {
                    LOGGER.warning(LocalizationMessages.WSRM_1117_UNEXPECTED_SEQUENCE_ID_IN_TERMINATE_SR(responseData.getSequenceId(), boundSequenceId));
                }
            } else if (this.rc.rmVersion.terminateSequenceResponseAction.equals(responseAction)) {
                TerminateSequenceResponseData responseData = this.rc.protocolHandler.toTerminateSequenceResponseData(response);
                this.rc.destinationMessageHandler.processAcknowledgements(responseData.getAcknowledgementData());
                if (!((String)this.outboundSequenceId.value).equals(responseData.getSequenceId())) {
                    LOGGER.warning(LocalizationMessages.WSRM_1117_UNEXPECTED_SEQUENCE_ID_IN_TERMINATE_SR(responseData.getSequenceId(), this.outboundSequenceId.value));
                }
            }
        }
        String boundSequenceId = this.rc.getBoundSequenceId((String)this.outboundSequenceId.value);
        try {
            this.rc.sequenceManager().terminateSequence((String)this.outboundSequenceId.value);
        }
        finally {
            if (boundSequenceId != null) {
                this.rc.sequenceManager().terminateSequence(boundSequenceId);
            }
        }
    }

    private boolean areEqual(String s1, String s2) {
        if (s1 == null) {
            return s2 == null;
        }
        return s1.equals(s2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForMissingAcknowledgements(final String sequenceId, long timeoutInMillis) {
        final CountDownLatch doneSignal = new CountDownLatch(1);
        ScheduledFuture<?> taskHandle = this.rc.scheduledTaskManager.startTask(new Runnable(){

            public void run() {
                try {
                    if (!ClientTube.this.rc.sequenceManager().getSequence(sequenceId).hasUnacknowledgedMessages()) {
                        doneSignal.countDown();
                    }
                }
                catch (UnknownSequenceException ex) {
                    LOGGER.severe(LocalizationMessages.WSRM_1111_WAITING_FOR_SEQ_ACKS_UNEXPECTED_EXCEPTION(sequenceId), (Throwable)((Object)ex));
                    doneSignal.countDown();
                }
            }
        }, 10L, 10L);
        try {
            if (timeoutInMillis > 0L) {
                boolean waitResult = doneSignal.await(timeoutInMillis, TimeUnit.MILLISECONDS);
                if (!waitResult) {
                    LOGGER.info(LocalizationMessages.WSRM_1112_WAITING_FOR_SEQ_ACKS_TIMED_OUT(sequenceId, timeoutInMillis));
                }
            } else {
                doneSignal.await();
            }
        }
        catch (InterruptedException ex) {
            LOGGER.fine(LocalizationMessages.WSRM_1113_WAITING_FOR_SEQ_ACKS_INTERRUPTED(sequenceId), (Throwable)ex);
        }
        finally {
            taskHandle.cancel(true);
        }
    }

    private Packet verifyResponse(Packet response, String requestId, Level logLevel) throws RxRuntimeException {
        if (response == null || response.getMessage() == null) {
            String logMessage = LocalizationMessages.WSRM_1114_NULL_RESPONSE_ON_PROTOCOL_MESSAGE_REQUEST(requestId);
            if (logLevel == Level.SEVERE) {
                throw (RxRuntimeException)((Object)LOGGER.logSevereException((Throwable)((Object)new RxRuntimeException(logMessage))));
            }
            LOGGER.log(logLevel, logMessage);
        } else if (response.getMessage().isFault()) {
            String logMessage = LocalizationMessages.WSRM_1115_PROTOCOL_MESSAGE_REQUEST_REFUSED(requestId);
            if (logLevel == Level.SEVERE) {
                throw (RxRuntimeException)((Object)LOGGER.logSevereException((Throwable)((Object)new RxRuntimeException(logMessage))));
            }
            LOGGER.log(logLevel, logMessage);
        }
        return response;
    }
}

