/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc;

import com.sun.messaging.jmq.jmsserver.persist.jdbc.BaseDAOImpl;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.ConfigRecordDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBManager;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.Util;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

class ConfigRecordDAOImpl
extends BaseDAOImpl
implements ConfigRecordDAO {
    protected String tableName;
    protected String insertSQL;
    protected String selectRecordsSinceSQL;
    protected String selectAllSQL;

    ConfigRecordDAOImpl() throws BrokerException {
        DBManager dBManager = DBManager.getDBManager();
        this.tableName = dBManager.getTableName("MQCREC41");
        this.insertSQL = new StringBuffer(128).append("INSERT INTO ").append(this.tableName).append(" ( ").append("RECORD").append(", ").append("CREATED_TS").append(") VALUES ( ?, ? )").toString();
        this.selectRecordsSinceSQL = new StringBuffer(128).append("SELECT ").append("RECORD").append(", ").append("CREATED_TS").append(" FROM ").append(this.tableName).append(" WHERE ").append("CREATED_TS").append(" > ?").toString();
        this.selectAllSQL = new StringBuffer(128).append("SELECT ").append("RECORD").append(", ").append("CREATED_TS").append(" FROM ").append(this.tableName).toString();
    }

    public final String getTableNamePrefix() {
        return "MQCREC41";
    }

    public final String getTableName() {
        return this.tableName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void insert(Connection connection, byte[] byArray, long l) throws BrokerException {
        PreparedStatement preparedStatement;
        block12: {
            boolean bl = false;
            preparedStatement = null;
            try {
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.insertSQL);
                    Util.setBytes(preparedStatement, 1, byArray);
                    preparedStatement.setLong(2, l);
                    preparedStatement.executeUpdate();
                }
                catch (Exception exception) {
                    Exception exception2;
                    try {
                        if (connection != null && !connection.getAutoCommit()) {
                            connection.rollback();
                        }
                    }
                    catch (SQLException sQLException) {
                        this.logger.log(32, "B4080", (Throwable)sQLException);
                    }
                    if (exception instanceof BrokerException) {
                        throw (BrokerException)exception;
                    }
                    if (exception instanceof SQLException) {
                        exception2 = DBManager.wrapSQLException("[" + this.insertSQL + "]", (SQLException)exception);
                        throw new BrokerException(this.br.getKString("B4083", String.valueOf(l)), exception2);
                    }
                    exception2 = exception;
                    throw new BrokerException(this.br.getKString("B4083", String.valueOf(l)), exception2);
                }
                Object var10_6 = null;
                if (!bl) break block12;
            }
            catch (Throwable throwable) {
                Object var10_7 = null;
                if (bl) {
                    Util.close(null, preparedStatement, connection);
                    throw throwable;
                }
                Util.close(null, preparedStatement, null);
                throw throwable;
            }
            Util.close(null, preparedStatement, connection);
            return;
        }
        Util.close(null, preparedStatement, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List getRecordsSince(Connection connection, long l) throws BrokerException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        ArrayList<byte[]> arrayList;
        block12: {
            arrayList = new ArrayList<byte[]>();
            boolean bl = false;
            preparedStatement = null;
            resultSet = null;
            try {
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectRecordsSinceSQL);
                    preparedStatement.setLong(1, l);
                    resultSet = preparedStatement.executeQuery();
                    while (resultSet.next()) {
                        try {
                            byte[] byArray = Util.readBytes(resultSet, 1);
                            arrayList.add(byArray);
                        }
                        catch (IOException iOException) {
                            IOException iOException2 = DBManager.wrapIOException("[" + this.selectRecordsSinceSQL + "]", iOException);
                            this.logger.logStack(32, "B4123", (Object)resultSet.getString(2), (Throwable)iOException2);
                        }
                    }
                    Object var11_12 = null;
                    if (!bl) break block12;
                }
                catch (Exception exception) {
                    Exception exception2;
                    if (exception instanceof BrokerException) {
                        throw (BrokerException)exception;
                    }
                    if (exception instanceof SQLException) {
                        exception2 = DBManager.wrapSQLException("[" + this.selectRecordsSinceSQL + "]", (SQLException)exception);
                        throw new BrokerException(this.br.getKString("B4082"), exception2);
                    }
                    exception2 = exception;
                    throw new BrokerException(this.br.getKString("B4082"), exception2);
                }
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                if (bl) {
                    Util.close(resultSet, preparedStatement, connection);
                    throw throwable;
                }
                Util.close(resultSet, preparedStatement, null);
                throw throwable;
            }
            Util.close(resultSet, preparedStatement, connection);
            return arrayList;
        }
        Util.close(resultSet, preparedStatement, null);
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object[] getAllRecords(Connection connection) throws BrokerException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        Object[] objectArray;
        block12: {
            ArrayList<Long> arrayList = new ArrayList<Long>();
            ArrayList<byte[]> arrayList2 = new ArrayList<byte[]>();
            objectArray = new Object[]{arrayList, arrayList2};
            boolean bl = false;
            preparedStatement = null;
            resultSet = null;
            try {
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectAllSQL);
                    resultSet = preparedStatement.executeQuery();
                    while (resultSet.next()) {
                        long l = -1L;
                        try {
                            l = resultSet.getLong(2);
                            arrayList.add(new Long(l));
                            byte[] byArray = Util.readBytes(resultSet, 1);
                            arrayList2.add(byArray);
                        }
                        catch (IOException iOException) {
                            IOException iOException2 = DBManager.wrapIOException("[" + this.selectAllSQL + "]", iOException);
                            this.logger.logStack(32, "B4123", (Object)String.valueOf(l), (Throwable)iOException2);
                        }
                    }
                    Object var13_13 = null;
                    if (!bl) break block12;
                }
                catch (Exception exception) {
                    Exception exception2;
                    if (exception instanceof BrokerException) {
                        throw (BrokerException)exception;
                    }
                    if (exception instanceof SQLException) {
                        exception2 = DBManager.wrapSQLException("[" + this.selectAllSQL + "]", (SQLException)exception);
                        throw new BrokerException(this.br.getKString("B4082"), exception2);
                    }
                    exception2 = exception;
                    throw new BrokerException(this.br.getKString("B4082"), exception2);
                }
            }
            catch (Throwable throwable) {
                Object var13_14 = null;
                if (bl) {
                    Util.close(resultSet, preparedStatement, connection);
                    throw throwable;
                }
                Util.close(resultSet, preparedStatement, null);
                throw throwable;
            }
            Util.close(resultSet, preparedStatement, connection);
            return objectArray;
        }
        Util.close(resultSet, preparedStatement, null);
        return objectArray;
    }

    public HashMap getDebugInfo(Connection connection) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n = -1;
        try {
            n = this.getRowCount(null, null);
        }
        catch (Exception exception) {
            this.logger.log(32, exception.getMessage(), exception.getCause());
        }
        hashMap.put("Config Change Records(" + this.tableName + ")", String.valueOf(n));
        return hashMap;
    }
}

