/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.gloomhavenhelper;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.ButtonGroup;
import com.badlogic.gdx.scenes.scene2d.ui.ImageButton;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.esotericsoftware.gloomhavenhelper.App;
import com.esotericsoftware.gloomhavenhelper.MonsterBox;
import com.esotericsoftware.gloomhavenhelper.PlayerRow;
import com.esotericsoftware.gloomhavenhelper.model.SummonColor;
import com.esotericsoftware.gloomhavenhelper.util.Menu;
import com.esotericsoftware.gloomhavenhelper.util.builders.ImageButtonBuilder;
import com.esotericsoftware.gloomhavenhelper.util.builders.TextButtonBuilder;

public class SummonAddMenu
extends Menu {
    public SummonAddMenu(final PlayerRow row) {
        this.defaults().size(100.0f);
        final ButtonGroup<ImageButton> colorButtons = new ButtonGroup<ImageButton>();
        int i = 0;
        SummonColor[] summonColorArray = SummonColor.values;
        int n = SummonColor.values.length;
        int n2 = 0;
        while (n2 < n) {
            SummonColor color = summonColorArray[n2];
            ++i;
            if (color != SummonColor.beast) {
                ImageButton button = ((ImageButtonBuilder)((ImageButtonBuilder)App.imageButton().imageUp(color.drawable).over("selected", App.buttonGray)).checked("selected")).create();
                this.add(button);
                colorButtons.add(button);
                if (colorButtons.getButtons().size == 4) {
                    this.row();
                }
            }
            ++n2;
        }
        this.row();
        i = 1;
        while (i <= 4) {
            Button button = ((TextButtonBuilder)((TextButtonBuilder)App.textButton(String.valueOf(i)).over("selected", App.buttonGray)).disabled("white", Color.CLEAR)).create();
            final int number = i++;
            button.addListener(new ClickListener(){

                @Override
                public void clicked(InputEvent event, float x, float y) {
                    SummonAddMenu.this.hide();
                    SummonColor color = SummonColor.values[((Actor)colorButtons.getChecked()).getZIndex() + 1];
                    MonsterBox box = row.addMonsterBox(number, App.summonData, row.player.level, false, color, false);
                    box.monster.hp = 2;
                    box.monster.hpMax = 2;
                    box.showMenu();
                    box.menu.levelButton.setProgrammaticChangeEvents(true);
                    box.menu.levelButton.toggle();
                    box.menu.levelButton.setProgrammaticChangeEvents(false);
                    App.state.changed();
                }
            });
            this.add(button);
        }
    }
}

