/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.gloomhavenhelper;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.PolygonSpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.CheckBox;
import com.badlogic.gdx.scenes.scene2d.ui.Container;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextField;
import com.badlogic.gdx.scenes.scene2d.ui.TextTooltip;
import com.badlogic.gdx.scenes.scene2d.ui.TooltipManager;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.IntMap;
import com.badlogic.gdx.utils.JsonReader;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.JsonWriter;
import com.badlogic.gdx.utils.ObjectSet;
import com.badlogic.gdx.utils.OrderedMap;
import com.badlogic.gdx.utils.Scaling;
import com.badlogic.gdx.utils.viewport.ExtendViewport;
import com.badlogic.gdx.utils.viewport.ScreenViewport;
import com.esotericsoftware.gloomhavenhelper.Edition;
import com.esotericsoftware.gloomhavenhelper.Game;
import com.esotericsoftware.gloomhavenhelper.GameConfig;
import com.esotericsoftware.gloomhavenhelper.GameState;
import com.esotericsoftware.gloomhavenhelper.GloomhavenHelper;
import com.esotericsoftware.gloomhavenhelper.Text;
import com.esotericsoftware.gloomhavenhelper.model.AttackModifier;
import com.esotericsoftware.gloomhavenhelper.model.CharacterClass;
import com.esotericsoftware.gloomhavenhelper.model.Condition;
import com.esotericsoftware.gloomhavenhelper.model.Line;
import com.esotericsoftware.gloomhavenhelper.model.MonsterAbility;
import com.esotericsoftware.gloomhavenhelper.model.MonsterAbilityDeck;
import com.esotericsoftware.gloomhavenhelper.model.MonsterData;
import com.esotericsoftware.gloomhavenhelper.model.MonsterStats;
import com.esotericsoftware.gloomhavenhelper.model.MonsterType;
import com.esotericsoftware.gloomhavenhelper.model.Scenario;
import com.esotericsoftware.gloomhavenhelper.model.SummonColor;
import com.esotericsoftware.gloomhavenhelper.util.CompositeDrawable;
import com.esotericsoftware.gloomhavenhelper.util.FontWrapping;
import com.esotericsoftware.gloomhavenhelper.util.Row;
import com.esotericsoftware.gloomhavenhelper.util.Shaders;
import com.esotericsoftware.gloomhavenhelper.util.builders.CheckBoxBuilder;
import com.esotericsoftware.gloomhavenhelper.util.builders.ImageButtonBuilder;
import com.esotericsoftware.gloomhavenhelper.util.builders.ImageTextButtonBuilder;
import com.esotericsoftware.gloomhavenhelper.util.builders.TextButtonBuilder;
import com.esotericsoftware.spine.AnimationStateData;
import com.esotericsoftware.spine.SkeletonData;
import com.esotericsoftware.spine.SkeletonJson;
import com.esotericsoftware.spine.SkeletonRenderer;
import com.esotericsoftware.spine.utils.SkeletonActorPool;

public class App {
    public static final String version = "8.3.6";
    public static final String majorMinor;
    public static final boolean eclipse;
    public static final GloomhavenHelper gloom;
    public static Game game;
    public static String[] args;
    public static GameConfig config;
    public static GameState state;
    public static Object gameThread;
    public static final IntMap<MonsterAbilityDeck> monsterAbilityDecks;
    public static final OrderedMap<String, MonsterData> nameToMonsterData;
    public static final Array<MonsterData> monsterDatas;
    public static MonsterData summonData;
    public static MonsterStats summonStats;
    public static final Array<MonsterAbility> monsterAbilities;
    public static final Array<Scenario> scenarios;
    public static final Array<Scenario> sections;
    public static BitmapFont fancyExtraLargeOutlineNumbers;
    public static BitmapFont fancyLargeOutline;
    public static BitmapFont fancyLargeOutlineFixedNumbers;
    public static BitmapFont plainExtraLargeNumbers;
    public static BitmapFont plainExtraLargeOutlineNumbers;
    public static BitmapFont plainLargeOutline;
    public static BitmapFont plainLargeFixedNumbers;
    public static BitmapFont plainLargeOutlineFixedNumbers;
    public static BitmapFont plainMedium;
    public static BitmapFont plainMediumOutline;
    public static BitmapFont plainMediumOutlineFixedNumbers;
    public static BitmapFont plainSmall;
    public static BitmapFont plainSmallOutline;
    public static Skin skin;
    public static TextureAtlas atlas;
    public static Stage stage;
    public static Table root;
    public static ExtendViewport viewport;
    public static SkeletonRenderer skeletonRenderer;
    static SkeletonActorPool rippleSkeletonPool;
    public static SkeletonData elementsSkeletonData;
    public static SkeletonData esotericSkeletonData;
    public static final Vector2 v2;
    public static final Vector3 v3;
    public static final Color c;
    public static final Color buttonGray;
    public static final Color disabledGray;
    public static final Color lightGray;
    public static final Color gray;
    public static final Color disabledDim;
    public static final Color healthGreen;
    public static final Color healthRed;
    public static final Color bossRed;
    public static final Color eliteGold;
    public static final Color xpBlue;
    public static final Color lootGold;
    public static final Color darken;
    public static final Color textSelect;
    public static final Color tooltips;
    public static final float monsterStatsDim = 0.4f;
    public static boolean dragging;
    public static Row dragRow;
    public static Row lastSwapRow;
    public static final Vector2 dragStart;
    public static ShaderProgram desatShader;
    public static final Array<Texture> textures;
    static int animateNumber;

    static {
        int first = version.indexOf(46);
        int last = version.lastIndexOf(46);
        majorMinor = first != -1 && first != last ? version.substring(0, last) : version;
        eclipse = "true".equals(System.getProperty("eclipse"));
        gloom = new GloomhavenHelper();
        monsterAbilityDecks = new IntMap(64);
        nameToMonsterData = new OrderedMap(64);
        monsterDatas = new Array(64);
        monsterAbilities = new Array(512);
        scenarios = new Array(100);
        sections = new Array(100);
        v2 = new Vector2();
        v3 = new Vector3();
        c = new Color();
        buttonGray = new Color(-1936945921);
        disabledGray = new Color(0x4C4C4CFF);
        lightGray = new Color(-976894465);
        gray = new Color(0x6C6C6CFF);
        disabledDim = new Color(1.0f, 1.0f, 1.0f, 0.4f);
        healthGreen = new Color(0x7FFF00FF);
        healthRed = new Color(-164416001);
        bossRed = new Color(-164416001);
        eliteGold = new Color(-4777985);
        xpBlue = new Color(746955007);
        lootGold = new Color(-963698689);
        darken = new Color(-370873665);
        textSelect = new Color(613154695);
        tooltips = new Color(0.0f, 0.0f, 0.0f, 0.75f);
        dragStart = new Vector2();
        textures = new Array();
    }

    public static void load() {
        Gdx.graphics.setContinuousRendering(false);
        TooltipManager.getInstance().initialTime = 0.8f;
        TooltipManager.getInstance().hideAll();
        atlas = App.loadAtlas();
        fancyExtraLargeOutlineNumbers = App.loadFont("fancyExtraLargeOutlineNumbers", -52, null);
        fancyLargeOutline = App.loadFont("fancyLargeOutline", -46, null);
        fancyLargeOutlineFixedNumbers = App.loadFont("fancyLargeOutline", -46, "0123456789_");
        plainExtraLargeNumbers = App.loadFont("plainExtraLargeNumbers", -46, null);
        plainExtraLargeOutlineNumbers = App.loadFont("plainExtraLargeOutlineNumbers", -46, "0123456789+-");
        plainLargeOutline = App.loadFont("plainLargeOutline", -35, null);
        plainLargeOutlineFixedNumbers = App.loadFont("plainLargeOutline", -32, "0123456789-+/");
        plainLargeFixedNumbers = App.loadFont("plainLargeNumbers", -35, "0123456789-+/");
        plainMedium = App.loadFont("plainMedium", -27, null);
        plainMediumOutline = App.loadFont("plainMediumOutline", -27, null);
        plainMediumOutlineFixedNumbers = App.loadFont("plainMediumOutline", -27, "0123456789-+/");
        plainSmall = App.loadFont("plainSmall", -20, null);
        plainSmallOutline = App.loadFont("plainSmallOutline", -20, null);
        skin = new Skin();
        skin.add("default", plainLargeOutline);
        skin.add("fancyExtraLargeOutlineNumbers", fancyExtraLargeOutlineNumbers);
        skin.add("fancyLargeOutline", fancyLargeOutline);
        skin.add("fancyLargeOutlineFixedNumbers", fancyLargeOutlineFixedNumbers);
        skin.add("plainExtraLargeNumbers", plainExtraLargeNumbers);
        skin.add("plainExtraLargeOutlineNumbers", plainExtraLargeOutlineNumbers);
        skin.add("plainLargeOutline", plainLargeOutline);
        skin.add("plainLargeOutlineFixedNumbers", plainLargeOutlineFixedNumbers);
        skin.add("plainMediumOutline", plainMediumOutline);
        skin.add("plainMediumOutlineFixedNumbers", plainMediumOutlineFixedNumbers);
        skin.add("plainSmallOutline", plainSmallOutline);
        skin.addRegions(atlas);
        Enum[] enumArray = Condition.values;
        int n = Condition.values.length;
        int n2 = 0;
        while (n2 < n) {
            Condition condition = enumArray[n2];
            condition.drawable = skin.getDrawable("conditions/" + condition.name());
            if (condition != Condition.summonNew && condition != Condition.summon && condition != Condition.star && condition != Condition.invisible && condition != Condition.doom) {
                condition.drawableMedium = skin.getDrawable("abilities/" + condition.name() + "-medium");
            }
            ++n2;
        }
        enumArray = SummonColor.values;
        n = SummonColor.values.length;
        n2 = 0;
        while (n2 < n) {
            Enum color = enumArray[n2];
            ((SummonColor)color).drawable = skin.getDrawable("summon/" + color.name());
            ++n2;
        }
        stage = new Stage(new ScreenViewport(), new PolygonSpriteBatch()){

            @Override
            public boolean touchDown(int screenX, int screenY, int pointer, int button) {
                this.setKeyboardFocus(null);
                Gdx.input.setOnscreenKeyboardVisible(false);
                return super.touchDown(screenX, screenY, pointer, button);
            }
        };
        viewport = new ExtendViewport(1113.0f, 800.0f, 2.1474836E9f, 2.1474836E9f, stage.getCamera());
        stage.setViewport(viewport);
        skeletonRenderer = new SkeletonRenderer();
        SkeletonJson json = new SkeletonJson(atlas);
        elementsSkeletonData = json.readSkeletonData(App.file("skeletons/elements.json"));
        esotericSkeletonData = json.readSkeletonData(App.file("skeletons/esoteric.json"));
        SkeletonData rippleData = json.readSkeletonData(App.file("skeletons/ripple.json"));
        rippleData.getBones().first().setScale(1.3f, 1.3f);
        rippleSkeletonPool = new SkeletonActorPool(skeletonRenderer, rippleData, new AnimationStateData(rippleData));
        desatShader = Shaders.desat();
        App.loadData();
    }

    public static FileHandle file(String path) {
        if (eclipse) {
            return Gdx.files.absolute("../ghh-core/assets/" + path);
        }
        return Gdx.files.internal(path);
    }

    public static TextureAtlas loadAtlas() {
        FileHandle atlasPath = App.file("skin.atlas");
        game.packAtlas();
        try {
            TextureAtlas atlas = new TextureAtlas(atlasPath);
            ((ObjectSet.ObjectSetIterator)atlas.getTextures().iterator()).toArray(textures);
            return atlas;
        }
        catch (Throwable ex) {
            String message = ex.getMessage();
            if (message != null && (message.contains("Unable to allocate memory") || message.contains("Out of memory"))) {
                game.oom();
            }
            throw new RuntimeException("Unable to load texture atlas.", ex);
        }
    }

    public static BitmapFont loadFont(String name, int down, String fixed) {
        String subdir = App.config.language;
        if (subdir.equals("pl") || subdir.equals("de")) {
            subdir = "en";
        }
        String dir = "fonts/" + subdir + "/";
        FileHandle file = App.file(String.valueOf(dir) + name + ".fnt");
        BitmapFont.BitmapFontData data = App.config.language.equals("ko") ? new BitmapFont.BitmapFontData(file, false){

            @Override
            public int getWrapIndex(Array<BitmapFont.Glyph> glyphs, int start) {
                return FontWrapping.Korean.getWrapIndex(glyphs, start);
            }
        } : new BitmapFont.BitmapFontData(file, false);
        BitmapFont font = new BitmapFont(data, (TextureRegion)atlas.findRegion(String.valueOf(dir) + name), true);
        font.setUseIntegerPositions(true);
        font.getData().breakChars = new char[]{'-'};
        font.getData().down = down;
        if (fixed != null) {
            font.setFixedWidthGlyphs(fixed);
        }
        return font;
    }

    public static void main(String[] args) throws Exception {
        JsonValue root = new JsonReader().parse(new FileHandle("C:/Users/Nate/Desktop/json_data_new.json"));
        JsonValue.PrettyPrintSettings s = new JsonValue.PrettyPrintSettings();
        s.outputType = JsonWriter.OutputType.javascript;
        s.singleLineColumns = 130;
        s.wrapNumericArrays = false;
        new FileHandle("C:/Dev/projects/ghh/ghh-core/assets/data.json").writeString(root.prettyPrint(s), false);
    }

    /*
     * WARNING - void declaration
     */
    private static void loadData() {
        String file = "data-" + App.config.language + ".json";
        JsonValue root = new JsonReader().parse(App.file(file));
        Text.loadText(root.get("text"));
        CharacterClass.loadText(root.get("classes"));
        Line.loadTokens(root.get("tokens"));
        JsonValue deckEntry = root.getChild("monsterAbilities");
        while (deckEntry != null) {
            MonsterAbilityDeck deck = new MonsterAbilityDeck();
            deck.name = deckEntry.getString("name");
            monsterAbilityDecks.put(deck.id, deck);
            deck.edition = Edition.valueOf(deckEntry.getString("edition", Edition.OG.name()));
            JsonValue cardEntry = deckEntry.get((String)"cards").child;
            while (cardEntry != null) {
                MonsterAbility monsterAbility = new MonsterAbility();
                monsterAbility.deck = deck;
                monsterAbility.number = cardEntry.getString(0);
                monsterAbility.shuffle = cardEntry.getBoolean(1);
                monsterAbility.initiative = cardEntry.getInt(2);
                monsterAbility.initiativeString = Integer.toString(monsterAbility.initiative);
                deck.abilities.add(monsterAbility);
                Object lineEntry = cardEntry.get(3);
                while (lineEntry != null) {
                    monsterAbility.text.add(((JsonValue)lineEntry).asString());
                    lineEntry = ((JsonValue)lineEntry).next;
                }
                monsterAbilities.add(monsterAbility);
                cardEntry = cardEntry.next;
            }
            deckEntry = deckEntry.next;
        }
        JsonValue monsterEntry = root.getChild("monsters");
        while (monsterEntry != null) {
            MonsterData data = new MonsterData();
            data.name = monsterEntry.name;
            data.english = monsterEntry.getString("english", data.name);
            data.display = monsterEntry.getString("display", data.name);
            data.count = monsterEntry.getInt("count");
            data.edition = Edition.valueOf(monsterEntry.getString("edition", Edition.OG.name()));
            data.hidden = monsterEntry.getBoolean("hidden", false);
            String deckName = monsterEntry.getString("deck");
            for (IntMap.Entry<MonsterAbilityDeck> entry : monsterAbilityDecks.entries()) {
                if (!((MonsterAbilityDeck)entry.value).name.equals(deckName)) continue;
                data.deckID = entry.key;
                break;
            }
            if (data.deckID == -1) {
                throw new RuntimeException("Deck not found: " + deckName);
            }
            data.flying = monsterEntry.getBoolean("flying", false);
            nameToMonsterData.put(data.name, data);
            monsterDatas.add(data);
            boolean bl = false;
            JsonValue levelEntry = monsterEntry.getChild("levels");
            while (levelEntry != null) {
                void var5_9;
                if (levelEntry.has("normal") && levelEntry.has("elite")) {
                    data.stats[MonsterType.normal.ordinal()][var5_9] = App.readStats(levelEntry.get("normal"), data, false);
                    data.stats[MonsterType.elite.ordinal()][var5_9] = App.readStats(levelEntry.get("elite"), data, true);
                } else {
                    data.stats[MonsterType.boss.ordinal()][var5_9] = App.readStats(levelEntry, data, false);
                }
                levelEntry = levelEntry.next;
                ++var5_9;
            }
            monsterEntry = monsterEntry.next;
        }
        MonsterAbilityDeck summonDeck = new MonsterAbilityDeck();
        summonDeck.name = "Summon";
        monsterAbilityDecks.put(summonDeck.id, summonDeck);
        summonData = new MonsterData();
        App.summonData.edition = Edition.OG;
        App.summonData.name = "Summon";
        App.summonData.count = 6;
        App.summonData.deckID = summonDeck.id;
        nameToMonsterData.put(App.summonData.name, summonData);
        monsterDatas.add(summonData);
        summonStats = new MonsterStats();
        App.summonStats.hpMax = "2";
        App.summonStats.move = "2";
        App.summonStats.attack = "2";
        App.summonStats.range = "2";
        App.loadScenarios(root.getChild("scenarios"), scenarios);
        App.loadScenarios(root.getChild("sections"), sections);
    }

    private static void loadScenarios(JsonValue scenarioEntry, Array<Scenario> array) {
        while (scenarioEntry != null) {
            Scenario scenario = new Scenario();
            scenario.name = scenarioEntry.name;
            scenario.edition = Edition.valueOf(scenarioEntry.getString("edition", Edition.OG.name()));
            JsonValue monsterEntry = scenarioEntry.getChild("monsters");
            while (monsterEntry != null) {
                scenario.monsters.add(App.findMonsterData(monsterEntry.asString()));
                monsterEntry = monsterEntry.next;
            }
            JsonValue specialEntry = scenarioEntry.getChild("special");
            while (specialEntry != null) {
                scenario.special.add(specialEntry.asString());
                specialEntry = specialEntry.next;
            }
            array.add(scenario);
            scenarioEntry = scenarioEntry.next;
        }
    }

    private static MonsterStats readStats(JsonValue statsEntry, MonsterData data, boolean elite) {
        MonsterStats stats = new MonsterStats();
        stats.hpMax = statsEntry.getString("health");
        stats.move = statsEntry.getString("move");
        stats.attack = statsEntry.getString("attack");
        stats.range = statsEntry.getString("range", "-");
        stats.notesText = statsEntry.getString("notes", "");
        JsonValue entry = statsEntry.getChild("immunities");
        while (entry != null) {
            String name = entry.asString().replaceAll("%", "");
            if (name.equals("curse")) {
                stats.immuneCurse = true;
            } else if (name.equals("push")) {
                stats.immunePush = true;
            } else if (name.equals("pull")) {
                stats.immunePull = true;
            } else {
                stats.immunities.add(Condition.valueOf(name));
            }
            entry = entry.next;
        }
        entry = statsEntry.getChild("attributes");
        while (entry != null) {
            stats.attributeText.add(entry.asString());
            entry = entry.next;
        }
        entry = statsEntry.getChild("special1");
        while (entry != null) {
            stats.specialText1.add(entry.asString());
            entry = entry.next;
        }
        entry = statsEntry.getChild("special2");
        while (entry != null) {
            stats.specialText2.add(entry.asString());
            entry = entry.next;
        }
        return stats;
    }

    public static MonsterAbilityDeck findMonsterAbilityDeck(int deckID) {
        MonsterAbilityDeck deck = monsterAbilityDecks.get(deckID);
        if (deck == null) {
            throw new RuntimeException();
        }
        return deck;
    }

    public static MonsterData findMonsterData(String name) {
        MonsterData data = (MonsterData)nameToMonsterData.get(name);
        if (data == null) {
            throw new RuntimeException("Monster not found: " + name);
        }
        return data;
    }

    public static Texture texture(String path) {
        Texture texture = new Texture(App.file(path));
        textures.add(texture);
        return texture;
    }

    public static void setAttackCards(AttackModifier attackModifier1, AttackModifier attackModifier2) {
        if (attackModifier1 == null) {
            App.gloom.attackImage1.setDrawable(null);
        } else {
            App.gloom.attackImage1.setDrawable(App.drawable("attack/" + attackModifier1, "attack/border"));
        }
        if (attackModifier2 == null) {
            App.gloom.attackImage2.setDrawable(null);
        } else {
            App.gloom.attackImage2.setDrawable(App.drawable("attack/" + attackModifier2, "attack/border"));
        }
        ++animateNumber;
    }

    public static void animateAttackCard(AttackModifier attackModifier1, AttackModifier attackModifier2, AttackModifier attackModifier3) {
        if (attackModifier2 == null) {
            App.gloom.attackImage1.setDrawable(null);
        } else {
            App.gloom.attackImage1.setDrawable(App.drawable("attack/" + attackModifier2, "attack/border"));
        }
        if (attackModifier3 == null) {
            App.gloom.attackImage2.setDrawable(null);
        } else {
            App.gloom.attackImage2.setDrawable(App.drawable("attack/" + attackModifier3, "attack/border"));
        }
        App.animateAttackCard(attackModifier1, App.gloom.attackButton, App.gloom.attackImage1, App.gloom.attackImage2);
    }

    public static void animateAttackCard(AttackModifier attackModifier, Button attackButton, final Image attackImage1, final Image attackImage2) {
        float showTime = 0.6f;
        float flipTime = 0.3f;
        float pauseTime = 0.2f;
        float halfFlipTime = flipTime / 2.0f;
        float finishTime = 0.4f;
        final Image darken = new Image(skin.newDrawable("white", new Color(0.0f, 0.0f, 0.0f, 0.4f)));
        darken.setFillParent(true);
        stage.addActor(darken);
        darken.getColor().a = 0.0f;
        darken.addAction(Actions.fadeIn(flipTime, Interpolation.fastSlow));
        final Image card = new Image(App.drawable("attack/back", "attack/border"));
        Vector2 start = attackButton.localToStageCoordinates(new Vector2(-139.5f, -94.0f));
        card.setScale(0.36155605f);
        card.setOrigin(218.5f, 148.0f);
        card.setPosition(Math.round(start.x), Math.round(start.y));
        stage.addActor(card);
        Vector2 end = attackImage1.localToStageCoordinates(new Vector2(-139.5f, -94.0f));
        final Drawable drawable = App.drawable("attack/" + attackModifier, "attack/border");
        final int startNumber = ++animateNumber;
        card.addAction(Actions.parallel((Action)Actions.moveTo(Math.round(viewport.getWorldWidth() / 2.0f - 218.5f), Math.round(viewport.getWorldHeight() / 2.0f - 148.0f), showTime - 0.05f, Interpolation.fastSlow), (Action)Actions.rotateTo(180.0f, showTime, Interpolation.fastSlow), (Action)Actions.scaleTo(1.75f, 1.75f, showTime - flipTime, Interpolation.fastSlow), (Action)Actions.sequence(Actions.delay(showTime - flipTime), Actions.scaleTo(1.25f, 0.0f, halfFlipTime, Interpolation.slowFast), Actions.parallel((Action)Actions.scaleTo(1.0f, 1.0f, halfFlipTime, Interpolation.fastSlow), new Action(){

            @Override
            public boolean act(float delta) {
                card.setDrawable(new CompositeDrawable(new Drawable[]{drawable}){

                    @Override
                    public void draw(Batch batch, float x, float y, float originX, float originY, float width, float height, float scaleX, float scaleY, float rotation) {
                        super.draw(batch, x, y, originX, originY, width, height, scaleX, scaleY, rotation + 180.0f);
                    }
                });
                return true;
            }
        }), Actions.delay(pauseTime), new Action(){

            @Override
            public boolean act(float delta) {
                if (animateNumber != startNumber) {
                    darken.remove();
                    card.remove();
                    return true;
                }
                darken.setTouchable(Touchable.disabled);
                darken.addAction(Actions.sequence((Action)Actions.fadeOut(0.4f, Interpolation.slowFast), (Action)Actions.removeActor()));
                Vector2 end = attackImage2.localToAscendantCoordinates(attackImage1.getParent(), new Vector2(0.0f, 0.0f));
                attackImage1.clearActions();
                attackImage1.addAction(Actions.sequence((Action)Actions.parallel((Action)Actions.moveTo(end.x, end.y, 0.4f, Interpolation.fastSlow), (Action)Actions.rotateTo(-31.5f, 0.4f, Interpolation.fastSlow)), new Action(){

                    @Override
                    public boolean act(float delta) {
                        attackImage2.setDrawable(attackImage1.getDrawable());
                        attackImage1.setDrawable(drawable);
                        attackImage1.setRotation(0.0f);
                        ((Table)attackImage1.getParent()).invalidate();
                        return true;
                    }
                }));
                return true;
            }
        }, Actions.parallel((Action)Actions.moveTo(Math.round(end.x), Math.round(end.y), 0.4f, Interpolation.slowFast), (Action)Actions.scaleTo(0.36155605f, 0.36155605f, 0.4f, Interpolation.slowFast)), Actions.removeActor())));
    }

    public static Drawable drawable(String ... names) {
        if (names.length == 1) {
            return skin.getDrawable(names[0]);
        }
        Drawable[] drawables = new Drawable[names.length];
        int i = 0;
        int n = names.length;
        while (i < n) {
            drawables[i] = skin.getDrawable(names[i]);
            ++i;
        }
        return new CompositeDrawable(drawables);
    }

    public static Drawable drawable(String name, Color color) {
        return skin.newDrawable(name, color);
    }

    public static Color c(Color color, float a) {
        c.set(color.r, color.g, color.b, a);
        return c;
    }

    public static Color c(float r, float g, float b, float a) {
        return c.set(r, g, b, a);
    }

    public static Color c(int rgba, float a) {
        c.set(rgba);
        App.c.a = a;
        return c;
    }

    public static void animate(Vector2 current, Vector2 target, float minSpeed, float maxSpeed, float distanceForMaxSpeed, float delta) {
        if (Float.isNaN(target.x)) {
            target.x = 0.0f;
        }
        if (Float.isNaN(target.y)) {
            target.y = 0.0f;
        }
        if (current.x == target.x && current.y == target.y) {
            return;
        }
        float diffX = target.x - current.x;
        float diffY = target.y - current.y;
        float slope = diffX == 0.0f || diffY == 0.0f ? 1.0f : diffY / diffX;
        float px = MathUtils.clamp(Math.abs(diffX / slope) / distanceForMaxSpeed, 0.0f, 1.0f);
        float py = MathUtils.clamp(Math.abs(diffY * slope) / distanceForMaxSpeed, 0.0f, 1.0f);
        float speedX = Interpolation.slowFast.apply(minSpeed, maxSpeed, px) * delta;
        float speedY = Interpolation.slowFast.apply(minSpeed, maxSpeed, py) * delta;
        current.x = diffX > 0.0f ? Math.min(target.x, current.x + speedX) : Math.max(target.x, current.x - speedX);
        current.y = diffY > 0.0f ? Math.min(target.y, current.y + speedY) : Math.max(target.y, current.y - speedY);
        Gdx.graphics.requestRendering();
    }

    public static float animate(float current, float target, float minSpeed, float maxSpeed, float distanceForMaxSpeed, float delta) {
        if (Float.isNaN(target)) {
            target = 0.0f;
        }
        if (current == target) {
            return current;
        }
        Gdx.graphics.requestRendering();
        float speed = Interpolation.slowFast.apply(minSpeed, maxSpeed, MathUtils.clamp(Math.abs(target - current) / distanceForMaxSpeed, 0.0f, 1.0f)) * delta;
        if (current < target) {
            return Math.min(target, current + speed);
        }
        return Math.max(target, current - speed);
    }

    public static ImageButtonBuilder imageButton() {
        return (ImageButtonBuilder)new ImageButtonBuilder().programmaticChangeEvents(false);
    }

    public static ImageTextButtonBuilder imageTextButton(String text) {
        return ((ImageTextButtonBuilder)new ImageTextButtonBuilder().programmaticChangeEvents(false)).font("fancyLargeOutline").fontColor(buttonGray).overFontColor(Color.WHITE).disabledFontColor(disabledGray).text(text);
    }

    public static TextButtonBuilder<?, ?> textButton(String text) {
        return ((TextButtonBuilder)((TextButtonBuilder)((TextButtonBuilder)((TextButtonBuilder)((TextButtonBuilder)new TextButtonBuilder().programmaticChangeEvents(false)).font("fancyLargeOutline")).fontColor(buttonGray)).overFontColor(Color.WHITE)).disabledFontColor(disabledGray)).text(text);
    }

    public static CheckBox checkbox(String text) {
        CheckBox checkbox = ((CheckBoxBuilder)((CheckBoxBuilder)((CheckBoxBuilder)((CheckBoxBuilder)((CheckBoxBuilder)((CheckBoxBuilder)((CheckBoxBuilder)new CheckBoxBuilder().checkboxOff("checkbox", buttonGray).checkboxOver("checkbox").checkboxOn("checkbox-checked").checkboxOnOver("checkbox-checked-over").checkboxOffDisabled("checkbox", disabledGray).checkboxOnDisabled("checkbox-checked-over", disabledGray).font("fancyLargeOutline")).fontColor(buttonGray)).disabledFontColor(disabledGray)).overFontColor(Color.WHITE)).text(text)).programmaticChangeEvents(false)).tapSquareSize(28)).create();
        checkbox.getLabelCell().padLeft(12.0f).left().expandX();
        return checkbox;
    }

    public static CheckBox radio(String text) {
        CheckBox radio = ((CheckBoxBuilder)((CheckBoxBuilder)((CheckBoxBuilder)((CheckBoxBuilder)((CheckBoxBuilder)((CheckBoxBuilder)new CheckBoxBuilder().checkboxOff("radio", buttonGray).checkboxOver("radio").checkboxOn("radio-checked").checkboxOnOver("radio-checked-over").font("fancyLargeOutline")).fontColor(buttonGray)).overFontColor(Color.WHITE)).text(text)).programmaticChangeEvents(false)).tapSquareSize(28)).create();
        radio.getLabelCell().padLeft(12.0f).left().expandX();
        return radio;
    }

    public static TextField textField(String text) {
        TextField.TextFieldStyle style = new TextField.TextFieldStyle();
        style.font = plainLargeOutline;
        style.fontColor = buttonGray;
        style.background = App.drawable("textfield");
        style.cursor = App.drawable("textfield-cursor", new Color(App.textSelect.r, App.textSelect.g, App.textSelect.b, 1.0f));
        style.selection = App.drawable("textfield-cursor", textSelect);
        TextField textField = new TextField(text, style);
        textField.setProgrammaticChangeEvents(false);
        return textField;
    }

    public static Image image(Drawable drawable) {
        Image image = new Image(drawable);
        image.setScaling(Scaling.none);
        return image;
    }

    public static Image image(String name) {
        return App.image(skin.getDrawable(name));
    }

    public static Image image(String name, Color color) {
        return App.image(skin.newDrawable(name, color));
    }

    public static TextTooltip tooltip(String text) {
        TextTooltip.TextTooltipStyle style = new TextTooltip.TextTooltipStyle();
        style.background = App.drawable("rounded", tooltips);
        style.wrapWidth = 700.0f;
        style.label = new Label.LabelStyle();
        style.label.font = plainLargeOutline;
        style.label.fontColor = Color.WHITE;
        return new TextTooltip(text, style);
    }

    public static void finishActions(Actor actor) {
        while (true) {
            Array<Action> actions = actor.getActions();
            if (actions.size == 0) break;
            actor.act(99.0f);
        }
    }

    public static AttackModifier readAttackModifier(byte b) {
        if (b == 0) {
            return null;
        }
        return AttackModifier.values[b - 1];
    }

    public static void gameThread() {
    }

    public static void toast(String text) {
        App.gameThread();
        Label label = new Label((CharSequence)text, skin, "fancyLargeOutline", Color.WHITE);
        Container<Label> container = new Container<Label>(label);
        container.setTouchable(Touchable.disabled);
        container.setBackground(App.drawable("rounded", new Color(0.0f, 0.0f, 0.0f, 0.6f)));
        container.pad(5.0f, 14.0f, 5.0f, 14.0f);
        container.pack();
        container.setX(Math.round(stage.getWidth() / 2.0f - container.getWidth() / 2.0f));
        container.setY(Math.round(stage.getHeight() / 4.0f));
        container.setTransform(true);
        container.getColor().a = 0.0f;
        container.setScale(3.0f);
        container.setOrigin(container.getWidth() / 2.0f, container.getHeight() / 2.0f);
        container.addAction(Actions.sequence((Action)Actions.parallel((Action)Actions.fadeIn(0.3f, Interpolation.fastSlow), (Action)Actions.scaleTo(1.0f, 1.0f, 0.3f, Interpolation.fastSlow)), (Action)Actions.delay(5.0f), (Action)Actions.parallel((Action)Actions.moveBy(0.0f, 150.0f, 0.8f, Interpolation.slowFast), (Action)Actions.fadeOut(0.8f, Interpolation.slowFast), (Action)Actions.scaleTo(0.5f, 0.5f, 0.8f, Interpolation.slowFast)), (Action)Actions.removeActor()));
        for (Actor other : App.gloom.toasts.getChildren()) {
            other.addAction(Actions.moveBy(0.0f, 60.0f, 0.25f));
        }
        App.gloom.toasts.addActor(container);
    }

    public static void sleep(int millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static int parseInt(String value) {
        if (value == null) {
            throw new IllegalArgumentException("value cannot be null.");
        }
        if (value.length() == 0) {
            throw new NumberFormatException("Empty string.");
        }
        if (value.charAt(0) == '+') {
            value = value.substring(1);
        }
        return Integer.parseInt(value);
    }
}

