/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.DataInput;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.IntArray;
import com.badlogic.gdx.utils.SerializationException;
import com.esotericsoftware.spine.Animation;
import com.esotericsoftware.spine.BlendMode;
import com.esotericsoftware.spine.BoneData;
import com.esotericsoftware.spine.Event;
import com.esotericsoftware.spine.EventData;
import com.esotericsoftware.spine.IkConstraintData;
import com.esotericsoftware.spine.PathConstraintData;
import com.esotericsoftware.spine.SkeletonData;
import com.esotericsoftware.spine.SkeletonJson;
import com.esotericsoftware.spine.Skin;
import com.esotericsoftware.spine.SlotData;
import com.esotericsoftware.spine.TransformConstraintData;
import com.esotericsoftware.spine.attachments.AtlasAttachmentLoader;
import com.esotericsoftware.spine.attachments.Attachment;
import com.esotericsoftware.spine.attachments.AttachmentLoader;
import com.esotericsoftware.spine.attachments.AttachmentType;
import com.esotericsoftware.spine.attachments.BoundingBoxAttachment;
import com.esotericsoftware.spine.attachments.ClippingAttachment;
import com.esotericsoftware.spine.attachments.MeshAttachment;
import com.esotericsoftware.spine.attachments.PathAttachment;
import com.esotericsoftware.spine.attachments.PointAttachment;
import com.esotericsoftware.spine.attachments.RegionAttachment;
import com.esotericsoftware.spine.attachments.VertexAttachment;
import java.io.EOFException;
import java.io.IOException;

public class SkeletonBinary {
    public static final int BONE_ROTATE = 0;
    public static final int BONE_TRANSLATE = 1;
    public static final int BONE_SCALE = 2;
    public static final int BONE_SHEAR = 3;
    public static final int SLOT_ATTACHMENT = 0;
    public static final int SLOT_COLOR = 1;
    public static final int SLOT_TWO_COLOR = 2;
    public static final int PATH_POSITION = 0;
    public static final int PATH_SPACING = 1;
    public static final int PATH_MIX = 2;
    public static final int CURVE_LINEAR = 0;
    public static final int CURVE_STEPPED = 1;
    public static final int CURVE_BEZIER = 2;
    private static final Color tempColor1 = new Color();
    private static final Color tempColor2 = new Color();
    private final AttachmentLoader attachmentLoader;
    private float scale = 1.0f;
    private Array<SkeletonJson.LinkedMesh> linkedMeshes = new Array();

    public SkeletonBinary(TextureAtlas atlas) {
        this.attachmentLoader = new AtlasAttachmentLoader(atlas);
    }

    public SkeletonBinary(AttachmentLoader attachmentLoader) {
        if (attachmentLoader == null) {
            throw new IllegalArgumentException("attachmentLoader cannot be null.");
        }
        this.attachmentLoader = attachmentLoader;
    }

    public float getScale() {
        return this.scale;
    }

    public void setScale(float scale) {
        if (scale == 0.0f) {
            throw new IllegalArgumentException("scale cannot be 0.");
        }
        this.scale = scale;
    }

    public SkeletonData readSkeletonData(FileHandle file) {
        if (file == null) {
            throw new IllegalArgumentException("file cannot be null.");
        }
        float scale = this.scale;
        SkeletonData skeletonData = new SkeletonData();
        skeletonData.name = file.nameWithoutExtension();
        SkeletonInput input = new SkeletonInput(file);
        try {
            try {
                int ii;
                BoneData[] bones;
                Object data;
                Object data2;
                skeletonData.hash = input.readString();
                if (skeletonData.hash.isEmpty()) {
                    skeletonData.hash = null;
                }
                skeletonData.version = input.readString();
                if (skeletonData.version.isEmpty()) {
                    skeletonData.version = null;
                }
                if ("3.8.75".equals(skeletonData.version)) {
                    throw new RuntimeException("Unsupported skeleton data, please export with a newer version of Spine.");
                }
                skeletonData.x = input.readFloat();
                skeletonData.y = input.readFloat();
                skeletonData.width = input.readFloat();
                skeletonData.height = input.readFloat();
                boolean nonessential = input.readBoolean();
                if (nonessential) {
                    skeletonData.fps = input.readFloat();
                    skeletonData.imagesPath = input.readString();
                    if (skeletonData.imagesPath.isEmpty()) {
                        skeletonData.imagesPath = null;
                    }
                    skeletonData.audioPath = input.readString();
                    if (skeletonData.audioPath.isEmpty()) {
                        skeletonData.audioPath = null;
                    }
                }
                int n = input.readInt(true);
                input.strings = new Array(n);
                Object[] o = input.strings.setSize(n);
                int i = 0;
                while (i < n) {
                    o[i] = input.readString();
                    ++i;
                }
                n = input.readInt(true);
                o = skeletonData.bones.setSize(n);
                i = 0;
                while (i < n) {
                    String name = input.readString();
                    BoneData parent = i == 0 ? null : skeletonData.bones.get(input.readInt(true));
                    data2 = new BoneData(i, name, parent);
                    ((BoneData)data2).rotation = input.readFloat();
                    ((BoneData)data2).x = input.readFloat() * scale;
                    ((BoneData)data2).y = input.readFloat() * scale;
                    ((BoneData)data2).scaleX = input.readFloat();
                    ((BoneData)data2).scaleY = input.readFloat();
                    ((BoneData)data2).shearX = input.readFloat();
                    ((BoneData)data2).shearY = input.readFloat();
                    ((BoneData)data2).length = input.readFloat() * scale;
                    ((BoneData)data2).transformMode = BoneData.TransformMode.values[input.readInt(true)];
                    ((BoneData)data2).skinRequired = input.readBoolean();
                    if (nonessential) {
                        Color.rgba8888ToColor(((BoneData)data2).color, input.readInt());
                    }
                    o[i] = data2;
                    ++i;
                }
                n = input.readInt(true);
                o = skeletonData.slots.setSize(n);
                i = 0;
                while (i < n) {
                    String slotName = input.readString();
                    BoneData boneData = skeletonData.bones.get(input.readInt(true));
                    data2 = new SlotData(i, slotName, boneData);
                    Color.rgba8888ToColor(((SlotData)data2).color, input.readInt());
                    int darkColor = input.readInt();
                    if (darkColor != -1) {
                        ((SlotData)data2).darkColor = new Color();
                        Color.rgb888ToColor(((SlotData)data2).darkColor, darkColor);
                    }
                    ((SlotData)data2).attachmentName = input.readStringRef();
                    ((SlotData)data2).blendMode = BlendMode.values[input.readInt(true)];
                    o[i] = data2;
                    ++i;
                }
                n = input.readInt(true);
                o = skeletonData.ikConstraints.setSize(n);
                i = 0;
                while (i < n) {
                    data = new IkConstraintData(input.readString());
                    ((IkConstraintData)data).order = input.readInt(true);
                    ((IkConstraintData)data).skinRequired = input.readBoolean();
                    int nn = input.readInt(true);
                    bones = ((IkConstraintData)data).bones.setSize(nn);
                    ii = 0;
                    while (ii < nn) {
                        bones[ii] = skeletonData.bones.get(input.readInt(true));
                        ++ii;
                    }
                    ((IkConstraintData)data).target = skeletonData.bones.get(input.readInt(true));
                    ((IkConstraintData)data).mix = input.readFloat();
                    ((IkConstraintData)data).softness = input.readFloat() * scale;
                    ((IkConstraintData)data).bendDirection = input.readByte();
                    ((IkConstraintData)data).compress = input.readBoolean();
                    ((IkConstraintData)data).stretch = input.readBoolean();
                    ((IkConstraintData)data).uniform = input.readBoolean();
                    o[i] = data;
                    ++i;
                }
                n = input.readInt(true);
                o = skeletonData.transformConstraints.setSize(n);
                i = 0;
                while (i < n) {
                    data = new TransformConstraintData(input.readString());
                    ((TransformConstraintData)data).order = input.readInt(true);
                    ((TransformConstraintData)data).skinRequired = input.readBoolean();
                    int nn = input.readInt(true);
                    bones = ((TransformConstraintData)data).bones.setSize(nn);
                    ii = 0;
                    while (ii < nn) {
                        bones[ii] = skeletonData.bones.get(input.readInt(true));
                        ++ii;
                    }
                    ((TransformConstraintData)data).target = skeletonData.bones.get(input.readInt(true));
                    ((TransformConstraintData)data).local = input.readBoolean();
                    ((TransformConstraintData)data).relative = input.readBoolean();
                    ((TransformConstraintData)data).offsetRotation = input.readFloat();
                    ((TransformConstraintData)data).offsetX = input.readFloat() * scale;
                    ((TransformConstraintData)data).offsetY = input.readFloat() * scale;
                    ((TransformConstraintData)data).offsetScaleX = input.readFloat();
                    ((TransformConstraintData)data).offsetScaleY = input.readFloat();
                    ((TransformConstraintData)data).offsetShearY = input.readFloat();
                    ((TransformConstraintData)data).rotateMix = input.readFloat();
                    ((TransformConstraintData)data).translateMix = input.readFloat();
                    ((TransformConstraintData)data).scaleMix = input.readFloat();
                    ((TransformConstraintData)data).shearMix = input.readFloat();
                    o[i] = data;
                    ++i;
                }
                n = input.readInt(true);
                o = skeletonData.pathConstraints.setSize(n);
                i = 0;
                while (i < n) {
                    data = new PathConstraintData(input.readString());
                    ((PathConstraintData)data).order = input.readInt(true);
                    ((PathConstraintData)data).skinRequired = input.readBoolean();
                    int nn = input.readInt(true);
                    bones = ((PathConstraintData)data).bones.setSize(nn);
                    ii = 0;
                    while (ii < nn) {
                        bones[ii] = skeletonData.bones.get(input.readInt(true));
                        ++ii;
                    }
                    ((PathConstraintData)data).target = skeletonData.slots.get(input.readInt(true));
                    ((PathConstraintData)data).positionMode = PathConstraintData.PositionMode.values[input.readInt(true)];
                    ((PathConstraintData)data).spacingMode = PathConstraintData.SpacingMode.values[input.readInt(true)];
                    ((PathConstraintData)data).rotateMode = PathConstraintData.RotateMode.values[input.readInt(true)];
                    ((PathConstraintData)data).offsetRotation = input.readFloat();
                    ((PathConstraintData)data).position = input.readFloat();
                    if (((PathConstraintData)data).positionMode == PathConstraintData.PositionMode.fixed) {
                        ((PathConstraintData)data).position *= scale;
                    }
                    ((PathConstraintData)data).spacing = input.readFloat();
                    if (((PathConstraintData)data).spacingMode == PathConstraintData.SpacingMode.length || ((PathConstraintData)data).spacingMode == PathConstraintData.SpacingMode.fixed) {
                        ((PathConstraintData)data).spacing *= scale;
                    }
                    ((PathConstraintData)data).rotateMix = input.readFloat();
                    ((PathConstraintData)data).translateMix = input.readFloat();
                    o[i] = data;
                    ++i;
                }
                Skin defaultSkin = this.readSkin(input, skeletonData, true, nonessential);
                if (defaultSkin != null) {
                    skeletonData.defaultSkin = defaultSkin;
                    skeletonData.skins.add(defaultSkin);
                }
                int i2 = skeletonData.skins.size;
                n = i2 + input.readInt(true);
                o = skeletonData.skins.setSize(n);
                while (i2 < n) {
                    o[i2] = this.readSkin(input, skeletonData, false, nonessential);
                    ++i2;
                }
                n = this.linkedMeshes.size;
                i2 = 0;
                while (i2 < n) {
                    Skin skin;
                    SkeletonJson.LinkedMesh linkedMesh = this.linkedMeshes.get(i2);
                    Skin skin2 = skin = linkedMesh.skin == null ? skeletonData.getDefaultSkin() : skeletonData.findSkin(linkedMesh.skin);
                    if (skin == null) {
                        throw new SerializationException("Skin not found: " + linkedMesh.skin);
                    }
                    Attachment parent = skin.getAttachment(linkedMesh.slotIndex, linkedMesh.parent);
                    if (parent == null) {
                        throw new SerializationException("Parent mesh not found: " + linkedMesh.parent);
                    }
                    linkedMesh.mesh.setDeformAttachment(linkedMesh.inheritDeform ? (VertexAttachment)parent : linkedMesh.mesh);
                    linkedMesh.mesh.setParentMesh((MeshAttachment)parent);
                    linkedMesh.mesh.updateUVs();
                    ++i2;
                }
                this.linkedMeshes.clear();
                n = input.readInt(true);
                o = skeletonData.events.setSize(n);
                i2 = 0;
                while (i2 < n) {
                    data = new EventData(input.readStringRef());
                    ((EventData)data).intValue = input.readInt(false);
                    ((EventData)data).floatValue = input.readFloat();
                    ((EventData)data).stringValue = input.readString();
                    ((EventData)data).audioPath = input.readString();
                    if (((EventData)data).audioPath != null) {
                        ((EventData)data).volume = input.readFloat();
                        ((EventData)data).balance = input.readFloat();
                    }
                    o[i2] = data;
                    ++i2;
                }
                n = input.readInt(true);
                o = skeletonData.animations.setSize(n);
                i2 = 0;
                while (i2 < n) {
                    o[i2] = this.readAnimation(input, input.readString(), skeletonData);
                    ++i2;
                }
            }
            catch (IOException ex) {
                throw new SerializationException("Error reading skeleton file.", ex);
            }
        }
        finally {
            try {
                input.close();
            }
            catch (IOException iOException) {}
        }
        return skeletonData;
    }

    private Skin readSkin(SkeletonInput input, SkeletonData skeletonData, boolean defaultSkin, boolean nonessential) throws IOException {
        Skin skin;
        int slotCount;
        if (defaultSkin) {
            slotCount = input.readInt(true);
            if (slotCount == 0) {
                return null;
            }
            skin = new Skin("default");
        } else {
            skin = new Skin(input.readStringRef());
            BoneData[] bones = skin.bones.setSize(input.readInt(true));
            int i = 0;
            int n = skin.bones.size;
            while (i < n) {
                bones[i] = skeletonData.bones.get(input.readInt(true));
                ++i;
            }
            i = 0;
            n = input.readInt(true);
            while (i < n) {
                skin.constraints.add(skeletonData.ikConstraints.get(input.readInt(true)));
                ++i;
            }
            i = 0;
            n = input.readInt(true);
            while (i < n) {
                skin.constraints.add(skeletonData.transformConstraints.get(input.readInt(true)));
                ++i;
            }
            i = 0;
            n = input.readInt(true);
            while (i < n) {
                skin.constraints.add(skeletonData.pathConstraints.get(input.readInt(true)));
                ++i;
            }
            skin.constraints.shrink();
            slotCount = input.readInt(true);
        }
        int i = 0;
        while (i < slotCount) {
            int slotIndex = input.readInt(true);
            int ii = 0;
            int nn = input.readInt(true);
            while (ii < nn) {
                String name = input.readStringRef();
                Attachment attachment = this.readAttachment(input, skeletonData, skin, slotIndex, name, nonessential);
                if (attachment != null) {
                    skin.setAttachment(slotIndex, name, attachment);
                }
                ++ii;
            }
            ++i;
        }
        return skin;
    }

    private Attachment readAttachment(SkeletonInput input, SkeletonData skeletonData, Skin skin, int slotIndex, String attachmentName, boolean nonessential) throws IOException {
        float scale = this.scale;
        String name = input.readStringRef();
        if (name == null) {
            name = attachmentName;
        }
        AttachmentType type = AttachmentType.values[input.readByte()];
        switch (type) {
            case region: {
                RegionAttachment region;
                String path = input.readStringRef();
                float rotation = input.readFloat();
                float x = input.readFloat();
                float y = input.readFloat();
                float scaleX = input.readFloat();
                float scaleY = input.readFloat();
                float width = input.readFloat();
                float height = input.readFloat();
                int color = input.readInt();
                if (path == null) {
                    path = name;
                }
                if ((region = this.attachmentLoader.newRegionAttachment(skin, name, path)) == null) {
                    return null;
                }
                region.setPath(path);
                region.setX(x * scale);
                region.setY(y * scale);
                region.setScaleX(scaleX);
                region.setScaleY(scaleY);
                region.setRotation(rotation);
                region.setWidth(width * scale);
                region.setHeight(height * scale);
                Color.rgba8888ToColor(region.getColor(), color);
                region.updateOffset();
                return region;
            }
            case boundingbox: {
                int vertexCount = input.readInt(true);
                Vertices vertices = this.readVertices(input, vertexCount);
                int color = nonessential ? input.readInt() : 0;
                BoundingBoxAttachment box = this.attachmentLoader.newBoundingBoxAttachment(skin, name);
                if (box == null) {
                    return null;
                }
                box.setWorldVerticesLength(vertexCount << 1);
                box.setVertices(vertices.vertices);
                box.setBones(vertices.bones);
                if (nonessential) {
                    Color.rgba8888ToColor(box.getColor(), color);
                }
                return box;
            }
            case mesh: {
                MeshAttachment mesh;
                String path = input.readStringRef();
                int color = input.readInt();
                int vertexCount = input.readInt(true);
                float[] uvs = this.readFloatArray(input, vertexCount << 1, 1.0f);
                short[] triangles = this.readShortArray(input);
                Vertices vertices = this.readVertices(input, vertexCount);
                int hullLength = input.readInt(true);
                short[] edges = null;
                float width = 0.0f;
                float height = 0.0f;
                if (nonessential) {
                    edges = this.readShortArray(input);
                    width = input.readFloat();
                    height = input.readFloat();
                }
                if (path == null) {
                    path = name;
                }
                if ((mesh = this.attachmentLoader.newMeshAttachment(skin, name, path)) == null) {
                    return null;
                }
                mesh.setPath(path);
                Color.rgba8888ToColor(mesh.getColor(), color);
                mesh.setBones(vertices.bones);
                mesh.setVertices(vertices.vertices);
                mesh.setWorldVerticesLength(vertexCount << 1);
                mesh.setTriangles(triangles);
                mesh.setRegionUVs(uvs);
                mesh.updateUVs();
                mesh.setHullLength(hullLength << 1);
                if (nonessential) {
                    mesh.setEdges(edges);
                    mesh.setWidth(width * scale);
                    mesh.setHeight(height * scale);
                }
                return mesh;
            }
            case linkedmesh: {
                MeshAttachment mesh;
                String path = input.readStringRef();
                int color = input.readInt();
                String skinName = input.readStringRef();
                String parent = input.readStringRef();
                boolean inheritDeform = input.readBoolean();
                float width = 0.0f;
                float height = 0.0f;
                if (nonessential) {
                    width = input.readFloat();
                    height = input.readFloat();
                }
                if (path == null) {
                    path = name;
                }
                if ((mesh = this.attachmentLoader.newMeshAttachment(skin, name, path)) == null) {
                    return null;
                }
                mesh.setPath(path);
                Color.rgba8888ToColor(mesh.getColor(), color);
                if (nonessential) {
                    mesh.setWidth(width * scale);
                    mesh.setHeight(height * scale);
                }
                this.linkedMeshes.add(new SkeletonJson.LinkedMesh(mesh, skinName, slotIndex, parent, inheritDeform));
                return mesh;
            }
            case path: {
                boolean closed = input.readBoolean();
                boolean constantSpeed = input.readBoolean();
                int vertexCount = input.readInt(true);
                Vertices vertices = this.readVertices(input, vertexCount);
                float[] lengths = new float[vertexCount / 3];
                int i = 0;
                int n = lengths.length;
                while (i < n) {
                    lengths[i] = input.readFloat() * scale;
                    ++i;
                }
                int color = nonessential ? input.readInt() : 0;
                PathAttachment path = this.attachmentLoader.newPathAttachment(skin, name);
                if (path == null) {
                    return null;
                }
                path.setClosed(closed);
                path.setConstantSpeed(constantSpeed);
                path.setWorldVerticesLength(vertexCount << 1);
                path.setVertices(vertices.vertices);
                path.setBones(vertices.bones);
                path.setLengths(lengths);
                if (nonessential) {
                    Color.rgba8888ToColor(path.getColor(), color);
                }
                return path;
            }
            case point: {
                float rotation = input.readFloat();
                float x = input.readFloat();
                float y = input.readFloat();
                int color = nonessential ? input.readInt() : 0;
                PointAttachment point = this.attachmentLoader.newPointAttachment(skin, name);
                if (point == null) {
                    return null;
                }
                point.setX(x * scale);
                point.setY(y * scale);
                point.setRotation(rotation);
                if (nonessential) {
                    Color.rgba8888ToColor(point.getColor(), color);
                }
                return point;
            }
            case clipping: {
                int endSlotIndex = input.readInt(true);
                int vertexCount = input.readInt(true);
                Vertices vertices = this.readVertices(input, vertexCount);
                int color = nonessential ? input.readInt() : 0;
                ClippingAttachment clip = this.attachmentLoader.newClippingAttachment(skin, name);
                if (clip == null) {
                    return null;
                }
                clip.setEndSlot(skeletonData.slots.get(endSlotIndex));
                clip.setWorldVerticesLength(vertexCount << 1);
                clip.setVertices(vertices.vertices);
                clip.setBones(vertices.bones);
                if (nonessential) {
                    Color.rgba8888ToColor(clip.getColor(), color);
                }
                return clip;
            }
        }
        return null;
    }

    private Vertices readVertices(SkeletonInput input, int vertexCount) throws IOException {
        int verticesLength = vertexCount << 1;
        Vertices vertices = new Vertices();
        if (!input.readBoolean()) {
            vertices.vertices = this.readFloatArray(input, verticesLength, this.scale);
            return vertices;
        }
        FloatArray weights = new FloatArray(verticesLength * 3 * 3);
        IntArray bonesArray = new IntArray(verticesLength * 3);
        int i = 0;
        while (i < vertexCount) {
            int boneCount = input.readInt(true);
            bonesArray.add(boneCount);
            int ii = 0;
            while (ii < boneCount) {
                bonesArray.add(input.readInt(true));
                weights.add(input.readFloat() * this.scale);
                weights.add(input.readFloat() * this.scale);
                weights.add(input.readFloat());
                ++ii;
            }
            ++i;
        }
        vertices.vertices = weights.toArray();
        vertices.bones = bonesArray.toArray();
        return vertices;
    }

    private float[] readFloatArray(SkeletonInput input, int n, float scale) throws IOException {
        float[] array = new float[n];
        if (scale == 1.0f) {
            int i = 0;
            while (i < n) {
                array[i] = input.readFloat();
                ++i;
            }
        } else {
            int i = 0;
            while (i < n) {
                array[i] = input.readFloat() * scale;
                ++i;
            }
        }
        return array;
    }

    private short[] readShortArray(SkeletonInput input) throws IOException {
        int n = input.readInt(true);
        short[] array = new short[n];
        int i = 0;
        while (i < n) {
            array[i] = input.readShort();
            ++i;
        }
        return array;
    }

    private Animation readAnimation(SkeletonInput input, String name, SkeletonData skeletonData) {
        Array<Animation.Timeline> timelines = new Array<Animation.Timeline>(32);
        float scale = this.scale;
        float duration = 0.0f;
        try {
            int eventCount;
            int frameIndex;
            int frameCount;
            int index;
            Animation.Timeline timeline;
            int frameCount2;
            byte timelineType;
            int nn;
            int ii;
            int i = 0;
            int n = input.readInt(true);
            while (i < n) {
                int slotIndex = input.readInt(true);
                ii = 0;
                nn = input.readInt(true);
                while (ii < nn) {
                    timelineType = input.readByte();
                    frameCount2 = input.readInt(true);
                    switch (timelineType) {
                        case 0: {
                            timeline = new Animation.AttachmentTimeline(frameCount2);
                            ((Animation.AttachmentTimeline)timeline).slotIndex = slotIndex;
                            int frameIndex2 = 0;
                            while (frameIndex2 < frameCount2) {
                                ((Animation.AttachmentTimeline)timeline).setFrame(frameIndex2, input.readFloat(), input.readStringRef());
                                ++frameIndex2;
                            }
                            timelines.add(timeline);
                            duration = Math.max(duration, ((Animation.AttachmentTimeline)timeline).getFrames()[frameCount2 - 1]);
                            break;
                        }
                        case 1: {
                            float time;
                            timeline = new Animation.ColorTimeline(frameCount2);
                            ((Animation.ColorTimeline)timeline).slotIndex = slotIndex;
                            int frameIndex2 = 0;
                            while (frameIndex2 < frameCount2) {
                                time = input.readFloat();
                                Color.rgba8888ToColor(tempColor1, input.readInt());
                                ((Animation.ColorTimeline)timeline).setFrame(frameIndex2, time, SkeletonBinary.tempColor1.r, SkeletonBinary.tempColor1.g, SkeletonBinary.tempColor1.b, SkeletonBinary.tempColor1.a);
                                if (frameIndex2 < frameCount2 - 1) {
                                    this.readCurve(input, frameIndex2, (Animation.CurveTimeline)timeline);
                                }
                                ++frameIndex2;
                            }
                            timelines.add(timeline);
                            duration = Math.max(duration, ((Animation.ColorTimeline)timeline).getFrames()[(frameCount2 - 1) * 5]);
                            break;
                        }
                        case 2: {
                            float time;
                            timeline = new Animation.TwoColorTimeline(frameCount2);
                            ((Animation.TwoColorTimeline)timeline).slotIndex = slotIndex;
                            int frameIndex2 = 0;
                            while (frameIndex2 < frameCount2) {
                                time = input.readFloat();
                                Color.rgba8888ToColor(tempColor1, input.readInt());
                                Color.rgb888ToColor(tempColor2, input.readInt());
                                ((Animation.TwoColorTimeline)timeline).setFrame(frameIndex2, time, SkeletonBinary.tempColor1.r, SkeletonBinary.tempColor1.g, SkeletonBinary.tempColor1.b, SkeletonBinary.tempColor1.a, SkeletonBinary.tempColor2.r, SkeletonBinary.tempColor2.g, SkeletonBinary.tempColor2.b);
                                if (frameIndex2 < frameCount2 - 1) {
                                    this.readCurve(input, frameIndex2, (Animation.CurveTimeline)timeline);
                                }
                                ++frameIndex2;
                            }
                            timelines.add(timeline);
                            duration = Math.max(duration, ((Animation.TwoColorTimeline)timeline).getFrames()[(frameCount2 - 1) * 8]);
                        }
                    }
                    ++ii;
                }
                ++i;
            }
            i = 0;
            n = input.readInt(true);
            while (i < n) {
                int boneIndex = input.readInt(true);
                ii = 0;
                nn = input.readInt(true);
                while (ii < nn) {
                    timelineType = input.readByte();
                    frameCount2 = input.readInt(true);
                    switch (timelineType) {
                        case 0: {
                            timeline = new Animation.RotateTimeline(frameCount2);
                            ((Animation.RotateTimeline)timeline).boneIndex = boneIndex;
                            int frameIndex3 = 0;
                            while (frameIndex3 < frameCount2) {
                                ((Animation.RotateTimeline)timeline).setFrame(frameIndex3, input.readFloat(), input.readFloat());
                                if (frameIndex3 < frameCount2 - 1) {
                                    this.readCurve(input, frameIndex3, (Animation.CurveTimeline)timeline);
                                }
                                ++frameIndex3;
                            }
                            timelines.add(timeline);
                            duration = Math.max(duration, ((Animation.RotateTimeline)timeline).getFrames()[(frameCount2 - 1) * 2]);
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: {
                            float timelineScale = 1.0f;
                            if (timelineType == 2) {
                                timeline = new Animation.ScaleTimeline(frameCount2);
                            } else if (timelineType == 3) {
                                timeline = new Animation.ShearTimeline(frameCount2);
                            } else {
                                timeline = new Animation.TranslateTimeline(frameCount2);
                                timelineScale = scale;
                            }
                            ((Animation.TranslateTimeline)timeline).boneIndex = boneIndex;
                            int frameIndex4 = 0;
                            while (frameIndex4 < frameCount2) {
                                ((Animation.TranslateTimeline)timeline).setFrame(frameIndex4, input.readFloat(), input.readFloat() * timelineScale, input.readFloat() * timelineScale);
                                if (frameIndex4 < frameCount2 - 1) {
                                    this.readCurve(input, frameIndex4, (Animation.CurveTimeline)timeline);
                                }
                                ++frameIndex4;
                            }
                            timelines.add(timeline);
                            duration = Math.max(duration, ((Animation.TranslateTimeline)timeline).getFrames()[(frameCount2 - 1) * 3]);
                        }
                    }
                    ++ii;
                }
                ++i;
            }
            i = 0;
            n = input.readInt(true);
            while (i < n) {
                index = input.readInt(true);
                frameCount = input.readInt(true);
                Animation.IkConstraintTimeline timeline2 = new Animation.IkConstraintTimeline(frameCount);
                timeline2.ikConstraintIndex = index;
                frameIndex = 0;
                while (frameIndex < frameCount) {
                    timeline2.setFrame(frameIndex, input.readFloat(), input.readFloat(), input.readFloat() * scale, input.readByte(), input.readBoolean(), input.readBoolean());
                    if (frameIndex < frameCount - 1) {
                        this.readCurve(input, frameIndex, timeline2);
                    }
                    ++frameIndex;
                }
                timelines.add(timeline2);
                duration = Math.max(duration, timeline2.getFrames()[(frameCount - 1) * 6]);
                ++i;
            }
            i = 0;
            n = input.readInt(true);
            while (i < n) {
                index = input.readInt(true);
                frameCount = input.readInt(true);
                Animation.TransformConstraintTimeline timeline3 = new Animation.TransformConstraintTimeline(frameCount);
                timeline3.transformConstraintIndex = index;
                frameIndex = 0;
                while (frameIndex < frameCount) {
                    timeline3.setFrame(frameIndex, input.readFloat(), input.readFloat(), input.readFloat(), input.readFloat(), input.readFloat());
                    if (frameIndex < frameCount - 1) {
                        this.readCurve(input, frameIndex, timeline3);
                    }
                    ++frameIndex;
                }
                timelines.add(timeline3);
                duration = Math.max(duration, timeline3.getFrames()[(frameCount - 1) * 5]);
                ++i;
            }
            i = 0;
            n = input.readInt(true);
            while (i < n) {
                index = input.readInt(true);
                PathConstraintData data = skeletonData.pathConstraints.get(index);
                int ii2 = 0;
                int nn2 = input.readInt(true);
                while (ii2 < nn2) {
                    byte timelineType2 = input.readByte();
                    int frameCount3 = input.readInt(true);
                    switch (timelineType2) {
                        case 0: 
                        case 1: {
                            Animation.CurveTimeline timeline4;
                            float timelineScale = 1.0f;
                            if (timelineType2 == 1) {
                                timeline4 = new Animation.PathConstraintSpacingTimeline(frameCount3);
                                if (data.spacingMode == PathConstraintData.SpacingMode.length || data.spacingMode == PathConstraintData.SpacingMode.fixed) {
                                    timelineScale = scale;
                                }
                            } else {
                                timeline4 = new Animation.PathConstraintPositionTimeline(frameCount3);
                                if (data.positionMode == PathConstraintData.PositionMode.fixed) {
                                    timelineScale = scale;
                                }
                            }
                            ((Animation.PathConstraintPositionTimeline)timeline4).pathConstraintIndex = index;
                            int frameIndex5 = 0;
                            while (frameIndex5 < frameCount3) {
                                ((Animation.PathConstraintPositionTimeline)timeline4).setFrame(frameIndex5, input.readFloat(), input.readFloat() * timelineScale);
                                if (frameIndex5 < frameCount3 - 1) {
                                    this.readCurve(input, frameIndex5, timeline4);
                                }
                                ++frameIndex5;
                            }
                            timelines.add(timeline4);
                            duration = Math.max(duration, ((Animation.PathConstraintPositionTimeline)timeline4).getFrames()[(frameCount3 - 1) * 2]);
                            break;
                        }
                        case 2: {
                            Animation.CurveTimeline timeline4 = new Animation.PathConstraintMixTimeline(frameCount3);
                            ((Animation.PathConstraintMixTimeline)timeline4).pathConstraintIndex = index;
                            int frameIndex6 = 0;
                            while (frameIndex6 < frameCount3) {
                                ((Animation.PathConstraintMixTimeline)timeline4).setFrame(frameIndex6, input.readFloat(), input.readFloat(), input.readFloat());
                                if (frameIndex6 < frameCount3 - 1) {
                                    this.readCurve(input, frameIndex6, timeline4);
                                }
                                ++frameIndex6;
                            }
                            timelines.add(timeline4);
                            duration = Math.max(duration, ((Animation.PathConstraintMixTimeline)timeline4).getFrames()[(frameCount3 - 1) * 3]);
                        }
                    }
                    ++ii2;
                }
                ++i;
            }
            i = 0;
            n = input.readInt(true);
            while (i < n) {
                Skin skin = skeletonData.skins.get(input.readInt(true));
                int ii3 = 0;
                int nn3 = input.readInt(true);
                while (ii3 < nn3) {
                    int slotIndex = input.readInt(true);
                    int iii = 0;
                    int nnn = input.readInt(true);
                    while (iii < nnn) {
                        VertexAttachment attachment = (VertexAttachment)skin.getAttachment(slotIndex, input.readStringRef());
                        boolean weighted = attachment.getBones() != null;
                        float[] vertices = attachment.getVertices();
                        int deformLength = weighted ? vertices.length / 3 * 2 : vertices.length;
                        int frameCount4 = input.readInt(true);
                        Animation.DeformTimeline timeline5 = new Animation.DeformTimeline(frameCount4);
                        timeline5.slotIndex = slotIndex;
                        timeline5.attachment = attachment;
                        int frameIndex7 = 0;
                        while (frameIndex7 < frameCount4) {
                            float[] deform;
                            float time = input.readFloat();
                            int end = input.readInt(true);
                            if (end == 0) {
                                deform = weighted ? new float[deformLength] : vertices;
                            } else {
                                int v;
                                deform = new float[deformLength];
                                int start = input.readInt(true);
                                end += start;
                                if (scale == 1.0f) {
                                    v = start;
                                    while (v < end) {
                                        deform[v] = input.readFloat();
                                        ++v;
                                    }
                                } else {
                                    v = start;
                                    while (v < end) {
                                        deform[v] = input.readFloat() * scale;
                                        ++v;
                                    }
                                }
                                if (!weighted) {
                                    v = 0;
                                    int vn = deform.length;
                                    while (v < vn) {
                                        int n2 = v;
                                        deform[n2] = deform[n2] + vertices[v];
                                        ++v;
                                    }
                                }
                            }
                            timeline5.setFrame(frameIndex7, time, deform);
                            if (frameIndex7 < frameCount4 - 1) {
                                this.readCurve(input, frameIndex7, timeline5);
                            }
                            ++frameIndex7;
                        }
                        timelines.add(timeline5);
                        duration = Math.max(duration, timeline5.getFrames()[frameCount4 - 1]);
                        ++iii;
                    }
                    ++ii3;
                }
                ++i;
            }
            int drawOrderCount = input.readInt(true);
            if (drawOrderCount > 0) {
                Animation.DrawOrderTimeline timeline6 = new Animation.DrawOrderTimeline(drawOrderCount);
                int slotCount = skeletonData.slots.size;
                int i2 = 0;
                while (i2 < drawOrderCount) {
                    float time = input.readFloat();
                    int offsetCount = input.readInt(true);
                    int[] drawOrder = new int[slotCount];
                    int ii4 = slotCount - 1;
                    while (ii4 >= 0) {
                        drawOrder[ii4] = -1;
                        --ii4;
                    }
                    int[] unchanged = new int[slotCount - offsetCount];
                    int originalIndex = 0;
                    int unchangedIndex = 0;
                    int ii5 = 0;
                    while (ii5 < offsetCount) {
                        int slotIndex = input.readInt(true);
                        while (originalIndex != slotIndex) {
                            unchanged[unchangedIndex++] = originalIndex++;
                        }
                        drawOrder[originalIndex + input.readInt((boolean)true)] = originalIndex++;
                        ++ii5;
                    }
                    while (originalIndex < slotCount) {
                        unchanged[unchangedIndex++] = originalIndex++;
                    }
                    ii5 = slotCount - 1;
                    while (ii5 >= 0) {
                        if (drawOrder[ii5] == -1) {
                            drawOrder[ii5] = unchanged[--unchangedIndex];
                        }
                        --ii5;
                    }
                    timeline6.setFrame(i2, time, drawOrder);
                    ++i2;
                }
                timelines.add(timeline6);
                duration = Math.max(duration, timeline6.getFrames()[drawOrderCount - 1]);
            }
            if ((eventCount = input.readInt(true)) > 0) {
                Animation.EventTimeline timeline7 = new Animation.EventTimeline(eventCount);
                int i3 = 0;
                while (i3 < eventCount) {
                    float time = input.readFloat();
                    EventData eventData = skeletonData.events.get(input.readInt(true));
                    Event event = new Event(time, eventData);
                    event.intValue = input.readInt(false);
                    event.floatValue = input.readFloat();
                    String string = event.stringValue = input.readBoolean() ? input.readString() : eventData.stringValue;
                    if (event.getData().audioPath != null) {
                        event.volume = input.readFloat();
                        event.balance = input.readFloat();
                    }
                    timeline7.setFrame(i3, event);
                    ++i3;
                }
                timelines.add(timeline7);
                duration = Math.max(duration, timeline7.getFrames()[eventCount - 1]);
            }
        }
        catch (IOException ex) {
            throw new SerializationException("Error reading skeleton file.", ex);
        }
        timelines.shrink();
        return new Animation(name, timelines, duration);
    }

    private void readCurve(SkeletonInput input, int frameIndex, Animation.CurveTimeline timeline) throws IOException {
        switch (input.readByte()) {
            case 1: {
                timeline.setStepped(frameIndex);
                break;
            }
            case 2: {
                this.setCurve(timeline, frameIndex, input.readFloat(), input.readFloat(), input.readFloat(), input.readFloat());
            }
        }
    }

    void setCurve(Animation.CurveTimeline timeline, int frameIndex, float cx1, float cy1, float cx2, float cy2) {
        timeline.setCurve(frameIndex, cx1, cy1, cx2, cy2);
    }

    static class SkeletonInput
    extends DataInput {
        private char[] chars = new char[32];
        Array<String> strings;

        public SkeletonInput(FileHandle file) {
            super(file.read(512));
        }

        public String readStringRef() throws IOException {
            int index = this.readInt(true);
            return index == 0 ? null : this.strings.get(index - 1);
        }

        @Override
        public String readString() throws IOException {
            int byteCount = this.readInt(true);
            switch (byteCount) {
                case 0: {
                    return null;
                }
                case 1: {
                    return "";
                }
            }
            if (this.chars.length < --byteCount) {
                this.chars = new char[byteCount];
            }
            char[] chars = this.chars;
            int charCount = 0;
            int i = 0;
            while (i < byteCount) {
                int b = this.read();
                switch (b >> 4) {
                    case -1: {
                        throw new EOFException();
                    }
                    case 12: 
                    case 13: {
                        chars[charCount++] = (char)((b & 0x1F) << 6 | this.read() & 0x3F);
                        i += 2;
                        break;
                    }
                    case 14: {
                        chars[charCount++] = (char)((b & 0xF) << 12 | (this.read() & 0x3F) << 6 | this.read() & 0x3F);
                        i += 3;
                        break;
                    }
                    default: {
                        chars[charCount++] = (char)b;
                        ++i;
                    }
                }
            }
            return new String(chars, 0, charCount);
        }
    }

    static class Vertices {
        int[] bones;
        float[] vertices;

        Vertices() {
        }
    }
}

