/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine;

import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Null;
import com.badlogic.gdx.utils.OrderedSet;
import com.esotericsoftware.spine.BoneData;
import com.esotericsoftware.spine.ConstraintData;
import com.esotericsoftware.spine.Skeleton;
import com.esotericsoftware.spine.Slot;
import com.esotericsoftware.spine.attachments.Attachment;
import com.esotericsoftware.spine.attachments.MeshAttachment;

public class Skin {
    final String name;
    final OrderedSet<SkinEntry> attachments = new OrderedSet();
    final Array<BoneData> bones = new Array(0);
    final Array<ConstraintData> constraints = new Array(0);
    private final SkinEntry lookup = new SkinEntry(0, "", null);

    public Skin(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null.");
        }
        this.name = name;
        this.attachments.orderedItems().ordered = false;
    }

    public void setAttachment(int slotIndex, String name, Attachment attachment) {
        if (attachment == null) {
            throw new IllegalArgumentException("attachment cannot be null.");
        }
        SkinEntry entry = new SkinEntry(slotIndex, name, attachment);
        if (!this.attachments.add(entry)) {
            this.attachments.get((SkinEntry)entry).attachment = attachment;
        }
    }

    public void addSkin(Skin skin) {
        if (skin == null) {
            throw new IllegalArgumentException("skin cannot be null.");
        }
        for (BoneData boneData : skin.bones) {
            if (this.bones.contains(boneData, true)) continue;
            this.bones.add(boneData);
        }
        for (ConstraintData constraintData : skin.constraints) {
            if (this.constraints.contains(constraintData, true)) continue;
            this.constraints.add(constraintData);
        }
        for (SkinEntry skinEntry : skin.attachments.orderedItems()) {
            this.setAttachment(skinEntry.slotIndex, skinEntry.name, skinEntry.attachment);
        }
    }

    public void copySkin(Skin skin) {
        if (skin == null) {
            throw new IllegalArgumentException("skin cannot be null.");
        }
        for (BoneData boneData : skin.bones) {
            if (this.bones.contains(boneData, true)) continue;
            this.bones.add(boneData);
        }
        for (ConstraintData constraintData : skin.constraints) {
            if (this.constraints.contains(constraintData, true)) continue;
            this.constraints.add(constraintData);
        }
        for (SkinEntry skinEntry : skin.attachments.orderedItems()) {
            if (skinEntry.attachment instanceof MeshAttachment) {
                this.setAttachment(skinEntry.slotIndex, skinEntry.name, ((MeshAttachment)skinEntry.attachment).newLinkedMesh());
                continue;
            }
            this.setAttachment(skinEntry.slotIndex, skinEntry.name, skinEntry.attachment != null ? skinEntry.attachment.copy() : null);
        }
    }

    @Null
    public Attachment getAttachment(int slotIndex, String name) {
        this.lookup.set(slotIndex, name);
        SkinEntry entry = this.attachments.get(this.lookup);
        return entry != null ? entry.attachment : null;
    }

    public void removeAttachment(int slotIndex, String name) {
        this.lookup.set(slotIndex, name);
        this.attachments.remove(this.lookup);
    }

    public Array<SkinEntry> getAttachments() {
        return this.attachments.orderedItems();
    }

    public void getAttachments(int slotIndex, Array<SkinEntry> attachments) {
        if (slotIndex < 0) {
            throw new IllegalArgumentException("slotIndex must be >= 0.");
        }
        if (attachments == null) {
            throw new IllegalArgumentException("attachments cannot be null.");
        }
        for (SkinEntry entry : this.attachments.orderedItems()) {
            if (entry.slotIndex != slotIndex) continue;
            attachments.add(entry);
        }
    }

    public void clear() {
        this.attachments.clear(1024);
        this.bones.clear();
        this.constraints.clear();
    }

    public Array<BoneData> getBones() {
        return this.bones;
    }

    public Array<ConstraintData> getConstraints() {
        return this.constraints;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    void attachAll(Skeleton skeleton, Skin oldSkin) {
        T[] slots = skeleton.slots.items;
        for (SkinEntry entry : oldSkin.attachments.orderedItems()) {
            Attachment attachment;
            int slotIndex = entry.slotIndex;
            Slot slot = (Slot)slots[slotIndex];
            if (slot.attachment != entry.attachment || (attachment = this.getAttachment(slotIndex, entry.name)) == null) continue;
            slot.setAttachment(attachment);
        }
    }

    public static class SkinEntry {
        int slotIndex;
        String name;
        @Null
        Attachment attachment;
        private int hashCode;

        SkinEntry(int slotIndex, String name, @Null Attachment attachment) {
            this.set(slotIndex, name);
            this.attachment = attachment;
        }

        void set(int slotIndex, String name) {
            if (slotIndex < 0) {
                throw new IllegalArgumentException("slotIndex must be >= 0.");
            }
            if (name == null) {
                throw new IllegalArgumentException("name cannot be null.");
            }
            this.slotIndex = slotIndex;
            this.name = name;
            this.hashCode = name.hashCode() + slotIndex * 37;
        }

        public int getSlotIndex() {
            return this.slotIndex;
        }

        public String getName() {
            return this.name;
        }

        public Attachment getAttachment() {
            return this.attachment;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            SkinEntry other = (SkinEntry)object;
            if (this.slotIndex != other.slotIndex) {
                return false;
            }
            return this.name.equals(other.name);
        }

        public String toString() {
            return String.valueOf(this.slotIndex) + ":" + this.name;
        }
    }
}

