/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source;

import java.lang.ref.Reference;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.extapi.psi.StubBasedPsiElementBase;
import org.jetbrains.kotlin.com.intellij.ide.util.PsiNavigationSupport;
import org.jetbrains.kotlin.com.intellij.lang.ASTFactory;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.lang.FileASTNode;
import org.jetbrains.kotlin.com.intellij.lang.Language;
import org.jetbrains.kotlin.com.intellij.lang.LanguageParserDefinitions;
import org.jetbrains.kotlin.com.intellij.lang.ParserDefinition;
import org.jetbrains.kotlin.com.intellij.navigation.ItemPresentation;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.application.ModalityState;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.editor.Document;
import org.jetbrains.kotlin.com.intellij.openapi.fileEditor.FileDocumentManager;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProgressManager;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.ui.Queryable;
import org.jetbrains.kotlin.com.intellij.openapi.util.Factory;
import org.jetbrains.kotlin.com.intellij.openapi.util.Getter;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.openapi.util.Pair;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFileWithId;
import org.jetbrains.kotlin.com.intellij.psi.AbstractFileViewProvider;
import org.jetbrains.kotlin.com.intellij.psi.FileViewProvider;
import org.jetbrains.kotlin.com.intellij.psi.PsiDirectory;
import org.jetbrains.kotlin.com.intellij.psi.PsiDocumentManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiFileSystemItem;
import org.jetbrains.kotlin.com.intellij.psi.PsiInvalidElementAccessException;
import org.jetbrains.kotlin.com.intellij.psi.PsiLock;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiReference;
import org.jetbrains.kotlin.com.intellij.psi.ResolveState;
import org.jetbrains.kotlin.com.intellij.psi.impl.BlockSupportImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.CheckUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.DebugUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.ElementBase;
import org.jetbrains.kotlin.com.intellij.psi.impl.FreeThreadedFileViewProvider;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiDocumentManagerBase;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiFileEx;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiManagerEx;
import org.jetbrains.kotlin.com.intellij.psi.impl.ResolveScopeManager;
import org.jetbrains.kotlin.com.intellij.psi.impl.SharedPsiElementImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.file.PsiFileImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.file.impl.FileManagerImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.AstPathPsiMap;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.FileTrees;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PsiFileWithStubSupport;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.SourceTreeToPsiMap;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.StubbedSpine;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.FileContextUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.AstPath;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.ChangeUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.CompositeElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.FileElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.SharedImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeUtil;
import org.jetbrains.kotlin.com.intellij.psi.scope.PsiScopeProcessor;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.kotlin.com.intellij.psi.search.PsiElementProcessor;
import org.jetbrains.kotlin.com.intellij.psi.search.SearchScope;
import org.jetbrains.kotlin.com.intellij.psi.stubs.ObjectStubTree;
import org.jetbrains.kotlin.com.intellij.psi.stubs.PsiFileStub;
import org.jetbrains.kotlin.com.intellij.psi.stubs.PsiFileStubImpl;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubBase;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubElement;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubTree;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubTreeBuilder;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubTreeLoader;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.IFileElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.ILazyParseableElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.IStubFileElementType;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.kotlin.com.intellij.reference.SoftReference;
import org.jetbrains.kotlin.com.intellij.testFramework.ReadOnlyLightVirtualFile;
import org.jetbrains.kotlin.com.intellij.util.FileContentUtilCore;
import org.jetbrains.kotlin.com.intellij.util.Function;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;
import org.jetbrains.kotlin.com.intellij.util.PatchedWeakReference;
import org.jetbrains.kotlin.com.intellij.util.concurrency.AtomicFieldUpdater;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.text.CharArrayUtil;

public abstract class PsiFileImpl
extends ElementBase
implements Queryable,
PsiFileEx,
PsiFileWithStubSupport {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.PsiFileImpl");
    public static final String STUB_PSI_MISMATCH = "stub-psi mismatch";
    private static final AtomicFieldUpdater<PsiFileImpl, FileTrees> ourTreeUpdater = AtomicFieldUpdater.forFieldOfType(PsiFileImpl.class, FileTrees.class);
    private IElementType myElementType;
    protected IElementType myContentElementType;
    private long myModificationStamp;
    protected PsiFile myOriginalFile;
    private final FileViewProvider myViewProvider;
    private volatile FileTrees myTrees;
    private boolean myInvalidated;
    private AstPathPsiMap myRefToPsi;
    private final ThreadLocal<FileElement> myFileElementBeingLoaded;
    protected final PsiManagerEx myManager;
    public static final Key<Boolean> BUILDING_STUB = new Key("Don't use stubs mark!");
    private final PsiLock myPsiLock;
    private static final Comparator<PsiFile> FILE_BY_LANGUAGE_ID = Comparator.comparing(o -> o.getLanguage().getID());

    protected PsiFileImpl(@NotNull IElementType elementType, IElementType contentElementType, @NotNull FileViewProvider provider) {
        if (elementType == null) {
            PsiFileImpl.$$$reportNull$$$0(0);
        }
        if (provider == null) {
            PsiFileImpl.$$$reportNull$$$0(1);
        }
        this(provider);
        this.init(elementType, contentElementType);
    }

    protected PsiFileImpl(@NotNull FileViewProvider provider) {
        if (provider == null) {
            PsiFileImpl.$$$reportNull$$$0(2);
        }
        this.myTrees = FileTrees.noStub(null, this);
        this.myFileElementBeingLoaded = new ThreadLocal();
        this.myManager = (PsiManagerEx)provider.getManager();
        this.myViewProvider = provider;
        this.myRefToPsi = new AstPathPsiMap(this.getProject());
        this.myPsiLock = ((AbstractFileViewProvider)provider).getFilePsiLock();
    }

    public void setContentElementType(IElementType contentElementType) {
        LOG.assertTrue(contentElementType instanceof ILazyParseableElementType, contentElementType);
        this.myContentElementType = contentElementType;
    }

    public IElementType getContentElementType() {
        return this.myContentElementType;
    }

    protected void init(@NotNull IElementType elementType, IElementType contentElementType) {
        if (elementType == null) {
            PsiFileImpl.$$$reportNull$$$0(3);
        }
        this.myElementType = elementType;
        this.setContentElementType(contentElementType);
    }

    public TreeElement createContentLeafElement(CharSequence leafText) {
        if (this.myContentElementType instanceof ILazyParseableElementType) {
            return ASTFactory.lazy((ILazyParseableElementType)this.myContentElementType, leafText);
        }
        return ASTFactory.leaf(this.myContentElementType, leafText);
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Nullable
    public FileElement getTreeElement() {
        FileElement node = this.derefTreeElement();
        if (node != null) {
            return node;
        }
        if (!this.getViewProvider().isPhysical()) {
            return this.loadTreeElement();
        }
        return null;
    }

    protected FileElement derefTreeElement() {
        return this.myTrees.derefTreeElement();
    }

    @Override
    public VirtualFile getVirtualFile() {
        return this.getViewProvider().isEventSystemEnabled() ? this.getViewProvider().getVirtualFile() : null;
    }

    @Override
    public boolean processChildren(PsiElementProcessor<PsiFileSystemItem> processor2) {
        return true;
    }

    @Override
    public boolean isValid() {
        if (this.myManager.getProject().isDisposed()) {
            return false;
        }
        if (!this.myViewProvider.getVirtualFile().isValid()) {
            return false;
        }
        return !this.myInvalidated;
    }

    @Override
    public void markInvalidated() {
        this.myInvalidated = true;
        DebugUtil.onInvalidated(this);
    }

    @Override
    public boolean isContentsLoaded() {
        return this.derefTreeElement() != null;
    }

    protected void assertReadAccessAllowed() {
        if (this.myViewProvider.getVirtualFile() instanceof ReadOnlyLightVirtualFile) {
            return;
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private FileElement loadTreeElement() {
        this.assertReadAccessAllowed();
        FileViewProvider viewProvider = this.getViewProvider();
        if (viewProvider.isPhysical() && this.myManager.isAssertOnFileLoading(viewProvider.getVirtualFile())) {
            LOG.error("Access to tree elements not allowed in tests. path='" + viewProvider.getVirtualFile().getPresentableUrl() + "'");
        }
        FileElement treeElement = this.createFileElement(viewProvider.getContents());
        treeElement.setPsi(this);
        this.myFileElementBeingLoaded.set(treeElement);
        try {
            List<Pair<StubBasedPsiElementBase, AstPath>> bindings;
            FileTrees trees;
            FileElement savedTree;
            while ((savedTree = this.ensureTreeElement(viewProvider, treeElement, trees = this.myTrees, bindings = this.calcStubAstBindings(treeElement, trees))) == null) {
            }
            FileElement fileElement = savedTree;
            FileElement fileElement2 = fileElement;
            if (fileElement2 == null) {
                PsiFileImpl.$$$reportNull$$$0(4);
            }
            return fileElement2;
        }
        finally {
            this.myFileElementBeingLoaded.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private FileElement ensureTreeElement(@NotNull FileViewProvider viewProvider, @NotNull FileElement treeElement, @NotNull FileTrees trees, @NotNull List<Pair<StubBasedPsiElementBase, AstPath>> bindings) {
        if (viewProvider == null) {
            PsiFileImpl.$$$reportNull$$$0(5);
        }
        if (treeElement == null) {
            PsiFileImpl.$$$reportNull$$$0(6);
        }
        if (trees == null) {
            PsiFileImpl.$$$reportNull$$$0(7);
        }
        if (bindings == null) {
            PsiFileImpl.$$$reportNull$$$0(8);
        }
        PsiLock psiLock = this.myPsiLock;
        synchronized (psiLock) {
            FileElement existing = this.derefTreeElement();
            if (existing != null) {
                return existing;
            }
            if (trees != this.myTrees) {
                return null;
            }
            this.switchFromStubToAst(bindings, trees);
            this.updateTrees(trees.withAst(this.createTreeElementPointer(treeElement)));
            if (LOG.isDebugEnabled() && viewProvider.isPhysical()) {
                LOG.debug("Loaded text for file " + viewProvider.getVirtualFile().getPresentableUrl());
            }
            return treeElement;
        }
    }

    @Override
    @NotNull
    public StubbedSpine getStubbedSpine() {
        StubTree tree = this.getGreenStubTree();
        StubbedSpine stubbedSpine = tree != null ? tree.getSpine() : this.calcTreeElement().getStubbedSpine();
        if (stubbedSpine == null) {
            PsiFileImpl.$$$reportNull$$$0(9);
        }
        return stubbedSpine;
    }

    private void switchFromStubToAst(List<Pair<StubBasedPsiElementBase, AstPath>> bindings, FileTrees trees) {
        if (!bindings.isEmpty() && trees.useStrongRefs) {
            List<String> psiStrings = ContainerUtil.map(bindings, pair -> ((StubBasedPsiElementBase)pair.first).getClass().getName());
            LOG.error(this + " of " + this.getClass() + "; " + psiStrings);
        }
        for (int i = 0; i < bindings.size(); ++i) {
            Pair<StubBasedPsiElementBase, AstPath> pair2 = bindings.get(i);
            StubBasedPsiElementBase psi = (StubBasedPsiElementBase)pair2.first;
            AstPath path2 = (AstPath)pair2.second;
            path2.getNode().setPsi(psi);
            this.myRefToPsi.cachePsi(path2, psi);
            psi.setStubIndex(i + 1);
        }
        this.myRefToPsi.clearStubIndexCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Pair<StubBasedPsiElementBase, AstPath>> calcStubAstBindings(@NotNull FileElement root2, FileTrees trees) {
        StubTree stubTree;
        if (root2 == null) {
            PsiFileImpl.$$$reportNull$$$0(10);
        }
        if ((stubTree = trees.derefStub()) == null || trees.astLoaded) {
            return Collections.emptyList();
        }
        try {
            List<Pair<StubBase, TreeElement>> result2 = TreeUtil.calcStubAstBindings(stubTree, root2);
            PsiLock psiLock = this.myPsiLock;
            synchronized (psiLock) {
                return ContainerUtil.map(result2, pair -> {
                    StubElement stub = (StubElement)pair.first;
                    Object psi = stub.getPsi();
                    assert (psi != null) : "Stub " + stub + " (" + stub.getClass() + ") has returned null PSI";
                    AstPath path2 = AstPath.getNodePath((CompositeElement)pair.second);
                    assert (path2 != null) : "Null path";
                    return Pair.create((StubBasedPsiElementBase)psi, path2);
                });
            }
        }
        catch (TreeUtil.StubBindingException e) {
            this.reportStubAstMismatch(e.getMessage(), stubTree);
            return Collections.emptyList();
        }
    }

    @Nullable
    public IStubFileElementType getElementTypeForStubBuilder() {
        ParserDefinition definition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(this.getLanguage());
        IFileElementType type2 = definition == null ? null : definition.getFileNodeType();
        return type2 instanceof IStubFileElementType ? (IStubFileElementType)type2 : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reportStubAstMismatch(String message, StubTree stubTree) {
        this.rebuildStub();
        PsiLock psiLock = this.myPsiLock;
        synchronized (psiLock) {
            this.updateTrees(this.myTrees.clearStub(STUB_PSI_MISMATCH));
        }
        throw StubTreeLoader.getInstance().stubTreeAndIndexDoNotMatch(message, stubTree, this);
    }

    @NotNull
    protected FileElement createFileElement(CharSequence docText) {
        FileElement treeElement;
        TreeElement contentLeaf = this.createContentLeafElement(docText);
        if (contentLeaf instanceof FileElement) {
            treeElement = (FileElement)contentLeaf;
        } else {
            CompositeElement xxx = ASTFactory.composite(this.myElementType);
            assert (xxx instanceof FileElement) : "BUMM";
            treeElement = (FileElement)xxx;
            treeElement.rawAddChildrenWithoutNotifications(contentLeaf);
        }
        FileElement fileElement = treeElement;
        if (fileElement == null) {
            PsiFileImpl.$$$reportNull$$$0(11);
        }
        return fileElement;
    }

    @Override
    public void clearCaches() {
        ++this.myModificationStamp;
    }

    @Override
    public String getText() {
        FileElement tree = this.derefTreeElement();
        if (!this.isValid()) {
            ProgressManager.checkCanceled();
            if (tree != null) {
                return tree.getText();
            }
            throw new PsiInvalidElementAccessException(this);
        }
        String string = this.getViewProvider().getContents().toString();
        if (tree != null && string.length() != tree.getTextLength()) {
            throw new AssertionError((Object)("File text mismatch: tree.length=" + tree.getTextLength() + "; psi.length=" + string.length() + "; this=" + this + "; vp=" + this.getViewProvider()));
        }
        return string;
    }

    @Override
    public int getTextLength() {
        FileElement tree = this.derefTreeElement();
        if (tree != null) {
            return tree.getTextLength();
        }
        PsiUtilCore.ensureValid(this);
        return this.getViewProvider().getContents().length();
    }

    @Override
    public TextRange getTextRange() {
        return new TextRange(0, this.getTextLength());
    }

    @Override
    public PsiElement getNextSibling() {
        return SharedPsiElementImplUtil.getNextSibling(this);
    }

    @Override
    public PsiElement getPrevSibling() {
        return SharedPsiElementImplUtil.getPrevSibling(this);
    }

    @Override
    public long getModificationStamp() {
        PsiElement context = this.getContext();
        PsiFile contextFile = context == null || !context.isValid() ? null : context.getContainingFile();
        long contextStamp = contextFile == null ? 0L : contextFile.getModificationStamp();
        return this.myModificationStamp + contextStamp;
    }

    @Override
    public void subtreeChanged() {
        this.doClearCaches("subtreeChanged");
        this.getViewProvider().rootChanged(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doClearCaches(String reason) {
        FileElement tree = this.getTreeElement();
        if (tree != null) {
            tree.clearCaches();
        }
        PsiLock psiLock = this.myPsiLock;
        synchronized (psiLock) {
            this.updateTrees(this.myTrees.clearStub(reason));
        }
        this.clearCaches();
    }

    @Override
    protected PsiFileImpl clone() {
        FileViewProvider viewProvider = this.getViewProvider();
        FileViewProvider providerCopy = viewProvider.clone();
        Language language = this.getLanguage();
        if (providerCopy == null) {
            throw new AssertionError((Object)("Unable to clone the view provider: " + viewProvider + "; " + language));
        }
        PsiFileImpl clone = BlockSupportImpl.getFileCopy(this, providerCopy);
        this.copyCopyableDataTo(clone);
        clone.myRefToPsi = new AstPathPsiMap(this.getProject());
        if (this.getTreeElement() != null) {
            FileElement treeClone = (FileElement)this.calcTreeElement().clone();
            clone.setTreeElementPointer(treeClone);
            treeClone.setPsi(clone);
        }
        if (viewProvider.isEventSystemEnabled()) {
            clone.myOriginalFile = this;
        } else if (this.myOriginalFile != null) {
            clone.myOriginalFile = this.myOriginalFile;
        }
        FileManagerImpl.clearPsiCaches(providerCopy);
        return clone;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.getViewProvider().getVirtualFile().getName();
        if (string == null) {
            PsiFileImpl.$$$reportNull$$$0(12);
        }
        return string;
    }

    @Override
    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            PsiFileImpl.$$$reportNull$$$0(13);
        }
        this.checkSetName(name);
        this.doClearCaches("setName");
        return PsiFileImplUtil.setName(this, name);
    }

    @Override
    public void checkSetName(String name) {
        if (!this.getViewProvider().isEventSystemEnabled()) {
            return;
        }
        PsiFileImplUtil.checkSetName(this, name);
    }

    @Override
    public boolean isWritable() {
        return this.getViewProvider().getVirtualFile().isWritable();
    }

    @Override
    public PsiDirectory getParent() {
        return this.getContainingDirectory();
    }

    @Override
    @Nullable
    public PsiDirectory getContainingDirectory() {
        VirtualFile file2 = this.getViewProvider().getVirtualFile();
        VirtualFile parentFile = file2.getParent();
        if (parentFile == null) {
            return null;
        }
        if (!parentFile.isValid()) {
            LOG.error("Invalid parent: " + parentFile + " of file " + file2 + ", file.valid=" + file2.isValid());
            return null;
        }
        return this.getManager().findDirectory(parentFile);
    }

    @Override
    @NotNull
    public PsiFile getContainingFile() {
        PsiFileImpl psiFileImpl = this;
        if (psiFileImpl == null) {
            PsiFileImpl.$$$reportNull$$$0(14);
        }
        return psiFileImpl;
    }

    @Override
    public void delete() throws IncorrectOperationException {
        this.checkDelete();
        PsiFileImplUtil.doDelete(this);
    }

    @Override
    public void checkDelete() throws IncorrectOperationException {
        if (!this.getViewProvider().isEventSystemEnabled()) {
            throw new IncorrectOperationException();
        }
        CheckUtil.checkWritable(this);
    }

    @Override
    @NotNull
    public PsiFile getOriginalFile() {
        PsiFile psiFile = this.myOriginalFile == null ? this : this.myOriginalFile;
        if (psiFile == null) {
            PsiFileImpl.$$$reportNull$$$0(15);
        }
        return psiFile;
    }

    public void setOriginalFile(@NotNull PsiFile originalFile) {
        if (originalFile == null) {
            PsiFileImpl.$$$reportNull$$$0(16);
        }
        this.myOriginalFile = originalFile.getOriginalFile();
        FileViewProvider original = this.myOriginalFile.getViewProvider();
        ((AbstractFileViewProvider)original).registerAsCopy((AbstractFileViewProvider)this.myViewProvider);
    }

    @Override
    @NotNull
    public PsiFile[] getPsiRoots() {
        FileViewProvider viewProvider = this.getViewProvider();
        Set<Language> languages = viewProvider.getLanguages();
        PsiFile[] roots2 = new PsiFile[languages.size()];
        int i = 0;
        for (Language language : languages) {
            PsiFile psi = viewProvider.getPsi(language);
            if (psi == null) {
                LOG.error("PSI is null for " + language + "; in file: " + this);
            }
            roots2[i++] = psi;
        }
        if (roots2.length > 1) {
            Arrays.sort(roots2, FILE_BY_LANGUAGE_ID);
        }
        if (roots2 == null) {
            PsiFileImpl.$$$reportNull$$$0(17);
        }
        return roots2;
    }

    @Override
    public boolean isPhysical() {
        return this.getViewProvider().isEventSystemEnabled();
    }

    @Override
    @NotNull
    public Language getLanguage() {
        Language language = this.myElementType.getLanguage();
        if (language == null) {
            PsiFileImpl.$$$reportNull$$$0(18);
        }
        return language;
    }

    @Override
    @NotNull
    public FileViewProvider getViewProvider() {
        FileViewProvider fileViewProvider = this.myViewProvider;
        if (fileViewProvider == null) {
            PsiFileImpl.$$$reportNull$$$0(19);
        }
        return fileViewProvider;
    }

    public void setTreeElementPointer(@Nullable FileElement element) {
        this.updateTrees(FileTrees.noStub(element, this));
    }

    @Override
    public PsiElement findElementAt(int offset2) {
        return this.getViewProvider().findElementAt(offset2);
    }

    @Override
    public PsiReference findReferenceAt(int offset2) {
        return this.getViewProvider().findReferenceAt(offset2);
    }

    @Override
    @NotNull
    public char[] textToCharArray() {
        char[] cArray = CharArrayUtil.fromSequence(this.getViewProvider().getContents());
        if (cArray == null) {
            PsiFileImpl.$$$reportNull$$$0(20);
        }
        return cArray;
    }

    @NotNull
    public <T> T[] findChildrenByClass(Class<T> aClass2) {
        ArrayList<PsiElement> result2 = new ArrayList<PsiElement>();
        for (PsiElement child : this.getChildren()) {
            if (!aClass2.isInstance(child)) continue;
            result2.add(child);
        }
        Object[] objectArray = result2.toArray((Object[])Array.newInstance(aClass2, result2.size()));
        if (objectArray == null) {
            PsiFileImpl.$$$reportNull$$$0(21);
        }
        return objectArray;
    }

    @Nullable
    public <T> T findChildByClass(Class<T> aClass2) {
        for (PsiElement child : this.getChildren()) {
            if (!aClass2.isInstance(child)) continue;
            return (T)child;
        }
        return null;
    }

    public boolean isTemplateDataFile() {
        return false;
    }

    @Override
    public PsiElement getContext() {
        return FileContextUtil.getFileContext(this);
    }

    @Override
    public void onContentReload() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        DebugUtil.performPsiModification("onContentReload", () -> {
            PsiLock psiLock = this.myPsiLock;
            synchronized (psiLock) {
                this.myRefToPsi.invalidatePsi();
                FileElement treeElement = this.derefTreeElement();
                if (treeElement != null) {
                    treeElement.detachFromFile();
                    DebugUtil.onInvalidated(treeElement);
                }
                this.updateTrees(this.myTrees.clearStub("onContentReload"));
                this.setTreeElementPointer(null);
            }
        });
        this.clearCaches();
    }

    @Nullable
    public StubElement getStub() {
        StubTree stubHolder = this.getStubTree();
        return stubHolder != null ? stubHolder.getRoot() : null;
    }

    @Nullable
    public final StubElement getGreenStub() {
        StubTree stubHolder = this.getGreenStubTree();
        return stubHolder != null ? stubHolder.getRoot() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public StubTree getStubTree() {
        this.assertReadAccessAllowed();
        if (this.myTrees.astLoaded && !this.mayReloadStub()) {
            return null;
        }
        if (Boolean.TRUE.equals(this.getUserData(BUILDING_STUB))) {
            return null;
        }
        StubTree derefd = this.derefStub();
        if (derefd != null) {
            return derefd;
        }
        if (this.getElementTypeForStubBuilder() == null) {
            return null;
        }
        VirtualFile vFile = this.getVirtualFile();
        if (!(vFile instanceof VirtualFileWithId) || !vFile.isValid()) {
            return null;
        }
        ObjectStubTree tree = StubTreeLoader.getInstance().readOrBuild(this.getProject(), vFile, this);
        if (!(tree instanceof StubTree)) {
            return null;
        }
        FileViewProvider viewProvider = this.getViewProvider();
        List<Pair<IStubFileElementType, PsiFile>> roots2 = StubTreeBuilder.getStubbedRoots(viewProvider);
        PsiLock psiLock = this.myPsiLock;
        synchronized (psiLock) {
            if (this.getTreeElement() != null || this.hasUnbindableCachedPsi()) {
                return null;
            }
            StubTree derefdOnLock = this.derefStub();
            if (derefdOnLock != null) {
                return derefdOnLock;
            }
            PsiFileStub baseRoot = ((StubTree)tree).getRoot();
            if (baseRoot instanceof PsiFileStubImpl && !((PsiFileStubImpl)baseRoot).rootsAreSet()) {
                LOG.error("Stub roots must be set when stub tree was read or built with StubTreeLoader");
                return null;
            }
            PsiFileStub[] stubRoots = baseRoot.getStubRoots();
            if (stubRoots.length != roots2.size()) {
                Function<PsiFileStub, String> stubToString = stub -> stub.getClass().getSimpleName();
                LOG.error("readOrBuilt roots = " + StringUtil.join(stubRoots, stubToString, ", ") + "; " + StubTreeLoader.getFileViewProviderMismatchDiagnostics(viewProvider));
                this.rebuildStub();
                return null;
            }
            Map<PsiFileImpl, StubTree> bindings = PsiFileImpl.prepareAllStubTrees(roots2, stubRoots);
            StubTree result2 = bindings.get(this);
            assert (result2 != null) : "Current file not in root list: " + roots2 + ", vp=" + viewProvider;
            for (PsiFileImpl eachPsiRoot : bindings.keySet()) {
                eachPsiRoot.updateTrees(eachPsiRoot.myTrees.withExclusiveStub(bindings.get(eachPsiRoot), bindings.keySet()));
            }
            return result2;
        }
    }

    private static Map<PsiFileImpl, StubTree> prepareAllStubTrees(List<Pair<IStubFileElementType, PsiFile>> roots2, PsiFileStub[] rootStubs) {
        IdentityHashMap<PsiFileImpl, StubTree> bindings = ContainerUtil.newIdentityHashMap();
        for (int i = 0; i < roots2.size(); ++i) {
            PsiFileImpl eachPsiRoot = (PsiFileImpl)roots2.get((int)i).second;
            ((StubBase)((Object)rootStubs[i])).setPsi(eachPsiRoot);
            StubTree stubTree = new StubTree(rootStubs[i]);
            FileElement fileElement = eachPsiRoot.getTreeElement();
            stubTree.setDebugInfo("created in getStubTree(), with AST = " + (fileElement != null));
            if (fileElement != null) {
                TreeUtil.bindStubsToTree(stubTree, fileElement);
                eachPsiRoot.myRefToPsi.clearStubIndexCache();
                continue;
            }
            eachPsiRoot.bindStubsToCachedPsi(stubTree);
            bindings.put(eachPsiRoot, stubTree);
        }
        return bindings;
    }

    private boolean mayReloadStub() {
        if (this.getTreeElement() != null || this.useStrongRefs()) {
            return false;
        }
        StubTreeLoader loader = StubTreeLoader.getInstance();
        if (loader != null && loader.isStubReloadingProhibited()) {
            return false;
        }
        return !this.hasUnbindableCachedPsi();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasUnbindableCachedPsi() {
        PsiLock psiLock = this.myPsiLock;
        synchronized (psiLock) {
            return ContainerUtil.exists(this.myViewProvider.getAllFiles(), file2 -> file2 instanceof PsiFileImpl && ((PsiFileImpl)file2).myRefToPsi.hasUnbindableCachedPsi());
        }
    }

    @Nullable
    private StubTree derefStub() {
        return this.myTrees.derefStub();
    }

    private void updateTrees(@NotNull FileTrees trees) {
        if (trees == null) {
            PsiFileImpl.$$$reportNull$$$0(22);
        }
        if (!ourTreeUpdater.compareAndSet(this, this.myTrees, trees)) {
            LOG.error("Non-atomic trees update");
            this.myTrees = trees;
        }
    }

    FileTrees getFileTrees() {
        return this.myTrees;
    }

    private void bindStubsToCachedPsi(StubTree stubTree) {
        this.myRefToPsi.getAllCachedPsi().forEach(psi -> {
            int index2 = psi.getStubIndex();
            if (index2 >= 0) {
                ((StubBase)stubTree.getPlainList().get(index2)).setPsi(psi);
            }
        });
    }

    protected PsiFileImpl cloneImpl(FileElement treeElementClone) {
        PsiFileImpl clone = (PsiFileImpl)super.clone();
        clone.myRefToPsi = new AstPathPsiMap(this.getProject());
        clone.setTreeElementPointer(treeElementClone);
        treeElementClone.setPsi(clone);
        return clone;
    }

    private boolean isKeepTreeElementByHardReference() {
        return !this.getViewProvider().isEventSystemEnabled();
    }

    @NotNull
    private Getter<FileElement> createTreeElementPointer(@NotNull FileElement treeElement) {
        if (treeElement == null) {
            PsiFileImpl.$$$reportNull$$$0(23);
        }
        if (this.isKeepTreeElementByHardReference()) {
            FileElement fileElement = treeElement;
            if (fileElement == null) {
                PsiFileImpl.$$$reportNull$$$0(24);
            }
            return fileElement;
        }
        Reference reference = this.myManager.isBatchFilesProcessingMode() ? new PatchedWeakReference<FileElement>(treeElement) : new SoftReference<FileElement>(treeElement);
        if (reference == null) {
            PsiFileImpl.$$$reportNull$$$0(25);
        }
        return reference;
    }

    @Override
    public final PsiManager getManager() {
        return this.myManager;
    }

    @Override
    public PsiElement getNavigationElement() {
        return this;
    }

    @Override
    public PsiElement getOriginalElement() {
        return this.getOriginalFile();
    }

    @NotNull
    public final FileElement calcTreeElement() {
        FileElement treeElement = this.getTreeElement();
        if (treeElement != null) {
            FileElement fileElement = treeElement;
            if (fileElement == null) {
                PsiFileImpl.$$$reportNull$$$0(26);
            }
            return fileElement;
        }
        treeElement = this.myFileElementBeingLoaded.get();
        if (treeElement != null) {
            FileElement fileElement = treeElement;
            if (fileElement == null) {
                PsiFileImpl.$$$reportNull$$$0(27);
            }
            return fileElement;
        }
        FileElement fileElement = this.loadTreeElement();
        if (fileElement == null) {
            PsiFileImpl.$$$reportNull$$$0(28);
        }
        return fileElement;
    }

    @Override
    @NotNull
    public PsiElement[] getChildren() {
        PsiElement[] psiElementArray = this.calcTreeElement().getChildrenAsPsiElements(null, PsiElement.ARRAY_FACTORY);
        if (psiElementArray == null) {
            PsiFileImpl.$$$reportNull$$$0(29);
        }
        return psiElementArray;
    }

    @Override
    public PsiElement getFirstChild() {
        return SharedImplUtil.getFirstChild(this.getNode());
    }

    @Override
    public PsiElement getLastChild() {
        return SharedImplUtil.getLastChild(this.getNode());
    }

    @Override
    public void acceptChildren(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            PsiFileImpl.$$$reportNull$$$0(30);
        }
        SharedImplUtil.acceptChildren(visitor2, this.getNode());
    }

    @Override
    public int getStartOffsetInParent() {
        return this.calcTreeElement().getStartOffsetInParent();
    }

    @Override
    public int getTextOffset() {
        return this.calcTreeElement().getTextOffset();
    }

    @Override
    public boolean textMatches(@NotNull CharSequence text2) {
        if (text2 == null) {
            PsiFileImpl.$$$reportNull$$$0(31);
        }
        return this.calcTreeElement().textMatches(text2);
    }

    @Override
    public boolean textMatches(@NotNull PsiElement element) {
        if (element == null) {
            PsiFileImpl.$$$reportNull$$$0(32);
        }
        return this.calcTreeElement().textMatches(element);
    }

    @Override
    public boolean textContains(char c) {
        return this.calcTreeElement().textContains(c);
    }

    @Override
    public final PsiElement copy() {
        return this.clone();
    }

    @Override
    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            PsiFileImpl.$$$reportNull$$$0(33);
        }
        CheckUtil.checkWritable(this);
        TreeElement elementCopy = ChangeUtil.copyToElement(element);
        this.calcTreeElement().addInternal(elementCopy, elementCopy, null, null);
        elementCopy = ChangeUtil.decodeInformation(elementCopy);
        return SourceTreeToPsiMap.treeElementToPsi(elementCopy);
    }

    @Override
    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor2) throws IncorrectOperationException {
        if (element == null) {
            PsiFileImpl.$$$reportNull$$$0(34);
        }
        CheckUtil.checkWritable(this);
        TreeElement elementCopy = ChangeUtil.copyToElement(element);
        this.calcTreeElement().addInternal(elementCopy, elementCopy, SourceTreeToPsiMap.psiElementToTree(anchor2), Boolean.TRUE);
        elementCopy = ChangeUtil.decodeInformation(elementCopy);
        return SourceTreeToPsiMap.treeElementToPsi(elementCopy);
    }

    @Override
    public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor2) throws IncorrectOperationException {
        if (element == null) {
            PsiFileImpl.$$$reportNull$$$0(35);
        }
        CheckUtil.checkWritable(this);
        TreeElement elementCopy = ChangeUtil.copyToElement(element);
        this.calcTreeElement().addInternal(elementCopy, elementCopy, SourceTreeToPsiMap.psiElementToTree(anchor2), Boolean.FALSE);
        elementCopy = ChangeUtil.decodeInformation(elementCopy);
        return SourceTreeToPsiMap.treeElementToPsi(elementCopy);
    }

    @Override
    public final void checkAdd(@NotNull PsiElement element) {
        if (element == null) {
            PsiFileImpl.$$$reportNull$$$0(36);
        }
        CheckUtil.checkWritable(this);
    }

    @Override
    public PsiElement addRange(PsiElement first2, PsiElement last2) throws IncorrectOperationException {
        return SharedImplUtil.addRange(this, first2, last2, null, null);
    }

    @Override
    public PsiElement addRangeBefore(@NotNull PsiElement first2, @NotNull PsiElement last2, PsiElement anchor2) throws IncorrectOperationException {
        if (first2 == null) {
            PsiFileImpl.$$$reportNull$$$0(37);
        }
        if (last2 == null) {
            PsiFileImpl.$$$reportNull$$$0(38);
        }
        return SharedImplUtil.addRange(this, first2, last2, SourceTreeToPsiMap.psiElementToTree(anchor2), Boolean.TRUE);
    }

    @Override
    public PsiElement addRangeAfter(PsiElement first2, PsiElement last2, PsiElement anchor2) throws IncorrectOperationException {
        return SharedImplUtil.addRange(this, first2, last2, SourceTreeToPsiMap.psiElementToTree(anchor2), Boolean.FALSE);
    }

    @Override
    public void deleteChildRange(PsiElement first2, PsiElement last2) throws IncorrectOperationException {
        CheckUtil.checkWritable(this);
        if (first2 == null) {
            LOG.assertTrue(last2 == null);
            return;
        }
        ASTNode firstElement = SourceTreeToPsiMap.psiElementToTree(first2);
        ASTNode lastElement = SourceTreeToPsiMap.psiElementToTree(last2);
        FileElement treeElement = this.calcTreeElement();
        LOG.assertTrue(firstElement.getTreeParent() == treeElement);
        LOG.assertTrue(lastElement.getTreeParent() == treeElement);
        CodeEditUtil.removeChildren(treeElement, firstElement, lastElement);
    }

    @Override
    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        if (newElement == null) {
            PsiFileImpl.$$$reportNull$$$0(39);
        }
        FileElement treeElement = this.calcTreeElement();
        return SharedImplUtil.doReplace(this, treeElement, newElement);
    }

    @Override
    public PsiReference getReference() {
        return null;
    }

    @Override
    @NotNull
    public PsiReference[] getReferences() {
        PsiReference[] psiReferenceArray = SharedPsiElementImplUtil.getReferences(this);
        if (psiReferenceArray == null) {
            PsiFileImpl.$$$reportNull$$$0(40);
        }
        return psiReferenceArray;
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor2, @NotNull ResolveState state2, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor2 == null) {
            PsiFileImpl.$$$reportNull$$$0(41);
        }
        if (state2 == null) {
            PsiFileImpl.$$$reportNull$$$0(42);
        }
        if (place == null) {
            PsiFileImpl.$$$reportNull$$$0(43);
        }
        return true;
    }

    @Override
    @NotNull
    public GlobalSearchScope getResolveScope() {
        GlobalSearchScope globalSearchScope = ResolveScopeManager.getElementResolveScope(this);
        if (globalSearchScope == null) {
            PsiFileImpl.$$$reportNull$$$0(44);
        }
        return globalSearchScope;
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        GlobalSearchScope globalSearchScope = ResolveScopeManager.getElementUseScope(this);
        if (globalSearchScope == null) {
            PsiFileImpl.$$$reportNull$$$0(45);
        }
        return globalSearchScope;
    }

    public ItemPresentation getPresentation() {
        return new ItemPresentation(){

            public String getPresentableText() {
                return PsiFileImpl.this.getName();
            }

            public String getLocationString() {
                PsiDirectory psiDirectory = PsiFileImpl.this.getParent();
                if (psiDirectory != null) {
                    return psiDirectory.getVirtualFile().getPresentableUrl();
                }
                return null;
            }

            @Override
            public Icon getIcon(boolean open) {
                return PsiFileImpl.this.getIcon(0);
            }
        };
    }

    @Override
    public void navigate(boolean requestFocus) {
        assert (this.canNavigate()) : this;
        PsiNavigationSupport.getInstance().getDescriptor(this).navigate(requestFocus);
    }

    @Override
    public boolean canNavigate() {
        return PsiNavigationSupport.getInstance().canNavigate(this);
    }

    @Override
    public boolean canNavigateToSource() {
        return this.canNavigate();
    }

    @Override
    @NotNull
    public final Project getProject() {
        Project project = this.getManager().getProject();
        if (project == null) {
            PsiFileImpl.$$$reportNull$$$0(46);
        }
        return project;
    }

    @Override
    @NotNull
    public FileASTNode getNode() {
        FileElement fileElement = this.calcTreeElement();
        if (fileElement == null) {
            PsiFileImpl.$$$reportNull$$$0(47);
        }
        return fileElement;
    }

    @Override
    public boolean isEquivalentTo(PsiElement another) {
        return this == another;
    }

    @Nullable
    public final StubTree getGreenStubTree() {
        StubTree result2 = this.derefStub();
        return result2 != null ? result2 : this.getStubTree();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public StubTree calcStubTree() {
        StubTree tree = this.derefStub();
        if (tree != null) {
            StubTree stubTree = tree;
            if (stubTree != null) return stubTree;
            PsiFileImpl.$$$reportNull$$$0(48);
            return stubTree;
        }
        assert (this.myFileElementBeingLoaded.get() == null) : "non-empty thread-local";
        FileElement fileElement = this.calcTreeElement();
        PsiLock psiLock = this.myPsiLock;
        // MONITORENTER : psiLock
        tree = this.derefStub();
        if (tree == null) {
            this.assertReadAccessAllowed();
            IStubFileElementType contentElementType = this.getElementTypeForStubBuilder();
            if (contentElementType == null) {
                VirtualFile vFile = this.getVirtualFile();
                String message = "ContentElementType: " + this.getContentElementType() + "; file: " + this + "\n\tBoolean.TRUE.equals(getUserData(BUILDING_STUB)) = " + Boolean.TRUE.equals(this.getUserData(BUILDING_STUB)) + "\n\tgetTreeElement() = " + this.getTreeElement() + "\n\tvFile instanceof VirtualFileWithId = " + (vFile instanceof VirtualFileWithId) + "\n\tStubUpdatingIndex.canHaveStub(vFile) = " + StubTreeLoader.getInstance().canHaveStub(vFile);
                this.rebuildStub();
                throw new AssertionError((Object)message);
            }
            StubElement currentStubTree = contentElementType.getBuilder().buildStubTree(this);
            if (currentStubTree == null) {
                throw new AssertionError((Object)("Stub tree wasn't built for " + contentElementType + "; file: " + this));
            }
            tree = new StubTree((PsiFileStub)currentStubTree);
            tree.setDebugInfo("created in calcStubTree");
            try {
                TreeUtil.bindStubsToTree(tree, fileElement);
                this.myRefToPsi.clearStubIndexCache();
            }
            catch (TreeUtil.StubBindingException e) {
                this.rebuildStub();
                throw new RuntimeException("Stub and PSI element type mismatch in " + this.getName(), e);
            }
            this.updateTrees(this.myTrees.withGreenStub(tree, this));
        }
        StubTree stubTree = tree;
        // MONITOREXIT : psiLock
        if (stubTree != null) return stubTree;
        PsiFileImpl.$$$reportNull$$$0(49);
        return stubTree;
    }

    private void rebuildStub() {
        ApplicationManager.getApplication().invokeLater(() -> {
            VirtualFile vFile;
            if (!this.myManager.isDisposed()) {
                this.myManager.dropPsiCaches();
            }
            if ((vFile = this.getVirtualFile()) != null && vFile.isValid()) {
                Document doc = FileDocumentManager.getInstance().getCachedDocument(vFile);
                if (doc != null) {
                    FileDocumentManager.getInstance().saveDocument(doc);
                }
                FileContentUtilCore.reparseFiles(vFile);
                StubTreeLoader.getInstance().rebuildStubTree(vFile);
            }
        }, ModalityState.NON_MODAL);
    }

    @Override
    public void putInfo(@NotNull Map<String, String> info) {
        if (info == null) {
            PsiFileImpl.$$$reportNull$$$0(50);
        }
        PsiFileImpl.putInfo(this, info);
    }

    public static void putInfo(PsiFile psiFile, Map<String, String> info) {
        info.put("fileName", psiFile.getName());
        info.put("fileType", psiFile.getFileType().toString());
    }

    @Override
    public String toString() {
        return this.myElementType.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void beforeAstChange() {
        this.checkWritable();
        if (!this.useStrongRefs()) {
            PsiLock psiLock = this.myPsiLock;
            synchronized (psiLock) {
                for (PsiFile root2 : this.myViewProvider.getAllFiles()) {
                    if (!(root2 instanceof PsiFileImpl)) continue;
                    ((PsiFileImpl)root2).switchToStrongRefs();
                }
            }
        }
    }

    private void checkWritable() {
        PsiDocumentManager docManager = PsiDocumentManager.getInstance(this.getProject());
        if (docManager instanceof PsiDocumentManagerBase && !((PsiDocumentManagerBase)docManager).isCommitInProgress() && !(this.myViewProvider instanceof FreeThreadedFileViewProvider)) {
            CheckUtil.checkWritable(this);
        }
    }

    private void switchToStrongRefs() {
        FileElement node = this.calcTreeElement();
        this.updateTrees(this.myTrees.switchToStrongRefs());
        this.myRefToPsi.switchToStrongRefs();
        AstPath.invalidatePaths(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public StubBasedPsiElementBase<?> obtainPsi(@NotNull AstPath path2, @NotNull Factory<StubBasedPsiElementBase<?>> creator) {
        if (path2 == null) {
            PsiFileImpl.$$$reportNull$$$0(51);
        }
        if (creator == null) {
            PsiFileImpl.$$$reportNull$$$0(52);
        }
        if (this.useStrongRefs()) {
            return null;
        }
        StubBasedPsiElementBase<?> psi = this.myRefToPsi.getCachedPsi(path2);
        if (psi != null) {
            return psi;
        }
        PsiLock psiLock = this.myPsiLock;
        synchronized (psiLock) {
            if (this.useStrongRefs()) {
                return null;
            }
            psi = this.myRefToPsi.getCachedPsi(path2);
            StubBasedPsiElementBase<?> stubBasedPsiElementBase = psi != null ? psi : this.myRefToPsi.cachePsi(path2, creator.create());
            return stubBasedPsiElementBase;
        }
    }

    final AstPathPsiMap getRefToPsi() {
        return this.myRefToPsi;
    }

    public final boolean useStrongRefs() {
        return this.myTrees.useStrongRefs;
    }

    public boolean mayCacheAst() {
        return this.myFileElementBeingLoaded.get() == null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 40: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 40: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 4: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 40: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiFileImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewProvider";
                break;
            }
            case 6: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeElement";
                break;
            }
            case 7: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trees";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bindings";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalFile";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "last";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElement";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "creator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiFileImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "loadTreeElement";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getStubbedSpine";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileElement";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainingFile";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginalFile";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiRoots";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getViewProvider";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "textToCharArray";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "findChildrenByClass";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "createTreeElementPointer";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "calcTreeElement";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolveScope";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getUseScope";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getNode";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "calcStubTree";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 4: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 40: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "ensureTreeElement";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "calcStubAstBindings";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setOriginalFile";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "updateTrees";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createTreeElementPointer";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "acceptChildren";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "textMatches";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "addBefore";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "addAfter";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "checkAdd";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "addRangeBefore";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "putInfo";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "obtainPsi";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 40: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

