/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.util.buffer;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import org.simpleframework.util.thread.Daemon;

class FileManager
extends Daemon
implements FileFilter {
    private String prefix;
    private long duration;
    private volatile boolean dead;

    public FileManager(String prefix) throws IOException {
        this(prefix, 300000L);
    }

    public FileManager(String prefix, long duration) throws IOException {
        this.duration = duration;
        this.prefix = prefix;
        this.start();
    }

    public File create() throws IOException {
        return this.create(this.prefix);
    }

    private File create(String prefix) throws IOException {
        File file = File.createTempFile(prefix, null);
        if (!file.exists()) {
            file.createNewFile();
        }
        return file;
    }

    public void run() {
        while (!this.dead) {
            try {
                Thread.sleep(this.duration);
                this.clean();
            }
            catch (Exception e) {}
        }
    }

    private void clean() throws IOException {
        File path = this.create();
        if (!path.isDirectory()) {
            path = path.getParentFile();
        }
        this.clean(path);
    }

    private void clean(File path) throws IOException {
        File[] list;
        for (File next : list = path.listFiles(this)) {
            next.delete();
        }
    }

    public boolean accept(File file) {
        String name = file.getName();
        if (file.isDirectory()) {
            return false;
        }
        return this.accept(file, name);
    }

    private boolean accept(File file, String name) {
        long time = System.currentTimeMillis();
        long modified = file.lastModified();
        if (modified + this.duration > time) {
            return false;
        }
        return name.startsWith(this.prefix);
    }

    public void close() throws IOException {
        if (!this.dead) {
            this.dead = true;
            this.interrupt();
            this.clean();
        }
    }
}

