/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.plugins;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Transformer;
import org.gradle.jvm.application.scripts.JavaAppStartScriptGenerationDetails;
import org.gradle.util.CollectionUtils;

public class StartScriptTemplateBindingFactory
implements Transformer<Map<String, String>, JavaAppStartScriptGenerationDetails> {
    private final boolean windows;

    private StartScriptTemplateBindingFactory(boolean windows) {
        this.windows = windows;
    }

    public static StartScriptTemplateBindingFactory windows() {
        return new StartScriptTemplateBindingFactory(true);
    }

    public static StartScriptTemplateBindingFactory unix() {
        return new StartScriptTemplateBindingFactory(false);
    }

    public Map<String, String> transform(JavaAppStartScriptGenerationDetails details) {
        HashMap<String, String> binding = new HashMap<String, String>();
        binding.put(ScriptBindingParameter.APP_NAME.getKey(), details.getApplicationName());
        binding.put(ScriptBindingParameter.OPTS_ENV_VAR.getKey(), details.getOptsEnvironmentVar());
        binding.put(ScriptBindingParameter.EXIT_ENV_VAR.getKey(), details.getExitEnvironmentVar());
        binding.put(ScriptBindingParameter.MAIN_CLASSNAME.getKey(), details.getMainClassName());
        binding.put(ScriptBindingParameter.DEFAULT_JVM_OPTS.getKey(), this.createJoinedDefaultJvmOpts(details.getDefaultJvmOpts()));
        binding.put(ScriptBindingParameter.APP_NAME_SYS_PROP.getKey(), details.getAppNameSystemProperty());
        binding.put(ScriptBindingParameter.APP_HOME_REL_PATH.getKey(), this.createJoinedAppHomeRelativePath(details.getScriptRelPath()));
        binding.put(ScriptBindingParameter.CLASSPATH.getKey(), this.createJoinedClasspath(details.getClasspath()));
        return binding;
    }

    private String createJoinedClasspath(Iterable<String> classpath) {
        if (this.windows) {
            return Joiner.on((String)";").join(Iterables.transform(classpath, (Function)new Function<String, String>(){

                public String apply(String input) {
                    return "%APP_HOME%\\" + input.replace("/", "\\");
                }
            }));
        }
        return Joiner.on((String)":").join(Iterables.transform(classpath, (Function)new Function<String, String>(){

            public String apply(String input) {
                return "$APP_HOME/" + input.replace("\\", "/");
            }
        }));
    }

    private String createJoinedDefaultJvmOpts(Iterable<String> defaultJvmOpts) {
        if (this.windows) {
            if (defaultJvmOpts == null) {
                return "";
            }
            Iterable quotedDefaultJvmOpts = Iterables.transform((Iterable)CollectionUtils.toStringList(defaultJvmOpts), (Function)new Function<String, String>(){

                public String apply(String jvmOpt) {
                    return "\"" + StartScriptTemplateBindingFactory.this.escapeWindowsJvmOpt(jvmOpt) + "\"";
                }
            });
            Joiner spaceJoiner = Joiner.on((String)" ");
            return spaceJoiner.join(quotedDefaultJvmOpts);
        }
        if (defaultJvmOpts == null) {
            return "";
        }
        Iterable quotedDefaultJvmOpts = Iterables.transform((Iterable)CollectionUtils.toStringList(defaultJvmOpts), (Function)new Function<String, String>(){

            public String apply(String jvmOpt) {
                jvmOpt = jvmOpt.replace("\\", "\\\\");
                jvmOpt = jvmOpt.replace("\"", "\\\"");
                jvmOpt = jvmOpt.replace("'", "'\"'\"'");
                jvmOpt = jvmOpt.replace("`", "'\"`\"'");
                jvmOpt = jvmOpt.replace("$", "\\$");
                return "\"" + jvmOpt + "\"";
            }
        });
        Joiner spaceJoiner = Joiner.on((String)" ");
        if (Iterables.size((Iterable)quotedDefaultJvmOpts) > 0) {
            return "'" + spaceJoiner.join(quotedDefaultJvmOpts) + "'";
        }
        return "\"\"";
    }

    private String escapeWindowsJvmOpt(String jvmOpts) {
        boolean wasOnBackslash = false;
        StringBuilder escapedJvmOpt = new StringBuilder();
        StringCharacterIterator it = new StringCharacterIterator(jvmOpts);
        char ch = it.first();
        while (ch != '\uffff') {
            String repl = Character.toString(ch);
            if (ch == '%') {
                repl = "%%";
            } else if (ch == '\"') {
                repl = (wasOnBackslash ? Character.valueOf('\\') : "") + "\\\"";
            }
            wasOnBackslash = ch == '\\';
            escapedJvmOpt.append(repl);
            ch = it.next();
        }
        return escapedJvmOpt.toString();
    }

    String createJoinedAppHomeRelativePath(String scriptRelPath) {
        int depth = StringUtils.countMatches((String)scriptRelPath, (String)"/");
        if (depth == 0) {
            return "";
        }
        ArrayList<String> appHomeRelativePath = new ArrayList<String>(depth);
        for (int i = 0; i < depth; ++i) {
            appHomeRelativePath.add("..");
        }
        return Joiner.on((String)(this.windows ? "\\" : "/")).join(appHomeRelativePath);
    }

    private static enum ScriptBindingParameter {
        APP_NAME("applicationName"),
        OPTS_ENV_VAR("optsEnvironmentVar"),
        EXIT_ENV_VAR("exitEnvironmentVar"),
        MAIN_CLASSNAME("mainClassName"),
        DEFAULT_JVM_OPTS("defaultJvmOpts"),
        APP_NAME_SYS_PROP("appNameSystemProperty"),
        APP_HOME_REL_PATH("appHomeRelativePath"),
        CLASSPATH("classpath");

        private final String key;

        private ScriptBindingParameter(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }
}

