/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.fingerprint.impl;

import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.changedetection.state.FileSystemSnapshotter;
import org.gradle.api.internal.changedetection.state.ResourceFilter;
import org.gradle.api.internal.changedetection.state.ResourceSnapshotterCacheService;
import org.gradle.api.internal.changedetection.state.RuntimeClasspathResourceHasher;
import org.gradle.api.tasks.ClasspathNormalizer;
import org.gradle.api.tasks.FileNormalizer;
import org.gradle.internal.fingerprint.ClasspathFingerprinter;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.fingerprint.impl.AbstractFileCollectionFingerprinter;
import org.gradle.internal.fingerprint.impl.ClasspathFingerprintingStrategy;
import org.gradle.normalization.internal.InputNormalizationStrategy;

public class DefaultClasspathFingerprinter
extends AbstractFileCollectionFingerprinter
implements ClasspathFingerprinter {
    private final ResourceSnapshotterCacheService cacheService;
    private final StringInterner stringInterner;
    private final RuntimeClasspathResourceHasher runtimeClasspathResourceHasher;

    public DefaultClasspathFingerprinter(ResourceSnapshotterCacheService cacheService, FileSystemSnapshotter fileSystemSnapshotter, StringInterner stringInterner) {
        super(stringInterner, fileSystemSnapshotter);
        this.cacheService = cacheService;
        this.stringInterner = stringInterner;
        this.runtimeClasspathResourceHasher = new RuntimeClasspathResourceHasher();
    }

    @Override
    public Class<? extends FileNormalizer> getRegisteredType() {
        return ClasspathNormalizer.class;
    }

    @Override
    public CurrentFileCollectionFingerprint fingerprint(FileCollection files, InputNormalizationStrategy inputNormalizationStrategy) {
        ResourceFilter classpathResourceFilter = inputNormalizationStrategy.getRuntimeClasspathNormalizationStrategy().getRuntimeClasspathResourceFilter();
        return super.fingerprint(files, ClasspathFingerprintingStrategy.runtimeClasspath(classpathResourceFilter, this.runtimeClasspathResourceHasher, this.cacheService, this.stringInterner));
    }
}

