/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.repository.internal;

import org.gradle.api.Action;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.api.artifacts.repositories.AuthenticationContainer;
import org.gradle.api.artifacts.repositories.IvyArtifactRepository;
import org.gradle.api.artifacts.repositories.RepositoryLayout;
import org.gradle.api.credentials.Credentials;
import org.gradle.api.internal.artifacts.DependencyResolutionServices;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelectorScheme;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.internal.artifacts.repositories.AuthenticationSupportedInternal;
import org.gradle.plugin.repository.IvyPluginRepository;
import org.gradle.plugin.repository.internal.AbstractArtifactPluginRepository;

class DefaultIvyPluginRepository
extends AbstractArtifactPluginRepository
implements IvyPluginRepository {
    private static final String IVY = "ivy";
    private String layoutName;
    private Action<? extends RepositoryLayout> layoutAction;
    private String artifactPattern;
    private String ivyPattern;

    public DefaultIvyPluginRepository(FileResolver fileResolver, DependencyResolutionServices dependencyResolutionServices, VersionSelectorScheme versionSelectorScheme, AuthenticationSupportedInternal delegate) {
        super(IVY, fileResolver, dependencyResolutionServices, versionSelectorScheme, delegate);
    }

    @Override
    protected ArtifactRepository internalCreateArtifactRepository(RepositoryHandler repositoryHandler) {
        return repositoryHandler.ivy((Action)new Action<IvyArtifactRepository>(){

            public void execute(IvyArtifactRepository ivyArtifactRepository) {
                ivyArtifactRepository.setName(DefaultIvyPluginRepository.this.getArtifactRepositoryName());
                ivyArtifactRepository.setUrl(DefaultIvyPluginRepository.this.getUrl());
                Credentials credentials = DefaultIvyPluginRepository.this.authenticationSupport().getConfiguredCredentials();
                if (credentials != null) {
                    ((AuthenticationSupportedInternal)ivyArtifactRepository).setConfiguredCredentials(credentials);
                    ivyArtifactRepository.authentication((Action)new Action<AuthenticationContainer>(){

                        public void execute(AuthenticationContainer authenticationContainer) {
                            authenticationContainer.addAll(DefaultIvyPluginRepository.this.authenticationSupport().getConfiguredAuthentication());
                        }
                    });
                }
                if (DefaultIvyPluginRepository.this.layoutName != null) {
                    if (DefaultIvyPluginRepository.this.layoutAction != null) {
                        ivyArtifactRepository.layout(DefaultIvyPluginRepository.this.layoutName, DefaultIvyPluginRepository.this.layoutAction);
                    } else {
                        ivyArtifactRepository.layout(DefaultIvyPluginRepository.this.layoutName);
                    }
                }
                if (DefaultIvyPluginRepository.this.artifactPattern != null) {
                    ivyArtifactRepository.artifactPattern(DefaultIvyPluginRepository.this.artifactPattern);
                }
                if (DefaultIvyPluginRepository.this.ivyPattern != null) {
                    ivyArtifactRepository.ivyPattern(DefaultIvyPluginRepository.this.ivyPattern);
                }
            }
        });
    }

    public void artifactPattern(String pattern) {
        this.artifactPattern = pattern;
    }

    public void ivyPattern(String pattern) {
        this.ivyPattern = pattern;
    }

    public void layout(String layoutName) {
        this.layoutName = layoutName;
    }

    public void layout(String layoutName, Action<? extends RepositoryLayout> config) {
        this.layout(layoutName);
        this.layoutAction = config;
    }
}

