/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.local;

import java.io.File;
import org.gradle.internal.hash.HashUtil;
import org.gradle.internal.hash.HashValue;
import org.gradle.internal.resource.local.LocallyAvailableResource;

public abstract class AbstractLocallyAvailableResource
implements LocallyAvailableResource {
    private HashValue sha1;
    private Long contentLength;
    private Long lastModified;

    protected AbstractLocallyAvailableResource() {
    }

    protected AbstractLocallyAvailableResource(HashValue sha1) {
        this.sha1 = sha1;
    }

    public String toString() {
        return this.getDisplayName();
    }

    public String getDisplayName() {
        return this.getFile().getPath();
    }

    public HashValue getSha1() {
        if (this.sha1 == null) {
            this.sha1 = HashUtil.sha1((File)this.getFile());
        }
        return this.sha1;
    }

    public long getContentLength() {
        if (this.contentLength == null) {
            this.contentLength = this.getFile().length();
        }
        return this.contentLength;
    }

    public long getLastModified() {
        if (this.lastModified == null) {
            this.lastModified = this.getFile().lastModified();
        }
        return this.lastModified;
    }
}

