/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.gradle.api.Transformer;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.MetaDataParseException;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.internal.component.external.model.MutableComponentVariant;
import org.gradle.internal.component.external.model.MutableComponentVariantResolveMetadata;
import org.gradle.internal.resource.ExternalResource;
import org.gradle.internal.resource.local.LocallyAvailableExternalResource;

public class ModuleMetadataParser {
    public static final String FORMAT_VERSION = "0.1";
    private final ImmutableAttributesFactory attributesFactory;

    public ModuleMetadataParser(ImmutableAttributesFactory attributesFactory) {
        this.attributesFactory = attributesFactory;
    }

    public void parse(final LocallyAvailableExternalResource resource, final MutableComponentVariantResolveMetadata metadata) {
        resource.withContent((Transformer)new Transformer<Void, InputStream>(){

            public Void transform(InputStream inputStream) {
                try {
                    JsonReader reader = new JsonReader((Reader)new InputStreamReader(inputStream, "utf-8"));
                    reader.beginObject();
                    if (reader.peek() != JsonToken.NAME) {
                        throw new RuntimeException("Module metadata should contain a 'formatVersion' value.");
                    }
                    String name = reader.nextName();
                    if (!name.equals("formatVersion")) {
                        throw new RuntimeException(String.format("The 'formatVersion' value should be the first value in a module metadata. Found '%s' instead.", name));
                    }
                    if (reader.peek() != JsonToken.STRING) {
                        throw new RuntimeException("The 'formatVersion' value should have a string value.");
                    }
                    String version = reader.nextString();
                    if (!version.equals(ModuleMetadataParser.FORMAT_VERSION)) {
                        throw new RuntimeException(String.format("Unsupported format version '%s' specified in module metadata. This version of Gradle supports only format version %s.", version, ModuleMetadataParser.FORMAT_VERSION));
                    }
                    ModuleMetadataParser.this.consumeTopLevelElements(reader, metadata);
                    return null;
                }
                catch (Exception e) {
                    throw new MetaDataParseException("module metadata", (ExternalResource)resource, e);
                }
            }
        });
    }

    private void consumeTopLevelElements(JsonReader reader, MutableComponentVariantResolveMetadata metadata) throws IOException {
        while (reader.peek() != JsonToken.END_OBJECT) {
            String name = reader.nextName();
            if (name.equals("variants")) {
                this.consumeVariants(reader, metadata);
                continue;
            }
            this.consumeAny(reader);
        }
    }

    private void consumeVariants(JsonReader reader, MutableComponentVariantResolveMetadata metadata) throws IOException {
        reader.beginArray();
        while (reader.peek() != JsonToken.END_ARRAY) {
            this.consumeVariant(reader, metadata);
        }
        reader.endArray();
    }

    private void consumeVariant(JsonReader reader, MutableComponentVariantResolveMetadata metadata) throws IOException {
        reader.beginObject();
        String variantName = null;
        ImmutableAttributes attributes = ImmutableAttributes.EMPTY;
        List<Object> files = Collections.emptyList();
        while (reader.peek() != JsonToken.END_OBJECT) {
            String name = reader.nextName();
            if (name.equals("name")) {
                variantName = reader.nextString();
                continue;
            }
            if (name.equals("attributes")) {
                attributes = this.consumeAttributes(reader);
                continue;
            }
            if (name.equals("files")) {
                files = this.consumeFiles(reader);
                continue;
            }
            this.consumeAny(reader);
        }
        reader.endObject();
        MutableComponentVariant variant = metadata.addVariant(variantName, attributes);
        for (ModuleFile file : files) {
            variant.addFile(file.name, file.uri);
        }
    }

    private List<ModuleFile> consumeFiles(JsonReader reader) throws IOException {
        ArrayList<ModuleFile> files = new ArrayList<ModuleFile>();
        reader.beginArray();
        while (reader.peek() != JsonToken.END_ARRAY) {
            reader.beginObject();
            String fileName = null;
            String fileUri = null;
            while (reader.peek() != JsonToken.END_OBJECT) {
                String name = reader.nextName();
                if (name.equals("name")) {
                    fileName = reader.nextString();
                    continue;
                }
                if (name.equals("url")) {
                    fileUri = reader.nextString();
                    continue;
                }
                this.consumeAny(reader);
            }
            reader.endObject();
            files.add(new ModuleFile(fileName, fileUri));
        }
        reader.endArray();
        return files;
    }

    private ImmutableAttributes consumeAttributes(JsonReader reader) throws IOException {
        ImmutableAttributes attributes = ImmutableAttributes.EMPTY;
        reader.beginObject();
        while (reader.peek() != JsonToken.END_OBJECT) {
            String attrName = reader.nextName();
            String attrValue = reader.nextString();
            attributes = this.attributesFactory.concat(attributes, Attribute.of((String)attrName, String.class), (Object)attrValue);
        }
        reader.endObject();
        return attributes;
    }

    private void consumeAny(JsonReader reader) throws IOException {
        reader.skipValue();
    }

    class ModuleFile {
        final String name;
        final String uri;

        public ModuleFile(String name, String uri) {
            this.name = name;
            this.uri = uri;
        }
    }
}

