/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.management.internal.autoapply;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.gradle.StartParameter;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.internal.artifacts.DefaultModuleVersionSelector;
import org.gradle.plugin.management.internal.DefaultPluginRequest;
import org.gradle.plugin.management.internal.DefaultPluginRequests;
import org.gradle.plugin.management.internal.PluginRequests;
import org.gradle.plugin.management.internal.autoapply.AutoAppliedPluginRegistry;
import org.gradle.plugin.use.PluginId;
import org.gradle.plugin.use.internal.DefaultPluginId;

public class DefaultAutoAppliedPluginRegistry
implements AutoAppliedPluginRegistry {
    private static final PluginId BUILD_SCAN_PLUGIN_ID = new DefaultPluginId("com.gradle.build-scan");
    private static final String BUILD_SCAN_PLUGIN_AUTO_APPLY_VERSION = "1.9.1";
    private static final String BUILD_SCAN_PLUGIN_GROUP = "com.gradle";
    private static final String BUILD_SCAN_PLUGIN_NAME = "build-scan-plugin";
    private final StartParameter startParameter;

    public DefaultAutoAppliedPluginRegistry(StartParameter startParameter) {
        this.startParameter = startParameter;
    }

    public PluginRequests getAutoAppliedPlugins(Project target) {
        ArrayList requests = Lists.newArrayList();
        if (this.shouldApplyScanPlugin(target)) {
            requests.add(this.createScanPluginRequest());
        }
        return new DefaultPluginRequests((List)requests);
    }

    private boolean shouldApplyScanPlugin(Project target) {
        return this.startParameter.isBuildScan() && target.getParent() == null && target.getGradle().getParent() == null;
    }

    private DefaultPluginRequest createScanPluginRequest() {
        DefaultModuleVersionSelector artifact = new DefaultModuleVersionSelector(BUILD_SCAN_PLUGIN_GROUP, BUILD_SCAN_PLUGIN_NAME, BUILD_SCAN_PLUGIN_AUTO_APPLY_VERSION);
        return new DefaultPluginRequest(BUILD_SCAN_PLUGIN_ID, BUILD_SCAN_PLUGIN_AUTO_APPLY_VERSION, true, null, DefaultAutoAppliedPluginRegistry.getScriptDisplayName(), (ModuleVersionSelector)artifact);
    }

    private static String getScriptDisplayName() {
        return String.format("auto-applied by using --%s", "scan");
    }
}

