/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.plugins.internal;

import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.buildinit.plugins.internal.BuildInitTestFramework;
import org.gradle.buildinit.plugins.internal.BuildScriptBuilder;
import org.gradle.buildinit.plugins.internal.JavaProjectInitDescriptor;
import org.gradle.buildinit.plugins.internal.ProjectInitDescriptor;
import org.gradle.buildinit.plugins.internal.TemplateLibraryVersionProvider;
import org.gradle.buildinit.plugins.internal.TemplateOperation;
import org.gradle.buildinit.plugins.internal.TemplateOperationFactory;

public class JavaLibraryProjectInitDescriptor
extends JavaProjectInitDescriptor {
    private static final JavaProjectInitDescriptor.Description DESCRIPTION = new JavaProjectInitDescriptor.Description("Java Library", "Java Libraries", "java_library_plugin", "java-library");

    public JavaLibraryProjectInitDescriptor(TemplateOperationFactory templateOperationFactory, FileResolver fileResolver, TemplateLibraryVersionProvider libraryVersionProvider, ProjectInitDescriptor globalSettingsDescriptor, DocumentationRegistry documentationRegistry) {
        super(templateOperationFactory, fileResolver, libraryVersionProvider, globalSettingsDescriptor, documentationRegistry);
    }

    @Override
    protected TemplateOperation sourceTemplateOperation() {
        return this.fromClazzTemplate("javalibrary/Library.java.template", "main");
    }

    @Override
    protected TemplateOperation testTemplateOperation(BuildInitTestFramework testFramework) {
        switch (testFramework) {
            case SPOCK: {
                return this.fromClazzTemplate("groovylibrary/LibraryTest.groovy.template", "test", "groovy");
            }
            case TESTNG: {
                return this.fromClazzTemplate("javalibrary/LibraryTestNG.java.template", "test", "java", "LibraryTest.java");
            }
        }
        return this.fromClazzTemplate("javalibrary/LibraryTest.java.template", "test");
    }

    @Override
    protected JavaProjectInitDescriptor.Description getDescription() {
        return DESCRIPTION;
    }

    @Override
    protected String getImplementationConfigurationName() {
        return "implementation";
    }

    @Override
    protected void configureBuildScript(BuildScriptBuilder buildScriptBuilder) {
        buildScriptBuilder.dependency("api", "This dependency is exported to consumers, that is to say found on their compile classpath.", "org.apache.commons:commons-math3:" + this.libraryVersionProvider.getVersion("commons-math"));
        buildScriptBuilder.dependency(this.getImplementationConfigurationName(), "This dependency is used internally, and not exposed to consumers on their own compile classpath.", "com.google.guava:guava:" + this.libraryVersionProvider.getVersion("guava"));
    }
}

