/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.http.internal;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.Set;
import org.apache.commons.lang.IncompleteArgumentException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpMessage;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.entity.AbstractHttpEntity;
import org.gradle.api.UncheckedIOException;
import org.gradle.caching.BuildCacheEntryReader;
import org.gradle.caching.BuildCacheEntryWriter;
import org.gradle.caching.BuildCacheException;
import org.gradle.caching.BuildCacheKey;
import org.gradle.caching.BuildCacheService;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.resource.transport.http.HttpClientHelper;
import org.gradle.util.GradleVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpBuildCacheService
implements BuildCacheService {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpBuildCacheService.class);
    static final String BUILD_CACHE_CONTENT_TYPE = "application/vnd.gradle.build-cache-artifact.v1";
    private static final Set<Integer> FATAL_HTTP_ERROR_CODES = ImmutableSet.of((Object)305, (Object)400, (Object)401, (Object)403, (Object)407, (Object)405, (Object[])new Integer[]{406, 411, 415, 417, 426, 505, 511});
    private final URI root;
    private final HttpClientHelper httpClientHelper;

    public HttpBuildCacheService(HttpClientHelper httpClientHelper, URI url) {
        if (!url.getPath().endsWith("/")) {
            throw new IncompleteArgumentException("HTTP cache root URI must end with '/'");
        }
        this.root = url;
        this.httpClientHelper = httpClientHelper;
    }

    public boolean load(BuildCacheKey key, BuildCacheEntryReader reader) throws BuildCacheException {
        boolean bl;
        int statusCode;
        StatusLine statusLine;
        CloseableHttpResponse response;
        URI uri;
        block8: {
            block7: {
                uri = this.root.resolve("./" + key.getHashCode());
                HttpGet httpGet = new HttpGet(uri);
                httpGet.addHeader("Accept", "application/vnd.gradle.build-cache-artifact.v1, */*");
                this.addDiagnosticHeaders((HttpMessage)httpGet);
                response = null;
                response = this.httpClientHelper.performHttpRequest((HttpRequestBase)httpGet);
                statusLine = response.getStatusLine();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Response for GET {}: {}", (Object)HttpBuildCacheService.safeUri(uri), (Object)statusLine);
                }
                if (!this.isHttpSuccess(statusCode = statusLine.getStatusCode())) break block7;
                reader.readFrom(response.getEntity().getContent());
                boolean bl2 = true;
                HttpClientUtils.closeQuietly((CloseableHttpResponse)response);
                return bl2;
            }
            if (statusCode != 404) break block8;
            boolean bl3 = false;
            HttpClientUtils.closeQuietly((CloseableHttpResponse)response);
            return bl3;
        }
        try {
            bl = this.throwHttpStatusCodeException(statusCode, String.format("Loading entry from '%s' response status %d: %s", HttpBuildCacheService.safeUri(uri), statusCode, statusLine.getReasonPhrase()));
        }
        catch (IOException e) {
            try {
                throw new BuildCacheException(String.format("Unable to load entry from '%s': %s", HttpBuildCacheService.safeUri(uri), e.getMessage()), (Throwable)e);
            }
            catch (Throwable throwable) {
                HttpClientUtils.closeQuietly(response);
                throw throwable;
            }
        }
        HttpClientUtils.closeQuietly((CloseableHttpResponse)response);
        return bl;
    }

    private void addDiagnosticHeaders(HttpMessage request) {
        request.addHeader("X-Gradle-Version", GradleVersion.current().getVersion());
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void store(BuildCacheKey key, final BuildCacheEntryWriter output) throws BuildCacheException {
        URI uri = this.root.resolve(key.getHashCode());
        HttpPut httpPut = new HttpPut(uri);
        httpPut.addHeader("Content-Type", BUILD_CACHE_CONTENT_TYPE);
        this.addDiagnosticHeaders((HttpMessage)httpPut);
        httpPut.setEntity((HttpEntity)new AbstractHttpEntity(){

            public boolean isRepeatable() {
                return true;
            }

            public long getContentLength() {
                return output.getSize();
            }

            public InputStream getContent() throws IOException, UnsupportedOperationException {
                throw new UnsupportedOperationException();
            }

            public void writeTo(OutputStream outstream) throws IOException {
                output.writeTo(outstream);
            }

            public boolean isStreaming() {
                return false;
            }
        });
        CloseableHttpResponse response = null;
        try {
            int statusCode;
            response = this.httpClientHelper.performHttpRequest((HttpRequestBase)httpPut);
            StatusLine statusLine = response.getStatusLine();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Response for PUT {}: {}", (Object)HttpBuildCacheService.safeUri(uri), (Object)statusLine);
            }
            if (!this.isHttpSuccess(statusCode = statusLine.getStatusCode())) {
                this.throwHttpStatusCodeException(statusCode, String.format("Storing entry at '%s' response status %d: %s", HttpBuildCacheService.safeUri(uri), statusCode, statusLine.getReasonPhrase()));
            }
        }
        catch (UnknownHostException e) {
            try {
                throw new UncheckedException((Throwable)e);
                catch (IOException e2) {
                    throw new BuildCacheException(String.format("Unable to store entry at '%s': %s", HttpBuildCacheService.safeUri(uri), e2.getMessage()), (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                HttpClientUtils.closeQuietly(response);
                throw throwable;
            }
        }
        HttpClientUtils.closeQuietly((CloseableHttpResponse)response);
    }

    private boolean isHttpSuccess(int statusCode) {
        return statusCode >= 200 && statusCode < 300;
    }

    private boolean throwHttpStatusCodeException(int statusCode, String message) {
        if (FATAL_HTTP_ERROR_CODES.contains(statusCode)) {
            throw new UncheckedIOException(message);
        }
        throw new BuildCacheException(message);
    }

    public void close() throws IOException {
        this.httpClientHelper.close();
    }

    private static URI safeUri(URI uri) {
        try {
            return new URI(uri.getScheme(), null, uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
        }
        catch (URISyntaxException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }
}

