/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.cpp.internal;

import java.io.File;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.attributes.Usage;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.file.TemporaryFileProvider;
import org.gradle.api.internal.file.collections.FileCollectionAdapter;
import org.gradle.api.internal.file.collections.MinimalFileSet;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.language.cpp.CppBinary;
import org.gradle.language.cpp.internal.NativeDependencyCache;
import org.gradle.language.nativeplatform.internal.Names;

public class DefaultCppBinary
implements CppBinary {
    private final String name;
    private final Provider<String> baseName;
    private final boolean debuggable;
    private final FileCollection sourceFiles;
    private final FileCollection includePath;
    private final FileCollection linkLibraries;
    private final FileCollection runtimeLibraries;
    private final DirectoryProperty objectsDir;

    public DefaultCppBinary(String name, ProjectLayout projectLayout, ObjectFactory objects, Provider<String> baseName, boolean debuggable, FileCollection sourceFiles, FileCollection componentHeaderDirs, ConfigurationContainer configurations, Configuration implementation) {
        this.name = name;
        this.baseName = baseName;
        this.debuggable = debuggable;
        this.sourceFiles = sourceFiles;
        this.objectsDir = projectLayout.directoryProperty();
        Names names = Names.of(name);
        Configuration includePathConfig = (Configuration)configurations.maybeCreate(names.withPrefix("cppCompile"));
        includePathConfig.setCanBeConsumed(false);
        includePathConfig.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)objects.named(Usage.class, "cplusplus-api"));
        includePathConfig.getAttributes().attribute(DEBUGGABLE_ATTRIBUTE, (Object)debuggable);
        Configuration nativeLink = (Configuration)configurations.maybeCreate(names.withPrefix("nativeLink"));
        nativeLink.setCanBeConsumed(false);
        nativeLink.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)objects.named(Usage.class, "native-link"));
        nativeLink.getAttributes().attribute(DEBUGGABLE_ATTRIBUTE, (Object)debuggable);
        Configuration nativeRuntime = (Configuration)configurations.maybeCreate(names.withPrefix("nativeRuntime"));
        nativeRuntime.setCanBeConsumed(false);
        nativeRuntime.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)objects.named(Usage.class, "native-runtime"));
        nativeRuntime.getAttributes().attribute(DEBUGGABLE_ATTRIBUTE, (Object)debuggable);
        includePathConfig.extendsFrom(new Configuration[]{implementation});
        nativeLink.extendsFrom(new Configuration[]{implementation});
        nativeRuntime.extendsFrom(new Configuration[]{implementation});
        this.includePath = componentHeaderDirs.plus((FileCollection)new FileCollectionAdapter((MinimalFileSet)new IncludePath(includePathConfig)));
        this.linkLibraries = nativeLink;
        this.runtimeLibraries = nativeRuntime;
    }

    @Inject
    protected FileOperations getFileOperations() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected TemporaryFileProvider getTemporaryFileProvider() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected NativeDependencyCache getNativeDependencyCache() {
        throw new UnsupportedOperationException();
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Provider<String> getBaseName() {
        return this.baseName;
    }

    @Override
    public boolean isDebuggable() {
        return this.debuggable;
    }

    @Override
    public FileCollection getCppSource() {
        return this.sourceFiles;
    }

    @Override
    public FileCollection getCompileIncludePath() {
        return this.includePath;
    }

    @Override
    public FileCollection getLinkLibraries() {
        return this.linkLibraries;
    }

    @Override
    public FileCollection getRuntimeLibraries() {
        return this.runtimeLibraries;
    }

    public DirectoryProperty getObjectsDir() {
        return this.objectsDir;
    }

    @Override
    public FileCollection getObjects() {
        return this.objectsDir.getAsFileTree().matching((PatternFilterable)new PatternSet().include(new String[]{"**/*.obj", "**/*.o"}));
    }

    private class IncludePath
    implements MinimalFileSet {
        private final Configuration includePathConfig;
        private Set<File> result;

        IncludePath(Configuration includePathConfig) {
            this.includePathConfig = includePathConfig;
        }

        public String getDisplayName() {
            return "Include path for " + DefaultCppBinary.this.toString();
        }

        public Set<File> getFiles() {
            if (this.result == null) {
                ArtifactCollection artifacts = this.includePathConfig.getIncoming().getArtifacts();
                LinkedHashSet<File> files = new LinkedHashSet<File>();
                if (!artifacts.getArtifacts().isEmpty()) {
                    NativeDependencyCache cache = DefaultCppBinary.this.getNativeDependencyCache();
                    for (ResolvedArtifactResult artifact : artifacts) {
                        if (artifact.getId().getComponentIdentifier() instanceof ModuleComponentIdentifier) {
                            ModuleComponentIdentifier id = (ModuleComponentIdentifier)artifact.getId().getComponentIdentifier();
                            File headerDir = cache.getUnpackedHeaders(artifact.getFile(), id.getModule() + "-" + id.getVersion());
                            files.add(headerDir);
                            continue;
                        }
                        files.add(artifact.getFile());
                    }
                }
                this.result = files;
            }
            return this.result;
        }
    }
}

