/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.nativeplatform.internal.incremental.sourceparser;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.gradle.api.UncheckedIOException;
import org.gradle.language.nativeplatform.internal.Include;
import org.gradle.language.nativeplatform.internal.IncludeDirectives;
import org.gradle.language.nativeplatform.internal.IncludeType;
import org.gradle.language.nativeplatform.internal.Macro;
import org.gradle.language.nativeplatform.internal.MacroFunction;
import org.gradle.language.nativeplatform.internal.incremental.sourceparser.CSourceParser;
import org.gradle.language.nativeplatform.internal.incremental.sourceparser.DefaultInclude;
import org.gradle.language.nativeplatform.internal.incremental.sourceparser.DefaultIncludeDirectives;
import org.gradle.language.nativeplatform.internal.incremental.sourceparser.DefaultMacro;
import org.gradle.language.nativeplatform.internal.incremental.sourceparser.DefaultMacroFunction;
import org.gradle.language.nativeplatform.internal.incremental.sourceparser.PreprocessingReader;
import org.gradle.language.nativeplatform.internal.incremental.sourceparser.UnresolveableMacro;
import org.gradle.language.nativeplatform.internal.incremental.sourceparser.UnresolveableMacroFunction;

public class RegexBackedCSourceParser
implements CSourceParser {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IncludeDirectives parseSource(File sourceFile) {
        ArrayList includes = Lists.newArrayList();
        ArrayList macros = Lists.newArrayList();
        ArrayList macroFunctions = Lists.newArrayList();
        try {
            BufferedReader bf = new BufferedReader((Reader)((Object)new PreprocessingReader(new BufferedReader(new FileReader(sourceFile)))));
            try {
                String line;
                while ((line = bf.readLine()) != null) {
                    int pos = RegexBackedCSourceParser.consumeWhitespace(line, 0);
                    if (pos < line.length() && line.charAt(pos) != '#') continue;
                    ++pos;
                    if ((pos = RegexBackedCSourceParser.consumeWhitespace(line, pos)) == line.length()) continue;
                    if (line.startsWith("define", pos)) {
                        this.consumeDefine(line, pos += 6, macros, macroFunctions);
                        continue;
                    }
                    if (line.startsWith("include", pos)) {
                        this.consumeIncludeOrImport(line, pos += 7, false, includes);
                        continue;
                    }
                    if (!line.startsWith("import", pos)) continue;
                    this.consumeIncludeOrImport(line, pos += 6, true, includes);
                }
            }
            finally {
                IOUtils.closeQuietly((Reader)bf);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
        return new DefaultIncludeDirectives((ImmutableList<Include>)ImmutableList.copyOf((Collection)includes), (ImmutableList<Macro>)ImmutableList.copyOf((Collection)macros), (ImmutableList<MacroFunction>)ImmutableList.copyOf((Collection)macroFunctions));
    }

    private void consumeIncludeOrImport(String line, int startPos, boolean isImport, List<Include> includes) {
        if (startPos == line.length()) {
            return;
        }
        if (RegexBackedCSourceParser.consumeIdentifier(line, startPos) != startPos) {
            return;
        }
        int startValue = RegexBackedCSourceParser.consumeWhitespace(line, startPos);
        String value = line.substring(startValue).trim();
        if (value.isEmpty()) {
            return;
        }
        includes.add(DefaultInclude.parse(value, isImport));
    }

    private void consumeDefine(String line, int startPos, List<Macro> macros, List<MacroFunction> macroFunctions) {
        int startName = RegexBackedCSourceParser.consumeWhitespace(line, startPos);
        if (startName == startPos) {
            return;
        }
        int endName = RegexBackedCSourceParser.consumeIdentifier(line, startName);
        if (endName == startName) {
            return;
        }
        String name = line.substring(startName, endName);
        if (endName < line.length() && line.charAt(endName) == '(') {
            int parameters;
            int pos;
            block13: {
                pos = RegexBackedCSourceParser.consumeWhitespace(line, endName + 1);
                int next = RegexBackedCSourceParser.consumeIdentifier(line, pos);
                parameters = 0;
                if (next != pos) {
                    do {
                        ++parameters;
                        pos = RegexBackedCSourceParser.consumeWhitespace(line, next);
                        if (pos == line.length()) {
                            return;
                        }
                        if (line.charAt(pos) == ')') break block13;
                        if (line.charAt(pos) != ',') {
                            return;
                        }
                        ++pos;
                    } while ((next = RegexBackedCSourceParser.consumeIdentifier(line, pos = RegexBackedCSourceParser.consumeWhitespace(line, pos))) != pos);
                    return;
                }
            }
            if ((pos = RegexBackedCSourceParser.consumeWhitespace(line, pos)) == line.length() || line.charAt(pos) != ')') {
                return;
            }
            int endArgs = pos + 1;
            String value = line.substring(endArgs).trim();
            Include include = DefaultInclude.parse(value, false);
            if (include.getType() == IncludeType.OTHER) {
                macroFunctions.add(new UnresolveableMacroFunction(name, parameters));
            } else {
                macroFunctions.add(new DefaultMacroFunction(name, parameters, include.getType(), include.getValue()));
            }
        } else {
            String value = line.substring(endName).trim();
            Include include = DefaultInclude.parse(value, false);
            if (include.getType() == IncludeType.OTHER) {
                macros.add(new UnresolveableMacro(name));
            } else {
                macros.add(new DefaultMacro(name, include.getType(), include.getValue()));
            }
        }
    }

    static int consumeIdentifier(CharSequence value, int startOffset) {
        char ch;
        int pos;
        for (pos = startOffset; pos < value.length() && (Character.isLetterOrDigit(ch = value.charAt(pos)) || ch == '_' || ch == '$'); ++pos) {
        }
        return pos;
    }

    static int consumeWhitespace(CharSequence value, int startOffset) {
        char ch;
        int pos;
        for (pos = startOffset; pos < value.length() && (Character.isWhitespace(ch = value.charAt(pos)) || ch == '\u0000'); ++pos) {
        }
        return pos;
    }
}

