/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer.connection;

import java.io.IOException;
import org.gradle.api.UncheckedIOException;
import org.gradle.tooling.BuildAction;
import org.gradle.tooling.internal.consumer.TestExecutionRequest;
import org.gradle.tooling.internal.consumer.connection.ConsumerConnection;
import org.gradle.tooling.internal.consumer.parameters.ConsumerOperationParameters;
import org.gradle.tooling.internal.consumer.versioning.VersionDetails;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeprecatedVersionConsumerConnection
implements ConsumerConnection {
    private static final String DEPRECATION_WARNING = "Support for builds using Gradle older than 2.6 was deprecated and will be removed in 5.0. You are currently using Gradle version %s. You should upgrade your Gradle build to use Gradle 2.6 or later.\n";
    private final ConsumerConnection delegate;
    private final String providerVersion;

    public DeprecatedVersionConsumerConnection(ConsumerConnection delegate, VersionDetails versionDetails) {
        this.delegate = delegate;
        this.providerVersion = versionDetails.getVersion();
    }

    @Override
    public void stop() {
        this.delegate.stop();
    }

    @Override
    public String getDisplayName() {
        return this.delegate.getDisplayName();
    }

    @Override
    public <T> T run(Class<T> type, ConsumerOperationParameters operationParameters) throws UnsupportedOperationException, IllegalStateException {
        this.outputDeprecationMessage(operationParameters);
        return this.delegate.run(type, operationParameters);
    }

    @Override
    public <T> T run(BuildAction<T> action, ConsumerOperationParameters operationParameters) throws UnsupportedOperationException, IllegalStateException {
        this.outputDeprecationMessage(operationParameters);
        return this.delegate.run(action, operationParameters);
    }

    @Override
    public void runTests(TestExecutionRequest testExecutionRequest, ConsumerOperationParameters operationParameters) {
        this.outputDeprecationMessage(operationParameters);
        this.delegate.runTests(testExecutionRequest, operationParameters);
    }

    private void outputDeprecationMessage(ConsumerOperationParameters parameters) {
        if (parameters.getStandardOutput() != null) {
            try {
                parameters.getStandardOutput().write(DeprecatedVersionConsumerConnection.createDeprecationMessage(this.providerVersion).getBytes());
            }
            catch (IOException e) {
                throw new UncheckedIOException((Throwable)e);
            }
        }
    }

    private static String createDeprecationMessage(String currentVersion) {
        return String.format(DEPRECATION_WARNING, currentVersion);
    }
}

