/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import groovy.lang.Closure;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.RandomAccess;
import java.util.Set;
import java.util.concurrent.Callable;
import org.gradle.api.Buildable;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Task;
import org.gradle.api.internal.tasks.AbstractTaskDependency;
import org.gradle.api.internal.tasks.RealizableTaskCollection;
import org.gradle.api.internal.tasks.TaskDependencyContainer;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.internal.tasks.TaskResolver;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.api.tasks.TaskReference;
import org.gradle.internal.typeconversion.UnsupportedNotationException;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTaskDependency
extends AbstractTaskDependency {
    private Set<Object> values;
    private final TaskResolver resolver;

    public DefaultTaskDependency() {
        this(null);
    }

    public DefaultTaskDependency(TaskResolver resolver) {
        this.resolver = resolver;
    }

    @Override
    public void visitDependencies(TaskDependencyResolveContext context) {
        if (this.getValues().isEmpty()) {
            return;
        }
        ArrayDeque<Object> queue = new ArrayDeque<Object>(this.getValues());
        while (!queue.isEmpty()) {
            ArrayList<String> formats;
            Object dependency = queue.removeFirst();
            if (dependency instanceof Buildable) {
                context.add(dependency);
                continue;
            }
            if (dependency instanceof Task) {
                context.add(dependency);
                continue;
            }
            if (dependency instanceof TaskDependency) {
                context.add(dependency);
                continue;
            }
            if (dependency instanceof Closure) {
                Closure closure = (Closure)dependency;
                Object closureResult = closure.call((Object)context.getTask());
                if (closureResult == null) continue;
                queue.addFirst(closureResult);
                continue;
            }
            if (dependency instanceof RealizableTaskCollection) {
                RealizableTaskCollection realizableTaskCollection = (RealizableTaskCollection)dependency;
                realizableTaskCollection.realizeRuleTaskTypes();
                DefaultTaskDependency.addAllFirst(queue, realizableTaskCollection.toArray());
                continue;
            }
            if (dependency instanceof List) {
                List list = (List)dependency;
                if (list instanceof RandomAccess) {
                    for (int i = list.size() - 1; i >= 0; --i) {
                        queue.addFirst(list.get(i));
                    }
                    continue;
                }
                ListIterator iterator = list.listIterator(list.size());
                while (iterator.hasPrevious()) {
                    Object item = iterator.previous();
                    queue.addFirst(item);
                }
                continue;
            }
            if (dependency instanceof Iterable) {
                Iterable iterable = (Iterable)dependency;
                DefaultTaskDependency.addAllFirst(queue, Iterables.toArray((Iterable)iterable, Object.class));
                continue;
            }
            if (dependency instanceof Map) {
                Map map = (Map)dependency;
                DefaultTaskDependency.addAllFirst(queue, map.values().toArray());
                continue;
            }
            if (dependency instanceof Object[]) {
                Object[] array = (Object[])dependency;
                DefaultTaskDependency.addAllFirst(queue, array);
                continue;
            }
            if (dependency instanceof Callable) {
                Callable callable = (Callable)dependency;
                Object callableResult = GUtil.uncheckedCall((Callable)callable);
                if (callableResult == null) continue;
                queue.addFirst(callableResult);
                continue;
            }
            if (this.resolver != null && dependency instanceof TaskReference) {
                context.add(this.resolver.resolveTask((TaskReference)dependency));
                continue;
            }
            if (this.resolver != null && dependency instanceof CharSequence) {
                context.add(this.resolver.resolveTask(dependency.toString()));
                continue;
            }
            if (dependency instanceof TaskDependencyContainer) {
                ((TaskDependencyContainer)dependency).visitDependencies(context);
                continue;
            }
            if (dependency instanceof Provider) {
                formats = new ArrayList<String>();
                formats.add("A RegularFileProperty");
                formats.add("A DirectoryProperty");
                throw new UnsupportedNotationException(dependency, String.format("Cannot convert Provider %s to a task.", dependency), null, formats);
            }
            formats = new ArrayList();
            if (this.resolver != null) {
                formats.add("A String or CharSequence task name or path");
                formats.add("A TaskReference instance");
            }
            formats.add("A Task instance");
            formats.add("A Buildable instance");
            formats.add("A TaskDependency instance");
            formats.add("A RegularFileProperty or DirectoryProperty instance");
            formats.add("A Closure instance that returns any of the above types");
            formats.add("A Callable instance that returns any of the above types");
            formats.add("An Iterable, Collection, Map or array instance that contains any of the above types");
            throw new UnsupportedNotationException(dependency, String.format("Cannot convert %s to a task.", dependency), null, formats);
        }
    }

    private static void addAllFirst(Deque<Object> queue, Object[] items) {
        for (int i = items.length - 1; i >= 0; --i) {
            queue.addFirst(items[i]);
        }
    }

    public Set<Object> getValues() {
        if (this.values == null) {
            this.values = Sets.newHashSet();
        }
        return this.values;
    }

    public void setValues(Iterable<?> values) {
        this.getValues().clear();
        for (Object value : values) {
            this.addValue(value);
        }
    }

    public DefaultTaskDependency add(Object ... values) {
        for (Object value : values) {
            this.addValue(value);
        }
        return this;
    }

    private void addValue(Object dependency) {
        if (dependency == null) {
            throw new InvalidUserDataException("A dependency must not be empty");
        }
        this.getValues().add(dependency);
    }
}

