/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.vcs.git.internal;

import com.google.common.collect.Sets;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.transport.URIish;
import org.gradle.api.GradleException;
import org.gradle.vcs.VersionControlSpec;
import org.gradle.vcs.VersionControlSystem;
import org.gradle.vcs.VersionRef;
import org.gradle.vcs.git.GitVersionControlSpec;
import org.gradle.vcs.git.internal.GitVersionRef;

public class GitVersionControlSystem
implements VersionControlSystem {
    public File populate(File versionDir, VersionRef ref, VersionControlSpec spec) {
        GitVersionControlSpec gitSpec = GitVersionControlSystem.cast(spec);
        File workingDir = new File(versionDir, gitSpec.getRepoName());
        File dbDir = new File(workingDir, ".git");
        if (dbDir.exists() && dbDir.isDirectory()) {
            GitVersionControlSystem.updateRepo(workingDir, gitSpec);
        } else {
            GitVersionControlSystem.cloneRepo(workingDir, gitSpec);
        }
        return workingDir;
    }

    public Set<VersionRef> getAvailableVersions(VersionControlSpec spec) {
        Collection refs;
        GitVersionControlSpec gitSpec = GitVersionControlSystem.cast(spec);
        try {
            refs = Git.lsRemoteRepository().setRemote(GitVersionControlSystem.normalizeUri(gitSpec.getUrl())).call();
        }
        catch (URISyntaxException e) {
            throw GitVersionControlSystem.wrapGitCommandException("ls-remote", gitSpec.getUrl(), null, e);
        }
        catch (GitAPIException e) {
            throw GitVersionControlSystem.wrapGitCommandException("ls-remote", gitSpec.getUrl(), null, (Exception)((Object)e));
        }
        HashSet versions = Sets.newHashSet();
        for (Ref ref : refs) {
            versions.add(GitVersionRef.from(ref));
        }
        return versions;
    }

    private static void cloneRepo(File workingDir, GitVersionControlSpec gitSpec) {
        CloneCommand clone = Git.cloneRepository().setURI(gitSpec.getUrl().toString()).setDirectory(workingDir);
        try (Git git = null;){
            git = clone.call();
        }
    }

    private static void updateRepo(File workingDir, GitVersionControlSpec gitSpec) {
        try (Git git = null;){
            git = Git.open((File)workingDir);
            git.pull().setRemote(GitVersionControlSystem.getRemoteForUrl(git.getRepository(), gitSpec.getUrl())).call();
        }
    }

    private static String getRemoteForUrl(Repository repository, URI url) throws URISyntaxException {
        StoredConfig config = repository.getConfig();
        Set remotes = config.getSubsections("remote");
        HashSet<String> foundUrls = new HashSet<String>();
        String normalizedUrl = GitVersionControlSystem.normalizeUri(url);
        for (String remote : remotes) {
            String remoteUrl = config.getString("remote", remote, "url");
            if (remoteUrl.equals(normalizedUrl)) {
                return remote;
            }
            foundUrls.add(remoteUrl);
        }
        throw new GradleException(String.format("Could not find remote with url: %s. Found: %s", url, foundUrls));
    }

    private static String normalizeUri(URI uri) throws URISyntaxException {
        return new URIish(uri.toString()).toString();
    }

    private static GitVersionControlSpec cast(VersionControlSpec spec) {
        if (!(spec instanceof GitVersionControlSpec)) {
            throw new IllegalArgumentException("The GitVersionControlSystem can only handle GitVersionControlSpec instances.");
        }
        return (GitVersionControlSpec)spec;
    }

    private static GradleException wrapGitCommandException(String commandName, URI repoUrl, File workingDir, Exception e) {
        if (workingDir == null) {
            return new GradleException(String.format("Could not run %s for %s", commandName, repoUrl), (Throwable)e);
        }
        return new GradleException(String.format("Could not %s from %s in %s", commandName, repoUrl, workingDir), (Throwable)e);
    }
}

