/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.io.File;
import org.gradle.cache.CacheBuilder;
import org.gradle.cache.CacheOpenException;
import org.gradle.cache.FileLock;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.LockOptions;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.cache.PersistentIndexedCacheParameters;
import org.gradle.cache.internal.CacheCleanupAction;
import org.gradle.cache.internal.CacheCoordinator;
import org.gradle.cache.internal.CacheInitializationAction;
import org.gradle.cache.internal.DefaultCacheAccess;
import org.gradle.cache.internal.ReferencablePersistentCache;
import org.gradle.internal.Factory;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.serialize.Serializer;
import org.gradle.util.GFileUtils;

public class DefaultPersistentDirectoryStore
implements ReferencablePersistentCache {
    private final File dir;
    private final CacheBuilder.LockTarget lockTarget;
    private final LockOptions lockOptions;
    private final FileLockManager lockManager;
    private final ExecutorFactory executorFactory;
    private final String displayName;
    protected final File propertiesFile;
    protected final File gcFile;
    private CacheCoordinator cacheAccess;

    public DefaultPersistentDirectoryStore(File dir, String displayName, CacheBuilder.LockTarget lockTarget, LockOptions lockOptions, FileLockManager fileLockManager, ExecutorFactory executorFactory) {
        this.dir = dir;
        this.lockTarget = lockTarget;
        this.lockOptions = lockOptions;
        this.lockManager = fileLockManager;
        this.executorFactory = executorFactory;
        this.propertiesFile = new File(dir, "cache.properties");
        this.gcFile = new File(dir, "gc.properties");
        this.displayName = displayName != null ? displayName + " (" + dir + ")" : "cache directory " + dir.getName() + " (" + dir + ")";
    }

    @Override
    public DefaultPersistentDirectoryStore open() {
        GFileUtils.mkdirs((File)this.dir);
        this.cacheAccess = this.createCacheAccess();
        try {
            this.cacheAccess.open();
        }
        catch (Throwable e) {
            throw new CacheOpenException(String.format("Could not open %s.", this), e);
        }
        return this;
    }

    private CacheCoordinator createCacheAccess() {
        return new DefaultCacheAccess(this.displayName, this.getLockTarget(), this.lockOptions, this.dir, this.lockManager, this.getInitAction(), this.getCleanupAction(), this.executorFactory);
    }

    private File getLockTarget() {
        switch (this.lockTarget) {
            case CacheDirectory: 
            case DefaultTarget: {
                return this.dir;
            }
            case CachePropertiesFile: {
                return this.propertiesFile;
            }
        }
        throw new IllegalArgumentException("Unsupported lock target: " + (Object)((Object)this.lockTarget));
    }

    protected CacheInitializationAction getInitAction() {
        return new CacheInitializationAction(){

            @Override
            public boolean requiresInitialization(FileLock fileLock) {
                return false;
            }

            @Override
            public void initialize(FileLock fileLock) {
                throw new UnsupportedOperationException();
            }
        };
    }

    protected CacheCleanupAction getCleanupAction() {
        return new CacheCleanupAction(){

            @Override
            public boolean requiresCleanup() {
                return false;
            }

            @Override
            public void cleanup() {
                throw new UnsupportedOperationException();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.cacheAccess != null) {
            try {
                this.cacheAccess.close();
            }
            finally {
                this.cacheAccess = null;
            }
        }
    }

    @Override
    public File getBaseDir() {
        return this.dir;
    }

    public String toString() {
        return this.displayName;
    }

    @Override
    public <K, V> PersistentIndexedCache<K, V> createCache(PersistentIndexedCacheParameters<K, V> parameters) {
        return this.cacheAccess.newCache(parameters);
    }

    @Override
    public <K, V> PersistentIndexedCache<K, V> createCache(String name, Class<K> keyType, Serializer<V> valueSerializer) {
        return this.cacheAccess.newCache(new PersistentIndexedCacheParameters<K, V>(name, keyType, valueSerializer));
    }

    @Override
    public <T> T withFileLock(Factory<? extends T> action) {
        return this.cacheAccess.withFileLock(action);
    }

    @Override
    public void withFileLock(Runnable action) {
        this.cacheAccess.withFileLock(action);
    }

    @Override
    public <T> T useCache(Factory<? extends T> action) {
        return this.cacheAccess.useCache(action);
    }

    @Override
    public void useCache(Runnable action) {
        this.cacheAccess.useCache(action);
    }
}

