/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.controller;

import javax.annotation.Nullable;
import org.gradle.caching.internal.controller.BuildCacheController;
import org.gradle.caching.internal.controller.BuildCacheLoadCommand;
import org.gradle.caching.internal.controller.BuildCacheStoreCommand;

public class RootBuildCacheControllerRef {
    private BuildCacheController buildCacheController;

    public void set(BuildCacheController buildCacheController) {
        this.buildCacheController = new CloseShieldBuildCacheController(buildCacheController);
    }

    public BuildCacheController getForNonRootBuild() {
        if (!this.isSet()) {
            throw new IllegalStateException("Root build cache controller not yet assigned");
        }
        return this.buildCacheController;
    }

    public boolean isSet() {
        return this.buildCacheController != null;
    }

    private static class CloseShieldBuildCacheController
    implements BuildCacheController {
        private final BuildCacheController delegate;

        private CloseShieldBuildCacheController(BuildCacheController delegate) {
            this.delegate = delegate;
        }

        @Override
        @Nullable
        public <T> T load(BuildCacheLoadCommand<T> command) {
            return this.delegate.load(command);
        }

        @Override
        public void store(BuildCacheStoreCommand command) {
            this.delegate.store(command);
        }

        @Override
        public void close() {
        }
    }
}

