/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.processing;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Set;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import org.gradle.api.internal.tasks.compile.incremental.processing.AnnotationProcessingResult;
import org.gradle.api.internal.tasks.compile.processing.AggregatingFiler;
import org.gradle.api.internal.tasks.compile.processing.DelegatingProcessor;
import org.gradle.api.internal.tasks.compile.processing.ElementUtils;
import org.gradle.api.internal.tasks.compile.processing.IncrementalProcessingEnvironment;

public final class AggregatingProcessor
extends DelegatingProcessor {
    private final AnnotationProcessingResult result;
    private Messager messager;

    public AggregatingProcessor(Processor delegate, AnnotationProcessingResult result) {
        super(delegate);
        this.result = result;
    }

    @Override
    public final void init(ProcessingEnvironment processingEnv) {
        this.messager = processingEnv.getMessager();
        AggregatingFiler incrementalFiler = new AggregatingFiler(processingEnv.getFiler(), this.result, this.messager);
        IncrementalProcessingEnvironment incrementalProcessingEnvironment = new IncrementalProcessingEnvironment(processingEnv, incrementalFiler);
        super.init(incrementalProcessingEnvironment);
    }

    @Override
    public final boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.validateAnnotations(annotations);
        this.recordAggregatedTypes(annotations, roundEnv);
        return super.process(annotations, roundEnv);
    }

    private void validateAnnotations(Set<? extends TypeElement> annotations) {
        for (TypeElement typeElement : annotations) {
            Retention retention = typeElement.getAnnotation(Retention.class);
            if (retention == null || retention.value() != RetentionPolicy.SOURCE) continue;
            this.messager.printMessage(Diagnostic.Kind.ERROR, "'@" + typeElement.getSimpleName() + "' has source retention. Aggregating annotation processors require class or runtime retention.");
        }
    }

    private void recordAggregatedTypes(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (this.getSupportedAnnotationTypes().contains("*")) {
            this.result.getAggregatedTypes().addAll(ElementUtils.getTopLevelTypeNames(roundEnv.getRootElements()));
        } else {
            for (TypeElement typeElement : annotations) {
                this.result.getAggregatedTypes().addAll(ElementUtils.getTopLevelTypeNames(roundEnv.getElementsAnnotatedWith(typeElement)));
            }
        }
    }
}

