/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts;

import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.LibraryComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentSelector;
import org.gradle.api.internal.artifacts.ComponentSelectorConverter;
import org.gradle.api.internal.artifacts.DefaultModuleVersionSelector;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.component.ComponentIdentifierFactory;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.LocalComponentRegistry;
import org.gradle.internal.component.local.model.LocalComponentMetadata;
import org.gradle.util.GUtil;

public class DefaultComponentSelectorConverter
implements ComponentSelectorConverter {
    private static final ModuleVersionSelector UNKNOWN_MODULE_VERSION_SELECTOR = DefaultModuleVersionSelector.newSelector("", "unknown", "");
    private final ImmutableModuleIdentifierFactory moduleIdentifierFactory;
    private final ComponentIdentifierFactory componentIdentifierFactory;
    private final LocalComponentRegistry localComponentRegistry;

    public DefaultComponentSelectorConverter(ImmutableModuleIdentifierFactory moduleIdentifierFactory, ComponentIdentifierFactory componentIdentifierFactory, LocalComponentRegistry localComponentRegistry) {
        this.moduleIdentifierFactory = moduleIdentifierFactory;
        this.componentIdentifierFactory = componentIdentifierFactory;
        this.localComponentRegistry = localComponentRegistry;
    }

    @Override
    public ModuleIdentifier getModule(ComponentSelector componentSelector) {
        if (componentSelector instanceof ModuleComponentSelector) {
            ModuleComponentSelector module = (ModuleComponentSelector)componentSelector;
            return this.moduleIdentifierFactory.module(module.getGroup(), module.getModule());
        }
        ModuleVersionSelector moduleVersionSelector = this.getSelector(componentSelector);
        return this.moduleIdentifierFactory.module(moduleVersionSelector.getGroup(), moduleVersionSelector.getName());
    }

    @Override
    public ModuleVersionSelector getSelector(ComponentSelector selector) {
        ProjectComponentSelector projectSelector;
        ProjectComponentIdentifier projectId;
        LocalComponentMetadata projectComponent;
        if (selector instanceof ModuleComponentSelector) {
            return DefaultModuleVersionSelector.newSelector((ModuleComponentSelector)selector);
        }
        if (selector instanceof ProjectComponentSelector && (projectComponent = this.localComponentRegistry.getComponent(projectId = this.componentIdentifierFactory.createProjectComponentIdentifier(projectSelector = (ProjectComponentSelector)selector))) != null) {
            ModuleVersionIdentifier moduleVersionId = projectComponent.getModuleVersionId();
            return DefaultModuleVersionSelector.newSelector(moduleVersionId.getGroup(), moduleVersionId.getName(), moduleVersionId.getVersion());
        }
        if (selector instanceof LibraryComponentSelector) {
            LibraryComponentSelector libraryComponentSelector = (LibraryComponentSelector)selector;
            String libraryName = (String)GUtil.elvis((Object)libraryComponentSelector.getLibraryName(), (Object)"");
            return DefaultModuleVersionSelector.newSelector(libraryComponentSelector.getProjectPath(), libraryName, "undefined");
        }
        return UNKNOWN_MODULE_VERSION_SELECTOR;
    }
}

