/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer.async;

import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.concurrent.ManagedExecutor;
import org.gradle.internal.concurrent.ServiceLifecycle;
import org.gradle.tooling.internal.consumer.async.AsyncConsumerActionExecutor;
import org.gradle.tooling.internal.consumer.connection.ConsumerAction;
import org.gradle.tooling.internal.consumer.connection.ConsumerActionExecutor;
import org.gradle.tooling.internal.protocol.ResultHandlerVersion1;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultAsyncConsumerActionExecutor
implements AsyncConsumerActionExecutor {
    private final ConsumerActionExecutor actionExecutor;
    private final ManagedExecutor executor;
    private final ServiceLifecycle lifecycle;

    public DefaultAsyncConsumerActionExecutor(ConsumerActionExecutor actionExecutor, ExecutorFactory executorFactory) {
        this.actionExecutor = actionExecutor;
        this.executor = executorFactory.create("Connection worker");
        this.lifecycle = new ServiceLifecycle(actionExecutor.getDisplayName());
    }

    @Override
    public String getDisplayName() {
        return this.actionExecutor.getDisplayName();
    }

    @Override
    public void stop() {
        CompositeStoppable.stoppable((Object[])new Object[]{this.lifecycle, this.executor, this.actionExecutor}).stop();
    }

    @Override
    public <T> void run(final ConsumerAction<? extends T> action, final ResultHandlerVersion1<? super T> handler) {
        this.lifecycle.use(new Runnable(){

            public void run() {
                DefaultAsyncConsumerActionExecutor.this.executor.execute(new Runnable(){

                    public void run() {
                        Object result;
                        try {
                            result = DefaultAsyncConsumerActionExecutor.this.actionExecutor.run(action);
                        }
                        catch (Throwable t) {
                            handler.onFailure(t);
                            return;
                        }
                        handler.onComplete(result);
                    }
                });
            }
        });
    }
}

