/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization.buildsrc;

import java.io.File;
import org.gradle.StartParameter;
import org.gradle.api.internal.BuildDefinition;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.cache.FileLock;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.LockOptions;
import org.gradle.cache.internal.filelock.LockOptionsBuilder;
import org.gradle.initialization.GradleLauncher;
import org.gradle.initialization.NestedBuildFactory;
import org.gradle.initialization.buildsrc.BuildBuildSrcBuildOperationType;
import org.gradle.initialization.buildsrc.BuildSrcBuildListenerFactory;
import org.gradle.initialization.buildsrc.BuildSrcUpdateFactory;
import org.gradle.internal.classpath.CachedClasspathTransformer;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.invocation.BuildController;
import org.gradle.internal.invocation.GradleBuildController;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.CallableBuildOperation;
import org.gradle.plugin.management.internal.DefaultPluginRequests;
import org.gradle.util.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildSourceBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(BuildSourceBuilder.class);
    private static final BuildBuildSrcBuildOperationType.Result BUILD_BUILDSRC_RESULT = new BuildBuildSrcBuildOperationType.Result(){};
    public static final String BUILD_SRC = "buildSrc";
    private final NestedBuildFactory nestedBuildFactory;
    private final ClassLoaderScope classLoaderScope;
    private final FileLockManager fileLockManager;
    private final BuildOperationExecutor buildOperationExecutor;
    private final CachedClasspathTransformer cachedClasspathTransformer;
    private final BuildSrcBuildListenerFactory buildSrcBuildListenerFactory;
    private static final LockOptions LOCK_OPTIONS = LockOptionsBuilder.mode((FileLockManager.LockMode)FileLockManager.LockMode.Exclusive).useCrossVersionImplementation();

    public BuildSourceBuilder(NestedBuildFactory nestedBuildFactory, ClassLoaderScope classLoaderScope, FileLockManager fileLockManager, BuildOperationExecutor buildOperationExecutor, CachedClasspathTransformer cachedClasspathTransformer, BuildSrcBuildListenerFactory buildSrcBuildListenerFactory) {
        this.nestedBuildFactory = nestedBuildFactory;
        this.classLoaderScope = classLoaderScope;
        this.fileLockManager = fileLockManager;
        this.buildOperationExecutor = buildOperationExecutor;
        this.cachedClasspathTransformer = cachedClasspathTransformer;
        this.buildSrcBuildListenerFactory = buildSrcBuildListenerFactory;
    }

    public ClassLoaderScope buildAndCreateClassLoader(GradleInternal gradle, File rootDir, StartParameter containingBuildParameters) {
        File buildSrcDir = new File(rootDir, BUILD_SRC);
        ClassPath classpath = this.createBuildSourceClasspath(gradle, buildSrcDir, containingBuildParameters);
        return this.classLoaderScope.createChild(buildSrcDir.getAbsolutePath()).export(classpath).lock();
    }

    private ClassPath createBuildSourceClasspath(final GradleInternal gradle, File buildSrcDir, StartParameter containingBuildParameters) {
        if (!buildSrcDir.isDirectory()) {
            LOGGER.debug("Gradle source dir does not exist. We leave.");
            return ClassPath.EMPTY;
        }
        StartParameter buildSrcStartParameter = containingBuildParameters.newBuild();
        buildSrcStartParameter.setCurrentDir(buildSrcDir);
        buildSrcStartParameter.setProjectProperties(containingBuildParameters.getProjectProperties());
        buildSrcStartParameter.setSearchUpwards(false);
        buildSrcStartParameter.setProfile(containingBuildParameters.isProfile());
        final BuildDefinition buildDefinition = BuildDefinition.fromStartParameterForBuild(buildSrcStartParameter, buildSrcDir, DefaultPluginRequests.EMPTY);
        assert (buildSrcStartParameter.getBuildFile() == null);
        return (ClassPath)this.buildOperationExecutor.call((CallableBuildOperation)new CallableBuildOperation<ClassPath>(){

            public ClassPath call(BuildOperationContext context) {
                ClassPath classPath = BuildSourceBuilder.this.buildBuildSrc(buildDefinition);
                context.setResult((Object)BUILD_BUILDSRC_RESULT);
                return classPath;
            }

            public BuildOperationDescriptor.Builder description() {
                return BuildOperationDescriptor.displayName((String)"Build buildSrc").progressDisplayName("Building buildSrc").details((Object)new BuildBuildSrcBuildOperationType.Details(){

                    public String getBuildPath() {
                        return gradle.getIdentityPath().toString();
                    }
                });
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassPath buildBuildSrc(BuildDefinition buildDefinition) {
        BuildController buildController = this.createBuildController(buildDefinition);
        try {
            ClassPath classPath;
            File lockTarget = new File(buildDefinition.getBuildRootDir(), ".gradle/noVersion/buildSrc");
            FileLock lock = this.fileLockManager.lock(lockTarget, LOCK_OPTIONS, "buildSrc build lock");
            try {
                classPath = new BuildSrcUpdateFactory(buildController, this.buildSrcBuildListenerFactory, this.cachedClasspathTransformer).create();
            }
            catch (Throwable throwable) {
                lock.close();
                throw throwable;
            }
            lock.close();
            return classPath;
        }
        finally {
            buildController.stop();
        }
    }

    private BuildController createBuildController(BuildDefinition buildDefinition) {
        GradleLauncher gradleLauncher = this.buildGradleLauncher(buildDefinition);
        return new GradleBuildController(gradleLauncher);
    }

    private GradleLauncher buildGradleLauncher(BuildDefinition buildDefinition) {
        GradleLauncher gradleLauncher = this.nestedBuildFactory.nestedInstance(buildDefinition);
        StartParameter startParameter = buildDefinition.getStartParameter();
        GradleInternal build = gradleLauncher.getGradle();
        if (build.getParent().findIdentityPath() == null) {
            Path path = build.getParent().getParent().getIdentityPath().child(startParameter.getCurrentDir().getParentFile().getName()).child(startParameter.getCurrentDir().getName());
            build.setIdentityPath(path);
        }
        return gradleLauncher;
    }
}

