/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testfixtures.internal;

import java.io.File;
import org.gradle.api.Project;
import org.gradle.api.internal.AsmBackedClassGenerator;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.TmpDirTemporaryFileProvider;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.internal.project.DefaultProject;
import org.gradle.api.internal.project.IProjectFactory;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.groovy.scripts.StringScriptSource;
import org.gradle.initialization.DefaultBuildRequestMetaData;
import org.gradle.initialization.DefaultProjectDescriptor;
import org.gradle.initialization.DefaultProjectDescriptorRegistry;
import org.gradle.initialization.LegacyTypesSupport;
import org.gradle.internal.FileUtils;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.internal.logging.services.LoggingServiceRegistry;
import org.gradle.internal.nativeintegration.services.NativeServices;
import org.gradle.internal.resources.DefaultResourceLockCoordinationService;
import org.gradle.internal.resources.ResourceLock;
import org.gradle.internal.resources.ResourceLockCoordinationService;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.ServiceRegistryBuilder;
import org.gradle.internal.service.scopes.BuildSessionScopeServices;
import org.gradle.internal.service.scopes.BuildTreeScopeServices;
import org.gradle.internal.service.scopes.CrossBuildSessionScopeServices;
import org.gradle.internal.service.scopes.GradleUserHomeScopeServiceRegistry;
import org.gradle.internal.service.scopes.ServiceRegistryFactory;
import org.gradle.internal.time.Time;
import org.gradle.internal.work.WorkerLeaseService;
import org.gradle.invocation.DefaultGradle;
import org.gradle.testfixtures.internal.TestBuildScopeServices;
import org.gradle.testfixtures.internal.TestGlobalScopeServices;

public class ProjectBuilderImpl {
    private static ServiceRegistry globalServices;
    private static final AsmBackedClassGenerator CLASS_GENERATOR;

    public Project createChildProject(String name, Project parent, File projectDir) {
        ProjectInternal parentProject = (ProjectInternal)parent;
        projectDir = projectDir != null ? projectDir.getAbsoluteFile() : new File(parentProject.getProjectDir(), name);
        DefaultProject project = CLASS_GENERATOR.newInstance(DefaultProject.class, name, parentProject, projectDir, new File(projectDir, "build.gradle"), new StringScriptSource("test build file", null), parentProject.getGradle(), parentProject.getGradle().getServiceRegistryFactory(), parentProject.getClassLoaderScope().createChild("project-" + name), parentProject.getBaseClassLoaderScope());
        parentProject.addChildProject(project);
        parentProject.getProjectRegistry().addProject(project);
        return project;
    }

    public Project createProject(String name, File inputProjectDir, File gradleUserHomeDir) {
        File projectDir = this.prepareProjectDir(inputProjectDir);
        File homeDir = new File(projectDir, "gradleHome");
        StartParameterInternal startParameter = new StartParameterInternal();
        File userHomeDir = gradleUserHomeDir == null ? new File(projectDir, "userHome") : FileUtils.canonicalize((File)gradleUserHomeDir);
        startParameter.setGradleUserHomeDir(userHomeDir);
        NativeServices.initialize((File)userHomeDir);
        DefaultBuildRequestMetaData buildRequestMetaData = new DefaultBuildRequestMetaData(Time.currentTimeMillis());
        CrossBuildSessionScopeServices crossBuildSessionScopeServices = new CrossBuildSessionScopeServices(this.getGlobalServices(), startParameter);
        ServiceRegistry userHomeServices = this.getUserHomeServices(userHomeDir);
        BuildSessionScopeServices buildSessionScopeServices = new BuildSessionScopeServices(userHomeServices, crossBuildSessionScopeServices, startParameter, buildRequestMetaData, ClassPath.EMPTY);
        BuildTreeScopeServices buildTreeScopeServices = new BuildTreeScopeServices((ServiceRegistry)buildSessionScopeServices);
        TestBuildScopeServices topLevelRegistry = new TestBuildScopeServices((ServiceRegistry)buildTreeScopeServices, homeDir);
        GradleInternal gradle = CLASS_GENERATOR.newInstance(DefaultGradle.class, new Object[]{null, startParameter, topLevelRegistry.get(ServiceRegistryFactory.class)});
        DefaultProjectDescriptor projectDescriptor = new DefaultProjectDescriptor(null, name, projectDir, new DefaultProjectDescriptorRegistry(), (PathToFileResolver)topLevelRegistry.get(FileResolver.class));
        ClassLoaderScope baseScope = gradle.getClassLoaderScope();
        ClassLoaderScope rootProjectScope = baseScope.createChild("root-project");
        ProjectInternal project = ((IProjectFactory)topLevelRegistry.get(IProjectFactory.class)).createProject(projectDescriptor, null, gradle, rootProjectScope, baseScope);
        gradle.setRootProject(project);
        gradle.setDefaultProject(project);
        ResourceLockCoordinationService coordinationService = (ResourceLockCoordinationService)topLevelRegistry.get(ResourceLockCoordinationService.class);
        WorkerLeaseService workerLeaseService = (WorkerLeaseService)topLevelRegistry.get(WorkerLeaseService.class);
        coordinationService.withStateLock(DefaultResourceLockCoordinationService.lock((ResourceLock[])new ResourceLock[]{workerLeaseService.getWorkerLease()}));
        return project;
    }

    private ServiceRegistry getUserHomeServices(File userHomeDir) {
        ServiceRegistry globalServices = this.getGlobalServices();
        GradleUserHomeScopeServiceRegistry userHomeScopeServiceRegistry = (GradleUserHomeScopeServiceRegistry)globalServices.get(GradleUserHomeScopeServiceRegistry.class);
        return userHomeScopeServiceRegistry.getServicesFor(userHomeDir);
    }

    private ServiceRegistry getGlobalServices() {
        if (globalServices == null) {
            globalServices = ServiceRegistryBuilder.builder().displayName("global services").parent((ServiceRegistry)LoggingServiceRegistry.newNestedLogging()).parent((ServiceRegistry)NativeServices.getInstance()).provider((Object)new TestGlobalScopeServices()).build();
            ((LegacyTypesSupport)globalServices.get(LegacyTypesSupport.class)).injectEmptyInterfacesIntoClassLoader(this.getClass().getClassLoader());
        }
        return globalServices;
    }

    public File prepareProjectDir(File projectDir) {
        if (projectDir == null) {
            TmpDirTemporaryFileProvider temporaryFileProvider = new TmpDirTemporaryFileProvider();
            projectDir = temporaryFileProvider.createTemporaryDirectory("gradle", "projectDir", new String[0]);
            projectDir.deleteOnExit();
        } else {
            projectDir = FileUtils.canonicalize((File)projectDir);
        }
        return projectDir;
    }

    static {
        CLASS_GENERATOR = new AsmBackedClassGenerator();
    }
}

