/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.internal.artifacts.DependencySubstitutionInternal;
import org.gradle.api.internal.artifacts.ResolvedConfigurationIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution.DependencySubstitutionApplicator;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.ModuleExclusion;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.ModuleExclusions;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphNode;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ComponentState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.DependencyGraphBuilder;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.DependencyState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.EdgeState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.PendingDependenciesHandler;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ResolveState;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.specs.Spec;
import org.gradle.internal.component.local.model.LocalConfigurationMetadata;
import org.gradle.internal.component.local.model.LocalFileDependencyMetadata;
import org.gradle.internal.component.model.ConfigurationMetadata;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.resolve.ModuleVersionResolveException;
import org.gradle.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NodeState
implements DependencyGraphNode {
    private static final Logger LOGGER = LoggerFactory.getLogger(DependencyGraphBuilder.class);
    private static final Spec<EdgeState> TRANSITIVE_EDGES = new Spec<EdgeState>(){

        public boolean isSatisfiedBy(EdgeState edge) {
            return edge.isTransitive();
        }
    };
    private final Long resultId;
    private final ComponentState component;
    private final List<EdgeState> incomingEdges = Lists.newArrayList();
    private final List<EdgeState> outgoingEdges = Lists.newArrayList();
    private final ResolvedConfigurationIdentifier id;
    private final ConfigurationMetadata metaData;
    private final ResolveState resolveState;
    private final boolean isTransitive;
    private ModuleExclusion previousTraversalExclusions;

    NodeState(Long resultId, ResolvedConfigurationIdentifier id, ComponentState component, ResolveState resolveState, ConfigurationMetadata md) {
        this.resultId = resultId;
        this.id = id;
        this.component = component;
        this.resolveState = resolveState;
        this.metaData = md;
        this.isTransitive = this.metaData.isTransitive();
        component.addConfiguration(this);
    }

    ComponentState getComponent() {
        return this.component;
    }

    @Override
    public Long getNodeId() {
        return this.resultId;
    }

    @Override
    public boolean isRoot() {
        return false;
    }

    @Override
    public ResolvedConfigurationIdentifier getResolvedConfigurationId() {
        return this.id;
    }

    @Override
    public ComponentState getOwner() {
        return this.component;
    }

    public List<EdgeState> getIncomingEdges() {
        return this.incomingEdges;
    }

    public List<EdgeState> getOutgoingEdges() {
        return this.outgoingEdges;
    }

    @Override
    public ConfigurationMetadata getMetadata() {
        return this.metaData;
    }

    @Override
    public Set<? extends LocalFileDependencyMetadata> getOutgoingFileEdges() {
        if (this.metaData instanceof LocalConfigurationMetadata) {
            for (EdgeState incomingEdge : this.incomingEdges) {
                if (!incomingEdge.isTransitive()) continue;
                return ((LocalConfigurationMetadata)this.metaData).getFiles();
            }
        }
        return Collections.emptySet();
    }

    public String toString() {
        return String.format("%s(%s)", this.component, this.id.getConfiguration());
    }

    public boolean isTransitive() {
        return this.isTransitive;
    }

    public void visitOutgoingDependencies(Collection<EdgeState> discoveredEdges, PendingDependenciesHandler pendingDependenciesHandler) {
        if (!this.component.isSelected()) {
            LOGGER.debug("version for {} is not selected. ignoring.", (Object)this);
            return;
        }
        boolean hasIncomingEdges = !this.incomingEdges.isEmpty();
        List<EdgeState> transitiveIncoming = this.getTransitiveIncomingEdges();
        if (transitiveIncoming.isEmpty() && !this.isRoot()) {
            if (this.previousTraversalExclusions != null) {
                this.removeOutgoingEdges();
            }
            if (hasIncomingEdges) {
                LOGGER.debug("{} has no transitive incoming edges. ignoring outgoing edges.", (Object)this);
            } else {
                LOGGER.debug("{} has no incoming edges. ignoring.", (Object)this);
            }
            return;
        }
        ModuleExclusion resolutionFilter = this.getModuleResolutionFilter(transitiveIncoming);
        if (this.previousTraversalExclusions != null && this.previousTraversalExclusions.excludesSameModulesAs(resolutionFilter)) {
            LOGGER.debug("Changed edges for {} selects same versions as previous traversal. ignoring", (Object)this);
            this.previousTraversalExclusions = resolutionFilter;
            return;
        }
        if (this.previousTraversalExclusions != null) {
            this.removeOutgoingEdges();
        }
        this.visitDependencies(resolutionFilter, pendingDependenciesHandler, discoveredEdges);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void visitDependencies(ModuleExclusion resolutionFilter, PendingDependenciesHandler pendingDependenciesHandler, Collection<EdgeState> discoveredEdges) {
        PendingDependenciesHandler.Visitor pendingDepsVisitor = pendingDependenciesHandler.start();
        try {
            for (DependencyMetadata dependencyMetadata : this.metaData.getDependencies()) {
                DependencyState dependencyState = new DependencyState(dependencyMetadata, this.resolveState.getComponentSelectorConverter());
                if (this.isExcluded(resolutionFilter, dependencyState) || pendingDepsVisitor.maybeAddAsPendingDependency(this, dependencyState = this.maybeSubstitute(dependencyState))) continue;
                EdgeState dependencyEdge = new EdgeState(this, dependencyState, resolutionFilter, this.resolveState);
                this.outgoingEdges.add(dependencyEdge);
                discoveredEdges.add(dependencyEdge);
            }
            this.previousTraversalExclusions = resolutionFilter;
        }
        finally {
            pendingDepsVisitor.complete();
        }
    }

    private DependencyState maybeSubstitute(DependencyState dependencyState) {
        DependencySubstitutionApplicator.SubstitutionResult substitutionResult = this.resolveState.getDependencySubstitutionApplicator().apply(dependencyState.getDependency());
        if (substitutionResult.hasFailure()) {
            dependencyState.failure = new ModuleVersionResolveException(dependencyState.getRequested(), substitutionResult.getFailure());
            return dependencyState;
        }
        DependencySubstitutionInternal details = substitutionResult.getResult();
        if (details != null && details.isUpdated()) {
            return dependencyState.withTarget(details.getTarget(), details.getSelectionDescription());
        }
        return dependencyState;
    }

    private List<EdgeState> getTransitiveIncomingEdges() {
        if (this.isRoot()) {
            return this.incomingEdges;
        }
        for (EdgeState incomingEdge : this.incomingEdges) {
            if (incomingEdge.isTransitive()) continue;
            return CollectionUtils.filter(this.incomingEdges, TRANSITIVE_EDGES);
        }
        return this.incomingEdges;
    }

    private boolean isExcluded(ModuleExclusion selector, DependencyState dependencyState) {
        DependencyMetadata dependency = dependencyState.getDependency();
        if (!this.resolveState.getEdgeFilter().isSatisfiedBy((Object)dependency)) {
            LOGGER.debug("{} is filtered.", (Object)dependency);
            return true;
        }
        if (selector == ModuleExclusions.excludeNone()) {
            return false;
        }
        ModuleIdentifier targetModuleId = dependencyState.getModuleIdentifier();
        if (selector.excludeModule(targetModuleId)) {
            LOGGER.debug("{} is excluded from {}.", (Object)targetModuleId, (Object)this);
            return true;
        }
        return false;
    }

    public void addIncomingEdge(EdgeState dependencyEdge) {
        this.incomingEdges.add(dependencyEdge);
        this.resolveState.onMoreSelected(this);
    }

    public void removeIncomingEdge(EdgeState dependencyEdge) {
        this.incomingEdges.remove(dependencyEdge);
        this.resolveState.onFewerSelected(this);
    }

    public boolean isSelected() {
        return !this.incomingEdges.isEmpty();
    }

    private ModuleExclusion getModuleResolutionFilter(List<EdgeState> incomingEdges) {
        ModuleExclusions moduleExclusions = this.resolveState.getModuleExclusions();
        ModuleExclusion nodeExclusions = moduleExclusions.excludeAny(this.metaData.getExcludes());
        if (incomingEdges.isEmpty()) {
            return nodeExclusions;
        }
        ModuleExclusion edgeExclusions = incomingEdges.get(0).getExclusions();
        for (int i = 1; i < incomingEdges.size(); ++i) {
            EdgeState dependencyEdge = incomingEdges.get(i);
            edgeExclusions = moduleExclusions.union(edgeExclusions, dependencyEdge.getExclusions());
        }
        return moduleExclusions.intersect(edgeExclusions, nodeExclusions);
    }

    private void removeOutgoingEdges() {
        for (EdgeState outgoingDependency : this.outgoingEdges) {
            outgoingDependency.removeFromTargetConfigurations();
        }
        this.outgoingEdges.clear();
        this.previousTraversalExclusions = null;
    }

    public void restart(ComponentState selected) {
        if (this.component == selected) {
            this.resolveState.onMoreSelected(this);
        } else if (!this.incomingEdges.isEmpty()) {
            this.restartIncomingEdges(selected);
        }
    }

    private void restartIncomingEdges(ComponentState selected) {
        if (this.incomingEdges.size() == 1) {
            this.incomingEdges.iterator().next().restart(selected);
        } else {
            for (EdgeState dependency : new ArrayList<EdgeState>(this.incomingEdges)) {
                dependency.restart(selected);
            }
        }
        this.incomingEdges.clear();
    }

    public void deselect() {
        this.removeOutgoingEdges();
    }

    void resetSelectionState() {
        this.previousTraversalExclusions = null;
        this.outgoingEdges.clear();
        this.resolveState.onMoreSelected(this);
    }

    public ImmutableAttributesFactory getAttributesFactory() {
        return this.resolveState.getAttributesFactory();
    }
}

