/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.rules;

import org.gradle.api.NonNullApi;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.changedetection.rules.CachingTaskStateChanges;
import org.gradle.api.internal.changedetection.rules.ChangeDetectorVisitor;
import org.gradle.api.internal.changedetection.rules.CollectingTaskStateChangeVisitor;
import org.gradle.api.internal.changedetection.rules.ErrorHandlingTaskStateChanges;
import org.gradle.api.internal.changedetection.rules.InputFilePropertyTaskStateChanges;
import org.gradle.api.internal.changedetection.rules.InputFileTaskStateChanges;
import org.gradle.api.internal.changedetection.rules.InputPropertyTaskStateChanges;
import org.gradle.api.internal.changedetection.rules.InputPropertyValueTaskStateChanges;
import org.gradle.api.internal.changedetection.rules.OutputFileTaskStateChanges;
import org.gradle.api.internal.changedetection.rules.OutputPropertyTaskChanges;
import org.gradle.api.internal.changedetection.rules.PreviousSuccessTaskStateChanges;
import org.gradle.api.internal.changedetection.rules.SummaryTaskStateChanges;
import org.gradle.api.internal.changedetection.rules.TaskStateChange;
import org.gradle.api.internal.changedetection.rules.TaskStateChangeVisitor;
import org.gradle.api.internal.changedetection.rules.TaskStateChanges;
import org.gradle.api.internal.changedetection.rules.TaskTypeTaskStateChanges;
import org.gradle.api.internal.changedetection.rules.TaskUpToDateState;
import org.gradle.api.internal.changedetection.state.TaskExecution;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonNullApi
public class DefaultTaskUpToDateState
implements TaskUpToDateState {
    private final TaskStateChanges inputFileChanges;
    private final OutputFileTaskStateChanges outputFileChanges;
    private final TaskStateChanges allTaskChanges;
    private final TaskStateChanges rebuildChanges;
    private final TaskStateChanges outputFilePropertyChanges;

    public DefaultTaskUpToDateState(TaskExecution lastExecution, TaskExecution thisExecution, TaskInternal task) {
        PreviousSuccessTaskStateChanges previousSuccessState = new PreviousSuccessTaskStateChanges(lastExecution);
        TaskTypeTaskStateChanges taskTypeState = new TaskTypeTaskStateChanges(lastExecution, thisExecution, task);
        InputPropertyTaskStateChanges inputPropertyChanges = new InputPropertyTaskStateChanges(lastExecution, thisExecution, task);
        InputPropertyValueTaskStateChanges inputPropertyValueChanges = new InputPropertyValueTaskStateChanges(lastExecution, thisExecution, task);
        this.outputFilePropertyChanges = new OutputPropertyTaskChanges(lastExecution, thisExecution, task);
        OutputFileTaskStateChanges uncachedOutputChanges = new OutputFileTaskStateChanges(lastExecution, thisExecution);
        TaskStateChanges outputFileChanges = DefaultTaskUpToDateState.caching(uncachedOutputChanges);
        this.outputFileChanges = uncachedOutputChanges;
        InputFilePropertyTaskStateChanges inputFilePropertyChanges = new InputFilePropertyTaskStateChanges(lastExecution, thisExecution, task);
        InputFileTaskStateChanges directInputFileChanges = new InputFileTaskStateChanges(lastExecution, thisExecution);
        TaskStateChanges inputFileChanges = DefaultTaskUpToDateState.caching(directInputFileChanges);
        this.inputFileChanges = new ErrorHandlingTaskStateChanges(task, inputFileChanges);
        this.allTaskChanges = new ErrorHandlingTaskStateChanges(task, new SummaryTaskStateChanges(previousSuccessState, taskTypeState, inputPropertyChanges, inputPropertyValueChanges, this.outputFilePropertyChanges, outputFileChanges, inputFilePropertyChanges, inputFileChanges));
        this.rebuildChanges = new ErrorHandlingTaskStateChanges(task, new SummaryTaskStateChanges(previousSuccessState, taskTypeState, inputPropertyChanges, inputPropertyValueChanges, inputFilePropertyChanges, this.outputFilePropertyChanges, outputFileChanges));
    }

    private static TaskStateChanges caching(TaskStateChanges wrapped) {
        return new CachingTaskStateChanges(3, wrapped);
    }

    @Override
    public Iterable<TaskStateChange> getInputFilesChanges() {
        CollectingTaskStateChangeVisitor visitor = new CollectingTaskStateChangeVisitor();
        this.inputFileChanges.accept(visitor);
        return visitor.getChanges();
    }

    @Override
    public boolean hasAnyOutputFileChanges() {
        ChangeDetectorVisitor visitor = new ChangeDetectorVisitor();
        this.outputFilePropertyChanges.accept(visitor);
        return visitor.hasAnyChanges() || this.outputFileChanges.hasAnyChanges();
    }

    @Override
    public void visitAllTaskChanges(TaskStateChangeVisitor visitor) {
        this.allTaskChanges.accept(visitor);
    }

    @Override
    public boolean isRebuildRequired() {
        ChangeDetectorVisitor changeDetectorVisitor = new ChangeDetectorVisitor();
        this.rebuildChanges.accept(changeDetectorVisitor);
        return changeDetectorVisitor.hasAnyChanges();
    }
}

