/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import com.google.common.util.concurrent.Runnables;
import java.io.File;
import org.gradle.api.Action;
import org.gradle.cache.FileLock;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.LockOptions;
import org.gradle.cache.internal.AbstractCrossProcessCacheAccess;
import org.gradle.cache.internal.CacheInitializationAction;
import org.gradle.internal.Factory;
import org.gradle.internal.UncheckedException;

public class FixedExclusiveModeCrossProcessCacheAccess
extends AbstractCrossProcessCacheAccess {
    private static final Runnable NO_OP_CONTENDED_ACTION = new Runnable(){

        @Override
        public void run() {
        }
    };
    private final String cacheDisplayName;
    private final File lockTarget;
    private final LockOptions lockOptions;
    private final FileLockManager lockManager;
    private final CacheInitializationAction initializationAction;
    private final Action<FileLock> onOpenAction;
    private final Action<FileLock> onCloseAction;
    private FileLock fileLock;

    public FixedExclusiveModeCrossProcessCacheAccess(String cacheDisplayName, File lockTarget, LockOptions lockOptions, FileLockManager lockManager, CacheInitializationAction initializationAction, Action<FileLock> onOpenAction, Action<FileLock> onCloseAction) {
        assert (lockOptions.getMode() == FileLockManager.LockMode.Exclusive);
        this.initializationAction = initializationAction;
        this.onOpenAction = onOpenAction;
        this.onCloseAction = onCloseAction;
        assert (lockOptions.getMode() == FileLockManager.LockMode.Exclusive);
        this.cacheDisplayName = cacheDisplayName;
        this.lockTarget = lockTarget;
        this.lockOptions = lockOptions;
        this.lockManager = lockManager;
    }

    @Override
    public void open() {
        if (this.fileLock != null) {
            throw new IllegalStateException("File lock " + this.lockTarget + " is already open.");
        }
        final FileLock fileLock = this.lockManager.lock(this.lockTarget, this.lockOptions, this.cacheDisplayName, "", NO_OP_CONTENDED_ACTION);
        try {
            boolean rebuild = this.initializationAction.requiresInitialization(fileLock);
            if (rebuild) {
                fileLock.writeFile(new Runnable(){

                    @Override
                    public void run() {
                        FixedExclusiveModeCrossProcessCacheAccess.this.initializationAction.initialize(fileLock);
                    }
                });
            }
            this.onOpenAction.execute((Object)fileLock);
        }
        catch (Exception e) {
            fileLock.close();
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
        this.fileLock = fileLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.fileLock != null) {
            try {
                this.onCloseAction.execute((Object)this.fileLock);
                this.fileLock.close();
            }
            finally {
                this.fileLock = null;
            }
        }
    }

    @Override
    public Runnable acquireFileLock() {
        return Runnables.doNothing();
    }

    @Override
    public <T> T withFileLock(Factory<T> factory) {
        return (T)factory.create();
    }
}

